/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.container.cdi;

import com.ibm.ws.jsf.container.cdi.IBMViewHandlerProxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.weld.el.WeldELContextListener;

public class CDIJSFInitializer {
    private static final Logger log = Logger.getLogger("com.ibm.ws.jsf.container.cdi");

    public static void initialize(Application application, String appname) {
        block6: {
            try {
                BeanManager beanManager = (BeanManager)InitialContext.doLookup("java:comp/BeanManager");
                if (beanManager != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.logp(Level.FINEST, CDIJSFInitializer.class.getName(), "initializeJSF", "Initializing application with CDI", appname);
                    }
                    application.addELContextListener((ELContextListener)new WeldELContextListener());
                    application.setViewHandler((ViewHandler)new IBMViewHandlerProxy(application.getViewHandler(), appname));
                    ELResolver elResolver = beanManager.getELResolver();
                    application.addELResolver(elResolver);
                } else if (log.isLoggable(Level.FINEST)) {
                    log.logp(Level.FINEST, CDIJSFInitializer.class.getName(), "initializeJSF", "No BeanManager found for application", appname);
                }
            }
            catch (NamingException e) {
                if (!log.isLoggable(Level.FINEST)) break block6;
                log.log(Level.FINEST, e.getMessage(), e);
            }
        }
    }
}

