/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.tai.TAIService;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.PostParameterHelper;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.SSOCookieHelperImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.WebRequestImpl;
import com.ibm.ws.webcontainer.security.internal.SSOAuthenticator;
import com.ibm.ws.webcontainer.security.internal.TAIAuthenticator;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebProviderAuthenticatorProxy
implements WebAuthenticator {
    private static final TraceComponent tc = Tr.register(WebProviderAuthenticatorProxy.class);
    AuthenticationResult JASPI_CONT = new AuthenticationResult(AuthResult.CONTINUE, "JASPI said continue...");
    protected final AtomicServiceReference<SecurityService> securityServiceRef;
    protected final AtomicServiceReference<TAIService> taiServiceRef;
    protected final ConcurrentServiceReferenceMap<String, TrustAssociationInterceptor> interceptorServiceRef;
    protected volatile WebAppSecurityConfig webAppSecurityConfig;
    protected final ConcurrentServiceReferenceMap<String, WebAuthenticator> webAuthenticatorRef;
    static final long serialVersionUID = -187182665254904997L;

    public WebProviderAuthenticatorProxy(AtomicServiceReference<SecurityService> securityServiceRef, AtomicServiceReference<TAIService> taiServiceRef, ConcurrentServiceReferenceMap<String, TrustAssociationInterceptor> interceptorServiceRef, WebAppSecurityConfig webAppSecurityConfig, ConcurrentServiceReferenceMap<String, WebAuthenticator> webAuthenticatorRef) {
        this.securityServiceRef = securityServiceRef;
        this.taiServiceRef = taiServiceRef;
        this.interceptorServiceRef = interceptorServiceRef;
        this.webAppSecurityConfig = webAppSecurityConfig;
        this.webAuthenticatorRef = webAuthenticatorRef;
    }

    @Override
    public AuthenticationResult authenticate(WebRequest webRequest) {
        AuthenticationResult authResult = this.handleTAI(webRequest, true);
        if (authResult.getStatus() == AuthResult.CONTINUE && (authResult = this.handleSSO(webRequest, null)).getStatus() == AuthResult.CONTINUE) {
            webRequest.setCallAfterSSO(true);
            authResult = this.handleTAI(webRequest, false);
        }
        return authResult;
    }

    /*
     * WARNING - void declaration
     */
    protected AuthenticationResult handleJaspi(WebRequest webRequest, HashMap<String, Object> props) {
        WebAuthenticator jaspiAuthenticator;
        AuthenticationResult authResult = this.JASPI_CONT;
        if (this.webAuthenticatorRef != null && (jaspiAuthenticator = (WebAuthenticator)this.webAuthenticatorRef.getService((Object)"com.ibm.ws.security.jaspi")) != null) {
            block16: {
                String uid;
                int index;
                String basicAuthHeader;
                String authHeader2;
                if (props == null) {
                    authResult = this.handleSSO(webRequest, null);
                    if (authResult.getStatus() == AuthResult.CONTINUE) {
                        authResult = this.handleSSO(webRequest, "jaspicSession");
                        if (authResult.getStatus() == AuthResult.SUCCESS) {
                            HashMap<String, Object> requestProps = new HashMap<String, Object>();
                            requestProps.put("javax.servlet.http.registerSession.subject", authResult.getSubject());
                            webRequest.setProperties(requestProps);
                        }
                        if ((authResult = jaspiAuthenticator.authenticate(webRequest)).getStatus() != AuthResult.CONTINUE) {
                            authHeader2 = webRequest.getHttpServletRequest().getHeader("Authorization");
                            if (authHeader2 != null && authHeader2.startsWith("Basic ")) {
                                basicAuthHeader = this.decodeCookieString(authHeader2.substring(6));
                                index = basicAuthHeader.indexOf(58);
                                uid = basicAuthHeader.substring(0, index);
                                authResult.setAuditCredValue(uid);
                            }
                            authResult.setAuditCredType("JASPIC");
                        }
                    }
                } else {
                    try {
                        authResult = jaspiAuthenticator.authenticate(webRequest.getHttpServletRequest(), webRequest.getHttpServletResponse(), props);
                        if (authResult.getStatus() != AuthResult.CONTINUE) {
                            authHeader2 = webRequest.getHttpServletRequest().getHeader("Authorization");
                            if (authHeader2 != null && authHeader2.startsWith("Basic ")) {
                                basicAuthHeader = this.decodeCookieString(authHeader2.substring(6));
                                index = basicAuthHeader.indexOf(58);
                                uid = basicAuthHeader.substring(0, index);
                                authResult.setAuditCredValue(uid);
                            }
                            authResult.setAuditCredType("JASPIC");
                        }
                    }
                    catch (Exception authHeader2) {
                        void e;
                        FFDCFilter.processException((Throwable)authHeader2, (String)"com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy", (String)"129", (Object)this, (Object[])new Object[]{webRequest, props});
                        if (!tc.isDebugEnabled()) break block16;
                        Tr.debug((TraceComponent)tc, (String)"Internal error handling JASPI request", (Object[])new Object[]{e});
                    }
                }
            }
            if (authResult.getStatus() == AuthResult.SUCCESS) {
                boolean registerSession = false;
                Map<String, Object> reqProps = webRequest.getProperties();
                if (reqProps != null) {
                    registerSession = Boolean.valueOf((String)reqProps.get("javax.servlet.http.registerSession"));
                }
                if (registerSession) {
                    SSOCookieHelperImpl ssoCh = new SSOCookieHelperImpl(this.webAppSecurityConfig, "jaspicSession");
                    ssoCh.addSSOCookiesToResponse(authResult.getSubject(), webRequest.getHttpServletRequest(), webRequest.getHttpServletResponse());
                }
                SSOCookieHelper ssoCh = this.webAppSecurityConfig.createSSOCookieHelper();
                HttpServletResponse res = webRequest.getHttpServletResponse();
                if (!res.isCommitted()) {
                    PostParameterHelper postParameterHelper = new PostParameterHelper(this.webAppSecurityConfig);
                    postParameterHelper.restore(webRequest.getHttpServletRequest(), res);
                }
                if (!(props != null && props.get("authType") != null && props.get("authType").equals("FORM_LOGIN") || res.isCommitted())) {
                    ssoCh.removeSSOCookieFromResponse(res);
                }
            }
        }
        return authResult;
    }

    @Override
    public AuthenticationResult authenticate(HttpServletRequest request, HttpServletResponse response, HashMap<String, Object> props) throws Exception {
        WebRequestImpl webRequest = new WebRequestImpl(request, response, null, null, null, null, null);
        AuthenticationResult authResult = this.handleJaspi(webRequest, props);
        return authResult;
    }

    protected AuthenticationResult handleTAI(WebRequest webRequest, boolean beforeSSO) {
        TAIAuthenticator taiAuthenticator = this.getTaiAuthenticator();
        AuthenticationResult authResult = null;
        if (taiAuthenticator == null) {
            authResult = new AuthenticationResult(AuthResult.CONTINUE, "TAI invoke " + (beforeSSO ? "before" : "after") + " SSO is not available, skipping TAI...");
        } else {
            authResult = taiAuthenticator.authenticate(webRequest, beforeSSO);
            if (authResult.getStatus() != AuthResult.CONTINUE) {
                authResult.setAuditCredType("TrustAssociationInterceptor");
            }
        }
        return authResult;
    }

    protected AuthenticationResult handleSSO(WebRequest webRequest, String ssoCookieName) {
        WebAuthenticator authenticator = this.getSSOAuthenticator(webRequest, ssoCookieName);
        AuthenticationResult authResult = authenticator.authenticate(webRequest);
        if (authResult == null || authResult.getStatus() != AuthResult.SUCCESS) {
            authResult = new AuthenticationResult(AuthResult.CONTINUE, "SSO did not succeed, so continue ...");
        }
        return authResult;
    }

    protected boolean isNotNullAndTrue(HttpServletRequest req, String key) {
        Boolean result = (Boolean)req.getAttribute(key);
        if (result != null) {
            return result;
        }
        return false;
    }

    protected TAIAuthenticator getTaiAuthenticator() {
        TAIAuthenticator taiAuthenticator = null;
        TAIService taiService = (TAIService)this.taiServiceRef.getService();
        Iterator interceptorServices = this.interceptorServiceRef.getServices();
        if (taiService != null || interceptorServices != null && interceptorServices.hasNext()) {
            SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
            taiAuthenticator = new TAIAuthenticator(taiService, this.interceptorServiceRef, securityService.getAuthenticationService(), this.webAppSecurityConfig.createSSOCookieHelper());
        }
        return taiAuthenticator;
    }

    public WebAuthenticator getSSOAuthenticator(WebRequest webRequest, String ssoCookieName) {
        SecurityMetadata securityMetadata = webRequest.getSecurityMetadata();
        SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
        SSOCookieHelper cookieHelper = ssoCookieName != null ? new SSOCookieHelperImpl(this.webAppSecurityConfig, ssoCookieName) : this.webAppSecurityConfig.createSSOCookieHelper();
        return new SSOAuthenticator(securityService.getAuthenticationService(), securityMetadata, this.webAppSecurityConfig, cookieHelper);
    }

    public ConcurrentServiceReferenceMap<String, WebAuthenticator> getWebAuthenticatorRefs() {
        return this.webAuthenticatorRef;
    }

    @Sensitive
    private String decodeCookieString(@Sensitive String cookieString) {
        try {
            return Base64Coder.base64Decode((String)cookieString);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive java.lang.String>";
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy", (String)"280", (Object)this, (Object[])objectArray);
            return null;
        }
    }
}

