/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.SSOCookieHelperImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticatorProxy;
import com.ibm.ws.webcontainer.security.internal.StringUtil;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebAppSecurityConfigImpl
implements WebAppSecurityConfig {
    private static final TraceComponent tc = Tr.register(WebAppSecurityConfigImpl.class);
    public static final String WLP_USER_DIR = "${wlp.user.dir}";
    public static final String AUTO_GEN_COOKIE_NAME_PREFIX = "WAS_";
    public static final String DEFAULT_SSO_COOKIE_NAME = "LtpaToken2";
    static final String CFG_KEY_LOGOUT_ON_HTTP_SESSION_EXPIRE = "logoutOnHttpSessionExpire";
    public static final String CFG_KEY_SINGLE_SIGN_ON_ENABLED = "singleSignonEnabled";
    static final String CFG_KEY_PRESERVE_FULLY_QUALIFIED_REFERRER_URL = "preserveFullyQualifiedReferrerUrl";
    static final String CFG_KEY_POSTPARAM_SAVE_METHOD = "postParamSaveMethod";
    static final String CFG_KEY_POSTPARAM_COOKIE_SIZE = "postParamCookieSize";
    static final String CFG_KEY_ALLOW_LOGOUT_PAGE_REDIRECT_TO_ANY_HOST = "allowLogoutPageRedirectToAnyHost";
    static final String CFG_KEY_LOGOUT_PAGE_REDIRECT_DOMAIN_NAMES = "logoutPageRedirectDomainNames";
    static final String CFG_KEY_WAS_REQ_URL_REDIRECT_DOMAIN_NAMES = "wasReqURLRedirectDomainNames";
    protected static final String CFG_KEY_SSO_COOKIE_NAME = "ssoCookieName";
    static final String CFG_KEY_AUTO_GEN_SSO_COOKIE_NAME = "autoGenSsoCookieName";
    public static final String CFG_KEY_FAIL_OVER_TO_BASICAUTH = "allowFailOverToBasicAuth";
    static final String CFG_KEY_DISPLAY_AUTHENTICATION_REALM = "displayAuthenticationRealm";
    static final String CFG_KEY_HTTP_ONLY_COOKIES = "httpOnlyCookies";
    static final String CFG_KEY_WEB_ALWAYS_LOGIN = "webAlwaysLogin";
    static final String CFG_KEY_SSO_DOMAIN_NAMES = "ssoDomainNames";
    static final String CFG_KEY_SSO_REQUIRES_SSL = "ssoRequiresSSL";
    static final String CFG_KEY_SSO_USE_DOMAIN_FROM_URL = "ssoUseDomainFromURL";
    public static final String CFG_KEY_USE_AUTH_DATA_FOR_UNPROTECTED = "useAuthenticationDataForUnprotectedResource";
    static final String CFG_KEY_LOGIN_FORM_URL = "loginFormURL";
    public static final String CFG_KEY_ALLOW_FAIL_OVER_TO_AUTH_METHOD = "allowAuthenticationFailOverToAuthMethod";
    static final String CFG_KEY_INCLUDE_PATH_IN_WAS_REQ_URL = "includePathInWASReqURL";
    static final String CFG_KEY_TRACK_LOGGED_OUT_SSO_COOKIES = "trackLoggedOutSSOCookies";
    static final String CFG_KEY_USE_ONLY_CUSTOM_COOKIE_NAME = "useOnlyCustomCookieName";
    private final Boolean logoutOnHttpSessionExpire;
    private final Boolean singleSignonEnabled;
    private final Boolean preserveFullyQualifiedReferrerUrl;
    private final String postParamSaveMethod;
    private final Integer postParamCookieSize;
    private final Boolean allowLogoutPageRedirectToAnyHost;
    private final String wasReqURLRedirectDomainNames;
    private final String logoutPageRedirectDomainNames;
    protected String ssoCookieName;
    protected final Boolean autoGenSsoCookieName;
    private final Boolean allowFailOverToBasicAuth;
    private final Boolean displayAuthenticationRealm;
    private final Boolean httpOnlyCookies;
    private final Boolean webAlwaysLogin;
    private final Boolean ssoRequiresSSL;
    private final String ssoDomainNames;
    private final Boolean ssoUseDomainFromURL;
    private final Boolean useAuthenticationDataForUnprotectedResource;
    private final String loginFormURL;
    private final String allowFailOverToAuthMethod;
    private final Boolean includePathInWASReqURL;
    private final Boolean trackLoggedOutSSOCookies;
    private final Boolean useOnlyCustomCookieName;
    protected final AtomicServiceReference<WsLocationAdmin> locationAdminRef;
    protected final AtomicServiceReference<SecurityService> securityServiceRef;
    static final long serialVersionUID = -7863660892004950769L;

    public WebAppSecurityConfigImpl(Map<String, Object> newProperties, AtomicServiceReference<WsLocationAdmin> locationAdminRef, AtomicServiceReference<SecurityService> securityServiceRef) {
        this.locationAdminRef = locationAdminRef;
        this.securityServiceRef = securityServiceRef;
        this.logoutOnHttpSessionExpire = (Boolean)newProperties.get(CFG_KEY_LOGOUT_ON_HTTP_SESSION_EXPIRE);
        this.singleSignonEnabled = (Boolean)newProperties.get(CFG_KEY_SINGLE_SIGN_ON_ENABLED);
        this.preserveFullyQualifiedReferrerUrl = (Boolean)newProperties.get(CFG_KEY_PRESERVE_FULLY_QUALIFIED_REFERRER_URL);
        this.postParamSaveMethod = (String)newProperties.get(CFG_KEY_POSTPARAM_SAVE_METHOD);
        this.postParamCookieSize = (Integer)newProperties.get(CFG_KEY_POSTPARAM_COOKIE_SIZE);
        this.allowLogoutPageRedirectToAnyHost = (Boolean)newProperties.get(CFG_KEY_ALLOW_LOGOUT_PAGE_REDIRECT_TO_ANY_HOST);
        this.wasReqURLRedirectDomainNames = (String)newProperties.get(CFG_KEY_WAS_REQ_URL_REDIRECT_DOMAIN_NAMES);
        this.logoutPageRedirectDomainNames = (String)newProperties.get(CFG_KEY_LOGOUT_PAGE_REDIRECT_DOMAIN_NAMES);
        this.autoGenSsoCookieName = (Boolean)newProperties.get(CFG_KEY_AUTO_GEN_SSO_COOKIE_NAME);
        this.ssoCookieName = this.resolveSsoCookieName(newProperties);
        this.allowFailOverToBasicAuth = (Boolean)newProperties.get(CFG_KEY_FAIL_OVER_TO_BASICAUTH);
        this.displayAuthenticationRealm = (Boolean)newProperties.get(CFG_KEY_DISPLAY_AUTHENTICATION_REALM);
        this.httpOnlyCookies = (Boolean)newProperties.get(CFG_KEY_HTTP_ONLY_COOKIES);
        this.webAlwaysLogin = (Boolean)newProperties.get(CFG_KEY_WEB_ALWAYS_LOGIN);
        this.ssoRequiresSSL = (Boolean)newProperties.get(CFG_KEY_SSO_REQUIRES_SSL);
        this.ssoDomainNames = (String)newProperties.get(CFG_KEY_SSO_DOMAIN_NAMES);
        this.ssoUseDomainFromURL = (Boolean)newProperties.get(CFG_KEY_SSO_USE_DOMAIN_FROM_URL);
        this.useAuthenticationDataForUnprotectedResource = (Boolean)newProperties.get(CFG_KEY_USE_AUTH_DATA_FOR_UNPROTECTED);
        this.loginFormURL = (String)newProperties.get(CFG_KEY_LOGIN_FORM_URL);
        this.allowFailOverToAuthMethod = (String)newProperties.get(CFG_KEY_ALLOW_FAIL_OVER_TO_AUTH_METHOD);
        this.includePathInWASReqURL = (Boolean)newProperties.get(CFG_KEY_INCLUDE_PATH_IN_WAS_REQ_URL);
        this.trackLoggedOutSSOCookies = (Boolean)newProperties.get(CFG_KEY_TRACK_LOGGED_OUT_SSO_COOKIES);
        this.useOnlyCustomCookieName = (Boolean)newProperties.get(CFG_KEY_USE_ONLY_CUSTOM_COOKIE_NAME);
        WebAppSecurityCollaboratorImpl.setGlobalWebAppSecurityConfig(this);
    }

    protected String resolveSsoCookieName(Map<String, Object> newProperties) {
        String genCookieName = null;
        String cookieName = (String)newProperties.get(CFG_KEY_SSO_COOKIE_NAME);
        if (DEFAULT_SSO_COOKIE_NAME.equalsIgnoreCase(cookieName) && this.autoGenSsoCookieName.booleanValue()) {
            genCookieName = this.generateSsoCookieName();
        }
        if (genCookieName != null) {
            return genCookieName;
        }
        return cookieName;
    }

    protected String generateSsoCookieName() {
        WsLocationAdmin locationAdmin = (WsLocationAdmin)this.locationAdminRef.getService();
        if (locationAdmin != null) {
            String usrLocation = locationAdmin.resolveString(WLP_USER_DIR).replace('\\', '/');
            String slash = usrLocation.endsWith("/") ? "" : "/";
            String cookieLongName = this.getHostName() + "_" + usrLocation + slash + "servers/" + locationAdmin.getServerName();
            String cookieHashName = AUTO_GEN_COOKIE_NAME_PREFIX + StringUtil.hash(cookieLongName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cookieHashName: " + cookieHashName + " cookieLongName: " + cookieLongName), (Object[])new Object[0]);
            }
            return cookieHashName;
        }
        Tr.error((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"WsLocationAdmin"});
        return null;
    }

    private String getHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName().toLowerCase();
        }
        catch (UnknownHostException unknownHostException) {
            FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.webcontainer.security.internal.WebAppSecurityConfigImpl", (String)"167", (Object)this, (Object[])new Object[0]);
            return "localhost";
        }
    }

    @Override
    public boolean getLogoutOnHttpSessionExpire() {
        return this.logoutOnHttpSessionExpire;
    }

    @Override
    public boolean isIncludePathInWASReqURL() {
        return this.includePathInWASReqURL;
    }

    @Override
    public boolean isSingleSignonEnabled() {
        return this.singleSignonEnabled;
    }

    @Override
    public boolean getPreserveFullyQualifiedReferrerUrl() {
        return this.preserveFullyQualifiedReferrerUrl;
    }

    @Override
    public String getPostParamSaveMethod() {
        return this.postParamSaveMethod;
    }

    @Override
    public int getPostParamCookieSize() {
        return this.postParamCookieSize;
    }

    @Override
    public boolean getAllowLogoutPageRedirectToAnyHost() {
        return this.allowLogoutPageRedirectToAnyHost;
    }

    @Override
    public String getSSOCookieName() {
        return this.ssoCookieName;
    }

    @Override
    public boolean getAllowFailOverToBasicAuth() {
        return this.allowFailOverToBasicAuth != false || this.allowFailOverToAuthMethod != null && this.allowFailOverToAuthMethod.equalsIgnoreCase("BASIC");
    }

    @Override
    public boolean getAllowFailOverToFormLogin() {
        return this.allowFailOverToAuthMethod != null && this.allowFailOverToAuthMethod.equalsIgnoreCase("FORM");
    }

    @Override
    public boolean allowFailOver() {
        return this.getAllowFailOverToBasicAuth() || this.getAllowFailOverToFormLogin();
    }

    @Override
    public boolean getDisplayAuthenticationRealm() {
        return this.displayAuthenticationRealm;
    }

    @Override
    public List<String> getWASReqURLRedirectDomainNames() {
        return this.domainNamesToList(this.wasReqURLRedirectDomainNames);
    }

    @Override
    public List<String> getLogoutPageRedirectDomainList() {
        return this.domainNamesToList(this.logoutPageRedirectDomainNames);
    }

    @Override
    public boolean getHttpOnlyCookies() {
        return this.httpOnlyCookies;
    }

    @Override
    public boolean getWebAlwaysLogin() {
        return this.webAlwaysLogin;
    }

    @Override
    public boolean getSSORequiresSSL() {
        return this.ssoRequiresSSL;
    }

    @Override
    public List<String> getSSODomainList() {
        return this.domainNamesToList(this.ssoDomainNames);
    }

    @Override
    public boolean getSSOUseDomainFromURL() {
        return this.ssoUseDomainFromURL;
    }

    @Override
    public boolean isUseAuthenticationDataForUnprotectedResourceEnabled() {
        return this.useAuthenticationDataForUnprotectedResource;
    }

    @Override
    public String getLoginFormURL() {
        return this.loginFormURL;
    }

    @Override
    public boolean isTrackLoggedOutSSOCookiesEnabled() {
        return this.trackLoggedOutSSOCookies;
    }

    @Override
    public boolean isUseOnlyCustomCookieName() {
        return this.useOnlyCustomCookieName;
    }

    private List<String> domainNamesToList(String domainNames) {
        if (domainNames == null || domainNames.length() == 0) {
            return null;
        }
        ArrayList<String> domainNameList = new ArrayList<String>();
        String[] sd = domainNames.split("\\|");
        for (int i = 0; i < sd.length; ++i) {
            domainNameList.add(sd[i].trim());
        }
        return domainNameList;
    }

    private void appendToBufferIfDifferent(StringBuffer buffer, String name, Object thisValue, Object otherValue) {
        if (thisValue != otherValue && thisValue != null && !thisValue.equals(otherValue)) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(name);
            buffer.append("=");
            buffer.append(thisValue.toString());
        }
    }

    @Override
    public String getChangedProperties(WebAppSecurityConfig original) {
        if (this == original) {
            return "";
        }
        if (!(original instanceof WebAppSecurityConfigImpl)) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        WebAppSecurityConfigImpl orig = (WebAppSecurityConfigImpl)original;
        this.appendToBufferIfDifferent(buf, CFG_KEY_FAIL_OVER_TO_BASICAUTH, this.allowFailOverToBasicAuth, orig.allowFailOverToBasicAuth);
        this.appendToBufferIfDifferent(buf, CFG_KEY_ALLOW_LOGOUT_PAGE_REDIRECT_TO_ANY_HOST, this.allowLogoutPageRedirectToAnyHost, orig.allowLogoutPageRedirectToAnyHost);
        this.appendToBufferIfDifferent(buf, CFG_KEY_DISPLAY_AUTHENTICATION_REALM, this.displayAuthenticationRealm, orig.displayAuthenticationRealm);
        this.appendToBufferIfDifferent(buf, CFG_KEY_HTTP_ONLY_COOKIES, this.httpOnlyCookies, orig.httpOnlyCookies);
        this.appendToBufferIfDifferent(buf, CFG_KEY_LOGOUT_ON_HTTP_SESSION_EXPIRE, this.logoutOnHttpSessionExpire, orig.logoutOnHttpSessionExpire);
        this.appendToBufferIfDifferent(buf, CFG_KEY_LOGOUT_PAGE_REDIRECT_DOMAIN_NAMES, this.logoutPageRedirectDomainNames, orig.logoutPageRedirectDomainNames);
        this.appendToBufferIfDifferent(buf, CFG_KEY_PRESERVE_FULLY_QUALIFIED_REFERRER_URL, this.preserveFullyQualifiedReferrerUrl, orig.preserveFullyQualifiedReferrerUrl);
        this.appendToBufferIfDifferent(buf, CFG_KEY_POSTPARAM_COOKIE_SIZE, this.postParamCookieSize, orig.postParamCookieSize);
        this.appendToBufferIfDifferent(buf, CFG_KEY_POSTPARAM_SAVE_METHOD, this.postParamSaveMethod, orig.postParamSaveMethod);
        this.appendToBufferIfDifferent(buf, CFG_KEY_SINGLE_SIGN_ON_ENABLED, this.singleSignonEnabled, orig.singleSignonEnabled);
        this.appendToBufferIfDifferent(buf, CFG_KEY_SSO_COOKIE_NAME, this.ssoCookieName, orig.ssoCookieName);
        this.appendToBufferIfDifferent(buf, CFG_KEY_AUTO_GEN_SSO_COOKIE_NAME, this.autoGenSsoCookieName, orig.autoGenSsoCookieName);
        this.appendToBufferIfDifferent(buf, CFG_KEY_SSO_DOMAIN_NAMES, this.ssoDomainNames, orig.ssoDomainNames);
        this.appendToBufferIfDifferent(buf, CFG_KEY_SSO_REQUIRES_SSL, this.ssoRequiresSSL, orig.ssoRequiresSSL);
        this.appendToBufferIfDifferent(buf, CFG_KEY_SSO_USE_DOMAIN_FROM_URL, this.ssoUseDomainFromURL, orig.ssoUseDomainFromURL);
        this.appendToBufferIfDifferent(buf, CFG_KEY_USE_AUTH_DATA_FOR_UNPROTECTED, this.useAuthenticationDataForUnprotectedResource, orig.useAuthenticationDataForUnprotectedResource);
        this.appendToBufferIfDifferent(buf, CFG_KEY_WEB_ALWAYS_LOGIN, this.webAlwaysLogin, orig.webAlwaysLogin);
        this.appendToBufferIfDifferent(buf, CFG_KEY_LOGIN_FORM_URL, this.loginFormURL, orig.loginFormURL);
        this.appendToBufferIfDifferent(buf, "allowFailOverToAuthMethod", this.allowFailOverToAuthMethod, orig.allowFailOverToAuthMethod);
        this.appendToBufferIfDifferent(buf, CFG_KEY_INCLUDE_PATH_IN_WAS_REQ_URL, this.includePathInWASReqURL, orig.includePathInWASReqURL);
        this.appendToBufferIfDifferent(buf, CFG_KEY_TRACK_LOGGED_OUT_SSO_COOKIES, this.trackLoggedOutSSOCookies, orig.trackLoggedOutSSOCookies);
        this.appendToBufferIfDifferent(buf, CFG_KEY_USE_ONLY_CUSTOM_COOKIE_NAME, this.useOnlyCustomCookieName, orig.useOnlyCustomCookieName);
        this.appendToBufferIfDifferent(buf, CFG_KEY_WAS_REQ_URL_REDIRECT_DOMAIN_NAMES, this.wasReqURLRedirectDomainNames, orig.wasReqURLRedirectDomainNames);
        return buf.toString();
    }

    @Override
    public SSOCookieHelper createSSOCookieHelper() {
        return new SSOCookieHelperImpl(this);
    }

    @Override
    public ReferrerURLCookieHandler createReferrerURLCookieHandler() {
        return new ReferrerURLCookieHandler(this);
    }

    @Override
    public WebAuthenticatorProxy createWebAuthenticatorProxy() {
        return new WebAuthenticatorProxy(this, null, this.securityServiceRef, null);
    }
}

