/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.beanvalidation.component;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.beanvalidation.service.BeanValidation;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.jaxrs20.BeanValidationService", property={"service.vendor=IBM"})
public class BeanValidationService {
    private static final TraceComponent tc = Tr.register(BeanValidationService.class);
    private static final String REFERENCE_BEANVALIDATION_SERVICE = "jaxrsbeanValidation";
    protected final AtomicServiceReference<BeanValidation> beanValidation = new AtomicServiceReference("jaxrsbeanValidation");
    private static volatile BeanValidationService svInstance = null;
    static final long serialVersionUID = 569278225324702192L;

    public static BeanValidationService instance() {
        return svInstance;
    }

    static void setInstance(BeanValidationService instance) {
        if (svInstance != null && instance != null) {
            throw new IllegalStateException("instance already set");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setInstance : " + Util.identity((Object)instance)), (Object[])new Object[0]);
        }
        svInstance = instance;
    }

    protected void activate(ComponentContext compcontext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Activating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        BeanValidationService.setInstance(this);
        this.beanValidation.activate(compcontext);
    }

    protected void deactivate(ComponentContext compcontext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Deactivating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        BeanValidationService.setInstance(null);
        this.beanValidation.deactivate(compcontext);
    }

    @Reference(name="jaxrsbeanValidation", service=BeanValidation.class)
    protected void setBeanValidation(ServiceReference<BeanValidation> ref) {
        this.beanValidation.setReference(ref);
    }

    protected void unsetBeanValidation(ServiceReference<BeanValidation> ref) {
        this.beanValidation.unsetReference(ref);
    }

    /*
     * WARNING - void declaration
     */
    public Validator getDefaultValidator() {
        BeanValidation beanValidation = (BeanValidation)BeanValidationService.instance().beanValidation.getService();
        if (beanValidation == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning a null Validator because the BeanValidation service is not currently unavailable. Is the bean validation feature enabled?", (Object[])new Object[0]);
            }
            return null;
        }
        try {
            ComponentMetaData componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            return beanValidation.getValidator(componentMetaData);
        }
        catch (ValidationException componentMetaData) {
            FFDCFilter.processException((Throwable)componentMetaData, (String)"com.ibm.ws.jaxrs20.beanvalidation.component.BeanValidationService", (String)"115", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("Returning a null Validator: " + e.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ValidatorFactory getDefaultValidatorFactory() {
        BeanValidation beanValidation = (BeanValidation)BeanValidationService.instance().beanValidation.getService();
        if (beanValidation == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning a null ValidatorFactory because the BeanValidation service is not currently available.  Is the bean validation feature enabled?", (Object[])new Object[0]);
            }
            return null;
        }
        try {
            ComponentMetaData componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            return beanValidation.getValidatorFactoryOrDefault(componentMetaData);
        }
        catch (ValidationException componentMetaData) {
            FFDCFilter.processException((Throwable)componentMetaData, (String)"com.ibm.ws.jaxrs20.beanvalidation.component.BeanValidationService", (String)"134", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("Returning a null ValidatorFactory: " + e.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
    }
}

