/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.internal.ClassLoadingServiceImpl;
import com.ibm.ws.container.service.app.deploy.NestedConfigHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.classloading.ClassLoadingServiceException;
import com.ibm.wsspi.classloading.GatewayConfiguration;
import com.ibm.wsspi.config.Fileset;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.library.Library;
import java.io.File;
import java.io.IOException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClassLoaderConfigHelper {
    private static final TraceComponent tc = Tr.register(ClassLoaderConfigHelper.class);
    private static final EnumSet<ApiType> DEFAULT_API_TYPES = EnumSet.of(ApiType.SPEC, ApiType.IBMAPI, ApiType.API, ApiType.STABLE);
    private final List<String> sharedLibraries;
    private final List<String> commonLibraries;
    private final List<String> classProviders;
    private String[] sharedLibrariesPids;
    private String[] commonLibrariesPids;
    private final boolean isDelegateLast;
    private final EnumSet<ApiType> apiTypes;
    private final Dictionary<String, Object> classLoaderConfigProps;
    static final long serialVersionUID = -3051196824456962209L;

    @FFDCIgnore(value={InitWithoutConfig.class})
    public ClassLoaderConfigHelper(NestedConfigHelper configHelper, ConfigurationAdmin configAdmin, ClassLoadingService classLoadingSvc) {
        Configuration cfg;
        String methodName = "ClassLoaderConfigHelper(): ";
        try {
            cfg = this.retrieveConfig(configHelper, configAdmin);
        }
        catch (InitWithoutConfig reason) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ClassLoaderConfigHelper(): " + reason.getMessage()), (Object[])new Object[0]);
            }
            this.classLoaderConfigProps = null;
            this.apiTypes = DEFAULT_API_TYPES;
            this.isDelegateLast = false;
            this.sharedLibraries = Collections.emptyList();
            this.commonLibraries = Collections.emptyList();
            this.classProviders = Collections.emptyList();
            return;
        }
        this.classLoaderConfigProps = cfg.getProperties();
        EnumMap<Attribute, Object> values = new EnumMap<Attribute, Object>(Attribute.class);
        for (Attribute attr : Attribute.values()) {
            values.put(attr, this.classLoaderConfigProps.get(attr.name()));
        }
        this.apiTypes = ApiType.createApiTypeSet((String)values.remove((Object)Attribute.apiTypeVisibility));
        Object value = values.remove((Object)Attribute.delegation);
        this.isDelegateLast = value instanceof String ? ((String)value).equalsIgnoreCase("parentLast") : false;
        this.sharedLibrariesPids = (String[])values.remove((Object)Attribute.privateLibraryRef);
        this.commonLibrariesPids = (String[])values.remove((Object)Attribute.commonLibraryRef);
        this.sharedLibraries = this.getIds(configAdmin, this.sharedLibrariesPids);
        this.commonLibraries = this.getIds(configAdmin, this.commonLibrariesPids);
        this.classProviders = this.getIds(configAdmin, (String[])values.remove((Object)Attribute.classProviderRef));
        if (values.isEmpty()) {
            return;
        }
        throw new Error("Config value(s) not dealt with! " + values);
    }

    /*
     * WARNING - void declaration
     */
    private Configuration retrieveConfig(NestedConfigHelper configHelper, ConfigurationAdmin configAdmin) throws InitWithoutConfig {
        if (configHelper == null) {
            throw new InitWithoutConfig("Configuration not found");
        }
        if (configAdmin == null) {
            throw new InitWithoutConfig("ConfigurationAdmin service not found");
        }
        String parentPid = (String)configHelper.get("service.pid");
        String sourcePid = (String)configHelper.get("ibm.extends.source.pid");
        if (sourcePid != null) {
            parentPid = sourcePid;
        }
        try {
            StringBuilder filter = new StringBuilder();
            filter.append("(&");
            filter.append(FilterUtils.createPropertyFilter((String)"service.factoryPid", (String)"com.ibm.ws.classloading.classloader"));
            filter.append(FilterUtils.createPropertyFilter((String)"config.parentPID", (String)parentPid));
            filter.append(")");
            Configuration[] configs = configAdmin.listConfigurations(filter.toString());
            if (configs == null || configs.length != 1) {
                throw new InitWithoutConfig("No classloader element found");
            }
            Configuration config = configs[0];
            if (config.getProperties() == null) {
                if (tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"cls.classloader.missing", (Object[])new Object[]{config.getPid()});
                }
                config.delete();
                throw new InitWithoutConfig("Classloader config not found");
            }
            return config;
        }
        catch (IOException filter) {
            void e;
            FFDCFilter.processException((Throwable)filter, (String)"com.ibm.ws.classloading.ClassLoaderConfigHelper", (String)"172", (Object)this, (Object[])new Object[]{configHelper, configAdmin});
            throw new InitWithoutConfig("Configuration for classloader not found, exception " + e);
        }
        catch (InvalidSyntaxException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.ClassLoaderConfigHelper", (String)"174", (Object)this, (Object[])new Object[]{configHelper, configAdmin});
            throw new InitWithoutConfig("Configuration for classloader not found, exception " + (Object)((Object)e));
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<String> getIds(ConfigurationAdmin ca, String[] pids) {
        String methodName = "getIds(): ";
        if (pids == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (String pid : pids) {
            try {
                String filter = "(service.pid=" + pid + ")";
                Configuration[] config = ca.listConfigurations(filter);
                if (config == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("getIds(): Configuration not found for pid " + pid), (Object[])new Object[0]);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getIds(): Found config for " + pid), (Object[])new Object[0]);
                }
                String id = (String)config[0].getProperties().get("id");
                ids.add(id);
            }
            catch (IOException filter) {
                void e;
                FFDCFilter.processException((Throwable)filter, (String)"com.ibm.ws.classloading.ClassLoaderConfigHelper", (String)"199", (Object)this, (Object[])new Object[]{ca, pids});
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("getIds(): Configuration not found for " + pid), (Object[])new Object[]{e});
            }
            catch (InvalidSyntaxException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.ClassLoaderConfigHelper", (String)"202", (Object)this, (Object[])new Object[]{ca, pids});
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("getIds(): Configuration not found for " + pid), (Object[])new Object[]{e});
            }
        }
        return Collections.unmodifiableList(ids);
    }

    private ClassLoader createGSLLoader(List<Container> classPath, ClassLoaderConfiguration config, ClassLoadingService classLoadingService, Library gsl) {
        ClassLoader parentCL = classLoadingService.getSharedLibraryClassLoader(gsl);
        ClassLoaderIdentity globalLibId = classLoadingService.createIdentity("Shared Library", "global");
        config.setParentId(globalLibId);
        ClassLoader loader = classLoadingService.createChildClassLoader(classPath, config);
        if ((parentCL.hashCode() > 0 || parentCL.hashCode() < 1) && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Created app class loader using global shared library loader as parent", (Object[])new Object[0]);
        }
        return loader;
    }

    private boolean folderContainsFiles(File folder) {
        if (folder != null) {
            File[] files;
            for (File file : files = folder.listFiles()) {
                if (!file.isFile()) continue;
                return true;
            }
            for (File file : files) {
                if (!file.isDirectory() || !this.folderContainsFiles(file)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDelegateLast() {
        return this.isDelegateLast;
    }

    public void processCommonLibraries(ClassLoadingService classLoadingService, ClassLoaderConfiguration config, String[] libraryPIDs) {
        if (libraryPIDs != null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(ClassLoaderConfigHelper.class).getBundleContext();
            for (String pid : libraryPIDs) {
                Collection libraryRefs;
                block12: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processCommonLibraries, pid: " + pid), (Object[])new Object[0]);
                    }
                    String libraryFilter = FilterUtils.createPropertyFilter((String)"service.pid", (String)pid);
                    libraryRefs = null;
                    try {
                        libraryRefs = bundleContext.getServiceReferences(Library.class, libraryFilter);
                    }
                    catch (InvalidSyntaxException invalidSyntaxException) {
                        FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.classloading.ClassLoaderConfigHelper", (String)"255", (Object)this, (Object[])new Object[]{classLoadingService, config, libraryPIDs});
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.debug((TraceComponent)tc, (String)"processCommonLibraries, invalidSyntaxException", (Object[])new Object[0]);
                    }
                }
                if (libraryRefs == null) continue;
                for (ServiceReference libraryRef : libraryRefs) {
                    Library library = (Library)bundleContext.getService(libraryRef);
                    if (library == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"processCommonLibraries, library is not null", (Object[])new Object[0]);
                    }
                    if (library.getFilesets() == null) continue;
                    block4: for (Fileset fileset : library.getFilesets()) {
                        for (File file : fileset.getFileset()) {
                            String path = file.getPath();
                            path = path.replace("\\", "/");
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("processCommonLibraries, path: " + path), (Object[])new Object[0]);
                            }
                            String matchingDomainKey = ((ClassLoadingServiceImpl)classLoadingService).getProtectionDomainMapKey(path);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("processCommonLibraries, matchingDomainKey: " + matchingDomainKey), (Object[])new Object[0]);
                            }
                            if (matchingDomainKey == null) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Setting the protection domain", (Object[])new Object[0]);
                            }
                            Map<String, ProtectionDomain> protectionDomainMap = ((ClassLoadingServiceImpl)classLoadingService).getProtectionDomainMap();
                            config.setProtectionDomain(protectionDomainMap.get(matchingDomainKey));
                            continue block4;
                        }
                    }
                }
            }
        }
    }

    public ClassLoader createTopLevelClassLoader(List<Container> classPath, GatewayConfiguration gwConfig, ClassLoaderConfiguration config, ClassLoadingService classLoadingService, Library globalSharedLibrary) {
        Library gsl;
        gwConfig.setApiTypeVisibility(this.apiTypes);
        if (this.classLoaderConfigProps != null) {
            config.addSharedLibraries(this.sharedLibraries);
            config.setCommonLibraries(this.commonLibraries);
            config.setClassProviders(this.classProviders);
            this.processCommonLibraries(classLoadingService, config, this.commonLibrariesPids);
            config.setDelegateToParentAfterCheckingLocalClasspath(this.isDelegateLast);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Creating class loader with parent gateway because <classloader> element config found for: " + config.getId()), (Object[])new Object[0]);
            }
            return classLoadingService.createTopLevelClassLoader(classPath, gwConfig, config);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Using common parent with common gateway for: " + config.getId()), (Object[])new Object[0]);
        }
        if ((gsl = globalSharedLibrary) == null) {
            ClassLoadingServiceException ffdcOnly = new ClassLoadingServiceException("Global shared library is null");
            FFDCFilter.processException((Throwable)ffdcOnly, (String)ClassLoadingServiceImpl.class.getSimpleName(), (String)"Missing global shared library when creating dependent class loader");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not retrieve global shared library - carrying on as if there are no global shared libraries", (Object[])new Object[0]);
            }
            return classLoadingService.createTopLevelClassLoader(classPath, gwConfig, config);
        }
        Collection<Fileset> filesets = gsl.getFilesets();
        Collection<File> folders = gsl.getFolders();
        if ((filesets == null || filesets.isEmpty()) && (folders == null || folders.isEmpty())) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not retrieve global shared library filesets - carrying on as if there are no global shared libraries", (Object[])new Object[0]);
            }
            return classLoadingService.createTopLevelClassLoader(classPath, gwConfig, config);
        }
        for (Fileset fileset : filesets) {
            Collection files;
            if (fileset == null || (files = fileset.getFileset()) == null || files.isEmpty()) continue;
            return this.createGSLLoader(classPath, config, classLoadingService, gsl);
        }
        for (File folder : folders) {
            if (!this.folderContainsFiles(folder)) continue;
            return this.createGSLLoader(classPath, config, classLoadingService, gsl);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No files found in the global shared library - ignoring global shared library", (Object[])new Object[0]);
        }
        return classLoadingService.createTopLevelClassLoader(classPath, gwConfig, config);
    }

    @Trivial
    private static class InitWithoutConfig
    extends Exception {
        public InitWithoutConfig(String because) {
            super(because);
        }
    }

    @Trivial
    static enum Attribute {
        apiTypeVisibility,
        delegation,
        privateLibraryRef,
        commonLibraryRef,
        classProviderRef;

    }
}

