/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorization.builtin.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.AccessIdUtil;
import com.ibm.ws.security.authorization.AccessDecisionService;
import com.ibm.ws.security.authorization.AuthorizationService;
import com.ibm.ws.security.authorization.AuthorizationTableService;
import com.ibm.ws.security.authorization.FeatureAuthorizationTableService;
import com.ibm.ws.security.authorization.RoleSet;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BuiltinAuthorizationService
implements AuthorizationService {
    private static final TraceComponent tc = Tr.register(BuiltinAuthorizationService.class);
    protected static final String KEY_ACCESS_DECISION_SERVICE = "accessDecisionService";
    protected static final String KEY_AUTHORIZATION_TABLE_SERVICE = "authorizationTableService";
    protected static final String KEY_USE_ROLE_AS_GROUP_NAME = "useRoleAsGroupName";
    private final AtomicServiceReference<AccessDecisionService> accessDecisionServiceRef = new AtomicServiceReference("accessDecisionService");
    private final ConcurrentServiceReferenceSet<AuthorizationTableService> authorizationTables = new ConcurrentServiceReferenceSet("authorizationTableService");
    private final SubjectManager subjManager = new SubjectManager();
    static final String KEY_FEATURE_SECURITY_AUTHZ_SERVICE = "featureAuthzTableService";
    private final AtomicServiceReference<FeatureAuthorizationTableService> featureAuthzTableServiceRef = new AtomicServiceReference("featureAuthzTableService");
    private boolean useRoleAsGroupName = false;
    private static final String MGMT_AUTHZ_ROLES = "com.ibm.ws.management";
    private final List<String> useRoleAsGroupNameForApps = new ArrayList<String>();
    static final long serialVersionUID = -7267972647635458778L;

    protected void setAccessDecisionService(ServiceReference<AccessDecisionService> ref) {
        this.accessDecisionServiceRef.setReference(ref);
    }

    protected void unsetAccessDecisionService(ServiceReference<AccessDecisionService> ref) {
        this.accessDecisionServiceRef.unsetReference(ref);
    }

    protected void setAuthorizationTableService(ServiceReference<AuthorizationTableService> ref) {
        this.authorizationTables.addReference(ref);
    }

    protected void unsetAuthorizationTableService(ServiceReference<AuthorizationTableService> ref) {
        this.authorizationTables.removeReference(ref);
    }

    protected void setFeatureAuthzTableService(ServiceReference<FeatureAuthorizationTableService> ref) {
        this.featureAuthzTableServiceRef.setReference(ref);
    }

    protected void unsetFeatureAuthzTableService(ServiceReference<FeatureAuthorizationTableService> ref) {
        this.featureAuthzTableServiceRef.unsetReference(ref);
    }

    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        this.accessDecisionServiceRef.activate(cc);
        this.authorizationTables.activate(cc);
        this.featureAuthzTableServiceRef.activate(cc);
        if (properties != null && properties.containsKey(KEY_USE_ROLE_AS_GROUP_NAME)) {
            this.useRoleAsGroupName = (Boolean)properties.get(KEY_USE_ROLE_AS_GROUP_NAME);
        }
    }

    protected void deactivate(ComponentContext cc) {
        this.accessDecisionServiceRef.deactivate(cc);
        this.authorizationTables.deactivate(cc);
        this.featureAuthzTableServiceRef.deactivate(cc);
        this.useRoleAsGroupNameForApps.clear();
    }

    public boolean isAuthorized(String resourceName, Collection<String> requiredRoles, Subject inSubject) {
        this.validateInput(resourceName, requiredRoles);
        Subject subject = inSubject;
        if (subject == null) {
            subject = this.subjManager.getCallerSubject();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Determining if Subject is authorized to access resource " + resourceName + ". Specified required roles are " + requiredRoles + "."), (Object[])new Object[]{subject});
        }
        if (requiredRoles.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Subject is authorized to access resource " + resourceName + " as there are no required roles."), (Object[])new Object[]{subject});
            }
            return true;
        }
        if (this.isEveryoneGranted(resourceName, requiredRoles)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Subject is authorized to access resource " + resourceName + " as everyone is authorized."), (Object[])new Object[]{subject});
            }
            return true;
        }
        if (!this.isSubjectValid(subject)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Subject is NOT authorized to access resource " + resourceName + " as the subject is not valid."), (Object[])new Object[]{subject});
            }
            return false;
        }
        if (this.isAllAuthenticatedGranted(resourceName, requiredRoles, subject)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Subject is authorized to access resource " + resourceName + " as all authenticated users are authorized."), (Object[])new Object[]{subject});
            }
            return true;
        }
        boolean authorized = this.isSubjectAuthorized(resourceName, requiredRoles, subject);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            if (authorized) {
                Tr.event((TraceComponent)tc, (String)("Subject is authorized to access resource " + resourceName + " as the Subject possesses one of the required roles."), (Object[])new Object[]{subject});
            } else {
                ArrayList<String> rolesList = new ArrayList<String>();
                Iterator<String> iter = requiredRoles.iterator();
                while (iter.hasNext()) {
                    rolesList.add(iter.next());
                }
                Tr.event((TraceComponent)tc, (String)("Subject is NOT authorized to access resource " + resourceName + " as the Subject does not possess one of the required roles: " + rolesList), (Object[])new Object[]{subject});
            }
        }
        return authorized;
    }

    public boolean isEveryoneGranted(String resourceName, Collection<String> requiredRoles) {
        this.validateInput(resourceName, requiredRoles);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Determining if Everyone is authorized to access resource " + resourceName + ". Specified required roles are " + requiredRoles + "."), (Object[])new Object[0]);
        }
        if (requiredRoles.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Everyone is granted access to resource " + resourceName + " as there are no required roles."), (Object[])new Object[0]);
            }
            return true;
        }
        Collection<String> roles = this.getRolesForSpecialSubject(resourceName, "EVERYONE");
        AccessDecisionService accessDecisionService = (AccessDecisionService)this.accessDecisionServiceRef.getService();
        boolean granted = accessDecisionService.isGranted(resourceName, requiredRoles, roles, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            if (granted) {
                Tr.event((TraceComponent)tc, (String)("Everyone is granted access to resource " + resourceName + "."), (Object[])new Object[0]);
            } else {
                Tr.event((TraceComponent)tc, (String)("Everyone is NOT granted access to resource " + resourceName + "."), (Object[])new Object[0]);
            }
        }
        return granted;
    }

    private Collection<String> getRolesForSpecialSubject(String resourceName, String specialSubject) {
        int found = 0;
        RoleSet roles = null;
        FeatureAuthorizationTableService featureAuthzTableSvc = (FeatureAuthorizationTableService)this.featureAuthzTableServiceRef.getService();
        String featureAuthzRoleHeaderValue = null;
        if (featureAuthzTableSvc != null) {
            featureAuthzRoleHeaderValue = featureAuthzTableSvc.getFeatureAuthzRoleHeaderValue();
        }
        if (featureAuthzRoleHeaderValue != null && !featureAuthzRoleHeaderValue.equals(MGMT_AUTHZ_ROLES)) {
            roles = featureAuthzTableSvc.getRolesForSpecialSubject(resourceName, specialSubject);
        } else {
            Iterator itr = this.authorizationTables.getServices();
            while (itr.hasNext()) {
                AuthorizationTableService authzTableSvc = (AuthorizationTableService)itr.next();
                RoleSet rolesFound = authzTableSvc.getRolesForSpecialSubject(resourceName, specialSubject);
                if (rolesFound == null) continue;
                roles = rolesFound;
                ++found;
            }
            if (found > 1) {
                Tr.error((TraceComponent)tc, (String)"AUTHZ_MULTIPLE_RESOURCES_WITH_SAME_NAME", (Object[])new Object[]{resourceName});
                roles = null;
            }
        }
        return roles;
    }

    private Collection<String> getRolesForAccessId(String resourceName, String accessId) {
        int found = 0;
        RoleSet roles = null;
        FeatureAuthorizationTableService featureAuthzTableSvc = (FeatureAuthorizationTableService)this.featureAuthzTableServiceRef.getService();
        String featureAuthzRoleHeaderValue = null;
        if (featureAuthzTableSvc != null) {
            featureAuthzRoleHeaderValue = featureAuthzTableSvc.getFeatureAuthzRoleHeaderValue();
        }
        if (featureAuthzRoleHeaderValue != null && !featureAuthzRoleHeaderValue.equals(MGMT_AUTHZ_ROLES)) {
            roles = featureAuthzTableSvc.getRolesForAccessId(resourceName, accessId);
        } else {
            Iterator itr = this.authorizationTables.getServices();
            while (itr.hasNext()) {
                AuthorizationTableService authzTableSvc = (AuthorizationTableService)itr.next();
                RoleSet rolesFound = authzTableSvc.getRolesForAccessId(resourceName, accessId);
                if (rolesFound == null) continue;
                roles = rolesFound;
                ++found;
            }
            if (found > 1) {
                Tr.error((TraceComponent)tc, (String)"AUTHZ_MULTIPLE_RESOURCES_WITH_SAME_NAME", (Object[])new Object[]{resourceName});
                roles = null;
            }
        }
        return roles;
    }

    private boolean isAuthzInfoAvailableForApp(String resourceName) {
        boolean found = false;
        FeatureAuthorizationTableService featureAuthzTableSvc = (FeatureAuthorizationTableService)this.featureAuthzTableServiceRef.getService();
        if (featureAuthzTableSvc != null) {
            found = featureAuthzTableSvc.isAuthzInfoAvailableForApp(resourceName);
        }
        if (!found) {
            Iterator itr = this.authorizationTables.getServices();
            while (itr.hasNext() && !found) {
                AuthorizationTableService authzTableSvc = (AuthorizationTableService)itr.next();
                found = authzTableSvc.isAuthzInfoAvailableForApp(resourceName);
            }
        }
        return found;
    }

    private boolean isSubjectAuthorized(String resourceName, Collection<String> requiredRoles, Subject subject) {
        AccessDecisionService accessDecisionService = (AccessDecisionService)this.accessDecisionServiceRef.getService();
        boolean isGranted = false;
        WSCredential wsCred = this.getWSCredentialFromSubject(subject);
        String accessId = this.getAccessId(wsCred);
        isGranted = this.useRoleAsGroupName && !this.isAuthzInfoAvailableForApp(resourceName) ? this.useRoleAsGroupNameForAccessDecision(resourceName, requiredRoles, subject, accessDecisionService, wsCred) : this.useAppBndForAccessDecision(resourceName, requiredRoles, subject, accessDecisionService, wsCred, accessId);
        return isGranted;
    }

    private boolean useAppBndForAccessDecision(String resourceName, Collection<String> requiredRoles, Subject subject, AccessDecisionService accessDecisionService, WSCredential wsCred, String accessId) {
        String[] groupIds;
        Collection<String> userRoles = this.getRolesForAccessId(resourceName, accessId);
        boolean isGranted = accessDecisionService.isGranted(resourceName, requiredRoles, userRoles, subject);
        if (!isGranted && (groupIds = this.getGroupIds(wsCred)) != null && groupIds.length > 0) {
            for (int i = 0; i < groupIds.length && !isGranted; ++i) {
                String groupId = groupIds[i];
                Collection<String> assignedRoles = this.getRolesForAccessId(resourceName, groupId);
                if (assignedRoles == null) continue;
                isGranted = accessDecisionService.isGranted(resourceName, requiredRoles, assignedRoles, subject);
            }
        }
        if (this.useRoleAsGroupNameForApps.contains(resourceName)) {
            this.useRoleAsGroupNameForApps.remove(resourceName);
        }
        return isGranted;
    }

    private boolean useRoleAsGroupNameForAccessDecision(String resourceName, Collection<String> requiredRoles, Subject subject, AccessDecisionService accessDecisionService, WSCredential wsCred) {
        boolean isGranted = false;
        String[] groupIds = this.getGroupIds(wsCred);
        String realmName = this.getRealmName(wsCred);
        if (groupIds != null && groupIds.length > 0) {
            ArrayList<String> assignedRoles = new ArrayList<String>();
            for (int i = 0; i < groupIds.length; ++i) {
                assignedRoles.add(AccessIdUtil.getUniqueId((String)groupIds[i], (String)realmName));
            }
            isGranted = accessDecisionService.isGranted(resourceName, requiredRoles, assignedRoles, subject);
        }
        if (!this.useRoleAsGroupNameForApps.contains(resourceName)) {
            Tr.info((TraceComponent)tc, (String)"AUTHZ_BASED_ON_ROLE_NAME_SAME_AS_GROUP_NAME", (Object[])new Object[]{resourceName});
            this.useRoleAsGroupNameForApps.add(resourceName);
        }
        return isGranted;
    }

    private WSCredential getWSCredentialFromSubject(Subject subject) {
        Set<Object> publicCreds;
        if (subject != null && (publicCreds = subject.getPublicCredentials()) != null && publicCreds.size() > 0) {
            for (Object e : publicCreds) {
                if (!(e instanceof WSCredential)) continue;
                return (WSCredential)e;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String getAccessId(WSCredential cred) {
        String accessId;
        block4: {
            accessId = null;
            try {
                accessId = cred.getAccessId();
            }
            catch (CredentialExpiredException credentialExpiredException) {
                FFDCFilter.processException((Throwable)credentialExpiredException, (String)"com.ibm.ws.security.authorization.builtin.internal.BuiltinAuthorizationService", (String)"433", (Object)this, (Object[])new Object[]{cred});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("Caught exception getting the access id: " + e), (Object[])new Object[0]);
                }
            }
            catch (CredentialDestroyedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authorization.builtin.internal.BuiltinAuthorizationService", (String)"437", (Object)this, (Object[])new Object[]{cred});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Caught exception getting the access id: " + (Object)((Object)e)), (Object[])new Object[0]);
            }
        }
        return accessId;
    }

    /*
     * WARNING - void declaration
     */
    private String[] getGroupIds(WSCredential cred) {
        ArrayList ids = null;
        if (cred != null) {
            block6: {
                try {
                    ids = cred.getGroupIds();
                }
                catch (CredentialExpiredException credentialExpiredException) {
                    FFDCFilter.processException((Throwable)credentialExpiredException, (String)"com.ibm.ws.security.authorization.builtin.internal.BuiltinAuthorizationService", (String)"460", (Object)this, (Object[])new Object[]{cred});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        void e;
                        Tr.debug((TraceComponent)tc, (String)("Caught exception getting the group access ids: " + e), (Object[])new Object[0]);
                    }
                }
                catch (CredentialDestroyedException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authorization.builtin.internal.BuiltinAuthorizationService", (String)"464", (Object)this, (Object[])new Object[]{cred});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)("Caught exception getting the group access ids: " + (Object)((Object)e)), (Object[])new Object[0]);
                }
            }
            if (ids != null) {
                return ids.toArray(new String[ids.size()]);
            }
        }
        return null;
    }

    private void validateInput(String resourceName, Collection<String> requiredRoles) {
        if (requiredRoles == null) {
            throw new NullPointerException("requiredRoles cannot be null.");
        }
        if (resourceName == null) {
            throw new NullPointerException("resourceName cannot be null.");
        }
    }

    protected boolean isAllAuthenticatedGranted(String resourceName, Collection<String> requiredRoles, Subject subject) {
        Collection<String> roles = this.getRolesForSpecialSubject(resourceName, "ALL_AUTHENTICATED_USERS");
        AccessDecisionService accessDecisionService = (AccessDecisionService)this.accessDecisionServiceRef.getService();
        return accessDecisionService.isGranted(resourceName, requiredRoles, roles, subject);
    }

    private boolean isSubjectValid(Subject subject) {
        WSCredential wsCred = this.getWSCredentialFromSubject(subject);
        if (wsCred == null) {
            return false;
        }
        return !wsCred.isUnauthenticated() && !wsCred.isBasicAuth();
    }

    /*
     * WARNING - void declaration
     */
    private String getRealmName(WSCredential cred) {
        String realmName;
        block3: {
            realmName = null;
            if (cred != null) {
                try {
                    realmName = cred.getRealmName();
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.authorization.builtin.internal.BuiltinAuthorizationService", (String)"551", (Object)this, (Object[])new Object[]{cred});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Caught exception getting the realm name: " + e), (Object[])new Object[0]);
                }
            }
        }
        return realmName;
    }
}

