/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.app.deploy;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ManifestClassPathUtils {
    static final TraceComponent tc = Tr.register(ManifestClassPathUtils.class);
    static final long serialVersionUID = 6200716064634612332L;

    public static String createEntryIdentity(Entry entry) throws UnableToAdaptException {
        String result = "";
        while (entry != null && !entry.getPath().isEmpty()) {
            result = entry.getPath() + result;
            entry = (Entry)entry.getRoot().adapt(Entry.class);
        }
        return result;
    }

    public static void processMFClasspath(Entry jarEntry, List<ContainerInfo> containers, Collection<String> resolved) throws UnableToAdaptException {
        ManifestClassPathUtils.processMFClasspath(jarEntry, containers, resolved, false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processMFClasspath(Entry jarEntry, List<ContainerInfo> containers, Collection<String> resolved, boolean addRoot) throws UnableToAdaptException {
        String mfClassPath;
        block19: {
            Entry manifestEntry;
            Container jarContainer;
            mfClassPath = null;
            if (jarEntry != null && (jarContainer = (Container)jarEntry.adapt(Container.class)) != null && (manifestEntry = jarContainer.getEntry("/META-INF/MANIFEST.MF")) != null) {
                InputStream is = null;
                try {
                    is = (InputStream)manifestEntry.adapt(InputStream.class);
                    Manifest manifest = new Manifest(is);
                    if (manifest != null) {
                        mfClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                    }
                    if (is == null) break block19;
                }
                catch (IOException manifest) {
                    try {
                        void e;
                        FFDCFilter.processException((Throwable)manifest, (String)"com.ibm.ws.container.service.app.deploy.ManifestClassPathUtils", (String)"73", null, (Object[])new Object[]{jarEntry, containers, resolved, addRoot});
                        throw new UnableToAdaptException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        if (is == null) throw throwable;
                        try {
                            is.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.container.service.app.deploy.ManifestClassPathUtils", (String)"79", null, (Object[])new Object[]{jarEntry, containers, resolved, addRoot});
                        }
                        throw throwable;
                    }
                }
                try {
                    is.close();
                }
                catch (IOException manifest) {
                    FFDCFilter.processException((Throwable)manifest, (String)"com.ibm.ws.container.service.app.deploy.ManifestClassPathUtils", (String)"79", null, (Object[])new Object[]{jarEntry, containers, resolved, addRoot});
                }
            }
        }
        if (mfClassPath == null) return;
        StringTokenizer tokenizer = new StringTokenizer(mfClassPath, " ");
        while (tokenizer.hasMoreTokens()) {
            URI pathUri;
            String path = tokenizer.nextToken();
            if (path.equals(".")) {
                if (!addRoot) continue;
                final Container rootContainer = jarEntry.getRoot();
                containers.add(new ContainerInfo(){
                    static final long serialVersionUID = -8138176996799986964L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public ContainerInfo.Type getType() {
                        return ContainerInfo.Type.MANIFEST_CLASSPATH;
                    }

                    @Override
                    public String getName() {
                        return "/";
                    }

                    @Override
                    public Container getContainer() {
                        return rootContainer;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                });
                continue;
            }
            try {
                pathUri = new URI(path);
            }
            catch (URISyntaxException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.container.service.app.deploy.ManifestClassPathUtils", (String)"117", null, (Object[])new Object[]{jarEntry, containers, resolved, addRoot});
                Tr.warning((TraceComponent)tc, (String)"WARN_INVALID_MANIFEST_CLASSPATH_DEFINITION", (Object[])new Object[]{path, jarEntry.getResource()});
                continue;
            }
            if (pathUri.isAbsolute()) {
                Tr.warning((TraceComponent)tc, (String)"WARN_INVALID_MANIFEST_CLASSPATH_DEFINITION", (Object[])new Object[]{path, jarEntry.getResource()});
                continue;
            }
            try {
                Entry classPathEntry = ManifestClassPathUtils.findClassPathEntry(jarEntry, pathUri);
                if (classPathEntry == null) {
                    Tr.warning((TraceComponent)tc, (String)"WARN_MANIFEST_CLASSPATH_NOT_FOUND", (Object[])new Object[]{path, jarEntry.getResource()});
                    continue;
                }
                final String classPathName = ManifestClassPathUtils.createEntryIdentity(classPathEntry);
                final Container classPathContainer = (Container)classPathEntry.adapt(Container.class);
                if (classPathContainer != null) {
                    containers.add(new ContainerInfo(){
                        static final long serialVersionUID = -1517262402913371521L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public ContainerInfo.Type getType() {
                            return ContainerInfo.Type.MANIFEST_CLASSPATH;
                        }

                        @Override
                        public String getName() {
                            return classPathName;
                        }

                        @Override
                        public Container getContainer() {
                            return classPathContainer;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(2.class);
                        }
                    });
                }
                if (!classPathEntry.getName().endsWith(".jar")) continue;
                ManifestClassPathUtils.addCompleteJarEntryUrls(containers, classPathEntry, resolved);
            }
            catch (URISyntaxException classPathEntry) {
                FFDCFilter.processException((Throwable)classPathEntry, (String)"com.ibm.ws.container.service.app.deploy.ManifestClassPathUtils", (String)"161", null, (Object[])new Object[]{jarEntry, containers, resolved, addRoot});
                throw new UnableToAdaptException((Throwable)e);
            }
        }
    }

    public static void addCompleteJarEntryUrls(List<ContainerInfo> containers, Entry jarEntry, Collection<String> resolved) throws UnableToAdaptException {
        String entryIdentity = ManifestClassPathUtils.createEntryIdentity(jarEntry);
        if (!entryIdentity.isEmpty() && !resolved.contains(entryIdentity)) {
            resolved.add(entryIdentity);
            ManifestClassPathUtils.processMFClasspath(jarEntry, containers, resolved);
        }
    }

    private static Entry findClassPathEntry(Entry jarEntry, URI pathUri) throws URISyntaxException, UnableToAdaptException {
        URI relativeJarUri = new URI("/").relativize(new URI(jarEntry.getPath()));
        URI targetUri = null;
        targetUri = relativeJarUri.resolve(pathUri);
        if (targetUri.toString().startsWith("..")) {
            Entry rootEntry = (Entry)jarEntry.getRoot().adapt(Entry.class);
            if (rootEntry == null || rootEntry.getPath().isEmpty()) {
                return null;
            }
            return ManifestClassPathUtils.findClassPathEntry(rootEntry, new URI("..").relativize(targetUri));
        }
        return jarEntry.getRoot().getEntry(targetUri.toString());
    }
}

