/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.injectionengine.osgi.internal;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.naming.JavaColonNamingHelper;
import com.ibm.ws.container.service.naming.NamingConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.injectionengine.osgi.internal.IndirectReference;
import com.ibm.ws.injectionengine.osgi.internal.OSGiInjectionEngineImpl;
import com.ibm.ws.injectionengine.osgi.internal.OSGiInjectionScopeData;
import com.ibm.ws.injectionengine.osgi.internal.ResourceEnvRefInfo;
import com.ibm.ws.injectionengine.osgi.internal.ResourceFactoryReference;
import com.ibm.ws.injectionengine.osgi.util.JNDIHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionScope;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.kernel.service.utils.ServiceReferenceUtils;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ObjectFactory.class, IndirectJndiLookupObjectFactory.class})
public class IndirectJndiLookupObjectFactory
implements ObjectFactory {
    private static final TraceComponent tc = Tr.register(IndirectJndiLookupObjectFactory.class);
    private BundleContext bundleContext;
    private OSGiInjectionEngineImpl injectionEngine;
    private volatile boolean javaCompDefaultEnabled;
    static final long serialVersionUID = 5904628231628438199L;

    @org.osgi.service.component.annotations.Reference
    protected void setInjectionEngine(OSGiInjectionEngineImpl injectionEngine) {
        this.injectionEngine = injectionEngine;
    }

    protected void unsetInjectionEngine(OSGiInjectionEngineImpl injectionEngine) {
    }

    @org.osgi.service.component.annotations.Reference(service=JavaColonNamingHelper.class, target="(javaCompDefault=true)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setJavaCompDefault(ServiceReference<?> reference) {
        this.javaCompDefaultEnabled = true;
    }

    protected void unsetJavaCompDefault(ServiceReference<?> reference) {
        this.javaCompDefaultEnabled = false;
    }

    @Activate
    protected void activate(BundleContext context) {
        this.bundleContext = context;
    }

    @Override
    public Object getObjectInstance(Object o, Name n, Context c, Hashtable<?, ?> envmt) throws Exception {
        if (!(o instanceof IndirectReference)) {
            return null;
        }
        IndirectReference ref = (IndirectReference)o;
        if (ref.getFactoryClassName() == null) {
            return null;
        }
        return this.getObjectInstance(c, envmt, ref.getClassName(), ref.bindingName, ref.resourceInfo, ref);
    }

    @FFDCIgnore(value={Exception.class})
    private Object getObjectInstance(Context c, Hashtable<?, ?> envmt, String className, String bindingName, ResourceInfo resourceRefInfo, IndirectReference ref) throws Exception {
        Object resource;
        block15: {
            try {
                boolean hasJNDIScheme;
                if (bindingName.startsWith("java:")) {
                    Object instance = this.getJavaObjectInstance(c, envmt, className, bindingName, resourceRefInfo, ref);
                    if (instance != null) {
                        return instance;
                    }
                    hasJNDIScheme = true;
                } else {
                    Object service;
                    Object resource2 = this.createResource(ref.name, className, bindingName, resourceRefInfo);
                    if (resource2 == null && !ref.defaultBinding) {
                        resource2 = this.createResource(ref.name, null, bindingName, resourceRefInfo);
                    }
                    if (resource2 != null) {
                        return resource2;
                    }
                    hasJNDIScheme = JNDIHelper.hasJNDIScheme(bindingName);
                    if (!hasJNDIScheme && (service = this.getJNDIServiceObjectInstance(className, bindingName, envmt)) != null) {
                        return service;
                    }
                }
                if (!hasJNDIScheme) break block15;
                try {
                    if (c == null) {
                        c = new InitialContext(envmt);
                    }
                    return c.lookup(bindingName);
                }
                catch (NoInitialContextException resource2) {
                    FFDCFilter.processException((Throwable)resource2, (String)"com.ibm.ws.injectionengine.osgi.internal.IndirectJndiLookupObjectFactory", (String)"167", (Object)this, (Object[])new Object[]{c, envmt, className, bindingName, resourceRefInfo, ref});
                }
                catch (NameNotFoundException resource2) {
                    FFDCFilter.processException((Throwable)resource2, (String)"com.ibm.ws.injectionengine.osgi.internal.IndirectJndiLookupObjectFactory", (String)"169", (Object)this, (Object[])new Object[]{c, envmt, className, bindingName, resourceRefInfo, ref});
                }
            }
            catch (Exception e) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"INDIRECT_LOOKUP_FAILED_CWNEN1006E", (Object[])new Object[]{bindingName, className, e instanceof InjectionException ? e.getLocalizedMessage() : e});
                throw new InjectionException(message, e);
            }
        }
        if (ref.defaultBinding && this.javaCompDefaultEnabled && (resource = this.createDefaultResource(className, resourceRefInfo)) != null) {
            return resource;
        }
        String refName = InjectionScope.denormalize(ref.name);
        if (ref.defaultBinding) {
            throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"DEFAULT_BINDING_OBJECT_NOT_FOUND_CWNEN1004E", (Object[])new Object[]{bindingName, className, refName}));
        }
        if (ref.bindingListenerName != null) {
            throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"LISTENER_BINDING_OBJECT_NOT_FOUND_CWNEN1005E", (Object[])new Object[]{bindingName, className, refName, ref.bindingListenerName}));
        }
        throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"BINDING_OBJECT_NOT_FOUND_CWNEN1003E", (Object[])new Object[]{bindingName, className, refName}));
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private Object getJNDIServiceObjectInstance(final String className, final String bindingName, final Hashtable<?, ?> envmt) throws Exception {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = 8028817559291721168L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws Exception {
                    return IndirectJndiLookupObjectFactory.this.getJNDIServiceObjectInstancePrivileged(className, bindingName, envmt);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        catch (PrivilegedActionException paex) {
            Throwable cause = paex.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new Error(cause);
        }
    }

    private Object getJNDIServiceObjectInstancePrivileged(String className, String bindingName, Hashtable<?, ?> envmt) throws Exception {
        String serviceNameFilter = FilterUtils.createPropertyFilter((String)"osgi.jndi.service.name", (String)bindingName);
        String nonFactoryFilter = "(!(" + ResourceFactory.class.getName() + "=*))";
        String filter = "(&" + serviceNameFilter + nonFactoryFilter + ")";
        ServiceReference[] servRefs = this.bundleContext.getAllServiceReferences(null, filter);
        if (servRefs != null) {
            ServiceReferenceUtils.sortByRankingOrder((ServiceReference[])servRefs);
            Class<?> serviceClass = null;
            for (ServiceReference servRef : servRefs) {
                Object obj;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checking service " + servRef), (Object[])new Object[0]);
                }
                if ((obj = this.bundleContext.getService(servRef)) == null) continue;
                String[] objectClass = (String[])servRef.getProperty("objectClass");
                if (className != null && IndirectJndiLookupObjectFactory.contains(objectClass, className)) {
                    if (serviceClass == null) {
                        ClassLoader tccl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
                            static final long serialVersionUID = 3253578514840895914L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public ClassLoader run() {
                                return Thread.currentThread().getContextClassLoader();
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register(2.class);
                            }
                        });
                        serviceClass = tccl.loadClass(className);
                    }
                    if (!serviceClass.isInstance(obj)) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("service object " + Util.identity((Object)obj) + " does not implement " + className), (Object[])new Object[0]);
                        continue;
                    }
                }
                return this.resolveJNDIObject(obj, servRef, objectClass, bindingName, envmt);
            }
        }
        return null;
    }

    private static boolean contains(String[] array, String find) {
        for (String value : array) {
            if (!find.equals(value)) continue;
            return true;
        }
        return false;
    }

    @FFDCIgnore(value={NamingException.class})
    private Object resolveJNDIObject(Object o, ServiceReference<?> ref, String[] objectClass, String bindingName, Hashtable<?, ?> envmt) throws Exception {
        if ("jndi".equals(ref.getProperty("osgi.jndi.service.origin")) || IndirectJndiLookupObjectFactory.contains(objectClass, Reference.class.getName())) {
            try {
                InitialContext context = new InitialContext(envmt);
                Name name = context.getNameParser("").parse(bindingName);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"calling NamingManager.getObjectInstance", (Object[])new Object[]{o, name, context, envmt});
                }
                return NamingManager.getObjectInstance(o, name, context, envmt);
            }
            catch (NamingException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ignoring NamingException from NamingManager.getObjectInstance", (Object[])new Object[]{e});
                }
                return null;
            }
        }
        return o;
    }

    private Object createResource(String refName, String className, String bindingName, ResourceInfo resourceRefInfo) throws Exception {
        String filter;
        String nameFilter = FilterUtils.createPropertyFilter((String)"jndiName", (String)bindingName);
        String createsFilter = className == null ? null : FilterUtils.createPropertyFilter((String)"creates.objectClass", (String)className);
        String string = filter = createsFilter == null ? nameFilter : "(&" + nameFilter + createsFilter + ")";
        ResourceInfo resInfo = resourceRefInfo != null ? resourceRefInfo : (className != null ? new ResourceEnvRefInfo(refName, className) : null);
        return this.createResourceWithFilter(filter, resInfo);
    }

    private Object createDefaultResource(String className, ResourceInfo resourceRefInfo) throws Exception {
        if (className != null) {
            String javaCompDefaultFilter = "(javaCompDefaultName=*)";
            String createsFilter = FilterUtils.createPropertyFilter((String)"creates.objectClass", (String)className);
            String filter = "(&" + javaCompDefaultFilter + createsFilter + ")";
            return this.createResourceWithFilter(filter, resourceRefInfo);
        }
        return null;
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private Object createResourceWithFilter(final String filter, final ResourceInfo resourceRefInfo) throws Exception {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -6200660346547324086L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws Exception {
                    return IndirectJndiLookupObjectFactory.this.createResourceWithFilterPrivileged(filter, resourceRefInfo);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            });
        }
        catch (PrivilegedActionException paex) {
            Throwable cause = paex.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new Error(cause);
        }
    }

    private Object createResourceWithFilterPrivileged(String filter, ResourceInfo resourceRefInfo) throws Exception {
        Collection serviceRefs = this.bundleContext.getServiceReferences(ResourceFactory.class, filter);
        if (serviceRefs != null) {
            for (ServiceReference serviceRef : serviceRefs) {
                ResourceFactory service = (ResourceFactory)this.bundleContext.getService(serviceRef);
                if (service == null) continue;
                Object resource = service.createResource(resourceRefInfo);
                if (resource == null) {
                    throw new NullPointerException();
                }
                return resource;
            }
        }
        return null;
    }

    private Object getJavaObjectInstance(Context c, Hashtable<?, ?> envmt, String className, String bindingName, ResourceInfo resourceRefInfo, IndirectReference ref) throws Exception {
        Object resource = null;
        NamingConstants.JavaColonNamespace namespace = NamingConstants.JavaColonNamespace.match((String)bindingName);
        if (namespace != null) {
            OSGiInjectionScopeData isd;
            ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            if (cmd != null && (isd = this.injectionEngine.getInjectionScopeData(cmd, namespace)) != null) {
                String name = namespace.unprefix(bindingName);
                InjectionBinding<?> binding = isd.getInjectionBinding(namespace, name);
                if (binding == null && isd.processDeferredReferenceData()) {
                    binding = isd.getInjectionBinding(namespace, name);
                }
                if (binding != null) {
                    resource = this.getBindingObjectInstance(c, envmt, className, resourceRefInfo, ref, binding);
                }
            }
            if (resource == null && namespace == NamingConstants.JavaColonNamespace.COMP) {
                resource = this.getDefaultJavaCompObjectInstance(namespace, bindingName, resourceRefInfo);
            }
            if (resource == null && ref.defaultBinding && !ref.name.startsWith("java:")) {
                resource = this.createResource(ref.name, className, ref.name, resourceRefInfo);
            }
        }
        return resource;
    }

    private Object getDefaultJavaCompObjectInstance(NamingConstants.JavaColonNamespace namespace, String bindingName, ResourceInfo resourceRefInfo) throws Exception {
        String name = namespace.unprefix(bindingName);
        StringBuilder filter = new StringBuilder("(&").append(FilterUtils.createPropertyFilter((String)"javaCompDefaultName", (String)name)).append("(!(ibm.extends.source.factoryPid=*))").append(')');
        return this.createResourceWithFilter(filter.toString(), resourceRefInfo);
    }

    private Object getBindingObjectInstance(Context c, Hashtable<?, ?> envmt, String className, ResourceInfo resourceRefInfo, Reference bindingRef, InjectionBinding<?> binding) throws Exception {
        Object bindingObject = binding.getBindingObject();
        if (bindingObject instanceof Reference) {
            Reference ref = (Reference)bindingObject;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ref=" + ref.getClass().getName() + ", factory=" + ref.getFactoryClassName()), (Object[])new Object[0]);
            }
            if (ref == bindingRef) {
                throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"INDIRECT_LOOKUP_LOOP_CWNEN1008E", (Object[])new Object[0]));
            }
            if (ref instanceof ResourceFactoryReference) {
                ResourceFactoryReference factoryRef = (ResourceFactoryReference)ref;
                com.ibm.ws.resource.ResourceFactory factory = factoryRef.getResourceFactory();
                return factory.createResource(resourceRefInfo);
            }
            if (ref instanceof IndirectReference) {
                ResourceInfo refResourceRefInfo;
                IndirectReference indirectRef = (IndirectReference)ref;
                String refBindingName = indirectRef.bindingName;
                String refClassName = ref.getClassName();
                if (refClassName == null) {
                    refClassName = className;
                }
                if ((refResourceRefInfo = indirectRef.resourceInfo) == null) {
                    refResourceRefInfo = resourceRefInfo;
                }
                return this.getObjectInstance(c, envmt, refClassName, refBindingName, refResourceRefInfo, indirectRef);
            }
        }
        return binding.getInjectionObject();
    }
}

