/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.faulttolerance.impl.ExecutorBuilderImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.policy.BulkheadPolicyImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.policy.CircuitBreakerPolicyImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.policy.FallbackPolicyImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.policy.RetryPolicyImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.policy.TimeoutPolicyImpl;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.ExecutorBuilder;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.FaultToleranceProviderResolver;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.PolicyExecutorProvider;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.microprofile.faulttolerance.impl.ProviderResolverImpl", service={FaultToleranceProviderResolver.class}, property={"service.vendor=IBM"}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE)
public class ProviderResolverImpl
extends FaultToleranceProviderResolver {
    private static final TraceComponent tc = Tr.register(ProviderResolverImpl.class);
    @Reference
    private WSContextService contextService;
    @Reference
    private PolicyExecutorProvider policyExecutorProvider;
    @Reference(target="(deferrable=false)")
    private ScheduledExecutorService scheduledExecutorService;
    private ScheduledExecutorService jseScheduledExecutorService;
    static final long serialVersionUID = 8184437348472404576L;

    public void activate(ComponentContext cc) {
        FaultToleranceProviderResolver.setInstance((FaultToleranceProviderResolver)this);
    }

    public void deactivate(ComponentContext cc) throws IOException {
        FaultToleranceProviderResolver.setInstance(null);
    }

    public BulkheadPolicy newBulkheadPolicy() {
        BulkheadPolicyImpl bulkhead = new BulkheadPolicyImpl();
        return bulkhead;
    }

    public RetryPolicy newRetryPolicy() {
        RetryPolicyImpl retry = new RetryPolicyImpl();
        return retry;
    }

    public CircuitBreakerPolicy newCircuitBreakerPolicy() {
        CircuitBreakerPolicyImpl circuitBreaker = new CircuitBreakerPolicyImpl();
        return circuitBreaker;
    }

    public FallbackPolicy newFallbackPolicy() {
        FallbackPolicyImpl fallback = new FallbackPolicyImpl();
        return fallback;
    }

    public TimeoutPolicy newTimeoutPolicy() {
        TimeoutPolicyImpl timeout = new TimeoutPolicyImpl();
        return timeout;
    }

    public <T, R> ExecutorBuilder<T, R> newExecutionBuilder() {
        ExecutorBuilderImpl ex = new ExecutorBuilderImpl(this.contextService, this.policyExecutorProvider, this.getScheduledExecutorService());
        return ex;
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        if (this.scheduledExecutorService == null) {
            if ("true".equalsIgnoreCase(System.getProperty("com.ibm.ws.microprofile.faulttolerance.jse"))) {
                if (this.jseScheduledExecutorService == null) {
                    this.jseScheduledExecutorService = Executors.newScheduledThreadPool(10);
                }
                this.scheduledExecutorService = this.jseScheduledExecutorService;
            } else {
                throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT4999E", (Object[])new Object[0]));
            }
        }
        return this.scheduledExecutorService;
    }
}

