/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.impl.sync;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.faulttolerance.impl.CircuitBreakerImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.ExecutionContextImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.RetryImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.TaskRunner;
import com.ibm.ws.microprofile.faulttolerance.impl.TimeoutImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.sync.SemaphoreTaskRunner;
import com.ibm.ws.microprofile.faulttolerance.impl.sync.SimpleTaskRunner;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.ExecutionException;
import com.ibm.ws.microprofile.faulttolerance.spi.Executor;
import com.ibm.ws.microprofile.faulttolerance.spi.FTExecutionContext;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeException;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.SyncFailsafe;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SynchronousExecutorImpl<R>
implements Executor<R> {
    private TaskRunner<R> taskRunner;
    private TimeoutPolicy timeoutPolicy;
    private ScheduledExecutorService scheduledExecutorService;
    private CircuitBreakerImpl circuitBreaker;
    private FallbackPolicy fallbackPolicy;
    private com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy retryPolicy;
    static final long serialVersionUID = -6308060216133668844L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SynchronousExecutorImpl(com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy retryPolicy, CircuitBreakerPolicy circuitBreakerPolicy, TimeoutPolicy timeoutPolicy, BulkheadPolicy bulkheadPolicy, FallbackPolicy fallbackPolicy, ScheduledExecutorService scheduledExecutorService) {
        this.timeoutPolicy = timeoutPolicy;
        this.scheduledExecutorService = scheduledExecutorService;
        if (circuitBreakerPolicy != null) {
            this.circuitBreaker = new CircuitBreakerImpl(circuitBreakerPolicy);
        }
        this.fallbackPolicy = fallbackPolicy;
        this.retryPolicy = retryPolicy;
        this.taskRunner = bulkheadPolicy == null ? new SimpleTaskRunner() : new SemaphoreTaskRunner(bulkheadPolicy);
    }

    protected SynchronousExecutorImpl() {
    }

    public FTExecutionContext newExecutionContext(String id_prefix, Method method, Object ... params) {
        String id = id_prefix + "_" + UUID.randomUUID();
        TimeoutImpl timeout = null;
        if (this.timeoutPolicy != null && !this.timeoutPolicy.getTimeout().isZero()) {
            timeout = new TimeoutImpl(id, this.timeoutPolicy, this.scheduledExecutorService);
        }
        RetryImpl retry = new RetryImpl(this.retryPolicy);
        ExecutionContextImpl executionContext = new ExecutionContextImpl(id, method, params, timeout, this.circuitBreaker, this.fallbackPolicy, retry);
        return executionContext;
    }

    protected Callable<R> createTask(Callable<R> callable, ExecutionContextImpl executionContext) {
        Callable<Object> task = () -> {
            R result = this.taskRunner.runTask(callable, executionContext);
            return result;
        };
        return task;
    }

    protected void preRun(ExecutionContextImpl executionContext) {
        executionContext.start();
    }

    protected boolean enableCircuitBreaker() {
        return true;
    }

    protected boolean enableFallback() {
        return true;
    }

    @FFDCIgnore(value={net.jodah.failsafe.CircuitBreakerOpenException.class, FailsafeException.class})
    public R execute(Callable<R> callable, ExecutionContext executionContext) {
        ExecutionContextImpl executionContextImpl = (ExecutionContextImpl)executionContext;
        SyncFailsafe failsafe = Failsafe.with((RetryPolicy)executionContextImpl.getRetry());
        failsafe.onRetry(t -> executionContextImpl.onRetry());
        if (executionContextImpl.getCircuitBreaker() != null && this.enableCircuitBreaker()) {
            failsafe = (SyncFailsafe)failsafe.with((CircuitBreaker)executionContextImpl.getCircuitBreaker());
        }
        if (executionContextImpl.getFallbackPolicy() != null && this.enableFallback()) {
            Callable<Object> fallback = () -> executionContextImpl.getFallbackPolicy().getFallbackFunction().execute((Object)executionContext);
            failsafe = (SyncFailsafe)failsafe.withFallback(fallback);
        }
        Callable<R> task = this.createTask(callable, executionContextImpl);
        this.preRun(executionContextImpl);
        Object result = null;
        try {
            result = failsafe.get(task);
        }
        catch (net.jodah.failsafe.CircuitBreakerOpenException e) {
            executionContextImpl.close();
            throw new CircuitBreakerOpenException((Throwable)e);
        }
        catch (FailsafeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof FaultToleranceException) {
                throw (FaultToleranceException)cause;
            }
            throw new ExecutionException(cause);
        }
        return (R)result;
    }

    public void close() {
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SynchronousExecutorImpl.class);
    }
}

