/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc.v42;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.impl.StatementCacheKey;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.jdbc.WSJdbcWrapper;
import com.ibm.ws.rsadapter.jdbc.v41.WSJdbc41CallableStatement;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.Arrays;
import java.util.Map;

public class WSJdbc42CallableStatement
extends WSJdbc41CallableStatement {
    private static final TraceComponent tc = Tr.register(WSJdbc42CallableStatement.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");

    public WSJdbc42CallableStatement(CallableStatement cstmtImplObject, WSJdbcConnection connWrapper, int theHoldability, String cstmtSQL) throws SQLException {
        super(cstmtImplObject, connWrapper, theHoldability, cstmtSQL);
    }

    public WSJdbc42CallableStatement(CallableStatement cstmtImplObject, WSJdbcConnection connWrapper, int theHoldability, String cstmtSQL, StatementCacheKey cstmtKey) throws SQLException {
        super(cstmtImplObject, connWrapper, theHoldability, cstmtSQL, cstmtKey);
    }

    public long getCompatibleUpdateCount() throws SQLException {
        return this.mcf.jdbcDriverSpecVersion >= 42 ? this.stmtImpl.getLargeUpdateCount() : (long)this.stmtImpl.getUpdateCount();
    }

    public Object getObject(int i) throws SQLException {
        Object o = super.getObject(i);
        if (o instanceof ResultSet) {
            o = this.createWrapper((ResultSet)o);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"getObject", (Object[])new Object[]{i, o});
            }
        }
        return o;
    }

    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        Object o = super.getObject(i, map);
        if (o instanceof ResultSet) {
            o = this.createWrapper((ResultSet)o);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"getObject", (Object[])new Object[]{i, o, map});
            }
        }
        return o;
    }

    public Object getObject(String parameterName) throws SQLException {
        Object o = super.getObject(parameterName);
        if (o instanceof ResultSet) {
            o = this.createWrapper((ResultSet)o);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"getObject", (Object[])new Object[]{parameterName, o});
            }
        }
        return o;
    }

    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        Object o = super.getObject(parameterName, map);
        if (o instanceof ResultSet) {
            o = this.createWrapper((ResultSet)o);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"getObject", (Object[])new Object[]{parameterName, map, o});
            }
        }
        return o;
    }

    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        Object o = super.getObject(parameterIndex, type);
        if (o instanceof ResultSet) {
            o = type.cast(this.createWrapper((ResultSet)o));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"getObject", (Object[])new Object[]{parameterIndex, type, o});
            }
        }
        return (T)o;
    }

    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        Object o = super.getObject(parameterName, type);
        if (o instanceof ResultSet) {
            o = type.cast(this.createWrapper((ResultSet)o));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"getObject", (Object[])new Object[]{parameterName, type, o});
            }
        }
        return (T)o;
    }

    public long getLargeUpdateCount() throws SQLException {
        try {
            return this.stmtImpl.getLargeUpdateCount();
        }
        catch (SQLException x) {
            FFDCFilter.processException((Throwable)x, (String)((Object)((Object)this)).getClass().getName(), (String)"699", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)x);
        }
        catch (NullPointerException x) {
            throw this.runtimeXIfNotClosed(x);
        }
    }

    public void setLargeMaxRows(long max) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"setLargeMaxRows", (Object[])new Object[]{max});
        }
        try {
            this.stmtImpl.setLargeMaxRows(max);
        }
        catch (SQLException x) {
            FFDCFilter.processException((Throwable)x, (String)((Object)((Object)this)).getClass().getName(), (String)"1041", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)x);
        }
        catch (NullPointerException x) {
            throw this.runtimeXIfNotClosed(x);
        }
        this.haveStatementPropertiesChanged = true;
    }

    public long getLargeMaxRows() throws SQLException {
        try {
            return this.stmtImpl.getLargeMaxRows();
        }
        catch (SQLException x) {
            FFDCFilter.processException((Throwable)x, (String)((Object)((Object)this)).getClass().getName(), (String)"691", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)x);
        }
        catch (NullPointerException x) {
            throw this.runtimeXIfNotClosed(x);
        }
    }

    public long[] executeLargeBatch() throws SQLException {
        long[] results;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeBatch", (Object[])new Object[0]);
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            results = this.stmtImpl.executeLargeBatch();
            this.hasBatchParameters = false;
        }
        catch (SQLException sqlX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeBatch", (Object)sqlX);
            }
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)sqlX);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeBatch", (Object)nullX);
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeBatch", (Object)Arrays.toString(results));
        }
        return results;
    }

    public long executeLargeUpdate(String sql) throws SQLException {
        long numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object[])new Object[]{sql});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.stmtImpl.executeLargeUpdate(sql);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)ex);
            }
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)nullX);
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }

    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        long numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object[])new Object[]{sql, AdapterUtil.getAutoGeneratedKeyString((int)autoGeneratedKeys)});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.stmtImpl.executeLargeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)ex);
            }
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)nullX);
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }

    public long executeLargeUpdate(String sql, int[] columnIndices) throws SQLException {
        long numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object[])new Object[]{sql, Arrays.toString(columnIndices)});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.stmtImpl.executeLargeUpdate(sql, columnIndices);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)ex);
            }
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)nullX);
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }

    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        long numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object[])new Object[]{sql, Arrays.toString(columnNames)});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.stmtImpl.executeLargeUpdate(sql, columnNames);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)ex);
            }
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)nullX);
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }

    public long executeLargeUpdate() throws SQLException {
        long numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object[])new Object[0]);
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.pstmtImpl.executeLargeUpdate();
        }
        catch (SQLException x) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)x);
            }
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)x);
        }
        catch (RuntimeException x) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)x);
            }
            throw x;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }

    public void setObject(int parameterIndex, Object x, SQLType sqlType) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("setObject #" + parameterIndex), (Object[])new Object[]{sqlType.getName()});
        }
        try {
            this.pstmtImpl.setObject(parameterIndex, x, sqlType);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbc42CallableStatement.setObject(int, Object, SQLType)", (String)"2057", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    public void setObject(int parameterIndex, Object x, SQLType sqlType, int scaleOrLength) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("setObject #" + parameterIndex), (Object[])new Object[]{sqlType.getName(), scaleOrLength});
        }
        try {
            this.pstmtImpl.setObject(parameterIndex, x, sqlType, scaleOrLength);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbc42CallableStatement.setObject(int, Object, SQLType, int)", (String)"2070", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    public void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"registerOutParameter", (Object[])new Object[]{parameterIndex, sqlType.getName()});
        }
        try {
            this.cstmtImpl.registerOutParameter(parameterIndex, sqlType);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbc42CallableStatement.registerOutParameter(int, SQLType)", (String)"2612", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    public void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"registerOutParameter", (Object[])new Object[]{parameterIndex, sqlType.getName(), scale});
        }
        try {
            this.cstmtImpl.registerOutParameter(parameterIndex, sqlType, scale);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbc42CallableStatement.registerOutParameter(int, SQLType, int)", (String)"2625", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    public void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"registerOutParameter", (Object[])new Object[]{parameterIndex, sqlType.getName(), typeName});
        }
        try {
            this.cstmtImpl.registerOutParameter(parameterIndex, sqlType, typeName);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbc42CallableStatement.registerOutParameter(int, SQLType, String)", (String)"2638", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"registerOutParameter", (Object[])new Object[]{parameterName, sqlType.getName()});
        }
        try {
            this.cstmtImpl.registerOutParameter(parameterName, sqlType);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbc42CallableStatement.registerOutParameter(String, SQLType)", (String)"2651", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"registerOutParameter", (Object[])new Object[]{parameterName, sqlType.getName(), scale});
        }
        try {
            this.cstmtImpl.registerOutParameter(parameterName, sqlType, scale);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbc42CallableStatement.registerOutParameter(String, SQLType, int)", (String)"2664", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"registerOutParameter", (Object[])new Object[]{parameterName, sqlType.getName(), typeName});
        }
        try {
            this.cstmtImpl.registerOutParameter(parameterName, sqlType, typeName);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbc42CallableStatement.registerOutParameter(String, SQLType, String)", (String)"2677", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    public void setObject(String parameterName, Object x, SQLType sqlType) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("setObject " + parameterName), (Object[])new Object[]{sqlType.getName()});
        }
        try {
            this.cstmtImpl.setObject(parameterName, x, sqlType);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbc42CallableStatement.setObject(String, Object, SQLType)", (String)"2690", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    public void setObject(String parameterName, Object x, SQLType sqlType, int scaleOrLength) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("setObject " + parameterName), (Object[])new Object[]{sqlType.getName(), scaleOrLength});
        }
        try {
            this.cstmtImpl.setObject(parameterName, x, sqlType, scaleOrLength);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbc42CallableStatement.setObject(String, Object, SQLType, int)", (String)"2703", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }
}

