/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc.v42;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.jdbc.WSJdbcWrapper;
import com.ibm.ws.rsadapter.jdbc.v41.WSJdbc41Statement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;

public class WSJdbc42Statement
extends WSJdbc41Statement {
    private static final TraceComponent tc = Tr.register(WSJdbc42Statement.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");

    public WSJdbc42Statement() {
    }

    public WSJdbc42Statement(Statement stmtImplObject, WSJdbcConnection connWrapper, int theHoldability) {
        super(stmtImplObject, connWrapper, theHoldability);
    }

    public long getCompatibleUpdateCount() throws SQLException {
        return this.mcf.jdbcDriverSpecVersion >= 42 ? this.stmtImpl.getLargeUpdateCount() : (long)this.stmtImpl.getUpdateCount();
    }

    public long getLargeUpdateCount() throws SQLException {
        try {
            return this.stmtImpl.getLargeUpdateCount();
        }
        catch (SQLException x) {
            FFDCFilter.processException((Throwable)x, (String)((Object)((Object)this)).getClass().getName(), (String)"699", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)x);
        }
        catch (NullPointerException x) {
            throw this.runtimeXIfNotClosed(x);
        }
    }

    public void setLargeMaxRows(long max) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"setLargeMaxRows", (Object[])new Object[]{max});
        }
        try {
            this.stmtImpl.setLargeMaxRows(max);
        }
        catch (SQLException x) {
            FFDCFilter.processException((Throwable)x, (String)((Object)((Object)this)).getClass().getName(), (String)"1041", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)x);
        }
        catch (NullPointerException x) {
            throw this.runtimeXIfNotClosed(x);
        }
        this.haveStatementPropertiesChanged = true;
    }

    public long getLargeMaxRows() throws SQLException {
        try {
            return this.stmtImpl.getLargeMaxRows();
        }
        catch (SQLException x) {
            FFDCFilter.processException((Throwable)x, (String)((Object)((Object)this)).getClass().getName(), (String)"691", (Object)((Object)this));
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)x);
        }
        catch (NullPointerException x) {
            throw this.runtimeXIfNotClosed(x);
        }
    }

    public long[] executeLargeBatch() throws SQLException {
        long[] results;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeBatch", (Object[])new Object[0]);
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            results = this.stmtImpl.executeLargeBatch();
            this.hasBatchParameters = false;
        }
        catch (SQLException sqlX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeBatch", (Object)sqlX);
            }
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)sqlX);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeBatch", (Object)nullX);
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeBatch", (Object)Arrays.toString(results));
        }
        return results;
    }

    public long executeLargeUpdate(String sql) throws SQLException {
        long numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object[])new Object[]{sql});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.stmtImpl.executeLargeUpdate(sql);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)ex);
            }
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)nullX);
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }

    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        long numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object[])new Object[]{sql, AdapterUtil.getAutoGeneratedKeyString((int)autoGeneratedKeys)});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.stmtImpl.executeLargeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)ex);
            }
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)nullX);
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }

    public long executeLargeUpdate(String sql, int[] columnIndices) throws SQLException {
        long numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object[])new Object[]{sql, Arrays.toString(columnIndices)});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.stmtImpl.executeLargeUpdate(sql, columnIndices);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)ex);
            }
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)nullX);
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }

    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        long numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object[])new Object[]{sql, Arrays.toString(columnNames)});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.stmtImpl.executeLargeUpdate(sql, columnNames);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)ex);
            }
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)nullX);
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"executeLargeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }
}

