/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.filemonitor.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.kernel.filemonitor.internal.DirectoryUpdateMonitor;
import com.ibm.ws.kernel.filemonitor.internal.FileUpdateMonitor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.util.Collection;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class UpdateMonitor {
    protected final File monitoredFile;
    protected final MonitorType type;
    protected final int hashCode;
    static final long serialVersionUID = -875158385776044743L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static UpdateMonitor getMonitor(File monitoredFile, MonitorType type, String filter) {
        if (monitoredFile == null) {
            throw new NullPointerException("MonitoredFile must be non-null");
        }
        if (type == null) {
            throw new NullPointerException("MonitorType must be non-null");
        }
        switch (type) {
            case DIRECTORY: 
            case DIRECTORY_RECURSE: 
            case DIRECTORY_SELF: 
            case DIRECTORY_RECURSE_SELF: {
                return new DirectoryUpdateMonitor(monitoredFile, type, filter);
            }
            case FILE: {
                return new FileUpdateMonitor(monitoredFile);
            }
        }
        throw new IllegalArgumentException("Unknown monitor type: " + (Object)((Object)type));
    }

    protected UpdateMonitor(File monitoredFile, MonitorType type) {
        this.monitoredFile = monitoredFile;
        this.type = type;
        int prime = 31;
        int result = 1;
        result = 31 * result + monitoredFile.hashCode();
        this.hashCode = 31 * result + type.hashCode();
    }

    public abstract void init(Collection<File> var1);

    protected abstract void destroy();

    public abstract void scanForUpdates(Collection<File> var1, Collection<File> var2, Collection<File> var3);

    protected void addToList(Collection<File> created, File file) {
        if (created != null) {
            created.add(file);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type=" + (Object)((Object)this.type) + ",file=" + this.monitoredFile + "]";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateMonitor other = (UpdateMonitor)obj;
        if (this.monitoredFile == null ? other.monitoredFile != null : !this.monitoredFile.equals(other.monitoredFile)) {
            return false;
        }
        return this.type == other.type;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(UpdateMonitor.class);
    }

    @Trivial
    public static enum MonitorType {
        FILE,
        DIRECTORY,
        DIRECTORY_RECURSE,
        DIRECTORY_SELF,
        DIRECTORY_RECURSE_SELF;

    }
}

