/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.metrics.impl.Clock;
import com.ibm.ws.microprofile.metrics.impl.Reservoir;
import com.ibm.ws.microprofile.metrics.impl.ThreadLocalRandomProxy;
import com.ibm.ws.microprofile.metrics.impl.WeightedSnapshot;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.microprofile.metrics.Snapshot;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ExponentiallyDecayingReservoir
implements Reservoir {
    private static final int DEFAULT_SIZE = 1028;
    private static final double DEFAULT_ALPHA = 0.015;
    private static final long RESCALE_THRESHOLD;
    private final ConcurrentSkipListMap<Double, WeightedSnapshot.WeightedSample> values = new ConcurrentSkipListMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final double alpha;
    private final int size;
    private final AtomicLong count;
    private volatile long startTime;
    private final AtomicLong nextScaleTime;
    private final Clock clock;
    static final long serialVersionUID = -5324164717188159070L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ExponentiallyDecayingReservoir() {
        this(1028, 0.015);
    }

    public ExponentiallyDecayingReservoir(int size, double alpha) {
        this(size, alpha, Clock.defaultClock());
    }

    public ExponentiallyDecayingReservoir(int size, double alpha, Clock clock) {
        this.alpha = alpha;
        this.size = size;
        this.clock = clock;
        this.count = new AtomicLong(0L);
        this.startTime = this.currentTimeInSeconds();
        this.nextScaleTime = new AtomicLong(clock.getTick() + RESCALE_THRESHOLD);
    }

    @Override
    public int size() {
        return (int)Math.min((long)this.size, this.count.get());
    }

    @Override
    public void update(long value) {
        this.update(value, this.currentTimeInSeconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long value, long timestamp) {
        this.rescaleIfNeeded();
        this.lockForRegularUsage();
        try {
            double itemWeight = this.weight(timestamp - this.startTime);
            WeightedSnapshot.WeightedSample sample = new WeightedSnapshot.WeightedSample(value, itemWeight);
            double priority = itemWeight / ThreadLocalRandomProxy.current().nextDouble();
            long newCount = this.count.incrementAndGet();
            if (newCount <= (long)this.size) {
                this.values.put(priority, sample);
            } else {
                Double first = this.values.firstKey();
                if (first < priority && this.values.putIfAbsent(priority, sample) == null) {
                    while (this.values.remove(first) == null) {
                        first = this.values.firstKey();
                    }
                }
            }
        }
        finally {
            this.unlockForRegularUsage();
        }
    }

    private void rescaleIfNeeded() {
        long next;
        long now = this.clock.getTick();
        if (now >= (next = this.nextScaleTime.get())) {
            this.rescale(now, next);
        }
    }

    @Override
    public Snapshot getSnapshot() {
        this.rescaleIfNeeded();
        this.lockForRegularUsage();
        try {
            WeightedSnapshot weightedSnapshot = new WeightedSnapshot(this.values.values());
            return weightedSnapshot;
        }
        finally {
            this.unlockForRegularUsage();
        }
    }

    private long currentTimeInSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.clock.getTime());
    }

    private double weight(long t) {
        return Math.exp(this.alpha * (double)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescale(long now, long next) {
        this.lockForRescale();
        try {
            if (this.nextScaleTime.compareAndSet(next, now + RESCALE_THRESHOLD)) {
                long oldStartTime = this.startTime;
                this.startTime = this.currentTimeInSeconds();
                double scalingFactor = Math.exp(-this.alpha * (double)(this.startTime - oldStartTime));
                if (Double.compare(scalingFactor, 0.0) == 0) {
                    this.values.clear();
                } else {
                    ArrayList keys = new ArrayList(this.values.keySet());
                    for (Double key : keys) {
                        WeightedSnapshot.WeightedSample sample = this.values.remove(key);
                        WeightedSnapshot.WeightedSample newSample = new WeightedSnapshot.WeightedSample(sample.value, sample.weight * scalingFactor);
                        this.values.put(key * scalingFactor, newSample);
                    }
                }
                this.count.set(this.values.size());
            }
        }
        finally {
            this.unlockForRescale();
        }
    }

    private void unlockForRescale() {
        this.lock.writeLock().unlock();
    }

    private void lockForRescale() {
        this.lock.writeLock().lock();
    }

    private void lockForRegularUsage() {
        this.lock.readLock().lock();
    }

    private void unlockForRegularUsage() {
        this.lock.readLock().unlock();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ExponentiallyDecayingReservoir.class);
        RESCALE_THRESHOLD = TimeUnit.HOURS.toNanos(1L);
    }
}

