/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.metrics.impl.Clock;
import com.ibm.ws.microprofile.metrics.impl.ExponentiallyDecayingReservoir;
import com.ibm.ws.microprofile.metrics.impl.HistogramImpl;
import com.ibm.ws.microprofile.metrics.impl.MeterImpl;
import com.ibm.ws.microprofile.metrics.impl.Reservoir;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TimerImpl
implements Timer {
    private final Meter meter;
    private final Histogram histogram;
    private final Clock clock;
    static final long serialVersionUID = 2037583049049402369L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TimerImpl() {
        this(new ExponentiallyDecayingReservoir());
    }

    public TimerImpl(Reservoir reservoir) {
        this(reservoir, Clock.defaultClock());
    }

    TimerImpl(Reservoir reservoir, Clock clock) {
        this.meter = new MeterImpl(clock);
        this.clock = clock;
        this.histogram = new HistogramImpl(reservoir);
    }

    public void update(long duration, TimeUnit unit) {
        this.update(unit.toNanos(duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = this.clock.getTick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(this.clock.getTick() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void time(Runnable event) {
        long startTime = this.clock.getTick();
        try {
            event.run();
        }
        finally {
            this.update(this.clock.getTick() - startTime);
        }
    }

    public Context time() {
        return new Context(this, this.clock);
    }

    public long getCount() {
        return this.histogram.getCount();
    }

    public double getFifteenMinuteRate() {
        return this.meter.getFifteenMinuteRate();
    }

    public double getFiveMinuteRate() {
        return this.meter.getFiveMinuteRate();
    }

    public double getMeanRate() {
        return this.meter.getMeanRate();
    }

    public double getOneMinuteRate() {
        return this.meter.getOneMinuteRate();
    }

    public Snapshot getSnapshot() {
        return this.histogram.getSnapshot();
    }

    private void update(long duration) {
        if (duration >= 0L) {
            this.histogram.update(duration);
            this.meter.mark();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(TimerImpl.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class Context
    implements Timer.Context {
        private final TimerImpl timer;
        private final Clock clock;
        private final long startTime;
        static final long serialVersionUID = 1640667897917146265L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private Context(TimerImpl timer, Clock clock) {
            this.timer = timer;
            this.clock = clock;
            this.startTime = clock.getTick();
        }

        public long stop() {
            long elapsed = this.clock.getTick() - this.startTime;
            this.timer.update(elapsed, TimeUnit.NANOSECONDS);
            return elapsed;
        }

        public void close() {
            this.stop();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Context.class);
        }
    }
}

