/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.v21.cdi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.enterprise.inject.spi.BeanManager;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BeanManagerInvocationHandler
implements InvocationHandler {
    private static final TraceComponent tc = Tr.register(BeanManagerInvocationHandler.class);
    private final CDIService cdiService;
    private BeanManager target;
    static final long serialVersionUID = -9155329660217983967L;

    BeanManagerInvocationHandler(CDIService cdiService) {
        this.cdiService = cdiService;
    }

    public String toString() {
        return super.toString() + '[' + this.target + ']';
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @FFDCIgnore(value={InvocationTargetException.class})
    public Object invoke(@Sensitive Object proxy, Method method, @Sensitive Object[] args) throws Throwable {
        Object ret;
        String methodName = method.getName();
        if (method.getDeclaringClass() == Object.class) {
            if ("toString".equals(methodName)) {
                return proxy.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(proxy)) + '[' + this + ']';
            }
            if ("equals".equals(methodName)) {
                return proxy == args[0];
            }
            if ("hashCode".equals(methodName)) {
                return this.getTarget().hashCode();
            }
            throw new UnsupportedOperationException(method.toString());
        }
        try {
            ret = method.invoke((Object)this.getTarget(), args);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invoked BeanManager method", (Object[])new Object[]{this.cdiService, method, args, ret});
            }
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (Throwable e) {
            void t;
            Object[] objectArray = new Object[3];
            objectArray[0] = "<sensitive java.lang.Object>";
            objectArray[1] = method;
            objectArray[2] = "<sensitive java.lang.Object[]>";
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.BeanManagerInvocationHandler", (String)"68", (Object)this, (Object[])objectArray);
            throw new IllegalStateException((Throwable)t);
        }
        return ret;
    }

    private BeanManager getTarget() {
        if (this.target == null) {
            this.target = this.cdiService.getCurrentBeanManager();
            if (this.target == null) {
                throw new UnsupportedOperationException("No current bean manager found in CDI service");
            }
        }
        return this.target;
    }
}

