/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.registry.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.wim.ConfigManager;
import com.ibm.ws.security.wim.VMMService;
import com.ibm.ws.security.wim.registry.WIMUserRegistryDefines;
import com.ibm.ws.security.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.security.wim.util.UniqueNameHelper;
import com.ibm.wsspi.security.wim.exception.CertificateMapFailedException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Context;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.ExternalNameControl;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.LoginControl;
import com.ibm.wsspi.security.wim.model.PropertyControl;
import com.ibm.wsspi.security.wim.model.Root;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BridgeUtils
implements WIMUserRegistryDefines {
    private static final TraceComponent tc = Tr.register(BridgeUtils.class);
    private short groupLevel = 1;
    public boolean returnRealmInfoInUniqueUserId = false;
    private final String groupLevelLock = "GROUP_LEVEL_LOCK";
    public boolean allowDNAsPrincipalName = false;
    private static final String ALLOW_DN_PRINCIPAL_NAME_AS_LITERAL = "com.ibm.ws.wim.registry.allowDNPrincipalNameAsLiteral";
    String urRealmName = null;
    private final VMMService VMMServiceRef;
    private final ConfigManager configMgrRef;
    private boolean hasFederatedRegistry = false;
    static final long serialVersionUID = -7680609249606796448L;

    public BridgeUtils(VMMService VMMServiceRef, ConfigManager configRef) {
        this.VMMServiceRef = VMMServiceRef;
        this.configMgrRef = configRef;
    }

    public VMMService getWimService() {
        return this.VMMServiceRef;
    }

    public ConfigManager getCoreConfiguration() {
        return this.configMgrRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FFDCIgnore(value={NumberFormatException.class})
    public void initialize(Map<String, Object> inputProperties) {
        String allowDNInPrincipalNameAsLiteral;
        String methodName = "initialize";
        this.urRealmName = (String)inputProperties.get("realm");
        String retRealmInfo = (String)inputProperties.get("com.ibm.ws.wim.registry.returnRealmQualifiedId");
        if (retRealmInfo != null) {
            this.returnRealmInfoInUniqueUserId = Boolean.parseBoolean(retRealmInfo);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " " + "com.ibm.ws.wim.registry.returnRealmQualifiedId" + " = " + this.returnRealmInfoInUniqueUserId), (Object[])new Object[]{methodName});
        }
        if ((allowDNInPrincipalNameAsLiteral = (String)inputProperties.get(ALLOW_DN_PRINCIPAL_NAME_AS_LITERAL)) != null) {
            this.allowDNAsPrincipalName = Boolean.parseBoolean(allowDNInPrincipalNameAsLiteral);
        }
        String groupChoice = (String)inputProperties.get("com.ibm.ws.wim.registry.grouplevel");
        try {
            if (groupChoice == null || groupChoice.equals("")) {
                String string = "GROUP_LEVEL_LOCK";
                synchronized ("GROUP_LEVEL_LOCK") {
                    this.groupLevel = 1;
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return;
                }
            }
            if (Short.parseShort(groupChoice) == 1) {
                String string = "GROUP_LEVEL_LOCK";
                synchronized ("GROUP_LEVEL_LOCK") {
                    this.groupLevel = 1;
                    // ** MonitorExit[var6_7] (shouldn't be in output)
                    return;
                }
            }
            if (Short.parseShort(groupChoice) == 0) {
                String string = "GROUP_LEVEL_LOCK";
                synchronized ("GROUP_LEVEL_LOCK") {
                    this.groupLevel = 0;
                    // ** MonitorExit[var6_8] (shouldn't be in output)
                    return;
                }
            }
            String string = "GROUP_LEVEL_LOCK";
            synchronized ("GROUP_LEVEL_LOCK") {
                this.groupLevel = 0;
                // ** MonitorExit[var6_9] (shouldn't be in output)
                return;
            }
        }
        catch (NumberFormatException toCatch) {
            String string = "GROUP_LEVEL_LOCK";
            synchronized ("GROUP_LEVEL_LOCK") {
                this.groupLevel = 0;
                // ** MonitorExit[var7_12] (shouldn't be in output)
                return;
            }
        }
    }

    protected void validateId(String inputId) throws WIMException {
        if (inputId == null) {
            throw new WIMException();
        }
    }

    protected void validateLimit(int inputLimit) throws WIMException {
        if (inputLimit < 0) {
            throw new WIMException(Integer.toString(inputLimit));
        }
    }

    protected void validateCertificate(X509Certificate inputCertificate) throws CertificateMapFailedException {
        if (inputCertificate == null) {
            throw new CertificateMapFailedException();
        }
    }

    protected IDAndRealm separateIDAndRealm(String inputString) throws WIMException {
        String methodName = "seperateIDAndRealm";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " inputString = \"" + inputString + "\""), (Object[])new Object[0]);
        }
        String defaultRealm = this.getDefaultRealmName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " Default realm name = \"" + defaultRealm + "\""), (Object[])new Object[0]);
        }
        String defaultRealmDelimiter = this.getCoreConfiguration().getDefaultDelimiter();
        HashSet<String> virtualRealms = this.getCoreConfiguration().getRealmNames();
        HashMap<String, String> virtualRealmsDelimiter = new HashMap<String, String>();
        for (String virtualRealm : virtualRealms) {
            String delimiter = this.getCoreConfiguration().getDelimiter(virtualRealm);
            virtualRealmsDelimiter.put(virtualRealm, delimiter);
        }
        if (virtualRealms.size() == 0) {
            virtualRealms = new HashSet<String>();
            virtualRealms.add(defaultRealm);
            virtualRealmsDelimiter.put(defaultRealm, defaultRealmDelimiter);
        }
        return this.seperateIDAndRealm(inputString, defaultRealm, defaultRealmDelimiter, virtualRealms, virtualRealmsDelimiter);
    }

    protected IDAndRealm seperateIDAndRealm(String inputString, String defaultRealm, String defaultRealmDelimiter, Set virtualRealms, Map virtualRealmsDelimiter) throws WIMException {
        IDAndRealm returnValue = null;
        boolean found = false;
        boolean realmFound = false;
        Iterator toUse = virtualRealms.iterator();
        block0: while (toUse.hasNext() && !found) {
            StringBuffer buffer = new StringBuffer();
            String virtualRealm = (String)toUse.next();
            String delimiter = (String)virtualRealmsDelimiter.get(virtualRealm);
            returnValue = new IDAndRealm();
            for (int i = inputString.length() - 1; i >= 0; --i) {
                if (Character.toString(inputString.charAt(i)).equals(delimiter)) {
                    if (!returnValue.isRealmDefined()) {
                        if (i - 1 >= 0 && inputString.charAt(i - 1) == '\\') {
                            buffer.append(inputString.charAt(i));
                            --i;
                            continue;
                        }
                        String realm = buffer.reverse().toString();
                        if (!virtualRealm.equals(realm)) continue block0;
                        returnValue.setDelimiter(delimiter);
                        returnValue.setRealm(realm);
                        buffer.setLength(0);
                        realmFound = true;
                        continue;
                    }
                    if (i - 1 >= 0 && inputString.charAt(i - 1) == '\\') {
                        buffer.append(inputString.charAt(i));
                        --i;
                        continue;
                    }
                    throw new WIMException(inputString);
                }
                if (i == 0 && realmFound) {
                    buffer.append(inputString.charAt(i));
                    returnValue.setId(buffer.reverse().toString());
                    found = true;
                    continue block0;
                }
                if (i == 0) {
                    buffer.append(inputString.charAt(i));
                    returnValue.setId(buffer.reverse().toString());
                    buffer.setLength(0);
                    continue;
                }
                buffer.append(inputString.charAt(i));
            }
        }
        if (!returnValue.isRealmDefined()) {
            returnValue.setDelimiter(defaultRealmDelimiter);
            returnValue.setRealm(defaultRealm);
        }
        if (!found && returnValue.getId().equals("")) {
            returnValue.setId(inputString);
        }
        return returnValue;
    }

    public boolean isIdentifierTypeProperty(String inputProperty) {
        boolean returnValue = false;
        if (inputProperty != null && (inputProperty.equals("uniqueId") || inputProperty.equals("uniqueName") || inputProperty.equals("externalId") || inputProperty.equals("externalName"))) {
            returnValue = true;
        }
        return returnValue;
    }

    protected void createRealmDataObject(Root inputRootObject, String inputRealm) {
        List contexts = inputRootObject.getContexts();
        if (contexts != null) {
            Context ctx = new Context();
            ctx.setKey("realm");
            ctx.setValue((Object)inputRealm);
            contexts.add(ctx);
        }
    }

    protected void createPropertyControlDataObject(Root inputRootDataObject, String inputProperty) {
        List propertyControls = inputRootDataObject.getControls();
        PropertyControl propCtrl = null;
        if (propertyControls != null) {
            propCtrl = new PropertyControl();
            propertyControls.add(propCtrl);
        }
        if (propCtrl != null) {
            propCtrl.getProperties().add(inputProperty);
        }
    }

    protected void createLoginControlDataObject(Root inputRootDataObject, String inputProperty) {
        List propertyControls = inputRootDataObject.getControls();
        LoginControl loginCtrl = null;
        if (propertyControls != null) {
            loginCtrl = new LoginControl();
            propertyControls.add(loginCtrl);
        }
        if (loginCtrl != null) {
            loginCtrl.getProperties().add(inputProperty);
        }
    }

    protected Root getEntityByIdentifier(Root root, String inputAttrName, String inputAttrValue, String outputAttrName, BridgeUtils mapUtils) throws WIMException {
        boolean isInputAttrIdentifier = mapUtils.isIdentifierTypeProperty(inputAttrName);
        boolean isInputAttrExternalId = inputAttrName.equals("externalName");
        boolean isOutputAttrIdentifier = mapUtils.isIdentifierTypeProperty(outputAttrName);
        Root returnValue = null;
        if (isInputAttrIdentifier || this.hasFederatedRegistry) {
            List controls;
            if (!isOutputAttrIdentifier) {
                mapUtils.createPropertyControlDataObject(root, outputAttrName);
            }
            List entities = root.getEntities();
            Entity entity = null;
            if (entities != null) {
                entity = new Entity();
                entities.add(entity);
            }
            if (entity != null) {
                IdentifierType idfType = new IdentifierType();
                if ("principalName".equalsIgnoreCase(inputAttrName) || "CN".equalsIgnoreCase(inputAttrName)) {
                    idfType.set("uniqueName", (Object)inputAttrValue);
                } else {
                    idfType.set(inputAttrName, (Object)inputAttrValue);
                }
                entity.setIdentifier(idfType);
            }
            if (isInputAttrExternalId && (controls = root.getControls()) != null) {
                controls.add(new ExternalNameControl());
            }
            if ((returnValue = mapUtils.getWimService().get(root)) != null && returnValue.getEntities().isEmpty()) {
                returnValue = null;
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    protected short getGroupDepth() {
        String string = "GROUP_LEVEL_LOCK";
        synchronized ("GROUP_LEVEL_LOCK") {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.groupLevel;
        }
    }

    protected String getRealInputAttrName(String inputAttrName, String id, boolean isUser) {
        boolean isInputAttrValueDN = UniqueNameHelper.isDN((String)id) != null;
        boolean isInputAttrIdentifier = this.isIdentifierTypeProperty(inputAttrName);
        if (!isInputAttrIdentifier && isInputAttrValueDN) {
            inputAttrName = "uniqueName";
        } else if (isInputAttrIdentifier && !isInputAttrValueDN) {
            inputAttrName = isUser ? "principalName" : "cn";
        }
        return inputAttrName;
    }

    public String getDefaultRealmName() {
        String returnRealm = this.getCoreConfiguration().getDefaultRealmName();
        if (returnRealm == null) {
            returnRealm = this.urRealmName;
        }
        return returnRealm;
    }

    public void addFederationRegistries(List<UserRegistry> registries) {
        if (!registries.isEmpty()) {
            this.getWimService().addFederationRegistries(registries);
            this.hasFederatedRegistry = true;
        }
    }

    public void removeAllFederatedRegistries() {
        this.getWimService().removeAllFederatedRegistries();
        this.hasFederatedRegistry = false;
    }
}

