/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.registry.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.websphere.security.wim.util.PasswordUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.CertificateMapNotSupportedException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.security.wim.registry.util.BridgeUtils;
import com.ibm.ws.security.wim.registry.util.TypeMappings;
import com.ibm.wsspi.security.wim.exception.CertificateMapFailedException;
import com.ibm.wsspi.security.wim.exception.PasswordCheckFailedException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Context;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.LoginAccount;
import com.ibm.wsspi.security.wim.model.LoginControl;
import com.ibm.wsspi.security.wim.model.Root;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LoginBridge {
    private static final TraceComponent tc = Tr.register(LoginBridge.class);
    private TypeMappings propertyMap = null;
    private BridgeUtils mappingUtils = null;
    static final long serialVersionUID = 5792269901425903980L;

    public LoginBridge(BridgeUtils mappingUtil) {
        this.mappingUtils = mappingUtil;
        this.propertyMap = new TypeMappings(mappingUtil);
    }

    @FFDCIgnore(value={WIMException.class})
    public String checkPassword(String inputUser, @Sensitive String inputPassword) throws RegistryException {
        StringBuffer returnValue = new StringBuffer();
        try {
            String outputAttrName;
            this.mappingUtils.validateId(inputUser);
            IDAndRealm idAndRealm = this.mappingUtils.separateIDAndRealm(inputUser);
            Root root = this.mappingUtils.getWimService().createRootObject();
            if (idAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
                List contexts = root.getContexts();
                if (contexts != null) {
                    Context ctx = new Context();
                    ctx.setKey("allowOperationIfReposDown");
                    ctx.setValue((Object)this.mappingUtils.getCoreConfiguration().isAllowOpIfRepoDown(idAndRealm.getRealm()));
                    contexts.add(ctx);
                }
            }
            if (!this.mappingUtils.isIdentifierTypeProperty(outputAttrName = this.propertyMap.getOutputUserSecurityName(idAndRealm.getRealm()))) {
                this.mappingUtils.createLoginControlDataObject(root, outputAttrName);
            } else {
                LoginControl ctrl = new LoginControl();
                ctrl.setCountLimit(this.mappingUtils.getCoreConfiguration().getMaxSearchResults() + 1);
                root.getControls().add(ctrl);
            }
            List entities = root.getEntities();
            LoginAccount loginAct = new LoginAccount();
            if (entities != null) {
                entities.add(loginAct);
            }
            loginAct.setPrincipalName(idAndRealm.getId());
            loginAct.setPassword(PasswordUtil.getByteArrayPassword((String)inputPassword));
            root = this.mappingUtils.getWimService().login(root);
            List returnList = root.getEntities();
            if (returnList.isEmpty()) {
                if (tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputUser));
                }
                throw new PasswordCheckFailedException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputUser)));
            }
            Entity entity = (Entity)returnList.get(0);
            if (!this.mappingUtils.isIdentifierTypeProperty(outputAttrName)) {
                returnValue.append(entity.get(outputAttrName));
            } else {
                returnValue.append(entity.getIdentifier().get(outputAttrName));
            }
            if (idAndRealm.isRealmDefined() && !this.mappingUtils.getDefaultRealmName().equals(idAndRealm.getRealm())) {
                returnValue.append(idAndRealm.getDelimiter() + idAndRealm.getRealm());
            }
        }
        catch (WIMException toCatch) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)toCatch.getMessage(), (Object[])new Object[]{toCatch});
            }
            if (tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)toCatch.getMessage(), (Object[])new Object[]{toCatch});
            }
            throw new RegistryException(toCatch.getMessage(), (Throwable)toCatch);
        }
        return returnValue.toString();
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={WIMException.class})
    public String mapCertificate(X509Certificate inputCertificate) throws CertificateMapNotSupportedException, com.ibm.ws.security.registry.CertificateMapFailedException, RegistryException {
        StringBuffer returnValue = new StringBuffer();
        try {
            this.mappingUtils.validateCertificate(inputCertificate);
            IDAndRealm idAndRealm = this.mappingUtils.separateIDAndRealm("");
            Root root = this.mappingUtils.getWimService().createRootObject();
            String outputAttrName = this.propertyMap.getOutputUserSecurityName(idAndRealm.getRealm());
            if (!this.mappingUtils.isIdentifierTypeProperty(outputAttrName)) {
                this.mappingUtils.createLoginControlDataObject(root, outputAttrName);
            }
            List entities = root.getEntities();
            LoginAccount loginAct = new LoginAccount();
            if (entities != null) {
                entities.add(loginAct);
            }
            loginAct.getCertificate().add(inputCertificate.getEncoded());
            root = this.mappingUtils.getWimService().login(root);
            List returnList = root.getEntities();
            if (returnList.isEmpty()) {
                throw new CertificateMapFailedException();
            }
            Entity entity = (Entity)returnList.get(0);
            if (!this.mappingUtils.isIdentifierTypeProperty(outputAttrName)) {
                returnValue.append(entity.get(outputAttrName));
            } else {
                returnValue.append(entity.getIdentifier().get(outputAttrName));
            }
            if (idAndRealm.isRealmDefined() && !this.mappingUtils.getDefaultRealmName().equals(idAndRealm.getRealm())) {
                returnValue.append(idAndRealm.getDelimiter() + idAndRealm.getRealm());
            }
        }
        catch (CertificateEncodingException idAndRealm) {
            void toCatch;
            FFDCFilter.processException((Throwable)idAndRealm, (String)"com.ibm.ws.security.wim.registry.util.LoginBridge", (String)"231", (Object)this, (Object[])new Object[]{inputCertificate});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)toCatch.getMessage(), (Object[])new Object[]{toCatch});
            }
            throw new RegistryException(toCatch.getMessage(), (Throwable)toCatch);
        }
        catch (WIMException toCatch) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)toCatch.getMessage(), (Object[])new Object[]{toCatch});
            }
            if (toCatch instanceof com.ibm.wsspi.security.wim.exception.CertificateMapNotSupportedException) {
                throw new CertificateMapNotSupportedException(toCatch.getMessage(), (Throwable)toCatch);
            }
            if (toCatch instanceof CertificateMapFailedException) {
                throw new com.ibm.ws.security.registry.CertificateMapFailedException(toCatch.getMessage(), (Throwable)toCatch);
            }
            throw new RegistryException(toCatch.getMessage(), (Throwable)toCatch);
        }
        return returnValue.toString();
    }

    public String getRealmName() throws WIMException {
        return this.mappingUtils.getWimService().getRealmName();
    }
}

