/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.annotations.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.annotations.ContainerAnnotations;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.adaptable.module.adapters.ContainerAdapter;
import com.ibm.wsspi.anno.classsource.ClassSource;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_Exception;
import com.ibm.wsspi.anno.classsource.ClassSource_Factory;
import com.ibm.wsspi.anno.classsource.ClassSource_MappedContainer;
import com.ibm.wsspi.anno.service.AnnotationService_Service;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Exception;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Factory;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ContainerAnnotationsAdapter
implements ContainerAdapter<ContainerAnnotations> {
    private static final TraceComponent tc = Tr.register(ContainerAnnotationsAdapter.class);
    private final AtomicServiceReference<AnnotationService_Service> annoServiceSRRef = new AtomicServiceReference("annoService");
    static final long serialVersionUID = 1089864060179472248L;

    public void activate(ComponentContext context) {
        this.annoServiceSRRef.activate(context);
    }

    public void deactivate(ComponentContext context) {
        this.annoServiceSRRef.deactivate(context);
    }

    protected void setAnnoService(ServiceReference<AnnotationService_Service> ref) {
        this.annoServiceSRRef.setReference(ref);
    }

    protected void unsetAnnoService(ServiceReference<AnnotationService_Service> ref) {
        this.annoServiceSRRef.unsetReference(ref);
    }

    public ContainerAnnotations adapt(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt) throws UnableToAdaptException {
        AnnotationService_Service annotationService = (AnnotationService_Service)this.annoServiceSRRef.getService();
        if (annotationService == null) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"annotation.service.not.available.CWWKM0451E", (Object[])new Object[]{"Annotation service not available", containerToAdapt});
            throw new UnableToAdaptException(msg);
        }
        return new ContainerAnnotationsImpl(root, rootOverlay, artifactContainer, containerToAdapt, annotationService);
    }

    @TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class ContainerAnnotationsImpl
    implements ContainerAnnotations {
        private static final TraceComponent _tc = Tr.register(ContainerAnnotationsImpl.class);
        private final AnnotationService_Service annotationService;
        private final Container rootContainer;
        private final Container adaptableContainer;
        static final long serialVersionUID = 9027790298236952927L;

        public ContainerAnnotationsImpl(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt, AnnotationService_Service annotationService) {
            this.rootContainer = root;
            this.adaptableContainer = containerToAdapt;
            this.annotationService = annotationService;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean hasSpecifiedAnnotations(List<String> annotationTypeNames) {
            try {
                ClassSource_Aggregate useClassSource = this.getClassSource();
                AnnotationTargets_Targets useTargets = this.getAnnotationTargets();
                useTargets.scan(useClassSource);
                for (String annotationTypeName : annotationTypeNames) {
                    Set classesWithAnno = useTargets.getAnnotatedClasses(annotationTypeName, AnnotationTargets_Targets.POLICY_SEED);
                    if (classesWithAnno.isEmpty()) continue;
                    return true;
                }
            }
            catch (AnnotationTargets_Exception useClassSource) {
                void e;
                FFDCFilter.processException((Throwable)useClassSource, (String)"com.ibm.ws.container.service.annotations.internal.ContainerAnnotationsAdapter$ContainerAnnotationsImpl", (String)"124", (Object)this, (Object[])new Object[]{annotationTypeNames});
                e.getClass();
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<String> getClassesWithSpecifiedInheritedAnnotations(List<String> annotationTypeNames) {
            HashSet<String> classesWithAnnotations = new HashSet<String>();
            try {
                ClassSource_Aggregate useClassSource = this.getClassSource();
                AnnotationTargets_Targets useTargets = this.getAnnotationTargets();
                useTargets.scan(useClassSource);
                for (String annotationTypeName : annotationTypeNames) {
                    Set classesWithAnno = useTargets.getAllInheritedAnnotatedClasses(annotationTypeName, AnnotationTargets_Targets.POLICY_SEED);
                    classesWithAnnotations.addAll(classesWithAnno);
                }
            }
            catch (AnnotationTargets_Exception useClassSource) {
                void e;
                FFDCFilter.processException((Throwable)useClassSource, (String)"com.ibm.ws.container.service.annotations.internal.ContainerAnnotationsAdapter$ContainerAnnotationsImpl", (String)"142", (Object)this, (Object[])new Object[]{annotationTypeNames});
                e.getClass();
            }
            return classesWithAnnotations;
        }

        /*
         * WARNING - void declaration
         */
        private ClassSource_Aggregate getClassSource() {
            ClassSource_Aggregate useClassSource = null;
            try {
                String containerName = this.rootContainer.getName();
                ClassSource_Factory useClassSourceFactory = this.annotationService.getClassSourceFactory();
                useClassSource = useClassSourceFactory.createAggregateClassSource(containerName);
                String containerClassSourceName = containerName + " container";
                ClassSource_MappedContainer containerClassSource = useClassSourceFactory.createContainerClassSource(useClassSource.getInternMap(), containerClassSourceName, this.adaptableContainer);
                useClassSource.addClassSource((ClassSource)containerClassSource, ClassSource_Aggregate.ScanPolicy.SEED);
            }
            catch (ClassSource_Exception containerName) {
                void e;
                FFDCFilter.processException((Throwable)containerName, (String)"com.ibm.ws.container.service.annotations.internal.ContainerAnnotationsAdapter$ContainerAnnotationsImpl", (String)"166", (Object)this, (Object[])new Object[0]);
                e.getClass();
            }
            return useClassSource;
        }

        /*
         * WARNING - void declaration
         */
        private AnnotationTargets_Targets getAnnotationTargets() {
            AnnotationTargets_Targets useTargets = null;
            try {
                AnnotationTargets_Factory useTargetsFactory = this.annotationService.getAnnotationTargetsFactory();
                useTargets = useTargetsFactory.createTargets();
            }
            catch (AnnotationTargets_Exception useTargetsFactory) {
                void e;
                FFDCFilter.processException((Throwable)useTargetsFactory, (String)"com.ibm.ws.container.service.annotations.internal.ContainerAnnotationsAdapter$ContainerAnnotationsImpl", (String)"178", (Object)this, (Object[])new Object[0]);
                e.getClass();
            }
            return useTargets;
        }
    }
}

