/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.metadata.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.internal.IndexList;
import com.ibm.ws.container.service.metadata.internal.MetaDataEventImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataImpl;
import com.ibm.ws.runtime.metadata.MetaDataSecrets;
import com.ibm.ws.runtime.metadata.MetaDataSlotImpl;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
abstract class MetaDataManager<M extends MetaData, L> {
    protected final ConcurrentServiceReferenceSet<L> listeners;
    private final IndexList metaDataIDs = new IndexList();
    private final List<MetaDataImpl> metaDatas = new ArrayList<MetaDataImpl>();
    private final IndexList slotIDs = new IndexList();
    static final long serialVersionUID = 5464421863354792977L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    MetaDataManager(String listenerRefName) {
        this.listeners = new ConcurrentServiceReferenceSet(listenerRefName);
    }

    void activate(ComponentContext cc) {
        this.listeners.activate(cc);
    }

    void deactivate(ComponentContext cc) {
        this.listeners.deactivate(cc);
    }

    final void addListener(ServiceReference<L> ref) {
        this.listeners.addReference(ref);
    }

    final void removeListener(ServiceReference<L> ref) {
        this.listeners.removeReference(ref);
    }

    protected static <M extends MetaData> MetaDataEvent<M> createMetaDataEvent(M metaData, Container container) {
        return new MetaDataEventImpl<M>(metaData, container);
    }

    private MetaDataImpl getMetaDataImpl(M metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException("metaData");
        }
        return (MetaDataImpl)metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    final void fireMetaDataCreated(M metaData, Container container) throws MetaDataException {
        MetaDataImpl metaDataImpl = this.getMetaDataImpl(metaData);
        MetaDataEvent<M> event = null;
        for (Object listener : this.listeners.services()) {
            if (event == null) {
                event = MetaDataManager.createMetaDataEvent(metaData, container);
            }
            try {
                this.fireMetaDataCreated(listener, event);
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.container.service.metadata.internal.MetaDataManager", (String)"100", (Object)this, (Object[])new Object[]{metaData, container});
                this.fireMetaDataDestroyedImpl(metaData);
                if (t instanceof MetaDataException) {
                    throw (MetaDataException)t;
                }
                throw new MetaDataException((Throwable)t);
            }
        }
        IndexList indexList = this.metaDataIDs;
        synchronized (indexList) {
            int id = this.metaDataIDs.reserve();
            MetaDataSecrets.setID(metaDataImpl, id);
            if (id == this.metaDatas.size()) {
                this.metaDatas.add(metaDataImpl);
            } else {
                this.metaDatas.set(id, metaDataImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMetaDataDestroyed(M metaData) {
        MetaDataImpl metaDataImpl = this.getMetaDataImpl(metaData);
        this.fireMetaDataDestroyedImpl(metaData);
        IndexList indexList = this.metaDataIDs;
        synchronized (indexList) {
            int id = MetaDataSecrets.getID(metaDataImpl);
            if (id >= 0) {
                this.metaDatas.set(id, null);
                this.metaDataIDs.unreserve(id);
            }
        }
    }

    private void fireMetaDataDestroyedImpl(M metaData) {
        MetaDataEvent<M> event = null;
        for (Object listener : this.listeners.services()) {
            if (event == null) {
                event = MetaDataManager.createMetaDataEvent(metaData, null);
            }
            try {
                this.fireMetaDataDestroyed(listener, event);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.container.service.metadata.internal.MetaDataManager", (String)"149", (Object)this, (Object[])new Object[]{metaData});
            }
        }
    }

    abstract void fireMetaDataCreated(L var1, MetaDataEvent<M> var2) throws MetaDataException;

    abstract void fireMetaDataDestroyed(L var1, MetaDataEvent<M> var2);

    abstract Class<M> getMetaDataClass();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final MetaDataSlotImpl reserveMetaDataSlot(Object bundle) {
        int id;
        IndexList indexList = this.slotIDs;
        synchronized (indexList) {
            id = this.slotIDs.reserve();
        }
        return new MetaDataSlotImpl(id, this.getMetaDataClass(), this, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void destroyMetaDataSlot(MetaDataSlotImpl slot) {
        slot.destroy();
        IndexList indexList = this.metaDataIDs;
        synchronized (indexList) {
            for (MetaDataImpl metaData : this.metaDatas) {
                if (metaData == null) continue;
                slot.destroy(metaData);
            }
        }
        int id = slot.getID();
        IndexList indexList2 = this.slotIDs;
        synchronized (indexList2) {
            this.slotIDs.unreserve(id);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MetaDataManager.class);
    }
}

