/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.remote.client.internal;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.ClassGenerator;
import com.ibm.ws.clientcontainer.remote.common.ClientSupportFactory;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ejbcontainer.jitdeploy.JIT_Stub;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.ejbcontainer.JITDeploy;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ApplicationStateListener.class, ClassGenerator.class})
public class ClientEJBStubClassGeneratorImpl
implements ClassGenerator,
ApplicationStateListener {
    private static final TraceComponent tc = Tr.register(ClientEJBStubClassGeneratorImpl.class);
    private static final String ORG_OMG_STUB_PREFIX = "org.omg.stub.";
    private static final int RMIC_COMPATIBLE_ALL = -1;
    private String appName;
    private boolean attemptConnectionToServer = true;
    private Set<Class<?>> rmicCompatibleClasses;
    private ClientSupportFactory clientSupportFactory;
    static final long serialVersionUID = 4254907049343353642L;

    @Reference(service=LibertyProcess.class, target="(wlp.process.type=client)")
    protected void setLibertyProcess(ServiceReference<LibertyProcess> reference) {
    }

    protected void unsetLibertyProcess(ServiceReference<LibertyProcess> reference) {
    }

    @Reference
    protected void setClientSupportFactory(ClientSupportFactory clientSupportFactory) {
        this.clientSupportFactory = clientSupportFactory;
    }

    protected void unsetClientSupportFactory(ClientSupportFactory clientSupportFactory) {
        this.clientSupportFactory = null;
    }

    @Trivial
    @FFDCIgnore(value={ClassNotFoundException.class})
    public byte[] generateClass(String name, ClassLoader loader) throws ClassNotFoundException {
        String remoteInterfaceName;
        if (!name.startsWith(ORG_OMG_STUB_PREFIX) && (remoteInterfaceName = JIT_Stub.getRemoteInterfaceName((String)name)) != null) {
            try {
                loader.loadClass(ORG_OMG_STUB_PREFIX + name);
            }
            catch (ClassNotFoundException e) {
                return this.generateStubClass(remoteInterfaceName, loader);
            }
        }
        return null;
    }

    @Sensitive
    @FFDCIgnore(value={ClassNotFoundException.class})
    private byte[] generateStubClass(String remoteInterfaceName, ClassLoader loader) {
        block4: {
            try {
                Class<?> remoteInterface = loader.loadClass(remoteInterfaceName);
                int rmicCompatible = this.isRMICCompatibleClass(remoteInterface, loader) ? -1 : JITDeploy.RMICCompatible;
                return JITDeploy.generateStubBytes(remoteInterface, (int)rmicCompatible);
            }
            catch (ClassNotFoundException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("unable to load remote interface class: " + e), (Object[])new Object[0]);
                }
            }
            catch (EJBConfigurationException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.ejbcontainer.remote.client.internal.ClientEJBStubClassGeneratorImpl", (String)"115", (Object)this, (Object[])new Object[]{remoteInterfaceName, loader});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("failed to process " + remoteInterfaceName + " as a remote interface"), (Object[])new Object[]{e});
            }
        }
        return null;
    }

    @FFDCIgnore(value={ClassNotFoundException.class, RemoteException.class})
    private synchronized boolean isRMICCompatibleClass(Class<?> c, ClassLoader loader) {
        block7: {
            if (this.attemptConnectionToServer && this.appName != null) {
                this.attemptConnectionToServer = false;
                try {
                    Set classNames = this.clientSupportFactory.getRemoteClientSupport().getEJBRmicCompatibleClasses(this.appName);
                    this.rmicCompatibleClasses = new HashSet(classNames.size());
                    for (String className : classNames) {
                        try {
                            this.rmicCompatibleClasses.add(loader.loadClass(className));
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("isRMICCompatibleClass: added " + className), (Object[])new Object[0]);
                        }
                        catch (ClassNotFoundException ex) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("isRMICCompatibleClass: not added " + className + ", " + ex), (Object[])new Object[0]);
                        }
                    }
                    if (this.rmicCompatibleClasses.size() == 0) {
                        this.rmicCompatibleClasses = null;
                    }
                }
                catch (RemoteException rex) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)("isRMICCompatibleClass: failed to connect to server:" + rex), (Object[])new Object[0]);
                }
            }
        }
        return this.rmicCompatibleClasses != null && this.rmicCompatibleClasses.contains(c);
    }

    public synchronized void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
        this.appName = appInfo.getName();
    }

    @Trivial
    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
    }

    @Trivial
    public void applicationStopping(ApplicationInfo appInfo) {
    }

    @Trivial
    public void applicationStopped(ApplicationInfo appInfo) {
    }
}

