/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicReference;

@Trivial
public class Utils {
    public static final String NEW_LINE = String.format("%n", new Object[0]);

    public static String getSpaceBufferString(int bufferSpaces) {
        StringBuilder sb = new StringBuilder(bufferSpaces);
        while (bufferSpaces-- > 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static boolean doesFileExistPrivileged(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 3704437075196022676L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return file.exists();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jca.utils.Utils$1", 1.class, null, null);
            }
        });
    }

    public static FileInputStream getFileInputStreamPrivileged(final File file) throws FileNotFoundException {
        final AtomicReference exceptionRef = new AtomicReference();
        FileInputStream fis = AccessController.doPrivileged(new PrivilegedAction<FileInputStream>(){
            static final long serialVersionUID = 250857461852956672L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public FileInputStream run() {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    void e;
                    FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.jca.utils.Utils$2", (String)"76", (Object)this, (Object[])new Object[0]);
                    exceptionRef.set(e);
                    return null;
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jca.utils.Utils$2", 2.class, null, null);
            }
        });
        if (exceptionRef.get() != null) {
            throw (FileNotFoundException)exceptionRef.get();
        }
        return fis;
    }

    public static enum ConstructType {
        AdminObject,
        ConnectionFactory,
        MessageListener,
        ResourceAdapter,
        Unknown;

    }
}

