/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.beanvalidation.v11.cdi.internal;

import com.ibm.ejs.util.dopriv.SetContextClassLoaderPrivileged;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.beanvalidation.service.BeanValidationExtensionHelper;
import com.ibm.ws.beanvalidation.v11.cdi.internal.BValExtensionBean;
import com.ibm.ws.beanvalidation.v11.cdi.internal.LibertyValidatorBean;
import com.ibm.ws.beanvalidation.v11.cdi.internal.LibertyValidatorFactoryBean;
import com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationExtensionService;
import com.ibm.ws.cdi.extension.WebSphereCDIExtension;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.util.ThreadContextAccessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.validation.BootstrapConfiguration;
import javax.validation.Configuration;
import javax.validation.Constraint;
import javax.validation.Valid;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableType;
import javax.validation.executable.ValidateOnExecution;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.MethodType;
import org.apache.bval.cdi.BValAnnotatedType;
import org.apache.bval.cdi.BValBinding;
import org.apache.bval.cdi.BValInterceptor;
import org.apache.bval.cdi.ValidatorBean;
import org.apache.bval.cdi.ValidatorFactoryBean;
import org.apache.commons.lang3.Validate;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={WebSphereCDIExtension.class}, property={"api.classes=javax.validation.Validator;javax.validation.ValidatorFactory;org.apache.bval.cdi.BValInterceptor;org.apache.bval.cdi.BValExtension"}, immediate=true)
public class ValidationExtension
extends ValidationExtensionService
implements Extension,
WebSphereCDIExtension {
    private static final TraceComponent tc = Tr.register(ValidationExtension.class, (String)"BeanValidation", null);
    private static final Logger LOGGER = Logger.getLogger(ValidationExtension.class.getName());
    private static ValidationExtension instance;
    private static final AnnotatedTypeFilter DEFAULT_ANNOTATED_TYPE_FILTER;
    private static AnnotatedTypeFilter annotatedTypeFilter;
    private boolean validatorFound = Boolean.getBoolean("bval.in-container");
    private boolean validatorFactoryFound = Boolean.getBoolean("bval.in-container");
    private boolean validBean;
    private boolean validConstructors;
    private boolean validBusinessMethods;
    private boolean validGetterMethods;
    private Configuration<?> config = null;
    private Set<ExecutableType> globalExecutableTypes;
    private boolean isExecutableValidationEnabled;
    static final long serialVersionUID = 4914279935810861282L;

    public static void setAnnotatedTypeFilter(AnnotatedTypeFilter annotatedTypeFilter) {
        ValidationExtension.annotatedTypeFilter = (AnnotatedTypeFilter)Validate.notNull((Object)annotatedTypeFilter);
    }

    private static void setInstance(ValidationExtension ve) {
        instance = ve;
    }

    static ValidationExtension getInstance() {
        return instance;
    }

    @Override
    protected void activate(ComponentContext cc) {
        super.activate(cc);
        ValidationExtension.setInstance(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void initValidationExtension(ClassLoader appCl) {
        ClassLoader classLoader;
        SetContextClassLoaderPrivileged setClassLoader;
        block15: {
            setClassLoader = null;
            ClassLoader oldClassLoader = null;
            classLoader = null;
            try {
                ThreadContextAccessor tca = System.getSecurityManager() == null ? ThreadContextAccessor.getThreadContextAccessor() : (ThreadContextAccessor)AccessController.doPrivileged(getThreadContextAccessorAction);
                classLoader = ValidationExtension.instance().configureBvalClassloader(appCl);
                classLoader = BeanValidationExtensionHelper.newValidationClassLoader((ClassLoader)classLoader);
                setClassLoader = new SetContextClassLoaderPrivileged(tca);
                oldClassLoader = setClassLoader.execute(classLoader);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Called setClassLoader with oldClassLoader of " + oldClassLoader + " and newClassLoader of " + classLoader), (Object[])new Object[0]);
                }
                this.config = Validation.byDefaultProvider().configure();
                try {
                    BootstrapConfiguration bootstrap = this.config.getBootstrapConfiguration();
                    this.globalExecutableTypes = Collections.unmodifiableSet(ValidationExtension.convertToRuntimeTypes(bootstrap.getDefaultValidatedExecutableTypes()));
                    this.isExecutableValidationEnabled = bootstrap.isExecutableValidationEnabled();
                    this.validBean = this.globalExecutableTypes.contains(ExecutableType.IMPLICIT) || this.globalExecutableTypes.contains(ExecutableType.ALL);
                    this.validConstructors = this.validBean || this.globalExecutableTypes.contains(ExecutableType.CONSTRUCTORS);
                    this.validBusinessMethods = this.validBean || this.globalExecutableTypes.contains(ExecutableType.NON_GETTER_METHODS);
                    this.validGetterMethods = this.globalExecutableTypes.contains(ExecutableType.ALL) || this.globalExecutableTypes.contains(ExecutableType.GETTER_METHODS);
                }
                catch (Exception bootstrap) {
                    void e;
                    FFDCFilter.processException((Throwable)bootstrap, (String)"com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationExtension", (String)"161", (Object)this, (Object[])new Object[]{appCl});
                    LOGGER.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                    this.globalExecutableTypes = Collections.emptySet();
                    this.isExecutableValidationEnabled = false;
                }
                if (setClassLoader == null) break block15;
            }
            catch (ValidationException tca) {
                block16: {
                    try {
                        FFDCFilter.processException((Throwable)tca, (String)"com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationExtension", (String)"168", (Object)this, (Object[])new Object[]{appCl});
                        if (tc.isDebugEnabled()) {
                            void e;
                            Tr.debug((TraceComponent)tc, (String)("Returning a null Configuration: " + e.getMessage()), (Object[])new Object[0]);
                        }
                        if (setClassLoader == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (setClassLoader != null) {
                            setClassLoader.execute(oldClassLoader);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                            }
                        }
                        if (setClassLoader != null && setClassLoader.wasChanged) {
                            ValidationExtensionService.instance().releaseLoader(classLoader);
                        }
                        throw throwable;
                    }
                    setClassLoader.execute(oldClassLoader);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                    }
                }
                if (setClassLoader != null && setClassLoader.wasChanged) {
                    ValidationExtensionService.instance().releaseLoader(classLoader);
                }
            }
            setClassLoader.execute(oldClassLoader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
            }
        }
        if (setClassLoader != null && setClassLoader.wasChanged) {
            ValidationExtensionService.instance().releaseLoader(classLoader);
        }
    }

    private ValidatorFactory ensureFactoryValidator(ClassLoader appCl) {
        this.config.addProperty("bval.before.cdi", "true");
        return BeanValidationExtensionHelper.validatorFactoryAccessorProxy((ClassLoader)appCl);
    }

    private static Set<ExecutableType> convertToRuntimeTypes(Set<ExecutableType> defaultValidatedExecutableTypes) {
        EnumSet<ExecutableType> types = EnumSet.noneOf(ExecutableType.class);
        for (ExecutableType type : defaultValidatedExecutableTypes) {
            if (ExecutableType.NONE == type) continue;
            if (ExecutableType.ALL == type) {
                types.add(ExecutableType.CONSTRUCTORS);
                types.add(ExecutableType.NON_GETTER_METHODS);
                types.add(ExecutableType.GETTER_METHODS);
                break;
            }
            if (ExecutableType.IMPLICIT == type) {
                types.add(ExecutableType.CONSTRUCTORS);
                types.add(ExecutableType.NON_GETTER_METHODS);
                continue;
            }
            types.add(type);
        }
        return types;
    }

    public Set<ExecutableType> getGlobalExecutableTypes() {
        this.initValidationExtension(null);
        return this.globalExecutableTypes;
    }

    public void addBvalBinding(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        beforeBeanDiscovery.addInterceptorBinding(BValBinding.class, new Annotation[0]);
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(BValInterceptor.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A> void processAnnotatedType(@Observes @WithAnnotations(value={Valid.class, Constraint.class, ValidateOnExecution.class}) ProcessAnnotatedType<A> pat, BeanManager beanManager) {
        block11: {
            block10: {
                ClassLoader classLoader;
                SetContextClassLoaderPrivileged setClassLoader;
                block9: {
                    ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
                    if (cmd == null) break block10;
                    setClassLoader = null;
                    ClassLoader oldClassLoader = null;
                    classLoader = null;
                    try {
                        classLoader = ValidationExtension.instance().configureBvalClassloader(pat.getAnnotatedType().getJavaClass().getClassLoader());
                        ThreadContextAccessor tca = System.getSecurityManager() == null ? ThreadContextAccessor.getThreadContextAccessor() : (ThreadContextAccessor)AccessController.doPrivileged(getThreadContextAccessorAction);
                        setClassLoader = new SetContextClassLoaderPrivileged(tca);
                        oldClassLoader = setClassLoader.execute(classLoader);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Called setClassLoader with oldClassLoader of" + oldClassLoader + " and newClassLoader of " + classLoader), (Object[])new Object[0]);
                        }
                        this.internalProcessAnnotatedType(pat);
                        if (setClassLoader == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (setClassLoader != null) {
                            setClassLoader.execute(oldClassLoader);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                            }
                        }
                        if (setClassLoader != null && setClassLoader.wasChanged) {
                            ValidationExtension.instance().releaseLoader(classLoader);
                        }
                        throw throwable;
                    }
                    setClassLoader.execute(oldClassLoader);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                    }
                }
                if (setClassLoader != null && setClassLoader.wasChanged) {
                    ValidationExtension.instance().releaseLoader(classLoader);
                }
                break block11;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No CMD on thread - ignoring call", (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A> void internalProcessAnnotatedType(@Observes @WithAnnotations(value={Valid.class, Constraint.class, ValidateOnExecution.class}) ProcessAnnotatedType<A> pat) {
        this.initValidationExtension(pat.getAnnotatedType().getJavaClass().getClassLoader());
        if (!this.isExecutableValidationEnabled) {
            return;
        }
        AnnotatedType annotatedType = pat.getAnnotatedType();
        if (!annotatedTypeFilter.accept(annotatedType)) {
            return;
        }
        Class javaClass = annotatedType.getJavaClass();
        int modifiers = javaClass.getModifiers();
        if (!(javaClass.isInterface() || Modifier.isFinal(modifiers) || Modifier.isAbstract(modifiers))) {
            try (ValidatorFactory factory = this.ensureFactoryValidator(pat.getAnnotatedType().getJavaClass().getClassLoader());){
                Validator validator = factory.getValidator();
                try {
                    BeanDescriptor classConstraints = validator.getConstraintsForClass(javaClass);
                    if (annotatedType.isAnnotationPresent(ValidateOnExecution.class) || ValidationExtension.hasValidationAnnotation(annotatedType.getMethods()) || ValidationExtension.hasValidationAnnotation(annotatedType.getConstructors()) || classConstraints != null && (this.validBean && classConstraints.isBeanConstrained() || this.validConstructors && !classConstraints.getConstrainedConstructors().isEmpty() || this.validBusinessMethods && !classConstraints.getConstrainedMethods(MethodType.NON_GETTER, new MethodType[0]).isEmpty() || this.validGetterMethods && !classConstraints.getConstrainedMethods(MethodType.GETTER, new MethodType[0]).isEmpty())) {
                        BValAnnotatedType bValAnnotatedType = new BValAnnotatedType(annotatedType);
                        pat.setAnnotatedType((AnnotatedType)bValAnnotatedType);
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    FFDCFilter.processException((Throwable)noClassDefFoundError, (String)"com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationExtension", (String)"294", (Object)this, (Object[])new Object[]{pat});
                }
            }
        }
    }

    private static <A> boolean hasValidationAnnotation(Collection<? extends AnnotatedCallable<? super A>> methods) {
        for (AnnotatedCallable<A> annotatedCallable : methods) {
            if (!annotatedCallable.isAnnotationPresent(ValidateOnExecution.class)) continue;
            return true;
        }
        return false;
    }

    public <A> void processBean(@Observes ProcessBean<A> processBeanEvent) {
        if (this.validatorFound && this.validatorFactoryFound) {
            return;
        }
        Bean bean = processBeanEvent.getBean();
        if (ValidatorBean.class.isInstance(bean) || ValidatorFactoryBean.class.isInstance(bean)) {
            return;
        }
        Set types = bean.getTypes();
        if (!this.validatorFound) {
            this.validatorFound = types.contains(Validator.class);
        }
        if (!this.validatorFactoryFound) {
            this.validatorFactoryFound = types.contains(ValidatorFactory.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBValBeans(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        ClassLoader classLoader;
        SetContextClassLoaderPrivileged setClassLoader;
        block8: {
            this.initValidationExtension(null);
            setClassLoader = null;
            ClassLoader oldClassLoader = null;
            classLoader = null;
            try {
                classLoader = ValidationExtension.instance().configureBvalClassloader(null);
                ThreadContextAccessor tca = System.getSecurityManager() == null ? ThreadContextAccessor.getThreadContextAccessor() : (ThreadContextAccessor)AccessController.doPrivileged(getThreadContextAccessorAction);
                setClassLoader = new SetContextClassLoaderPrivileged(tca);
                oldClassLoader = setClassLoader.execute(classLoader);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Called setClassLoader with oldClassLoader of" + oldClassLoader + " and newClassLoader of " + classLoader), (Object[])new Object[0]);
                }
                this.cdiIntegration(afterBeanDiscovery, beanManager);
                if (setClassLoader == null) break block8;
            }
            catch (Throwable throwable) {
                if (setClassLoader != null) {
                    setClassLoader.execute(oldClassLoader);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                    }
                }
                if (setClassLoader != null && setClassLoader.wasChanged) {
                    ValidationExtension.instance().releaseLoader(classLoader);
                }
                throw throwable;
            }
            setClassLoader.execute(oldClassLoader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
            }
        }
        if (setClassLoader != null && setClassLoader.wasChanged) {
            ValidationExtension.instance().releaseLoader(classLoader);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void cdiIntegration(AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        try {
            this.config.addProperty("bval.before.cdi", "false");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationExtension", (String)"367", (Object)this, (Object[])new Object[]{afterBeanDiscovery, beanManager});
        }
        if (!this.validatorFactoryFound) {
            try {
                afterBeanDiscovery.addBean((Bean)new LibertyValidatorFactoryBean());
                this.validatorFactoryFound = true;
            }
            catch (IllegalStateException illegalStateException) {
                void e;
                FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationExtension", (String)"375", (Object)this, (Object[])new Object[]{afterBeanDiscovery, beanManager});
                throw new ValidationException((Throwable)e);
            }
        }
        if (!this.validatorFound) {
            try {
                afterBeanDiscovery.addBean((Bean)new LibertyValidatorBean());
                afterBeanDiscovery.addBean((Bean)new BValExtensionBean());
                this.validatorFound = true;
            }
            catch (IllegalStateException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationExtension", (String)"384", (Object)this, (Object[])new Object[]{afterBeanDiscovery, beanManager});
                throw new ValidationException((Throwable)e);
            }
        }
    }

    public static <T> Releasable<T> inject(Class<T> clazz) {
        try {
            BeanManager beanManager = CDI.current().getBeanManager();
            if (beanManager == null) {
                return null;
            }
            AnnotatedType annotatedType = beanManager.createAnnotatedType(clazz);
            InjectionTarget it = beanManager.createInjectionTarget(annotatedType);
            CreationalContext context = beanManager.createCreationalContext(null);
            Object instance = it.produce(context);
            it.inject(instance, context);
            it.postConstruct(instance);
            return new Releasable(context, it, instance);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationExtension", (String)"410", null, (Object[])new Object[]{clazz});
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            FFDCFilter.processException((Throwable)noClassDefFoundError, (String)"com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationExtension", (String)"412", null, (Object[])new Object[]{clazz});
        }
        return null;
    }

    public static BeanManager getBeanManager() {
        return CDI.current().getBeanManager();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        annotatedTypeFilter = DEFAULT_ANNOTATED_TYPE_FILTER = new AnnotatedTypeFilter(){
            static final long serialVersionUID = -8046711305282635673L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean accept(AnnotatedType<?> annotatedType) {
                return !annotatedType.getJavaClass().getName().startsWith("org.apache.bval.");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationExtension$1", 1.class, (String)"BeanValidation", null);
            }
        };
    }

    public static interface AnnotatedTypeFilter {
        public boolean accept(AnnotatedType<?> var1);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Releasable<T> {
        private final CreationalContext<T> context;
        private final InjectionTarget<T> injectionTarget;
        private final T instance;
        static final long serialVersionUID = -5988662132366013387L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private Releasable(CreationalContext<T> context, InjectionTarget<T> injectionTarget, T instance) {
            this.context = context;
            this.injectionTarget = injectionTarget;
            this.instance = instance;
        }

        public void release() {
            try {
                this.injectionTarget.preDestroy(this.instance);
                this.injectionTarget.dispose(this.instance);
                this.context.release();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationExtension$Releasable", (String)"443", (Object)this, (Object[])new Object[0]);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                FFDCFilter.processException((Throwable)noClassDefFoundError, (String)"com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationExtension$Releasable", (String)"445", (Object)this, (Object[])new Object[0]);
            }
        }

        public T getInstance() {
            return this.instance;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationExtension$Releasable", Releasable.class, (String)"BeanValidation", null);
        }
    }
}

