/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ProxyClassLoader;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class ProxyClassLoaderCache {
    private static final Logger LOG = LogUtils.getL7dLogger(ProxyClassLoaderCache.class);
    private static final ThreadLocal<ClassLoader> PARENT_CLASSLOADER = new ThreadLocal();
    private static final ThreadLocal<Class<?>[]> PROXY_INTERFACES = new ThreadLocal();
    private final ClassValue<ClassLoader> backend;
    static final long serialVersionUID = -9014871973495978627L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ProxyClassLoaderCache() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.ProxyClassLoaderCache", "<init>", new Object[0]);
        }
        this.backend = new ClassValue<ClassLoader>(){
            static final long serialVersionUID = 832623891541686891L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            protected ClassLoader computeValue(Class<?> proxyInterface) {
                LOG.log(Level.FINE, "can't find ProxyClassLoader from ClassValue Cache, will create a new one");
                LOG.log(Level.FINE, "interface for new created ProxyClassLoader is " + proxyInterface.getName());
                LOG.log(Level.FINE, "interface's classloader for new created ProxyClassLoader is " + ClassLoaderUtils.getClassLoaderName(proxyInterface));
                return ProxyClassLoaderCache.this.createProxyClassLoader(proxyInterface);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.common.util.ProxyClassLoaderCache$1", 1.class, null, null);
            }
        };
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.common.util.ProxyClassLoaderCache", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ClassLoader createProxyClassLoader(Class<?> proxyInterface) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.ProxyClassLoaderCache", "createProxyClassLoader", new Object[]{proxyInterface});
        }
        SecurityManager sm = System.getSecurityManager();
        ProxyClassLoader ret = null;
        ret = sm == null ? new ProxyClassLoader(PARENT_CLASSLOADER.get(), PROXY_INTERFACES.get()) : AccessController.doPrivileged(new PrivilegedAction<ProxyClassLoader>(){
            static final long serialVersionUID = -1383119357504751205L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ProxyClassLoader run() {
                return new ProxyClassLoader((ClassLoader)PARENT_CLASSLOADER.get(), (Class[])PROXY_INTERFACES.get());
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.common.util.ProxyClassLoaderCache$2", 2.class, null, null);
            }
        });
        for (Class<?> currentInterface : PROXY_INTERFACES.get()) {
            ret.addLoader(ProxyClassLoaderCache.getClassLoader(currentInterface));
            LOG.log(Level.FINE, "interface for new created ProxyClassLoader is " + currentInterface.getName());
            LOG.log(Level.FINE, "interface's classloader for new created ProxyClassLoader is " + ClassLoaderUtils.getClassLoaderName(currentInterface));
        }
        ProxyClassLoader proxyClassLoader = ret;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            proxyClassLoader = proxyClassLoader;
            LOG.exiting("org.apache.cxf.common.util.ProxyClassLoaderCache", "createProxyClassLoader", proxyClassLoader);
        }
        return proxyClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassLoader getProxyClassLoader(ClassLoader parent, Class<?>[] proxyInterfaces) {
        ClassLoader classLoader;
        block7: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.common.util.ProxyClassLoaderCache", "getProxyClassLoader", new Object[]{parent, proxyInterfaces});
            }
            PARENT_CLASSLOADER.set(parent);
            PROXY_INTERFACES.set(proxyInterfaces);
            for (Class<?> currentInterface : proxyInterfaces) {
                String ifName = currentInterface.getName();
                LOG.log(Level.FINE, "the interface we are checking is " + currentInterface.getName());
                LOG.log(Level.FINE, "the interface' classloader we are checking is " + ClassLoaderUtils.getClassLoaderName(currentInterface));
                if (ifName.startsWith("org.apache.cxf") || ifName.startsWith("java")) continue;
                LOG.log(Level.FINE, "the customer interface is " + currentInterface.getName() + ". Will try to fetch it from Cache");
                ClassLoader classLoader2 = this.backend.get(currentInterface);
                ClassLoader classLoader3 = classLoader2;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    classLoader3 = classLoader3;
                    LOG.exiting("org.apache.cxf.common.util.ProxyClassLoaderCache", "getProxyClassLoader", classLoader3);
                }
                return classLoader3;
            }
            LOG.log(Level.FINE, "Non of interfaces are customer interface, retrive the last interface as key:" + proxyInterfaces[proxyInterfaces.length - 1].getName());
            ClassLoader classLoader4 = this.backend.get(proxyInterfaces[proxyInterfaces.length - 1]);
            classLoader = classLoader4;
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block7;
            classLoader = classLoader;
            LOG.exiting("org.apache.cxf.common.util.ProxyClassLoaderCache", "getProxyClassLoader", classLoader);
        }
        return classLoader;
        finally {
            PARENT_CLASSLOADER.remove();
            PROXY_INTERFACES.remove();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void removeStaleProxyClassLoader(Class<?> proxyInterface) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.ProxyClassLoaderCache", "removeStaleProxyClassLoader", new Object[]{proxyInterface});
        }
        this.backend.remove(proxyInterface);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.common.util.ProxyClassLoaderCache", "removeStaleProxyClassLoader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static ClassLoader getClassLoader(final Class<?> clazz) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.ProxyClassLoaderCache", "getClassLoader", new Object[]{clazz});
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
                static final long serialVersionUID = -2135583677353709020L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ClassLoader run() {
                    return clazz.getClassLoader();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.common.util.ProxyClassLoaderCache$3", 3.class, null, null);
                }
            });
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                classLoader = classLoader;
                LOG.exiting("org.apache.cxf.common.util.ProxyClassLoaderCache", "getClassLoader", classLoader);
            }
            return classLoader;
        }
        ClassLoader classLoader = clazz.getClassLoader();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classLoader = classLoader;
            LOG.exiting("org.apache.cxf.common.util.ProxyClassLoaderCache", "getClassLoader", classLoader);
        }
        return classLoader;
    }
}

