/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.jaxrs2.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.impl.core.util.ParameterProcessor;
import com.ibm.ws.microprofile.openapi.impl.core.util.ReflectionUtils;
import com.ibm.ws.microprofile.openapi.impl.jaxrs2.ext.OpenAPIExtension;
import com.ibm.ws.microprofile.openapi.impl.jaxrs2.ext.OpenAPIExtensions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ReaderUtils {
    private static final String GET_METHOD = "get";
    private static final String POST_METHOD = "post";
    private static final String PUT_METHOD = "put";
    private static final String DELETE_METHOD = "delete";
    private static final String HEAD_METHOD = "head";
    private static final String OPTIONS_METHOD = "options";
    private static final String PATCH_METHOD = "patch";
    private static final String PATH_DELIMITER = "/";
    static final long serialVersionUID = 9146707194207322239L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static List<Parameter> collectConstructorParameters(Class<?> cls, Components components, Consumes classConsumes) {
        if (cls.isLocalClass() || cls.isMemberClass() && !Modifier.isStatic(cls.getModifiers())) {
            return Collections.emptyList();
        }
        List<Parameter> selected = Collections.emptyList();
        int maxParamsCount = 0;
        for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
            if (!ReflectionUtils.isConstructorCompatible(constructor) && !ReflectionUtils.isInject(Arrays.asList(constructor.getDeclaredAnnotations()))) continue;
            Type[] genericParameterTypes = constructor.getGenericParameterTypes();
            Annotation[][] annotations = constructor.getParameterAnnotations();
            int paramsCount = 0;
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            for (int i = 0; i < genericParameterTypes.length; ++i) {
                List<Annotation> tmpAnnotations = Arrays.asList(annotations[i]);
                if (ReaderUtils.isContext(tmpAnnotations)) {
                    ++paramsCount;
                    continue;
                }
                Type genericParameterType = genericParameterTypes[i];
                List<Parameter> tmpParameters = ReaderUtils.collectParameters(genericParameterType, tmpAnnotations, components, classConsumes);
                if (tmpParameters.size() < 1) continue;
                for (Parameter tmpParameter : tmpParameters) {
                    if (ParameterProcessor.applyAnnotations(tmpParameter, genericParameterType, tmpAnnotations, components, classConsumes == null ? new String[]{} : classConsumes.value(), null) == null) continue;
                    parameters.add(tmpParameter);
                }
                ++paramsCount;
            }
            if (paramsCount < maxParamsCount) continue;
            maxParamsCount = paramsCount;
            selected = parameters;
        }
        return selected;
    }

    public static List<Parameter> collectFieldParameters(Class<?> cls, Components components, Consumes classConsumes) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Field field : ReflectionUtils.getDeclaredFields(cls)) {
            List<Annotation> annotations = Arrays.asList(field.getAnnotations());
            Type genericType = field.getGenericType();
            parameters.addAll(ReaderUtils.collectParameters(genericType, annotations, components, classConsumes));
        }
        return parameters;
    }

    private static List<Parameter> collectParameters(Type type, List<Annotation> annotations, Components components, Consumes classConsumes) {
        Iterator<OpenAPIExtension> chain = OpenAPIExtensions.chain();
        return chain.hasNext() ? chain.next().extractParameters(annotations, (Type)type, new HashSet<Type>(), (Components)components, (Consumes)classConsumes, null, (boolean)false, chain).parameters : Collections.emptyList();
    }

    private static boolean isContext(List<Annotation> annotations) {
        return false;
    }

    public static String[] splitContentValues(String[] strings) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String string : strings) {
            String[] splitted;
            if (string.isEmpty()) continue;
            for (String string2 : splitted = string.trim().split(",")) {
                result.add(string2);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static Optional<List<String>> getStringListFromStringArray(String[] array) {
        if (array == null) {
            return Optional.empty();
        }
        ArrayList<String> list = new ArrayList<String>();
        boolean isEmpty = true;
        for (String value : array) {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                isEmpty = false;
            }
            list.add(value);
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(list);
    }

    public static String getPath(Path classLevelPath, Path methodLevelPath, String parentPath) {
        String output;
        if (classLevelPath == null && methodLevelPath == null && StringUtils.isEmpty((CharSequence)parentPath)) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        if (parentPath != null && !"".equals(parentPath) && !PATH_DELIMITER.equals(parentPath)) {
            if (!parentPath.startsWith(PATH_DELIMITER)) {
                parentPath = PATH_DELIMITER + parentPath;
            }
            if (parentPath.endsWith(PATH_DELIMITER)) {
                parentPath = parentPath.substring(0, parentPath.length() - 1);
            }
            b.append(parentPath);
        }
        if (classLevelPath != null && !PATH_DELIMITER.equals(classLevelPath.value())) {
            String classPath = classLevelPath.value();
            if (!classPath.startsWith(PATH_DELIMITER) && !b.toString().endsWith(PATH_DELIMITER)) {
                b.append(PATH_DELIMITER);
            }
            if (classPath.endsWith(PATH_DELIMITER)) {
                classPath = classPath.substring(0, classPath.length() - 1);
            }
            b.append(classPath);
        }
        if (methodLevelPath != null && !PATH_DELIMITER.equals(methodLevelPath.value())) {
            String methodPath = methodLevelPath.value();
            if (!methodPath.startsWith(PATH_DELIMITER) && !b.toString().endsWith(PATH_DELIMITER)) {
                b.append(PATH_DELIMITER);
            }
            if (methodPath.endsWith(PATH_DELIMITER)) {
                methodPath = methodPath.substring(0, methodPath.length() - 1);
            }
            b.append(methodPath);
        }
        if (!(output = b.toString()).startsWith(PATH_DELIMITER)) {
            output = PATH_DELIMITER + output;
        }
        if (output.endsWith(PATH_DELIMITER) && output.length() > 1) {
            return output.substring(0, output.length() - 1);
        }
        return output;
    }

    public static String extractOperationMethod(Operation operation, Method method, Iterator<OpenAPIExtension> chain) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!annotation.getClass().getName().equals("javax.ws.rs.PATCH")) continue;
            return PATCH_METHOD;
        }
        if (method.getAnnotation(GET.class) != null) {
            return GET_METHOD;
        }
        if (method.getAnnotation(PUT.class) != null) {
            return PUT_METHOD;
        }
        if (method.getAnnotation(POST.class) != null) {
            return POST_METHOD;
        }
        if (method.getAnnotation(DELETE.class) != null) {
            return DELETE_METHOD;
        }
        if (method.getAnnotation(OPTIONS.class) != null) {
            return OPTIONS_METHOD;
        }
        if (method.getAnnotation(HEAD.class) != null) {
            return HEAD_METHOD;
        }
        if (method.getAnnotation(DELETE.class) != null) {
            return DELETE_METHOD;
        }
        if (method.getAnnotation(HttpMethod.class) != null) {
            HttpMethod httpMethod = method.getAnnotation(HttpMethod.class);
            return httpMethod.value().toLowerCase();
        }
        if (!StringUtils.isEmpty((CharSequence)ReaderUtils.getHttpMethodFromCustomAnnotations(method))) {
            return ReaderUtils.getHttpMethodFromCustomAnnotations(method);
        }
        if (ReflectionUtils.getOverriddenMethod(method) != null) {
            return ReaderUtils.extractOperationMethod(operation, ReflectionUtils.getOverriddenMethod(method), chain);
        }
        if (chain != null && chain.hasNext()) {
            return chain.next().extractOperationMethod(operation, method, chain);
        }
        return null;
    }

    public static String getHttpMethodFromCustomAnnotations(Method method) {
        for (Annotation methodAnnotation : method.getAnnotations()) {
            HttpMethod httpMethod = methodAnnotation.annotationType().getAnnotation(HttpMethod.class);
            if (httpMethod == null) continue;
            return httpMethod.value().toLowerCase();
        }
        return null;
    }

    public static void copyParamValues(Parameter to, Parameter from) {
        if (from.getIn() != null) {
            to.setIn(from.getIn());
        }
        if (from.getAllowEmptyValue() != null) {
            to.setAllowEmptyValue(from.getAllowEmptyValue());
        }
        if (from.getAllowReserved() != null) {
            to.setAllowReserved(from.getAllowReserved());
        }
        if (from.getDeprecated() != null) {
            to.setDeprecated(from.getDeprecated());
        }
        if (from.getDescription() != null) {
            to.setDescription(from.getDescription());
        }
        if (from.getStyle() != null) {
            to.setStyle(from.getStyle());
        }
        if (to.getSchema() == null) {
            to.setSchema(from.getSchema());
        }
        if (to.getContent() == null) {
            to.setContent(from.getContent());
        }
        if (from.getExample() != null) {
            to.setExample(from.getExample());
        }
        if (from.getRequired() != null) {
            to.setRequired(from.getRequired());
        }
        if (from.getExplode() != null) {
            to.setExplode(from.getExplode());
        }
        if (from.getExamples() != null) {
            to.setExamples(from.getExamples());
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.openapi.impl.jaxrs2.util.ReaderUtils", ReaderUtils.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    }
}

