/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.parser.processors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.impl.parser.ResolverCache;
import com.ibm.ws.microprofile.openapi.impl.parser.models.RefFormat;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.ExternalRefProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.ParameterProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.RequestBodyProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.ResponseProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.util.RefUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OperationProcessor {
    private final ParameterProcessor parameterProcessor;
    private final RequestBodyProcessor requestBodyProcessor;
    private final ResponseProcessor responseProcessor;
    private final ExternalRefProcessor externalRefProcessor;
    private final ResolverCache cache;
    static final long serialVersionUID = 7650938885659110367L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public OperationProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.parameterProcessor = new ParameterProcessor(cache, openAPI);
        this.responseProcessor = new ResponseProcessor(cache, openAPI);
        this.requestBodyProcessor = new RequestBodyProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
        this.cache = cache;
    }

    public void processOperation(Operation operation) {
        Map callbacks;
        APIResponses responses;
        RequestBody requestBody;
        List<Parameter> processedOperationParameters = this.parameterProcessor.processParameters(operation.getParameters());
        if (processedOperationParameters != null) {
            operation.setParameters(processedOperationParameters);
        }
        if ((requestBody = operation.getRequestBody()) != null) {
            this.requestBodyProcessor.processRequestBody(requestBody);
        }
        if ((responses = operation.getResponses()) != null) {
            for (String responseCode : responses.keySet()) {
                APIResponse response = (APIResponse)responses.get(responseCode);
                if (response == null) continue;
                this.responseProcessor.processResponse(response);
            }
        }
        if ((callbacks = operation.getCallbacks()) != null) {
            for (String name : callbacks.keySet()) {
                String newRef;
                String $ref;
                RefFormat refFormat;
                Callback callback = (Callback)callbacks.get(name);
                if (callback == null) continue;
                if (callback.get((Object)"$ref") != null && RefUtils.isAnExternalRefFormat(refFormat = RefUtils.computeRefFormat($ref = ((PathItem)callback.get((Object)"$ref")).getRef())) && (newRef = this.externalRefProcessor.processRefToExternalCallback($ref, refFormat)) != null) {
                    ((PathItem)callback.get((Object)"$ref")).setRef(newRef);
                }
                for (String callbackName : callback.keySet()) {
                    PathItem pathItem = (PathItem)callback.get((Object)callbackName);
                    Map operationMap = pathItem.readOperationsMap();
                    for (PathItem.HttpMethod httpMethod : operationMap.keySet()) {
                        Operation op = (Operation)operationMap.get(httpMethod);
                        this.processOperation(op);
                    }
                    List parameters = pathItem.getParameters();
                    if (parameters == null) continue;
                    for (Parameter parameter : parameters) {
                        this.parameterProcessor.processParameter(parameter);
                    }
                }
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.openapi.impl.parser.processors.OperationProcessor", OperationProcessor.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    }
}

