/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.openapi.AnnotationScanner;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.OASModelReader;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIUtils {
    private static final TraceComponent tc = Tr.register(OpenAPIUtils.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    static final long serialVersionUID = -6717960984634534689L;

    @Trivial
    public static boolean isDebugEnabled(TraceComponent tc) {
        return TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
    }

    @Trivial
    public static boolean isEventEnabled(TraceComponent tc) {
        return TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled();
    }

    @Trivial
    public static boolean isDumpEnabled(TraceComponent tc) {
        return TraceComponent.isAnyTracingEnabled() && tc.isDumpEnabled();
    }

    @FFDCIgnore(value={UnableToAdaptException.class})
    public static WebModuleInfo getWebModuleInfo(Container container) {
        NonPersistentCache overlayCache;
        WebModuleInfo moduleInfo = null;
        try {
            overlayCache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
        }
        catch (UnableToAdaptException e) {
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Failed to get web module info: " + e.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
        if (overlayCache != null) {
            moduleInfo = (WebModuleInfo)overlayCache.getFromCache(WebModuleInfo.class);
        }
        return moduleInfo;
    }

    @FFDCIgnore(value={UnableToAdaptException.class})
    public static AnnotationScanner creatAnnotationScanner(ClassLoader classloader, Container cotainer) {
        try {
            AnnotationScanner scanner = new AnnotationScanner(classloader, cotainer);
            return scanner;
        }
        catch (UnableToAdaptException e) {
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Failed to create annotation scanner: " + e.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
    }

    @FFDCIgnore(value={ClassNotFoundException.class, InstantiationException.class, IllegalAccessException.class})
    public static OASModelReader getOASModelReader(ClassLoader appClassloader, String OASModelReaderClassName) {
        block6: {
            if (appClassloader == null || OASModelReaderClassName == null || OASModelReaderClassName.isEmpty()) {
                return null;
            }
            try {
                Class<?> clazz = appClassloader.loadClass(OASModelReaderClassName);
                Class<?> modelReaderClass = null;
                if (OASModelReader.class.isAssignableFrom(clazz)) {
                    modelReaderClass = clazz;
                    OASModelReader modelReader = (OASModelReader)modelReaderClass.newInstance();
                    return modelReader;
                }
            }
            catch (ClassNotFoundException e) {
                Tr.event((TraceComponent)tc, (String)("Failed to find class for model: " + OASModelReaderClassName), (Object[])new Object[0]);
            }
            catch (InstantiationException e) {
                Tr.event((TraceComponent)tc, (String)("Failed to instantiate class for model: " + OASModelReaderClassName), (Object[])new Object[0]);
            }
            catch (IllegalAccessException e) {
                if (!OpenAPIUtils.isEventEnabled(tc)) break block6;
                Tr.event((TraceComponent)tc, (String)("Failed to access class for model: " + OASModelReaderClassName), (Object[])new Object[0]);
            }
        }
        Tr.error((TraceComponent)tc, (String)"OPENAPI_MODEL_READER_LOAD_ERROR", (Object[])new Object[]{OASModelReaderClassName});
        return null;
    }

    @FFDCIgnore(value={ClassNotFoundException.class, InstantiationException.class, IllegalAccessException.class})
    public static OASFilter getOASFilter(ClassLoader appClassloader, String OASFilterClassName) {
        block8: {
            if (appClassloader == null || OASFilterClassName == null || OASFilterClassName.isEmpty()) {
                return null;
            }
            try {
                Class<?> clazz = appClassloader.loadClass(OASFilterClassName);
                Class<?> oasFilterClass = null;
                if (OASFilter.class.isAssignableFrom(clazz)) {
                    oasFilterClass = clazz;
                    OASFilter oasFilter = (OASFilter)oasFilterClass.newInstance();
                    return oasFilter;
                }
            }
            catch (ClassNotFoundException e) {
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Failed to find class for filter: " + OASFilterClassName), (Object[])new Object[0]);
                }
            }
            catch (InstantiationException e) {
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Failed to instantiate class for filter: " + OASFilterClassName), (Object[])new Object[0]);
                }
            }
            catch (IllegalAccessException e) {
                if (!OpenAPIUtils.isEventEnabled(tc)) break block8;
                Tr.event((TraceComponent)tc, (String)("Failed to access class for filter: " + OASFilterClassName), (Object[])new Object[0]);
            }
        }
        Tr.error((TraceComponent)tc, (String)"OPENAPI_FILTER_LOAD_ERROR", (Object[])new Object[]{OASFilterClassName});
        return null;
    }

    public static InputStream getUrlAsStream(URL url, String acceptValue) throws IOException {
        int responseCode;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        if (acceptValue != null && !acceptValue.trim().isEmpty()) {
            connection.setRequestProperty("Accept", acceptValue);
        }
        if ((responseCode = connection.getResponseCode()) == 200) {
            return connection.getInputStream();
        }
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Did not find resource at " + url + ".  ResponseCode: " + responseCode), (Object[])new Object[0]);
        }
        return null;
    }

    public static String mapToString(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        for (String key : map.keySet()) {
            if (map.get(key) == null) continue;
            sb.append(key + ": " + map.get(key) + "\n ");
        }
        sb.append("}");
        return sb.toString();
    }
}

