/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.main;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ras.instrument.internal.bci.LibertyTracingClassAdapter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;

public class LibertyJava8WorkaroundRuntimeTransformer
implements ClassFileTransformer {
    private static final TraceComponent tc = Tr.register(LibertyJava8WorkaroundRuntimeTransformer.class, (String)"logging", (String)"com.ibm.ws.logging.internal.resources.LoggingMessages");
    private static final boolean isIBMVirtualMachine = System.getProperty("java.vm.name", "unknown").contains("IBM J9") || System.getProperty("java.vm.name", "unknown").contains("OpenJ9");
    private static final boolean isJava8TraceEnabled = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            Boolean prop = Boolean.getBoolean("com.ibm.ws.ras.instrument.instrumentJava8Trace");
            return prop == null ? false : prop;
        }
    });
    private static final boolean detailedTransformTrace = Boolean.getBoolean("com.ibm.ws.logging.instrumentation.detail.enabled");
    private static Instrumentation instrumentation;
    private static LibertyJava8WorkaroundRuntimeTransformer registeredTransformer;
    private static boolean injectAtTransform;
    private static boolean skipDebugData;
    private static final Boolean isJDK8WithHotReplaceBug;

    protected static Boolean checkJDK8WithHotReplaceBug() {
        if (isIBMVirtualMachine) {
            int fploc;
            int offset;
            String runtimeVersion = System.getProperty("java.runtime.version", "unknown-00000000_0000");
            String specVersion = System.getProperty("java.specification.version");
            String[] versions = specVersion.split("[^0-9]");
            int n = offset = "1".equals(versions[0]) ? 1 : 0;
            if (versions.length <= offset) {
                return false;
            }
            int MAJOR = Integer.parseInt(versions[offset]);
            int MINOR = versions.length < 2 + offset ? 0 : Integer.parseInt(versions[1 + offset]);
            int SR = 0;
            int FP = 0;
            int srloc = runtimeVersion.toLowerCase().indexOf("sr");
            if (srloc > -1 && (srloc += 2) < runtimeVersion.length()) {
                int len = 0;
                while (srloc + len < runtimeVersion.length() && Character.isDigit(runtimeVersion.charAt(srloc + len))) {
                    ++len;
                }
                SR = Integer.parseInt(runtimeVersion.substring(srloc, srloc + len));
            }
            if ((fploc = runtimeVersion.toLowerCase().indexOf("fp")) > -1 && (fploc += 2) < runtimeVersion.length()) {
                int len = 0;
                while (fploc + len < runtimeVersion.length() && Character.isDigit(runtimeVersion.charAt(fploc + len))) {
                    ++len;
                }
                FP = Integer.parseInt(runtimeVersion.substring(fploc, fploc + len));
            }
            if (MAJOR == 8 && MINOR == 0 && (SR < 5 || SR == 5 && FP < 5)) {
                return true;
            }
        }
        return false;
    }

    public static synchronized void setInstrumentation(Instrumentation inst) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setInstrumentation", (Object[])new Object[]{inst});
        }
        if ((instrumentation = inst) != null && isJava8TraceEnabled) {
            LibertyJava8WorkaroundRuntimeTransformer.setInjectAtTransform(true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setInstrumentation");
        }
    }

    protected static void setInjectAtTransform(boolean injectAtTransform) {
        LibertyJava8WorkaroundRuntimeTransformer.injectAtTransform = injectAtTransform;
        if (injectAtTransform) {
            LibertyJava8WorkaroundRuntimeTransformer.addTransformer();
        }
    }

    protected static void setSkipDebugData(boolean skipDebugData) {
        LibertyJava8WorkaroundRuntimeTransformer.skipDebugData = skipDebugData;
    }

    private static synchronized void addTransformer() {
        if (detailedTransformTrace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addTransformer", (Object[])new Object[0]);
        }
        if (registeredTransformer == null && instrumentation != null) {
            registeredTransformer = new LibertyJava8WorkaroundRuntimeTransformer();
            instrumentation.addTransformer(registeredTransformer, false);
        }
        if (detailedTransformTrace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addTransformer");
        }
    }

    private static boolean isTransformPossible(byte[] bytes) {
        if (bytes.length < 8) {
            return false;
        }
        int classFileVersion = (bytes[6] & 0xFF) << 8 | bytes[7] & 0xFF;
        if (isJDK8WithHotReplaceBug.booleanValue()) {
            return classFileVersion == 52;
        }
        return false;
    }

    public static byte[] transform(byte[] bytes) throws IOException {
        return LibertyJava8WorkaroundRuntimeTransformer.transform(bytes, true);
    }

    public static byte[] transform(byte[] bytes, boolean skipIfNotPreprocessed) throws IOException {
        byte[] result;
        if (detailedTransformTrace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"transform", (Object[])new Object[0]);
        }
        ClassReader reader = new ClassReader(bytes);
        ClassWriter writer = new ClassWriter(reader, 1);
        StringWriter sw = null;
        ClassWriter visitor = writer;
        if (tc.isDumpEnabled()) {
            sw = new StringWriter();
            visitor = new CheckClassAdapter((ClassVisitor)visitor, false);
            visitor = new TraceClassVisitor((ClassVisitor)visitor, new PrintWriter(sw));
        }
        LibertyTracingClassAdapter tracingClassAdapter = new LibertyTracingClassAdapter((ClassVisitor)visitor, skipIfNotPreprocessed);
        try {
            reader.accept((ClassVisitor)tracingClassAdapter, skipDebugData ? 2 : 0);
        }
        catch (Throwable t) {
            IOException ioe = new IOException("Unable to instrument class stream with trace: " + t.getMessage(), t);
            throw ioe;
        }
        if (detailedTransformTrace && tc.isDumpEnabled() && tracingClassAdapter.isClassModified()) {
            Tr.dump((TraceComponent)tc, (String)"Transformed class", (Object[])new Object[]{sw});
        }
        byte[] byArray = result = tracingClassAdapter.isClassModified() ? writer.toByteArray() : null;
        if (detailedTransformTrace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"transform", (Object)result);
        }
        return result;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (detailedTransformTrace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"transform", (Object[])new Object[]{loader, className, classBeingRedefined, protectionDomain});
        }
        if (!isJava8TraceEnabled) {
            return null;
        }
        if (classBeingRedefined != null) {
            return null;
        }
        byte[] newClassBytes = null;
        if (LibertyJava8WorkaroundRuntimeTransformer.isTransformPossible(classfileBuffer)) {
            try {
                newClassBytes = LibertyJava8WorkaroundRuntimeTransformer.transform(classfileBuffer);
            }
            catch (Throwable t) {
                Tr.error((TraceComponent)tc, (String)"INSTRUMENTATION_TRANSFORM_FAILED_FOR_CLASS_2", (Object[])new Object[]{className, t});
            }
        }
        if (detailedTransformTrace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"transform", (Object)newClassBytes);
        }
        return newClassBytes;
    }

    static {
        registeredTransformer = null;
        injectAtTransform = false;
        skipDebugData = false;
        isJDK8WithHotReplaceBug = LibertyJava8WorkaroundRuntimeTransformer.checkJDK8WithHotReplaceBug() != false ? Boolean.TRUE : Boolean.FALSE;
    }
}

