/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.saaj.SAAJFactoryResolver;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Message;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class HandlerChainInvoker {
    private static final Logger LOG = LogUtils.getL7dLogger(HandlerChainInvoker.class);
    private final List<Handler<?>> protocolHandlers;
    private List<LogicalHandler<?>> logicalHandlers;
    private final List<Handler<?>> invokedHandlers;
    private final List<Handler<?>> closeHandlers;
    private boolean outbound;
    private boolean isRequestor;
    private boolean responseExpected;
    private boolean faultExpected;
    private boolean closed;
    private boolean messageDirectionReversed;
    private Exception fault;
    private LogicalMessageContext logicalMessageContext;
    private MessageContext protocolMessageContext;
    static final long serialVersionUID = -3197956785155349179L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HandlerChainInvoker(List<Handler> hc) {
        this(hc, true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "<init>", new Object[]{hc});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HandlerChainInvoker(List<Handler> hc, boolean isOutbound) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "<init>", new Object[]{hc, isOutbound});
        }
        this.protocolHandlers = new ArrayList();
        this.logicalHandlers = new ArrayList();
        this.invokedHandlers = new ArrayList();
        this.closeHandlers = new ArrayList();
        this.responseExpected = true;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "invoker for chain size: " + (hc != null ? hc.size() : 0));
        }
        if (hc != null) {
            for (Handler h : hc) {
                if (h instanceof LogicalHandler) {
                    this.logicalHandlers.add((LogicalHandler)h);
                    continue;
                }
                this.protocolHandlers.add(h);
            }
        }
        this.outbound = isOutbound;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<LogicalHandler<?>> getLogicalHandlers() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "getLogicalHandlers", new Object[0]);
        }
        List<LogicalHandler<?>> list = this.logicalHandlers;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "getLogicalHandlers", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Handler<?>> getProtocolHandlers() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "getProtocolHandlers", new Object[0]);
        }
        List<Handler<?>> list = this.protocolHandlers;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "getProtocolHandlers", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public LogicalMessageContext getLogicalMessageContext() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "getLogicalMessageContext", new Object[0]);
        }
        LogicalMessageContext logicalMessageContext = this.logicalMessageContext;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            logicalMessageContext = logicalMessageContext;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "getLogicalMessageContext", logicalMessageContext);
        }
        return logicalMessageContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setLogicalMessageContext(LogicalMessageContext mc) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setLogicalMessageContext", new Object[]{mc});
        }
        this.logicalMessageContext = mc;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setLogicalMessageContext");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MessageContext getProtocolMessageContext() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "getProtocolMessageContext", new Object[0]);
        }
        MessageContext messageContext = this.protocolMessageContext;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            messageContext = messageContext;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "getProtocolMessageContext", messageContext);
        }
        return messageContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setProtocolMessageContext(MessageContext mc) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setProtocolMessageContext", new Object[]{mc});
        }
        this.protocolMessageContext = mc;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setProtocolMessageContext");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean invokeLogicalHandlers(boolean requestor, LogicalMessageContext context) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeLogicalHandlers", new Object[]{requestor, context});
        }
        boolean bl = this.invokeHandlerChain(this.logicalHandlers, (MessageContext)context);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeLogicalHandlers", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean invokeLogicalHandlersHandleFault(boolean requestor, LogicalMessageContext context) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeLogicalHandlersHandleFault", new Object[]{requestor, context});
        }
        boolean bl = this.invokeHandlerChainHandleFault(this.logicalHandlers, (MessageContext)context);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeLogicalHandlersHandleFault", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean invokeProtocolHandlers(boolean requestor, MessageContext context) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeProtocolHandlers", new Object[]{requestor, context});
        }
        boolean bl = this.invokeHandlerChain(this.protocolHandlers, context);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeProtocolHandlers", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean invokeProtocolHandlersHandleFault(boolean requestor, MessageContext context) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeProtocolHandlersHandleFault", new Object[]{requestor, context});
        }
        boolean bl = this.invokeHandlerChainHandleFault(this.protocolHandlers, context);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeProtocolHandlersHandleFault", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setResponseExpected(boolean expected) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setResponseExpected", new Object[]{expected});
        }
        this.responseExpected = expected;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setResponseExpected");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isResponseExpected() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "isResponseExpected", new Object[0]);
        }
        boolean bl = this.responseExpected;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "isResponseExpected", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isOutbound() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "isOutbound", new Object[0]);
        }
        boolean bl = this.outbound;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "isOutbound", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isInbound() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "isInbound", new Object[0]);
        }
        boolean bl = !this.outbound;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "isInbound", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isRequestor() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "isRequestor", new Object[0]);
        }
        boolean bl = this.isRequestor;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "isRequestor", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setRequestor(boolean requestor) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setRequestor", new Object[]{requestor});
        }
        this.isRequestor = requestor;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setRequestor");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setInbound() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setInbound", new Object[0]);
        }
        this.outbound = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setInbound");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setOutbound() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setOutbound", new Object[0]);
        }
        this.outbound = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setOutbound");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean faultRaised() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "faultRaised", new Object[0]);
        }
        boolean bl = null != this.fault || this.faultExpected;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "faultRaised", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Exception getFault() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "getFault", new Object[0]);
        }
        Exception exception = this.fault;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            exception = exception;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "getFault", exception);
        }
        return exception;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setFault(boolean fe) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setFault", new Object[]{fe});
        }
        this.faultExpected = fe;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setFault");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void mepComplete(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "mepComplete", new Object[]{message});
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "closing protocol handlers - handler count:" + this.invokedHandlers.size());
        }
        if (this.isClosed()) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "mepComplete");
            }
            return;
        }
        this.invokeReversedClose();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "mepComplete");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isClosed() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "isClosed", new Object[0]);
        }
        boolean bl = this.closed;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "isClosed", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void adoptLogicalHandlers(HandlerChainInvoker invoker) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "adoptLogicalHandlers", new Object[]{invoker});
        }
        this.logicalHandlers = invoker.getLogicalHandlers();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "adoptLogicalHandlers");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    List<Handler<?>> getInvokedHandlers() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "getInvokedHandlers", new Object[0]);
        }
        List<Handler<?>> list = Collections.unmodifiableList(this.invokedHandlers);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "getInvokedHandlers", list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean invokeHandlerChain(List<? extends Handler<?>> handlerChain, MessageContext ctx) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeHandlerChain", new Object[]{handlerChain, ctx});
        }
        if (handlerChain.isEmpty()) {
            LOG.log(Level.FINEST, "no handlers registered");
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeHandlerChain", bl);
            }
            return bl;
        }
        if (this.isClosed()) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeHandlerChain", bl);
            }
            return bl;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "invoking handlers, direction: " + (this.outbound ? "outbound" : "inbound"));
        }
        if (!this.outbound) {
            handlerChain = this.reverseHandlerChain(handlerChain);
        }
        boolean continueProcessing = true;
        MessageContext oldCtx = null;
        try {
            oldCtx = WebServiceContextImpl.setMessageContext(ctx);
            continueProcessing = this.invokeHandleMessage(handlerChain, ctx);
        }
        finally {
            if (oldCtx == null) {
                WebServiceContextImpl.clear();
            } else {
                WebServiceContextImpl.setMessageContext(oldCtx);
            }
        }
        boolean bl = continueProcessing;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeHandlerChain", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean invokeHandlerChainHandleFault(List<? extends Handler<?>> handlerChain, MessageContext ctx) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeHandlerChainHandleFault", new Object[]{handlerChain, ctx});
        }
        if (handlerChain.isEmpty()) {
            LOG.log(Level.FINEST, "no handlers registered");
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeHandlerChainHandleFault", bl);
            }
            return bl;
        }
        if (this.isClosed()) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeHandlerChainHandleFault", bl);
            }
            return bl;
        }
        if (this.fault != null) {
            if (!(this.fault instanceof ProtocolException)) {
                boolean bl = true;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeHandlerChainHandleFault", bl);
                }
                return bl;
            }
            if (!this.responseExpected && !this.messageDirectionReversed) {
                boolean bl = true;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeHandlerChainHandleFault", bl);
                }
                return bl;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "invoking handlers, direction: " + (this.outbound ? "outbound" : "inbound"));
        }
        this.setMessageOutboundProperty(ctx);
        if (!this.outbound) {
            handlerChain = this.reverseHandlerChain(handlerChain);
        }
        boolean continueProcessing = true;
        MessageContext oldCtx = null;
        try {
            oldCtx = WebServiceContextImpl.setMessageContext(ctx);
            continueProcessing = this.invokeHandleFault(handlerChain, ctx);
        }
        finally {
            if (oldCtx == null) {
                WebServiceContextImpl.clear();
            } else {
                WebServiceContextImpl.setMessageContext(oldCtx);
            }
        }
        boolean bl = continueProcessing;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeHandlerChainHandleFault", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean invokeHandleFault(List<? extends Handler<?>> handlerChain, MessageContext ctx) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeHandleFault", new Object[]{handlerChain, ctx});
        }
        boolean continueProcessing = true;
        try {
            for (Handler<?> h : handlerChain) {
                if (this.invokeThisHandler(h)) {
                    this.closeHandlers.add(h);
                    this.markHandlerInvoked(h);
                    Handler<?> lh = h;
                    continueProcessing = lh.handleFault(ctx);
                }
                if (continueProcessing) continue;
                break;
            }
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "HANDLER_RAISED_RUNTIME_EXCEPTION", e);
            continueProcessing = false;
            throw e;
        }
        boolean bl = continueProcessing;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeHandleFault", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean invokeHandleMessage(List<? extends Handler<?>> handlerChain, MessageContext ctx) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeHandleMessage", new Object[]{handlerChain, ctx});
        }
        boolean continueProcessing = true;
        try {
            for (Handler<?> h : handlerChain) {
                if (this.invokeThisHandler(h)) {
                    this.closeHandlers.add(h);
                    this.markHandlerInvoked(h);
                    Handler<?> lh = h;
                    continueProcessing = lh.handleMessage(ctx);
                }
                if (continueProcessing) continue;
                if (this.responseExpected) {
                    this.changeMessageDirection(ctx);
                    this.messageDirectionReversed = true;
                } else {
                    this.invokeReversedClose();
                }
                break;
            }
        }
        catch (ProtocolException e) {
            LOG.log(Level.FINE, "handleMessage raised exception", e);
            if (this.responseExpected) {
                this.changeMessageDirection(ctx);
                this.messageDirectionReversed = true;
            }
            if (this.isRequestor()) {
                if (this.responseExpected) {
                    this.setFaultMessage(ctx, (Exception)((Object)e));
                    this.invokeReversedHandleFault(ctx);
                } else {
                    this.invokeReversedClose();
                }
                continueProcessing = false;
                this.setFault((Exception)((Object)e));
                if (this.responseExpected || this.isInbound()) {
                    if (e instanceof SOAPFaultException) {
                        throw this.mapSoapFault((SOAPFaultException)e);
                    }
                    throw e;
                }
            } else {
                continueProcessing = false;
                if (this.responseExpected || this.outbound) {
                    this.setFault((Exception)((Object)e));
                    if (e instanceof SOAPFaultException) {
                        throw this.mapSoapFault((SOAPFaultException)e);
                    }
                    throw e;
                }
                this.invokeReversedClose();
            }
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "HANDLER_RAISED_RUNTIME_EXCEPTION", e);
            if (this.responseExpected) {
                this.changeMessageDirection(ctx);
                this.messageDirectionReversed = true;
            }
            if (this.isRequestor()) {
                this.invokeReversedClose();
                continueProcessing = false;
                this.setFault(e);
                throw e;
            }
            if (!this.responseExpected && !this.outbound) {
                this.invokeReversedClose();
                continueProcessing = false;
            }
            continueProcessing = false;
            this.setFault(e);
            throw e;
        }
        boolean bl = continueProcessing;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeHandleMessage", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private SoapFault mapSoapFault(SOAPFaultException sfe) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "mapSoapFault", new Object[]{sfe});
        }
        SoapFault sf = new SoapFault(sfe.getFault().getFaultString(), (Throwable)sfe, sfe.getFault().getFaultCodeAsQName());
        sf.setRole(sfe.getFault().getFaultActor());
        if (sfe.getFault().hasDetail()) {
            sf.setDetail((Element)sfe.getFault().getDetail());
        }
        SoapFault soapFault = sf;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            soapFault = soapFault;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "mapSoapFault", soapFault);
        }
        return soapFault;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setFaultMessage(MessageContext mc, Exception exception) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setFaultMessage", new Object[]{mc, exception});
        }
        Message msg = ((WrappedMessageContext)mc).getWrappedMessage();
        msg.setContent(Exception.class, (Object)exception);
        msg.removeContent(XMLStreamReader.class);
        msg.removeContent(Source.class);
        try {
            SOAPMessage soapMessage = null;
            SoapVersion version = null;
            if (msg instanceof SoapMessage) {
                version = ((SoapMessage)msg).getVersion();
            }
            soapMessage = SAAJFactoryResolver.createMessageFactory(version).createMessage();
            msg.setContent(SOAPMessage.class, (Object)soapMessage);
            SOAPBody body = SAAJUtils.getBody((SOAPMessage)soapMessage);
            SOAPFault soapFault = body.addFault();
            if (exception instanceof SOAPFaultException) {
                SOAPFaultException sf = (SOAPFaultException)exception;
                soapFault.setFaultString(sf.getFault().getFaultString());
                SAAJUtils.setFaultCode((SOAPFault)soapFault, (QName)sf.getFault().getFaultCodeAsQName());
                soapFault.setFaultActor(sf.getFault().getFaultActor());
                if (sf.getFault().hasDetail()) {
                    Node nd = soapMessage.getSOAPPart().importNode((Node)sf.getFault().getDetail(), true);
                    soapFault.addDetail();
                    for (nd = nd.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
                        soapFault.getDetail().appendChild(nd);
                    }
                }
            } else if (exception instanceof Fault) {
                SoapFault sf = SoapFault.createFault((Fault)((Fault)((Object)exception)), (SoapVersion)((SoapMessage)msg).getVersion());
                soapFault.setFaultString(sf.getReason());
                SAAJUtils.setFaultCode((SOAPFault)soapFault, (QName)sf.getFaultCode());
                if (sf.hasDetails()) {
                    soapFault.addDetail();
                    Node nd = soapMessage.getSOAPPart().importNode((Node)sf.getDetail(), true);
                    for (nd = nd.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
                        soapFault.getDetail().appendChild(nd);
                    }
                }
            } else {
                SAAJUtils.setFaultCode((SOAPFault)soapFault, (QName)new QName("http://cxf.apache.org/faultcode", "HandlerFault"));
                soapFault.setFaultString(exception.getMessage());
            }
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setFaultMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean invokeReversedHandleFault(MessageContext ctx) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeReversedHandleFault", new Object[]{ctx});
        }
        boolean continueProcessing = true;
        try {
            for (int index = this.invokedHandlers.size() - 2; index >= 0 && continueProcessing; --index) {
                Handler<?> h = this.invokedHandlers.get(index);
                if (h instanceof LogicalHandler) {
                    LogicalHandler lh = (LogicalHandler)h;
                    continueProcessing = lh.handleFault((MessageContext)this.logicalMessageContext);
                } else {
                    Handler<?> ph = h;
                    continueProcessing = ph.handleFault(this.protocolMessageContext);
                }
                if (continueProcessing) continue;
                this.invokeReversedClose();
                break;
            }
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "HANDLER_RAISED_RUNTIME_EXCEPTION", e);
            this.invokeReversedClose();
            continueProcessing = false;
            this.closed = true;
            throw e;
        }
        this.invokeReversedClose();
        boolean bl = continueProcessing;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeReversedHandleFault", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void invokeReversedClose() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeReversedClose", new Object[0]);
        }
        for (int index = this.invokedHandlers.size() - 1; index >= 0; --index) {
            Handler<?> handler = this.invokedHandlers.get(index);
            if (handler instanceof LogicalHandler) {
                handler.close((MessageContext)this.logicalMessageContext);
            } else {
                handler.close(this.protocolMessageContext);
            }
            this.invokedHandlers.remove(index);
        }
        this.closed = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeReversedClose");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean invokeThisHandler(Handler<?> h) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeThisHandler", new Object[]{h});
        }
        boolean ret = true;
        if (this.messageDirectionReversed) {
            boolean bl = ret = this.invokedHandlers.contains(h) && !this.isTheLastInvokedHandler(h);
        }
        if (ret && LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "invoking handler of type " + h.getClass().getName());
        }
        boolean bl = ret;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "invokeThisHandler", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isTheLastInvokedHandler(Handler<?> h) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "isTheLastInvokedHandler", new Object[]{h});
        }
        boolean bl = this.invokedHandlers.contains(h) && this.invokedHandlers.indexOf(h) == this.invokedHandlers.size() - 1;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "isTheLastInvokedHandler", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void markHandlerInvoked(Handler<?> h) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "markHandlerInvoked", new Object[]{h});
        }
        if (!this.invokedHandlers.contains(h)) {
            this.invokedHandlers.add(h);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "markHandlerInvoked");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void changeMessageDirection(MessageContext context) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "changeMessageDirection", new Object[]{context});
        }
        this.outbound = !this.outbound;
        this.setMessageOutboundProperty(context);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "changeMessageDirection");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setMessageOutboundProperty(MessageContext context) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setMessageOutboundProperty", new Object[]{context});
        }
        context.put((Object)"javax.xml.ws.handler.message.outbound", (Object)this.outbound);
        if (this.logicalMessageContext != null) {
            this.logicalMessageContext.put((Object)"javax.xml.ws.handler.message.outbound", (Object)this.outbound);
        }
        if (this.protocolMessageContext != null) {
            this.protocolMessageContext.put((Object)"javax.xml.ws.handler.message.outbound", (Object)this.outbound);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setMessageOutboundProperty");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private <T extends Handler<?>> List<T> reverseHandlerChain(List<T> handlerChain) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "reverseHandlerChain", new Object[]{handlerChain});
        }
        ArrayList<T> reversedHandlerChain = new ArrayList<T>();
        reversedHandlerChain.addAll(handlerChain);
        Collections.reverse(reversedHandlerChain);
        ArrayList<T> arrayList = reversedHandlerChain;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "reverseHandlerChain", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected final void setFault(Exception ex) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setFault", new Object[]{ex});
        }
        this.fault = ex;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.handler.HandlerChainInvoker", "setFault");
        }
    }
}

