/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.ByteDataSource;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.model.SoapBodyInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.interceptors.HolderOutInterceptor;
import org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class SwAOutInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(SwAOutInterceptor.class);
    private static final Map<String, Method> SWA_REF_METHOD = new ConcurrentHashMap<String, Method>(4, 0.75f, 2);
    private static boolean skipHasSwaRef;
    AttachmentOutInterceptor attachOut;
    static final long serialVersionUID = -9123079183859247672L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SwAOutInterceptor() {
        super("pre-logical");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "<init>", new Object[0]);
        }
        this.attachOut = new AttachmentOutInterceptor();
        this.addAfter(HolderOutInterceptor.class.getName());
        this.addBefore(WrapperClassOutInterceptor.class.getName());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean callSWARefMethod(final JAXBContext ctx) {
        boolean bl;
        block7: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "callSWARefMethod", new Object[]{ctx});
            }
            Method m = SWA_REF_METHOD.get(ctx.getClass().getName());
            if (m == null && !SWA_REF_METHOD.containsKey(ctx.getClass().getName())) {
                try {
                    m = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){
                        static final long serialVersionUID = -2473244584917779893L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Method run() throws Exception {
                            Method hasSwaRefMethod = ctx.getClass().getMethod("hasSwaRef", new Class[0]);
                            if (!hasSwaRefMethod.isAccessible()) {
                                hasSwaRefMethod.setAccessible(true);
                            }
                            return hasSwaRefMethod;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxws.interceptors.SwAOutInterceptor$1", 1.class, null, null);
                        }
                    });
                    SWA_REF_METHOD.put(ctx.getClass().getName(), m);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                bl = (Boolean)m.invoke((Object)ctx, new Object[0]);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block7;
            }
            catch (Exception e) {
                boolean bl2 = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl2 = bl2;
                    LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "callSWARefMethod", bl2);
                }
                return bl2;
            }
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "callSWARefMethod", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(SoapMessage message) throws Fault {
        SoapBodyInfo sbi;
        boolean client;
        BindingMessageInfo bmi;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "handleMessage", new Object[]{message});
        }
        Exchange ex = message.getExchange();
        BindingOperationInfo bop = ex.getBindingOperationInfo();
        if (bop == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "handleMessage");
            }
            return;
        }
        if (bop.isUnwrapped()) {
            bop = bop.getWrappedOperation();
        }
        BindingMessageInfo bindingMessageInfo = bmi = (client = this.isRequestor((Message)message)) ? bop.getInput() : bop.getOutput();
        if (bmi == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "handleMessage");
            }
            return;
        }
        Boolean newAttachment = false;
        Message exOutMsg = ex.getOutMessage();
        if (exOutMsg != null) {
            newAttachment = MessageUtils.isTrue((Object)exOutMsg.getContextualProperty("cxf.add.attachments"));
            LOG.log(Level.FINE, "Request context attachment property: cxf.add.attachments is set to: " + newAttachment);
        }
        if ((sbi = (SoapBodyInfo)bmi.getExtensor(SoapBodyInfo.class)) == null || sbi.getAttachments() == null || sbi.getAttachments().size() == 0) {
            Service s = ex.getService();
            DataBinding db = s.getDataBinding();
            if (db instanceof JAXBDataBinding && this.hasSwaRef((JAXBDataBinding)db)) {
                Boolean includeAttachs = false;
                Message exInpMsg = ex.getInMessage();
                LOG.log(Level.FINE, "Exchange Input message: " + exInpMsg);
                if (exInpMsg != null) {
                    includeAttachs = MessageUtils.isTrue((Object)exInpMsg.getContextualProperty("cxf.add.attachments"));
                }
                LOG.log(Level.FINE, "Add attachments message property: cxf.add.attachments value is " + includeAttachs);
                if (!skipHasSwaRef || includeAttachs.booleanValue() || newAttachment.booleanValue()) {
                    this.setupAttachmentOutput(message);
                } else {
                    this.skipAttachmentOutput(message);
                }
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "handleMessage");
            }
            return;
        }
        this.processAttachments(message, sbi);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "handleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void processAttachments(SoapMessage message, SoapBodyInfo sbi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "processAttachments", new Object[]{message, sbi});
        }
        Collection<Attachment> atts = this.setupAttachmentOutput(message);
        List outObjects = CastUtils.cast((List)((List)message.getContent(List.class)));
        for (MessagePartInfo mpi : sbi.getAttachments()) {
            String partName = mpi.getConcreteName().getLocalPart();
            String ct = (String)mpi.getProperty("Content-Type");
            String id = partName + "=" + UUID.randomUUID() + "@apache.org";
            int idx = mpi.getIndex();
            Object o = outObjects.get(idx);
            if (o == null) continue;
            outObjects.set(idx, null);
            DataHandler dh = null;
            if (o instanceof Source) {
                dh = new DataHandler(this.createDataSource((Source)o, ct));
            } else if (o instanceof Image) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
                Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType(ct);
                if (writers.hasNext()) {
                    ImageWriter writer = writers.next();
                    try {
                        BufferedImage bimg = this.convertToBufferedImage((Image)o);
                        ImageOutputStream out = ImageIO.createImageOutputStream(bos);
                        writer.setOutput(out);
                        writer.write(bimg);
                        writer.dispose();
                        out.flush();
                        out.close();
                        bos.close();
                    }
                    catch (IOException e) {
                        throw new Fault((Throwable)e);
                    }
                } else {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("ATTACHMENT_NOT_SUPPORTED", LOG, new Object[]{ct}));
                }
                dh = new DataHandler((DataSource)new ByteDataSource(bos.toByteArray(), ct));
            } else if (o instanceof DataHandler) {
                dh = (DataHandler)o;
                ct = dh.getContentType();
                try {
                    if ("text/xml".equals(ct) && dh.getContent() instanceof Source) {
                        dh = new DataHandler(this.createDataSource((Source)dh.getContent(), ct));
                    }
                }
                catch (IOException bos) {}
            } else if (o instanceof byte[]) {
                if (ct == null) {
                    ct = "application/octet-stream";
                }
                dh = new DataHandler((DataSource)new ByteDataSource((byte[])o, ct));
            } else if (o instanceof String) {
                if (ct == null) {
                    ct = "text/plain; charset='UTF-8'";
                }
                try {
                    dh = new DataHandler((DataSource)new ByteDataSource(((String)o).getBytes("UTF-8"), ct));
                }
                catch (IOException e) {
                    throw new Fault((Throwable)e);
                }
            } else {
                throw new Fault(new org.apache.cxf.common.i18n.Message("ATTACHMENT_NOT_SUPPORTED", LOG, new Object[]{o.getClass()}));
            }
            AttachmentImpl att = new AttachmentImpl(id);
            att.setDataHandler(dh);
            att.setHeader("Content-Type", ct);
            atts.add((Attachment)att);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "processAttachments");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean hasSwaRef(JAXBDataBinding db) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "hasSwaRef", new Object[]{db});
        }
        JAXBContext context = db.getContext();
        boolean bl = this.callSWARefMethod(context);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "hasSwaRef", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private DataSource createDataSource(Source o, String ct) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "createDataSource", new Object[]{o, ct});
        }
        ByteDataSource ds = null;
        if (o instanceof StreamSource) {
            StreamSource src = (StreamSource)o;
            try {
                if (src.getInputStream() != null) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
                    IOUtils.copy((InputStream)src.getInputStream(), (OutputStream)bos, (int)1024);
                    ds = new ByteDataSource(bos.toByteArray(), ct);
                }
                ds = new ByteDataSource(IOUtils.toString((Reader)src.getReader()).getBytes("UTF-8"), ct);
            }
            catch (IOException e) {
                throw new Fault((Throwable)e);
            }
        } else {
            ByteArrayOutputStream bwriter = new ByteArrayOutputStream();
            XMLStreamWriter writer = null;
            try {
                writer = StaxUtils.createXMLStreamWriter((OutputStream)bwriter);
                StaxUtils.copy((Source)o, (XMLStreamWriter)writer);
                writer.flush();
                ds = new ByteDataSource(bwriter.toByteArray(), ct);
            }
            catch (XMLStreamException e1) {
                throw new Fault((Throwable)e1);
            }
            finally {
                StaxUtils.close((XMLStreamWriter)writer);
            }
        }
        ByteDataSource byteDataSource = ds;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            byteDataSource = byteDataSource;
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "createDataSource", byteDataSource);
        }
        return byteDataSource;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private BufferedImage convertToBufferedImage(Image image) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "convertToBufferedImage", new Object[]{image});
        }
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bufferedImage = bufferedImage;
                LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "convertToBufferedImage", bufferedImage);
            }
            return bufferedImage;
        }
        MediaTracker tracker = new MediaTracker(new Component(){
            private static final long serialVersionUID = 6412221228374321325L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxws.interceptors.SwAOutInterceptor$2", 2.class, null, null);
            }
        });
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException e) {
            throw new Fault((Throwable)e);
        }
        BufferedImage bufImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bufImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        BufferedImage bufferedImage = bufImage;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bufferedImage = bufferedImage;
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "convertToBufferedImage", bufferedImage);
        }
        return bufferedImage;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Collection<Attachment> setupAttachmentOutput(SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "setupAttachmentOutput", new Object[]{message});
        }
        message.getInterceptorChain().add((Interceptor)this.attachOut);
        message.put("write.attachments", (Object)Boolean.TRUE);
        ArrayList<Attachment> atts = message.getAttachments();
        if (atts == null) {
            atts = new ArrayList<Attachment>();
            message.setAttachments(atts);
        }
        ArrayList<Attachment> arrayList = atts;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "setupAttachmentOutput", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Collection<Attachment> skipAttachmentOutput(SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "skipAttachmentOutput", new Object[]{message});
        }
        ArrayList<Attachment> atts = message.getAttachments();
        LOG.log(Level.FINE, "skipAttachmentOutput: getAttachments returned  " + atts);
        if (atts != null) {
            message.getInterceptorChain().add((Interceptor)this.attachOut);
            message.put("write.attachments", (Object)Boolean.TRUE);
        } else {
            atts = new ArrayList<Attachment>();
            message.setAttachments(atts);
        }
        ArrayList<Attachment> arrayList = atts;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "skipAttachmentOutput", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        String skipSwaRef = System.getProperty("cxf.multipart.attachment");
        LOG.log(Level.FINE, "cxf.multipart.attachment property is set to " + skipSwaRef);
        skipHasSwaRef = skipSwaRef != null && skipSwaRef.trim().length() > 0 && skipSwaRef.trim().equalsIgnoreCase("false");
    }
}

