/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.expiry;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.expiry.Expirable;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.lang.ref.SoftReference;

public class ExpirableReference
extends SoftReference {
    private static TraceComponent tc = SibTr.register(ExpirableReference.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private long expiryTime = 0L;
    private long objectID = 0L;

    public ExpirableReference(Expirable expirable) throws SevereMessageStoreException {
        super(expirable);
        if (expirable != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("id=" + expirable.expirableGetID()));
            }
            this.expiryTime = 0L;
            this.objectID = expirable.expirableGetID();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)"null");
        }
        if (this.objectID == -1L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
            }
            throw new SevereMessageStoreException("DUPLICATE_EXPIRABLE_SIMS2000");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public long getID() {
        return this.objectID;
    }

    public void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }
}

