/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.task;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.impl.CachedPersistableImpl;
import com.ibm.ws.sib.msgstore.task.Task;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.TransactionState;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;

public final class AddTask
extends Task {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceComponent tc = SibTr.register(AddTask.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private CachedPersistable _cachedPersistable = null;
    private Persistable _masterPersistable;
    private final boolean _isPersistentDataImmutable;
    private final boolean _isPersistentDataNeverUpdated;

    public AddTask(AbstractItemLink link) throws SevereMessageStoreException {
        super(link);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)link);
        }
        this._masterPersistable = super.getPersistable();
        this._isPersistentDataImmutable = this.getItem().isPersistentDataImmutable();
        this._isPersistentDataNeverUpdated = this.getItem().isPersistentDataNeverUpdated();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @Override
    public final void abort(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"abort", (Object)transaction);
        }
        this.getLink().abortAdd(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"abort");
        }
    }

    @Override
    public final void commitExternal(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitExternal", (Object)transaction);
        }
        this.getLink().commitAdd(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitExternal");
        }
    }

    @Override
    public final void commitInternal(PersistentTransaction transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitInternal", (Object)transaction);
        }
        this.getLink().internalCommitAdd();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitInternal");
        }
    }

    @Override
    public final void copyDataIfVulnerable() throws PersistentDataEncodingException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"copyDataIfVulnerable");
        }
        if (this._cachedPersistable == null) {
            this._cachedPersistable = new CachedPersistable(this._masterPersistable, !this._isPersistentDataImmutable || !this._isPersistentDataNeverUpdated);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"copyDataIfVulnerable");
        }
    }

    @Override
    public void ensureDataAvailable() throws PersistentDataEncodingException, SevereMessageStoreException {
        AbstractItem item;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"ensureDataAvailable");
        }
        if ((item = this.getItem()) == null || !item.isInStore()) {
            throw new NotInMessageStore();
        }
        if (this._cachedPersistable == null) {
            this._cachedPersistable = new CachedPersistable(this._masterPersistable, true);
        } else {
            this._cachedPersistable.cacheMemberData();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"ensureDataAvailable");
        }
    }

    @Override
    public final Persistable getPersistable() {
        if (this._cachedPersistable != null) {
            return this._cachedPersistable;
        }
        return this._masterPersistable;
    }

    @Override
    public Task.Type getTaskType() {
        return Task.Type.ADD;
    }

    @Override
    public final boolean isCreateOfPersistentRepresentation() {
        return true;
    }

    @Override
    public final int getPersistableInMemorySizeApproximation(TransactionState tranState) {
        int size;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPersistableInMemorySizeApproximation", (Object)tranState);
        }
        if (tranState == TransactionState.STATE_COMMITTED || tranState == TransactionState.STATE_COMMITTING_1PC || tranState == TransactionState.STATE_PREPARING || tranState == TransactionState.STATE_PREPARED) {
            size = 500 + this.getPersistable().getInMemoryByteSize();
        } else if (tranState == TransactionState.STATE_ROLLEDBACK || tranState == TransactionState.STATE_ROLLINGBACK) {
            size = 500;
        } else if (tranState == TransactionState.STATE_COMMITTING_2PC) {
            size = 0;
        } else {
            throw new IllegalStateException(nls.getFormattedMessage("INVALID_TASK_OPERATION_SIMS1520", new Object[]{tranState}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPersistableInMemorySizeApproximation", (Object)size);
        }
        return size;
    }

    @Override
    public final void persist(BatchingContext batchingContext, TransactionState tranState) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persist", (Object)new Object[]{batchingContext, tranState});
        }
        if (tranState == TransactionState.STATE_COMMITTED || tranState == TransactionState.STATE_COMMITTING_1PC || tranState == TransactionState.STATE_PREPARING || tranState == TransactionState.STATE_PREPARED) {
            batchingContext.insert(this.getPersistable());
        } else if (tranState == TransactionState.STATE_ROLLEDBACK || tranState == TransactionState.STATE_ROLLINGBACK) {
            batchingContext.delete(this.getPersistable());
        } else if (tranState != TransactionState.STATE_COMMITTING_2PC) {
            throw new IllegalStateException(nls.getFormattedMessage("INVALID_TASK_OPERATION_SIMS1520", new Object[]{tranState}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"persist");
        }
    }

    @Override
    public final void postAbort(PersistentTransaction transaction) throws SevereMessageStoreException {
        AbstractItem item;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"postAbort", (Object)transaction);
        }
        if (null == (item = this.getItem())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"null item");
            }
        } else {
            item.eventPostRollbackAdd((Transaction)transaction);
        }
        this.getLink().postAbortAdd(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"postAbort");
        }
    }

    @Override
    public final void postCommit(PersistentTransaction transaction) throws SevereMessageStoreException {
        AbstractItem item;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"postCommit", (Object)transaction);
        }
        if (null == (item = this.getItem())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"null item");
            }
        } else {
            item.eventPostCommitAdd((Transaction)transaction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"postCommit");
        }
    }

    @Override
    public final void preCommit(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"preCommit", (Object)transaction);
        }
        this.getLink().preCommitAdd(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"preCommit");
        }
    }

    private final class CachedPersistable
    extends CachedPersistableImpl {
        private long _cachedLockId;
        private List<DataSlice> _cachedMemberData;
        private int _cachedInMemorySize;
        private boolean _isMemberDataCached;

        public CachedPersistable(Persistable masterPersistable, boolean copyMemberData) throws PersistentDataEncodingException, SevereMessageStoreException {
            super(masterPersistable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>$CachedPersistable");
            }
            if (copyMemberData) {
                List<DataSlice> memberData = masterPersistable.getData();
                this._cachedMemberData = null == memberData || AddTask.this._isPersistentDataImmutable ? memberData : new ArrayList<DataSlice>(memberData);
            }
            this._cachedInMemorySize = masterPersistable.getInMemoryByteSize();
            this._isMemberDataCached = copyMemberData;
            this._cachedLockId = masterPersistable.getLockID();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>$CachedPersistable");
            }
        }

        @Override
        public List<DataSlice> getData() throws PersistentDataEncodingException, SevereMessageStoreException {
            if (!this._isMemberDataCached) {
                return AddTask.this._masterPersistable.getData();
            }
            return this._cachedMemberData;
        }

        @Override
        public int getInMemoryByteSize() {
            return this._cachedInMemorySize;
        }

        @Override
        public long getLockID() {
            return this._cachedLockId;
        }

        @Override
        public void setLockID(long l) {
            throw new UnsupportedOperationException();
        }

        public void cacheMemberData() throws PersistentDataEncodingException, SevereMessageStoreException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"cacheMemberData");
            }
            if (!this._isMemberDataCached) {
                List<DataSlice> memberData = AddTask.this._masterPersistable.getData();
                this._cachedMemberData = null == memberData || AddTask.this._isPersistentDataImmutable ? memberData : new ArrayList<DataSlice>(memberData);
                this._isMemberDataCached = true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"cacheMemberData");
            }
        }
    }
}

