/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.CancelException;
import com.ibm.ws.install.InstallConstants;
import com.ibm.ws.install.InstallEventListener;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallKernel;
import com.ibm.ws.install.InstallKernelFactory;
import com.ibm.ws.install.InstallKernelInteractive;
import com.ibm.ws.install.InstallLicense;
import com.ibm.ws.install.InstallProgressEvent;
import com.ibm.ws.install.RepositoryConfigUtils;
import com.ibm.ws.install.internal.ArchiveUtils;
import com.ibm.ws.install.internal.ArtifactDownloader;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.InstallKernelImpl;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.ProgressBar;
import com.ibm.ws.install.internal.ResolveDirector;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.repository.connections.DirectoryRepositoryConnection;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.connections.RepositoryConnectionList;
import com.ibm.ws.repository.connections.SingleFileRepositoryConnection;
import com.ibm.ws.repository.connections.liberty.ProductInfoProductDefinition;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.parsers.EsaParser;
import com.ibm.ws.repository.resolver.RepositoryResolutionException;
import com.ibm.ws.repository.resolver.RepositoryResolver;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.writeable.RepositoryResourceWritable;
import com.ibm.ws.repository.strategies.writeable.AddThenDeleteStrategy;
import com.ibm.ws.repository.strategies.writeable.UploadStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.aries.util.manifest.ManifestProcessor;

public class InstallKernelMap
implements Map {
    private static final String MAP_BASED_INSTALL_KERNEL = "mapBasedInstallKernel";
    private static final String RUNTIME_INSTALL_DIR = "runtime.install.dir";
    private static final String LICENSE_ACCEPT = "license.accept";
    private static final String REPOSITORIES_PROPERTIES = "repositories.properties";
    private static final String DOWLOAD_EXTERNAL_DEPS = "dowload.external.deps";
    private static final String INSTALL_LOCAL_ESA = "install.local.esa";
    private static final String LOCAL_ESA_DOWNLOAD_DIR = "local.esa.download.dir";
    private static final String USER_AGENT = "user.agent";
    private static final String PROGRESS_MONITOR_MESSAGE = "progress.monitor.message";
    private static final String PROGRESS_MONITOR_CANCELLED = "progress.monitor.cancelled";
    private static final String PROGRESS_MONITOR_SIZE = "progress.monitor.size";
    private static final String TARGET_USER_DIRECTORY = "target.user.directory";
    private static final String INSTALL_KERNEL_INIT_CODE = "install.kernel.init.code";
    private static final String INSTALL_KERNEL_INIT_ERROR_MESSAGE = "install.kernel.init.error.message";
    private static final String UNINSTALL_USER_FEATURES = "uninstall.user.features";
    private static final String FORCE_UNINSTALL = "force.uninstall";
    private static final String ACTION_INSTALL = "action.install";
    private static final String ACTION_INSTALL_RESULT = "action.install.result";
    private static final String ACTION_UNINSTALL = "action.uninstall";
    private static final String ACTION_RESULT = "action.result";
    private static final String ACTION_ERROR_MESSAGE = "action.error.message";
    private static final String ACTION_EXCEPTION_STACKTRACE = "action.exception.stacktrace";
    private static final String TO_EXTENSION = "to.extension";
    private static final String DIRECTORY_BASED_REPOSITORY = "directory.based.repository";
    private static final String FEATURES_TO_RESOLVE = "features.to.resolve";
    private static final String SINGLE_JSON_FILE = "single.json.file";
    private static final String MESSAGE_LOCALE = "message.locale";
    private static final String INSTALL_INDIVIDUAL_ESAS = "install.individual.esas";
    private static final String INDIVIDUAL_ESAS = "individual.esas";
    private static final String DOWNLOAD_RESULT = "download.result";
    private static final String DOWNLOAD_INDIVIDUAL_ARTIFACT = "download.individual.artifact";
    private static final String DOWNLOAD_FILETYPE = "download.filetype";
    private static final String DOWNLOAD_LOCAL_DIR_LOCATION = "download.local.dir.location";
    private static final String DOWNLOAD_ARTIFACT_SINGLE = "download.artifact.single";
    private static final String DOWNLOAD_ARTIFACT_LIST = "download.artifact.list";
    private static final String DOWNLOAD_LOCATION = "download.location";
    private static final String FROM_REPO = "from.repo";
    private static final String CLEANUP_TEMP_LOCATION = "cleanup.temp.location";
    private static final String CLEANUP_NEEDED = "cleanup.needed";
    private static final String ENVIRONMENT_VARIABLE_MAP = "environment.variable.map";
    private static final String IS_FEATURE_UTILITY = "is.feature.utility";
    private static final String SHORTNAME_HEADER_NAME = "IBM-ShortName";
    private static final String SYMBOLICNAME_HEADER_NAME = "Subsystem-SymbolicName";
    private static final Integer OK = 0;
    private static final Integer CANCELLED = -1;
    private static final Integer ERROR = 1;
    private static final String LICENSE_EPL_PREFIX = "https://www.eclipse.org/legal/epl-";
    private static final String LICENSE_FEATURE_TERMS = "http://www.ibm.com/licenses/wlp-featureterms-v1";
    private static final String LICENSE_FEATURE_TERMS_RESTRICTED = "http://www.ibm.com/licenses/wlp-featureterms-restricted-v1";
    private final String OPEN_LIBERTY_GROUP_ID = "io.openliberty.features";
    private final String JSON_ARTIFACT_ID = "features";
    private final String OPEN_LIBERTY_PRODUCT_ID = "io.openliberty";
    private final String MAVEN_CENTRAL = "https://repo.maven.apache.org/maven2/";
    private final String TEMP_DIRECTORY = Utils.getInstallDir().getAbsolutePath() + File.separator + "tmp" + File.separator;
    private static final String ETC_DIRECTORY = Utils.getInstallDir().getAbsolutePath() + File.separator + "etc" + File.separator;
    private static final String FEATURE_UTILITY_PROPS_FILE = "featureUtility.env";
    private Map<String, String> envMap = null;
    private final Map data = new HashMap();
    private InstallKernelInteractive installKernel;
    private InstallEventListener ielistener;
    private ActionType actionType = null;
    private boolean usingM2Cache = false;
    private String openLibertyVersion = null;
    private final Logger logger = InstallLogUtils.getInstallLogger();
    private final ProgressBar progressBar = ProgressBar.getInstance();
    private final boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;

    public InstallKernelMap() {
        this.data.put(LICENSE_ACCEPT, Boolean.FALSE);
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object key) {
        if (INSTALL_KERNEL_INIT_CODE.equals(key)) {
            return this.initKernel();
        }
        if (ACTION_RESULT.equals(key)) {
            if (this.actionType.equals((Object)ActionType.install)) {
                Boolean localESAInstall = (Boolean)this.data.get(INSTALL_LOCAL_ESA);
                if (localESAInstall == null || !localESAInstall.booleanValue()) {
                    return this.install();
                }
                return this.localESAInstall();
            }
            if (this.actionType.equals((Object)ActionType.uninstall)) {
                return this.uninstall();
            }
            if (this.actionType.equals((Object)ActionType.resolve)) {
                Boolean localESAInstall = (Boolean)this.data.get(INSTALL_LOCAL_ESA);
                if (localESAInstall == null || !localESAInstall.booleanValue()) {
                    return this.data.get(ACTION_RESULT);
                }
                return this.singleFileResolve();
            }
        } else {
            if (IS_FEATURE_UTILITY.equals(key)) {
                if (this.data.get(IS_FEATURE_UTILITY) == null) {
                    return false;
                }
                return (Boolean)this.data.get(IS_FEATURE_UTILITY);
            }
            if (PROGRESS_MONITOR_SIZE.equals(key)) {
                return this.getMonitorSize();
            }
            if (DOWNLOAD_RESULT.equals(key)) {
                Boolean downloadSingleArtifact = (Boolean)this.data.get(DOWNLOAD_INDIVIDUAL_ARTIFACT);
                if (downloadSingleArtifact != null && downloadSingleArtifact.booleanValue()) {
                    return this.downloadArtifact();
                }
                return this.downloadEsas();
            }
            if (ENVIRONMENT_VARIABLE_MAP.equals(key)) {
                this.envMap = this.getEnvMap();
                return this.envMap;
            }
        }
        return this.data.get(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object put(Object key, Object value) {
        if (LICENSE_ACCEPT.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(LICENSE_ACCEPT, value);
            return this.data.get(key);
        } else if (RUNTIME_INSTALL_DIR.equals(key)) {
            if (!(value instanceof File)) throw new IllegalArgumentException();
            this.data.put(RUNTIME_INSTALL_DIR, value);
            return this.data.get(key);
        } else if (LOCAL_ESA_DOWNLOAD_DIR.equals(key)) {
            if (!(value instanceof File)) throw new IllegalArgumentException();
            this.data.put(LOCAL_ESA_DOWNLOAD_DIR, value);
            return this.data.get(key);
        } else if (REPOSITORIES_PROPERTIES.equals(key)) {
            if (!(value instanceof File)) throw new IllegalArgumentException();
            this.data.put(REPOSITORIES_PROPERTIES, value);
            System.setProperty("WLP_REPOSITORIES_PROPS", ((File)value).getAbsolutePath());
            try {
                Properties repoProperties = RepositoryConfigUtils.loadRepoProperties();
                if (repoProperties == null) return this.data.get(key);
                this.installKernel.setRepositoryProperties(repoProperties);
                return this.data.get(key);
            }
            catch (InstallException e) {
                this.data.put(ACTION_RESULT, ERROR);
                this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
                this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
                throw new RuntimeException(e);
            }
        } else if (DOWLOAD_EXTERNAL_DEPS.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(DOWLOAD_EXTERNAL_DEPS, value);
            return this.data.get(key);
        } else if (INSTALL_LOCAL_ESA.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(INSTALL_LOCAL_ESA, value);
            return this.data.get(key);
        } else if (CLEANUP_TEMP_LOCATION.equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put(CLEANUP_TEMP_LOCATION, value);
            return this.data.get(key);
        } else if (CLEANUP_NEEDED.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(CLEANUP_NEEDED, value);
            return this.data.get(key);
        } else if (USER_AGENT.equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put(USER_AGENT, value);
            if (this.installKernel == null) return this.data.get(key);
            this.installKernel.setUserAgent((String)value);
            return this.data.get(key);
        } else if (IS_FEATURE_UTILITY.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(IS_FEATURE_UTILITY, value);
            return this.data.get(key);
        } else if (TO_EXTENSION.equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put(TO_EXTENSION, value);
            return this.data.get(key);
        } else if (DOWNLOAD_FILETYPE.equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put(DOWNLOAD_FILETYPE, value);
            return this.data.get(key);
        } else if (DOWNLOAD_LOCAL_DIR_LOCATION.equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put(DOWNLOAD_LOCAL_DIR_LOCATION, value);
            return this.data.get(key);
        } else if (FROM_REPO.equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put(FROM_REPO, value);
            return this.data.get(key);
        } else if (ENVIRONMENT_VARIABLE_MAP.equals(key)) {
            if (!(value instanceof Map)) throw new IllegalArgumentException();
            this.data.put(ENVIRONMENT_VARIABLE_MAP, value);
            return this.data.get(key);
        } else if (DOWNLOAD_ARTIFACT_SINGLE.equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put(DOWNLOAD_ARTIFACT_SINGLE, value);
            return this.data.get(key);
        } else if (DOWNLOAD_ARTIFACT_LIST.equals(key)) {
            if (!(value instanceof List) && !(value instanceof String)) throw new IllegalArgumentException();
            this.data.put(DOWNLOAD_ARTIFACT_LIST, value);
            return this.data.get(key);
        } else if (DOWNLOAD_INDIVIDUAL_ARTIFACT.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(DOWNLOAD_INDIVIDUAL_ARTIFACT, value);
            return this.data.get(key);
        } else if (DOWNLOAD_LOCATION.equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put(DOWNLOAD_LOCATION, value);
            return this.data.get(key);
        } else if (TARGET_USER_DIRECTORY.equals(key)) {
            if (!(value instanceof File)) throw new IllegalArgumentException();
            this.data.put(TARGET_USER_DIRECTORY, value);
            Utils.setUserDir((File)((File)value));
            return this.data.get(key);
        } else if (MESSAGE_LOCALE.equals(key)) {
            if (!(value instanceof Locale)) throw new IllegalArgumentException();
            this.data.put(MESSAGE_LOCALE, value);
            InstallLogUtils.Messages.setLocale((Locale)value);
            return this.data.get(key);
        } else if (PROGRESS_MONITOR_MESSAGE.equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            this.data.put(PROGRESS_MONITOR_MESSAGE, value);
            return this.data.get(key);
        } else if (PROGRESS_MONITOR_CANCELLED.equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            this.data.put(PROGRESS_MONITOR_CANCELLED, value);
            return this.data.get(key);
        } else if (ACTION_INSTALL.equals(key)) {
            if (!(value instanceof List) && !(value instanceof File)) throw new IllegalArgumentException();
            Boolean localESAInstall = (Boolean)this.data.get(INSTALL_LOCAL_ESA);
            if (localESAInstall == null || !localESAInstall.booleanValue()) {
                this.resolve(value);
                return this.data.get(key);
            } else {
                this.data.put(ACTION_INSTALL, value);
            }
            return this.data.get(key);
        } else if (UNINSTALL_USER_FEATURES.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(UNINSTALL_USER_FEATURES, value);
            return this.data.get(key);
        } else if (FORCE_UNINSTALL.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(FORCE_UNINSTALL, value);
            return this.data.get(key);
        } else if (ACTION_UNINSTALL.equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            this.data.put(ACTION_UNINSTALL, value);
            this.actionType = ActionType.uninstall;
            return this.data.get(key);
        } else if (FEATURES_TO_RESOLVE.equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            Boolean localESAInstall = (Boolean)this.data.get(INSTALL_LOCAL_ESA);
            if (localESAInstall == null || !localESAInstall.booleanValue()) throw new IllegalArgumentException();
            if ((List)this.data.get(SINGLE_JSON_FILE) == null) throw new IllegalArgumentException();
            this.actionType = ActionType.resolve;
            this.data.put(FEATURES_TO_RESOLVE, value);
            return this.data.get(key);
        } else if (SINGLE_JSON_FILE.equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            Boolean localESAInstall = (Boolean)this.data.get(INSTALL_LOCAL_ESA);
            if (localESAInstall == null || !localESAInstall.booleanValue()) throw new IllegalArgumentException();
            this.data.put(SINGLE_JSON_FILE, value);
            return this.data.get(key);
        } else if (DIRECTORY_BASED_REPOSITORY.equals(key)) {
            if (!(value instanceof File)) return this.data.get(key);
            this.data.put(DIRECTORY_BASED_REPOSITORY, value);
            return this.data.get(key);
        } else if (INDIVIDUAL_ESAS.equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            this.data.put(INDIVIDUAL_ESAS, value);
            return this.data.get(key);
        } else if (INSTALL_INDIVIDUAL_ESAS.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(INSTALL_INDIVIDUAL_ESAS, value);
            return this.data.get(key);
        } else {
            if (!key.equals("debug")) return this.data.get(key);
            if (!(value instanceof Level)) throw new IllegalArgumentException();
            this.data.put("debug", value);
            ((InstallKernelImpl)this.installKernel).enableConsoleLog((Level)value);
        }
        return this.data.get(key);
    }

    private InstallEventListener getListener() {
        if (this.ielistener == null) {
            this.ielistener = new InstallEventListener(){

                @Override
                public void handleInstallEvent(InstallProgressEvent event) throws Exception {
                    if (InstallKernelMap.this.actionType != null) {
                        List messages;
                        if (InstallKernelMap.this.actionType.equals((Object)ActionType.install)) {
                            List messages2 = (List)InstallKernelMap.this.data.get(InstallKernelMap.PROGRESS_MONITOR_MESSAGE);
                            if (messages2 != null) {
                                messages2.add(event.message);
                                List cancelledList = (List)InstallKernelMap.this.data.get(InstallKernelMap.PROGRESS_MONITOR_CANCELLED);
                                if (((Boolean)cancelledList.get(0)).booleanValue()) {
                                    throw new CancelException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("MSG_CANCEL_INSTALL", new Object[0]), CANCELLED);
                                }
                            }
                        } else if (InstallKernelMap.this.actionType.equals((Object)ActionType.uninstall) && event.state == 255 && (messages = (List)InstallKernelMap.this.data.get(InstallKernelMap.PROGRESS_MONITOR_MESSAGE)) != null) {
                            messages.add(event.message);
                        }
                    }
                }
            };
        }
        return this.ielistener;
    }

    private Integer initKernel() {
        File installDir = (File)this.data.get(RUNTIME_INSTALL_DIR);
        Utils.setInstallDir((File)installDir);
        this.installKernel = InstallKernelFactory.getInteractiveInstance();
        String userAgent = (String)this.data.get(USER_AGENT);
        this.installKernel.setUserAgent(userAgent != null && !userAgent.isEmpty() ? userAgent : MAP_BASED_INSTALL_KERNEL);
        this.installKernel.setFirePublicAssetOnly(false);
        this.installKernel.addListener(this.getListener(), "PROGRESS");
        this.data.put(INSTALL_KERNEL_INIT_ERROR_MESSAGE, null);
        return OK;
    }

    private void resolve(Object installObject) {
        this.data.put(ACTION_INSTALL, null);
        this.data.put(ACTION_RESULT, OK);
        this.data.put(ACTION_INSTALL_RESULT, null);
        this.data.put(ACTION_ERROR_MESSAGE, null);
        this.data.put(ACTION_EXCEPTION_STACKTRACE, null);
        this.actionType = ActionType.resolve;
        if (installObject instanceof List) {
            List assets = (List)installObject;
            try {
                this.installKernel.resolve(assets, false);
                this.checkLicense();
                this.actionType = ActionType.install;
                this.data.put(ACTION_INSTALL, installObject);
            }
            catch (InstallException e) {
                this.data.put(ACTION_RESULT, ERROR);
                this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
                this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
            }
        } else if (installObject instanceof File) {
            File esaFile = (File)installObject;
            boolean isESA = ArchiveUtils.ArchiveFileType.ESA.isType(esaFile.getName());
            if (isESA) {
                try {
                    String feature = InstallUtils.getFeatureName(esaFile);
                    this.installKernel.resolve(feature, esaFile, "usr");
                    this.checkLicense();
                    this.actionType = ActionType.install;
                    this.data.put(ACTION_INSTALL, installObject);
                }
                catch (InstallException e) {
                    this.data.put(ACTION_RESULT, ERROR);
                    this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
                    this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
                }
            } else {
                this.data.put(ACTION_RESULT, ERROR);
                this.data.put(ACTION_ERROR_MESSAGE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MAPBASED_ERROR_UNSUPPORTED_FILE", esaFile.getAbsoluteFile()));
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static boolean containsIgnoreCase(Collection<String> featureToInstall, String existingFeature) {
        for (String current : featureToInstall) {
            if (!current.equalsIgnoreCase(existingFeature)) continue;
            return true;
        }
        return false;
    }

    public Collection<String> singleFileResolve() {
        this.data.put(ACTION_INSTALL, null);
        this.data.put(ACTION_RESULT, OK);
        this.data.put(ACTION_INSTALL_RESULT, null);
        this.data.put(ACTION_ERROR_MESSAGE, null);
        this.data.put(ACTION_EXCEPTION_STACKTRACE, null);
        HashSet<ProductInfoProductDefinition> productDefinitions = new HashSet<ProductInfoProductDefinition>();
        Collection resolveResult = null;
        RepositoryResolver resolver = null;
        Collection<String> featuresResolved = new ArrayList<String>();
        boolean isOpenLiberty = false;
        try {
            for (ProductInfo productInfo : ProductInfo.getAllProductInfo().values()) {
                productDefinitions.add(new ProductInfoProductDefinition(productInfo));
                if (productInfo.getReplacedBy() != null || !productInfo.getId().equals("io.openliberty")) continue;
                isOpenLiberty = true;
            }
            RepositoryConnectionList repoList = new RepositoryConnectionList();
            List singleJsonRepos = (List)this.data.get(SINGLE_JSON_FILE);
            File directoryBasedRepo = (File)this.data.get(DIRECTORY_BASED_REPOSITORY);
            if (directoryBasedRepo != null) {
                DirectoryRepositoryConnection directRepo = new DirectoryRepositoryConnection(directoryBasedRepo);
                repoList.add((RepositoryConnection)directRepo);
            }
            for (File jsonRepo : singleJsonRepos) {
                SingleFileRepositoryConnection repo = new SingleFileRepositoryConnection(jsonRepo);
                repoList.add((RepositoryConnection)repo);
            }
            ManifestFileProcessor m_ManifestFileProcessor = new ManifestFileProcessor();
            Collection installedFeatures = m_ManifestFileProcessor.getFeatureDefinitions().values();
            int alreadyInstalled = 0;
            Collection featureToInstall = (Collection)this.data.get(FEATURES_TO_RESOLVE);
            try {
                if (this.data.get(INSTALL_INDIVIDUAL_ESAS).equals(Boolean.TRUE)) {
                    Path tempDir = Files.createTempDirectory("generatedJson", new FileAttribute[0]);
                    tempDir.toFile().deleteOnExit();
                    HashMap<String, String> shortNameMap = new HashMap<String, String>();
                    File individualEsaJson = this.generateJsonFromIndividualESAs(tempDir, shortNameMap);
                    SingleFileRepositoryConnection repo = new SingleFileRepositoryConnection(individualEsaJson);
                    repoList.add((RepositoryConnection)repo);
                    ArrayList<String> shortNamesToInstall = new ArrayList<String>();
                    Iterator it = featureToInstall.iterator();
                    while (it.hasNext()) {
                        String feature = (String)it.next();
                        if (!feature.endsWith(".esa") || !shortNameMap.containsKey(feature)) continue;
                        it.remove();
                        shortNamesToInstall.add((String)shortNameMap.get(feature));
                    }
                    featureToInstall.addAll(shortNamesToInstall);
                }
            }
            catch (NullPointerException e) {
                this.data.put(ACTION_RESULT, ERROR);
                this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
                this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
            }
            ArrayList<String> featuresAlreadyPresent = new ArrayList<String>();
            for (ProvisioningFeatureDefinition feature : installedFeatures) {
                if (!InstallKernelMap.containsIgnoreCase(featureToInstall, feature.getIbmShortName()) && !featureToInstall.contains(feature.getFeatureName())) continue;
                ++alreadyInstalled;
                if (feature.getIbmShortName() == null) {
                    featuresAlreadyPresent.add(feature.getFeatureName());
                    continue;
                }
                featuresAlreadyPresent.add(feature.getIbmShortName());
            }
            if (alreadyInstalled == featureToInstall.size()) {
                throw ExceptionUtils.createByKey(22, "ASSETS_ALREADY_INSTALLED", featuresAlreadyPresent);
            }
            resolver = new RepositoryResolver(productDefinitions, installedFeatures, Collections.emptySet(), repoList);
            resolveResult = resolver.resolveAsSet((Collection)this.data.get(FEATURES_TO_RESOLVE));
            ResolveDirector.resolveAutoFeatures(resolveResult, new RepositoryResolver(productDefinitions, installedFeatures, Collections.emptySet(), repoList));
            if (!resolveResult.isEmpty()) {
                for (List item : resolveResult) {
                    for (RepositoryResource repoResrc : item) {
                        String license = repoResrc.getLicenseId();
                        if (license != null) {
                            Boolean accepted;
                            boolean autoAcceptLicense;
                            boolean isNDRuntime = false;
                            for (ProductInfo productInfo : ProductInfo.getAllProductInfo().values()) {
                                if (!"com.ibm.websphere.appserver".equals(productInfo.getId()) || !"ND".equals(productInfo.getEdition())) continue;
                                isNDRuntime = true;
                                break;
                            }
                            boolean bl = autoAcceptLicense = license.startsWith(LICENSE_EPL_PREFIX) || license.equals(LICENSE_FEATURE_TERMS) || isNDRuntime && license.equals(LICENSE_FEATURE_TERMS_RESTRICTED);
                            if (!(autoAcceptLicense || (accepted = (Boolean)this.data.get(LICENSE_ACCEPT)) != null && accepted.booleanValue())) {
                                featuresResolved.clear();
                                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_LICENSES_NOT_ACCEPTED", new Object[0]));
                            }
                        }
                        if (repoResrc.getRepositoryConnection() instanceof DirectoryRepositoryConnection) {
                            featuresResolved.add(repoResrc.getId());
                            continue;
                        }
                        featuresResolved.add(repoResrc.getMavenCoordinates());
                    }
                }
            }
            this.actionType = ActionType.install;
            featuresResolved = InstallKernelMap.keepFirstInstance(featuresResolved);
            return featuresResolved;
        }
        catch (ProductInfoParseException e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString((Exception)((Object)e)));
        }
        catch (DuplicateProductInfoException e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString((Exception)((Object)e)));
        }
        catch (ProductInfoReplaceException e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString((Exception)((Object)e)));
        }
        catch (RepositoryResolutionException e) {
            boolean isFeatureUtility = (Boolean)this.get(IS_FEATURE_UTILITY);
            this.data.put(ACTION_RESULT, ERROR);
            InstallException ie = ExceptionUtils.create(e, (Collection<String>)e.getTopLevelFeaturesNotResolved(), (File)this.data.get(RUNTIME_INSTALL_DIR), false, isOpenLiberty, isFeatureUtility);
            this.data.put(ACTION_ERROR_MESSAGE, ie.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(ie));
        }
        catch (InstallException e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
        }
        catch (RepositoryException e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString((Exception)((Object)e)));
        }
        catch (Exception e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
        }
        this.actionType = ActionType.install;
        return featuresResolved;
    }

    private static Collection<String> keepFirstInstance(Collection<String> dupStrCollection) {
        ArrayList<String> uniqueStrCollection = new ArrayList<String>();
        for (String str : dupStrCollection) {
            if (uniqueStrCollection.contains(str)) continue;
            uniqueStrCollection.add(str);
        }
        return uniqueStrCollection;
    }

    private void checkLicense() throws InstallException {
        Boolean accepted;
        Set<InstallLicense> licenses = this.installKernel.getFeatureLicense(Locale.getDefault());
        if (!(licenses.isEmpty() || (accepted = (Boolean)this.data.get(LICENSE_ACCEPT)) != null && accepted.booleanValue())) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_LICENSES_NOT_ACCEPTED", new Object[0]));
        }
    }

    private Integer getMonitorSize() {
        if (this.actionType != null) {
            if (this.actionType.equals((Object)ActionType.install)) {
                int numInstallResources = this.installKernel.getInstallResourcesSize();
                int numInstallAssets = this.installKernel.getLocalInstallAssetsSize();
                return numInstallResources * 2 + numInstallAssets + 1;
            }
            if (this.actionType.equals((Object)ActionType.uninstall)) {
                return 1;
            }
        }
        return 0;
    }

    public Integer install() {
        this.data.put(ACTION_RESULT, OK);
        this.data.put(ACTION_INSTALL_RESULT, null);
        this.data.put(ACTION_ERROR_MESSAGE, null);
        this.data.put(ACTION_EXCEPTION_STACKTRACE, null);
        try {
            this.installKernel.checkResources();
            Boolean agreedToDownloadDependencies = (Boolean)this.data.get(DOWLOAD_EXTERNAL_DEPS);
            if (agreedToDownloadDependencies == null) {
                agreedToDownloadDependencies = Boolean.TRUE;
            }
            Map<String, Collection<String>> installedAssets = this.installKernel.install("usr", true, agreedToDownloadDependencies);
            this.data.put(ACTION_INSTALL_RESULT, installedAssets);
        }
        catch (CancelException e) {
            this.data.put(ACTION_RESULT, CANCELLED);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
            return CANCELLED;
        }
        catch (InstallException e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
            return ERROR;
        }
        return OK;
    }

    public List<File> downloadFeatures(List<String> featureList) {
        String downloadDir;
        this.data.put(ACTION_ERROR_MESSAGE, null);
        this.data.put(ACTION_EXCEPTION_STACKTRACE, null);
        ArtifactDownloader artifactDownloader = new ArtifactDownloader();
        String fromRepo = (String)this.data.get(FROM_REPO);
        Boolean cleanupNeeded = (Boolean)this.data.get(CLEANUP_NEEDED);
        if (cleanupNeeded != null && cleanupNeeded.booleanValue()) {
            this.fine("Using temp location: " + this.TEMP_DIRECTORY);
            this.data.put(CLEANUP_TEMP_LOCATION, this.TEMP_DIRECTORY);
            downloadDir = this.TEMP_DIRECTORY;
        } else {
            downloadDir = this.getDownloadDir((String)this.data.get(DOWNLOAD_LOCATION));
        }
        String repo = this.getRepo(fromRepo);
        try {
            artifactDownloader.setEnvMap(this.envMap);
            artifactDownloader.synthesizeAndDownloadFeatures(featureList, downloadDir, repo);
        }
        catch (InstallException e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
            return null;
        }
        return artifactDownloader.getDownloadedEsas();
    }

    public List<File> downloadArtifact() {
        String downloadDir;
        this.data.put(ACTION_ERROR_MESSAGE, null);
        this.data.put(ACTION_EXCEPTION_STACKTRACE, null);
        ArtifactDownloader artifactDownloader = new ArtifactDownloader();
        Boolean cleanupNeeded = (Boolean)this.data.get(CLEANUP_NEEDED);
        if (cleanupNeeded != null && cleanupNeeded.booleanValue()) {
            this.fine("Using temp location: " + this.TEMP_DIRECTORY);
            this.data.put(CLEANUP_TEMP_LOCATION, this.TEMP_DIRECTORY);
            downloadDir = this.TEMP_DIRECTORY;
        } else {
            downloadDir = this.getDownloadDir((String)this.data.get(DOWNLOAD_LOCATION));
        }
        String feature = (String)this.get(DOWNLOAD_ARTIFACT_SINGLE);
        String filetype = (String)this.get(DOWNLOAD_FILETYPE);
        String repo = this.getRepo(null);
        try {
            artifactDownloader.setEnvMap(this.envMap);
            artifactDownloader.synthesizeAndDownload(feature, filetype, downloadDir, repo, true);
        }
        catch (InstallException e) {
            this.put(ACTION_RESULT, ERROR);
            this.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
            return null;
        }
        return artifactDownloader.getDownloadedFiles();
    }

    private String getDownloadDir(String fromDir) {
        String result;
        if (fromDir != null) {
            result = fromDir;
        } else {
            fromDir = this.getM2Cache();
            if (fromDir != null) {
                this.usingM2Cache = true;
                result = this.getM2Cache();
            } else if (this.checkM2Writable()) {
                File newM2 = new File(this.getM2Path().toString());
                result = newM2.toString();
            } else {
                this.fine("Using temp location: " + this.TEMP_DIRECTORY);
                this.data.put(CLEANUP_TEMP_LOCATION, this.TEMP_DIRECTORY);
                this.data.put(CLEANUP_NEEDED, true);
                result = this.TEMP_DIRECTORY;
            }
        }
        return result;
    }

    private String getM2Cache() {
        Path m2Path = this.getM2Path();
        if (Files.exists(m2Path, new LinkOption[0]) && Files.isWritable(m2Path)) {
            return m2Path.toString();
        }
        return null;
    }

    private Path getM2Path() {
        return Paths.get(System.getProperty("user.home"), ".m2", "repository", "");
    }

    private boolean checkM2Writable() {
        String userhome = System.getProperty("user.home");
        Path userhomePath = Paths.get(userhome, new String[0]);
        if (!Files.exists(userhomePath, new LinkOption[0]) || !Files.isWritable(userhomePath)) {
            return false;
        }
        Path withM2 = Paths.get(userhome, "/.m2");
        Path withRepository = Paths.get(userhome, "/.m2/repository");
        if (Files.exists(withM2, new LinkOption[0])) {
            if (Files.exists(withRepository, new LinkOption[0])) {
                return Files.isWritable(withRepository);
            }
            return withRepository.toFile().mkdir();
        }
        if (withM2.toFile().mkdir()) {
            return this.checkM2Writable();
        }
        return false;
    }

    private String getRepo(String fromRepo) {
        String repo;
        if (this.envMap.get("FEATURE_REPO_URL") != null) {
            this.fine("Connecting to the following repository: " + this.envMap.get("FEATURE_REPO_URL"));
            repo = this.envMap.get("FEATURE_REPO_URL");
        } else {
            this.fine("Connecting to the following repository: https://repo.maven.apache.org/maven2/");
            repo = "https://repo.maven.apache.org/maven2/";
        }
        return repo;
    }

    public File downloadSingleFeature() {
        String downloadDir;
        this.data.put(ACTION_ERROR_MESSAGE, null);
        this.data.put(ACTION_EXCEPTION_STACKTRACE, null);
        ArtifactDownloader artifactDownloader = new ArtifactDownloader();
        String featureList = (String)this.data.get(DOWNLOAD_ARTIFACT_LIST);
        String filetype = (String)this.data.get(DOWNLOAD_FILETYPE);
        String fromRepo = (String)this.data.get(FROM_REPO);
        Boolean cleanupNeeded = (Boolean)this.data.get(CLEANUP_NEEDED);
        if (cleanupNeeded != null && cleanupNeeded.booleanValue()) {
            this.fine("Using temp location: " + this.TEMP_DIRECTORY);
            this.data.put(CLEANUP_TEMP_LOCATION, this.TEMP_DIRECTORY);
            downloadDir = this.TEMP_DIRECTORY;
        } else {
            downloadDir = this.getDownloadDir((String)this.data.get(DOWNLOAD_LOCATION));
        }
        String repo = this.getRepo(fromRepo);
        try {
            artifactDownloader.setEnvMap(this.envMap);
            artifactDownloader.synthesizeAndDownload(featureList, filetype, downloadDir, repo, true);
        }
        catch (InstallException e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
            return null;
        }
        return artifactDownloader.getDownloadedFiles().get(0);
    }

    public Integer localESAInstall() {
        this.data.put(ACTION_RESULT, OK);
        this.data.put(ACTION_INSTALL_RESULT, null);
        this.data.put(ACTION_ERROR_MESSAGE, null);
        this.data.put(ACTION_EXCEPTION_STACKTRACE, null);
        try {
            InstallKernelImpl installKernel = (InstallKernelImpl)this.installKernel;
            File esaFile = (File)this.data.get(ACTION_INSTALL);
            String toExtension = (String)this.data.get(TO_EXTENSION);
            if (toExtension == null) {
                toExtension = "usr";
            }
            Collection<String> installedAssets = installKernel.installLocalFeatureNoResolve(esaFile.getAbsolutePath(), toExtension, true, InstallConstants.ExistsAction.replace);
            this.data.put(ACTION_INSTALL_RESULT, installedAssets);
        }
        catch (InstallException e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
            return ERROR;
        }
        return OK;
    }

    private Integer uninstall() {
        ArrayList<String> uninstallFeatures = this.data.containsKey(ACTION_UNINSTALL) ? new ArrayList<String>((Collection)this.data.get(ACTION_UNINSTALL)) : new ArrayList();
        this.data.put(ACTION_ERROR_MESSAGE, null);
        try {
            Boolean allowUninstallUserFeatures;
            InstallKernel installKernel = (InstallKernel)((Object)this.installKernel);
            Boolean forceUninstall = this.data.containsKey(FORCE_UNINSTALL) ? (Boolean)this.data.get(FORCE_UNINSTALL) : Boolean.FALSE;
            Boolean bl = allowUninstallUserFeatures = this.data.containsKey(UNINSTALL_USER_FEATURES) ? (Boolean)this.data.get(UNINSTALL_USER_FEATURES) : Boolean.FALSE;
            if (forceUninstall.booleanValue()) {
                if (uninstallFeatures.size() > 1) {
                    this.data.put(ACTION_ERROR_MESSAGE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INVALID_NUMBER_OF_FEATURES_FORCE_UNINSTALL", new Object[0]));
                    return ERROR;
                }
                installKernel.uninstallFeaturePrereqChecking((String)uninstallFeatures.get(0), allowUninstallUserFeatures, forceUninstall);
                installKernel.uninstallFeature((String)uninstallFeatures.get(0), forceUninstall);
            } else {
                if (allowUninstallUserFeatures != null && allowUninstallUserFeatures.booleanValue()) {
                    installKernel.uninstallFeaturePrereqChecking(uninstallFeatures);
                } else {
                    installKernel.uninstallCoreFeaturePrereqChecking(uninstallFeatures);
                }
                installKernel.uninstallFeature(uninstallFeatures);
            }
        }
        catch (InstallException e) {
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
            return ERROR;
        }
        return OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateFeatureNameFromManifest(File esa, Map<String, String> shortNameMap) throws IOException {
        String esaLocation = esa.getCanonicalPath();
        try (ZipFile zip = null;){
            zip = new ZipFile(esaLocation);
            Enumeration<? extends ZipEntry> zipEntries = zip.entries();
            ZipEntry subsystemEntry = null;
            while (zipEntries.hasMoreElements()) {
                ZipEntry nextEntry = zipEntries.nextElement();
                if (!"OSGI-INF/SUBSYSTEM.MF".equalsIgnoreCase(nextEntry.getName())) continue;
                subsystemEntry = nextEntry;
                break;
            }
            if (subsystemEntry != null) {
                Manifest m = ManifestProcessor.parseManifest((InputStream)zip.getInputStream(subsystemEntry));
                Attributes manifestAttrs = m.getMainAttributes();
                String featureName = manifestAttrs.getValue(SHORTNAME_HEADER_NAME);
                if (featureName == null) {
                    featureName = manifestAttrs.getValue(SYMBOLICNAME_HEADER_NAME).split(";")[0];
                }
                shortNameMap.put(esa.getCanonicalPath(), featureName);
            }
        }
    }

    private File generateJsonFromIndividualESAs(Path jsonDirectory, Map<String, String> shortNameMap) throws IOException, RepositoryException, InstallException {
        String dir = jsonDirectory.toString();
        List esas = (List)this.data.get(INDIVIDUAL_ESAS);
        File singleJson = new File(dir + "/SingleJson.json");
        for (File esa : esas) {
            try {
                InstallKernelMap.populateFeatureNameFromManifest(esa, shortNameMap);
            }
            catch (IOException e) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_ESA_NOT_FOUND", esa.getAbsolutePath()));
            }
            SingleFileRepositoryConnection mySingleFileRepo = null;
            if (singleJson.exists()) {
                mySingleFileRepo = new SingleFileRepositoryConnection(singleJson);
            } else {
                try {
                    mySingleFileRepo = SingleFileRepositoryConnection.createEmptyRepository((File)singleJson);
                }
                catch (IOException e) {
                    throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_SINGLE_REPO_CONNECTION_FAILED", dir, esa.getAbsolutePath()));
                }
            }
            EsaParser parser = new EsaParser(true);
            RepositoryResourceWritable resource = parser.parseFileToResource(esa, null, null);
            resource.updateGeneratedFields(true);
            resource.setRepositoryConnection((RepositoryConnection)mySingleFileRepo);
            resource.setMavenCoordinates(esa.getAbsolutePath());
            resource.uploadToMassive((UploadStrategy)new AddThenDeleteStrategy());
        }
        return singleJson;
    }

    private Collection<File> downloadEsas() {
        String fromRepo = this.getDownloadDir((String)this.data.get(FROM_REPO));
        File rootDir = new File(fromRepo);
        List resolvedFeatures = (List)this.data.get(DOWNLOAD_ARTIFACT_LIST);
        String openLibertyVersion = this.getLibertyVersion();
        Map<String, List> artifactsMap = this.fetchArtifactsFromLocalRepository(rootDir, resolvedFeatures, openLibertyVersion, ".esa");
        List foundFeatures = artifactsMap.get("foundArtifacts");
        List missingFeatures = artifactsMap.get("missingArtifacts");
        if (foundFeatures.size() != resolvedFeatures.size() && !missingFeatures.isEmpty()) {
            List missingFeatureIndexes = artifactsMap.get("missingArtifactIndexes");
            List<File> downloadedFeatures = this.downloadFeatures(missingFeatures);
            if (downloadedFeatures == null) {
                return null;
            }
            this.insertElementsIntoList(foundFeatures, downloadedFeatures, missingFeatureIndexes);
            double increment = this.progressBar.getMethodIncrement("fetchArtifacts") / (double)resolvedFeatures.size() * (double)downloadedFeatures.size();
            this.updateProgress(increment);
            this.fine("Downloaded the following features from the remote maven repository:" + downloadedFeatures);
        }
        return foundFeatures;
    }

    private Map<String, List> fetchArtifactsFromLocalRepository(File rootDir, Collection<String> artifacts, String openLibertyVersion, String extension) {
        ArrayList<String> artifactsClone = new ArrayList<String>(artifacts);
        ArrayList<File> foundArtifacts = new ArrayList<File>();
        ArrayList<Integer> missingArtifactIndexes = new ArrayList<Integer>();
        int index = 0;
        double increment = this.progressBar.getMethodIncrement("fetchArtifacts") / (double)artifacts.size();
        for (String feature : artifacts) {
            this.fine("Processing feature: " + feature);
            String groupId = feature.split(":")[0];
            String featureName = feature.split(":")[1];
            File groupDir = new File(rootDir, groupId.replace(".", "/"));
            if (!groupDir.exists()) {
                missingArtifactIndexes.add(index);
                continue;
            }
            String featureEsa = featureName + "-" + openLibertyVersion + extension;
            Path featurePath = Paths.get(groupDir.getAbsolutePath().toString(), featureName, openLibertyVersion, featureEsa);
            if (Files.isRegularFile(featurePath, new LinkOption[0])) {
                foundArtifacts.add(featurePath.toFile());
                artifactsClone.remove(feature);
                this.updateProgress(increment);
                this.fine("Found feature at path: " + featurePath.toString());
            } else {
                missingArtifactIndexes.add(index);
            }
            ++index;
        }
        HashMap<String, List> artifactsMap = new HashMap<String, List>();
        artifactsMap.put("foundArtifacts", foundArtifacts);
        artifactsMap.put("missingArtifacts", artifactsClone);
        artifactsMap.put("missingArtifactIndexes", missingArtifactIndexes);
        return artifactsMap;
    }

    private <T> void insertElementsIntoList(List<T> target, List<T> elements, List<Integer> indexes) {
        int index = 0;
        for (T obj : elements) {
            target.add(indexes.get(index), obj);
            ++index;
        }
    }

    private String getLibertyVersion() {
        if (this.openLibertyVersion != null) {
            return this.openLibertyVersion;
        }
        File propertiesFile = new File(Utils.getInstallDir(), "lib/versions/openliberty.properties");
        String openLibertyVersion = null;
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(propertiesFile);){
            properties.load(input);
            String productId = properties.getProperty("com.ibm.websphere.productId");
            String productVersion = properties.getProperty("com.ibm.websphere.productVersion");
            if (productId.equals("io.openliberty")) {
                openLibertyVersion = productVersion;
            }
        }
        catch (IOException e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
        }
        if (openLibertyVersion == null) {
            InstallException ie = new InstallException("Could not determine the open liberty runtime version.");
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, ie.getMessage());
            this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(ie));
        }
        this.openLibertyVersion = openLibertyVersion;
        return openLibertyVersion;
    }

    public List<File> getLocalJsonFiles(Set<String> jsonsRequired) throws InstallException {
        String fromRepo = this.getDownloadDir((String)this.data.get(DOWNLOAD_LOCATION));
        File fromDir = new File(fromRepo);
        String openLibertyVersion = this.getLibertyVersion();
        String artifactId = "features";
        ArrayList<File> jsons = new ArrayList<File>();
        for (String json : jsonsRequired) {
            String mavenCoordinateDirectory = json.replace(".", "/") + "/" + artifactId + "/" + openLibertyVersion + "/";
            String jsonFilePath = mavenCoordinateDirectory + "features-" + openLibertyVersion + ".json";
            File openLibertyJson = new File(fromDir, jsonFilePath);
            if (!openLibertyJson.exists()) continue;
            jsons.add(openLibertyJson);
        }
        return jsons;
    }

    public List<File> getJsonsFromMavenCentral(Set<String> jsonsRequired) throws InstallException {
        String openLibertyVersion = this.getLibertyVersion();
        ArrayList<File> result = new ArrayList<File>();
        this.put(DOWNLOAD_FILETYPE, "json");
        boolean singleArtifactInstall = true;
        this.put(DOWNLOAD_INDIVIDUAL_ARTIFACT, (Object)singleArtifactInstall);
        String artifactId = "features";
        for (String jsonGroupId : jsonsRequired) {
            String jsonCoord = jsonGroupId + ":" + artifactId + ":" + openLibertyVersion;
            this.put(DOWNLOAD_ARTIFACT_SINGLE, jsonCoord);
            this.put(DOWNLOAD_ARTIFACT_LIST, jsonCoord);
            Object downloaded = this.get(DOWNLOAD_RESULT);
            if (this.get(ACTION_ERROR_MESSAGE) != null) {
                this.fine("action.exception.stacktrace: " + this.get("action.error.stacktrace"));
                String exceptionMessage = (String)this.get(ACTION_ERROR_MESSAGE);
                throw new InstallException(exceptionMessage);
            }
            if (downloaded instanceof List) {
                result.addAll((List)downloaded);
                continue;
            }
            if (!(downloaded instanceof File)) continue;
            result.add((File)downloaded);
        }
        this.fine("Downloaded the following json files from remote: " + result);
        return result;
    }

    private Map<String, String> getEnvMap() {
        String proxyEnvVarHttps;
        HashMap<String, String> envMapRet = new HashMap<String, String>();
        String proxyEnvVarHttp = System.getenv("http_proxy");
        if (proxyEnvVarHttp != null) {
            Map<String, String> httpProxyVariables;
            try {
                httpProxyVariables = this.getProxyVariables(proxyEnvVarHttp, "http");
            }
            catch (InstallException e) {
                this.data.put(ACTION_RESULT, ERROR);
                this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
                this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
                return null;
            }
            Set<String> httpProxyVarKeys = httpProxyVariables.keySet();
            for (String key : httpProxyVarKeys) {
                envMapRet.put(key, httpProxyVariables.get(key));
            }
        }
        if ((proxyEnvVarHttps = System.getenv("https_proxy")) != null) {
            Map<String, String> httpsProxyVariables;
            try {
                httpsProxyVariables = this.getProxyVariables(proxyEnvVarHttps, "https");
            }
            catch (InstallException e) {
                this.data.put(ACTION_RESULT, ERROR);
                this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
                this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
                return null;
            }
            Set<String> httpsProxyVarKeys = httpsProxyVariables.keySet();
            for (String key : httpsProxyVarKeys) {
                envMapRet.put(key, httpsProxyVariables.get(key));
            }
        }
        envMapRet.put("FEATURE_REPO_URL", System.getenv("FEATURE_REPO_URL"));
        envMapRet.put("FEATURE_REPO_USER", System.getenv("FEATURE_REPO_USER"));
        envMapRet.put("FEATURE_REPO_PASSWORD", System.getenv("FEATURE_REPO_PASSWORD"));
        envMapRet.put("FEATURE_LOCAL_REPO", System.getenv("FEATURE_LOCAL_REPO"));
        Map<String, String> propsFileMap = this.getFeatureUtilEnvProps();
        if (!propsFileMap.isEmpty()) {
            this.fine("The properties found in featureUtility.env will override latent environment variables of the same name");
            this.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_READING_ENV_PROPS_FILE", Utils.getInstallDir().toString()));
            Set<String> keys = propsFileMap.keySet();
            for (String key : keys) {
                if (key.equals("http_proxy") || key.equals("https_proxy")) {
                    Map<String, String> proxyVar;
                    try {
                        proxyVar = this.getProxyVariables(propsFileMap.get(key), key.split("_")[0]);
                    }
                    catch (InstallException e) {
                        this.data.put(ACTION_RESULT, ERROR);
                        this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
                        this.data.put(ACTION_EXCEPTION_STACKTRACE, ExceptionUtils.stacktraceToString(e));
                        return null;
                    }
                    Set<String> proxyVarKeys = proxyVar.keySet();
                    for (String k : proxyVarKeys) {
                        envMapRet.put(k, proxyVar.get(k));
                    }
                    continue;
                }
                envMapRet.put(key, propsFileMap.get(key));
            }
        }
        return envMapRet;
    }

    private Map<String, String> getProxyVariables(String proxyEnvVar, String protocol) throws InstallException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (protocol.equals("https")) {
            String[] proxyEnvVarSplit = proxyEnvVar.split("@");
            if (proxyEnvVarSplit.length != 2) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_IMPROPER_HTTPSPROXY_FORMAT", proxyEnvVar));
            }
            String[] proxyCredentials = proxyEnvVarSplit[0].split(":");
            if (proxyCredentials.length != 3) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_IMPROPER_HTTPSPROXY_FORMAT", proxyEnvVar));
            }
            String[] proxyHostPort = proxyEnvVarSplit[1].split(":");
            if (proxyHostPort.length != 2) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_IMPROPER_HTTPSPROXY_FORMAT", proxyEnvVar));
            }
            result.put(protocol + ".proxyHost", proxyHostPort[0]);
            result.put(protocol + ".proxyPort", proxyHostPort[1]);
            result.put(protocol + ".proxyUser", proxyCredentials[1].replace("/", ""));
            result.put(protocol + ".proxyPassword", proxyCredentials[2]);
        } else if (protocol.equals("http")) {
            String[] proxyHttpSplit = proxyEnvVar.split(":");
            if (proxyHttpSplit.length != 3) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_IMPROPER_HTTPPROXY_FORMAT", proxyEnvVar));
            }
            result.put(protocol + ".proxyHost", proxyHttpSplit[1].replace("/", ""));
            result.put(protocol + ".proxyPort", proxyHttpSplit[2]);
        }
        return result;
    }

    private Map<String, String> getFeatureUtilEnvProps() {
        File featureUtilEnvFile = new File(ETC_DIRECTORY + FEATURE_UTILITY_PROPS_FILE);
        HashMap<String, String> propEnvMap = new HashMap<String, String>();
        try {
            Scanner scanner = new Scanner(featureUtilEnvFile);
            this.fine("featureUtility.env exists");
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                String[] splitLine = line.split("=");
                propEnvMap.put(splitLine[0], splitLine[1]);
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            this.fine("featureUtility.env not found");
        }
        return propEnvMap;
    }

    private void updateProgress(double increment) {
        this.progressBar.updateProgress(increment);
    }

    private void info(String msg) {
        this.logger.info(msg);
    }

    private void fine(String msg) {
        this.logger.fine(msg);
    }

    private void severe(String msg) {
        this.logger.severe(msg);
    }

    private static enum ActionType {
        install,
        uninstall,
        resolve;

    }
}

