/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.beanvalidation.v20;

import com.ibm.ejs.util.dopriv.SetContextClassLoaderPrivileged;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.beanvalidation.service.BvalManagedObjectBuilder;
import com.ibm.ws.beanvalidation.service.Validation20ClassLoader;
import com.ibm.ws.beanvalidation.service.ValidatorFactoryBuilder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.security.AccessController;
import javax.validation.Configuration;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
public class ValidatorFactoryBuilderImpl
implements ValidatorFactoryBuilder {
    private static final TraceComponent tc = Tr.register(ValidatorFactoryBuilderImpl.class, (String)"BeanValidation", (String)"com.ibm.ws.beanvalidation.resources.nls.BVNLSMessages");
    private static final String REFERENCE_BVAL_MANAGED_OBJECT_BUILDER = "BvalManagedObjectBuilder";
    private final AtomicServiceReference<BvalManagedObjectBuilder> bvalManagedObjectBuilderSR = new AtomicServiceReference("BvalManagedObjectBuilder");
    @Reference
    private ClassLoadingService classLoadingService;
    static final long serialVersionUID = -7501661895615796328L;

    public void closeValidatorFactory(ValidatorFactory vf) {
        if (vf != null) {
            vf.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidatorFactory buildValidatorFactory(ClassLoader appClassLoader, String containerPath) {
        ValidatorFactory validatorFactory;
        SetContextClassLoaderPrivileged setClassLoader;
        ClassLoader tcclClassLoader;
        block14: {
            Configuration config;
            ClassLoader oldClassLoader;
            block12: {
                ValidatorFactory validatorFactory2;
                block13: {
                    tcclClassLoader = null;
                    setClassLoader = null;
                    oldClassLoader = null;
                    try {
                        ClassLoader tcclClassLoaderTmp = tcclClassLoader = this.configureBvalClassloader(appClassLoader);
                        ClassLoader bvalClassLoader = AccessController.doPrivileged(() -> new Validation20ClassLoader(tcclClassLoaderTmp, containerPath));
                        ThreadContextAccessor tca = AccessController.doPrivileged(() -> ThreadContextAccessor.getThreadContextAccessor());
                        setClassLoader = new SetContextClassLoaderPrivileged(tca);
                        oldClassLoader = setClassLoader.execute(bvalClassLoader);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Called setClassLoader with oldClassLoader of " + oldClassLoader + " and newClassLoader of " + bvalClassLoader), (Object[])new Object[0]);
                        }
                        if ((config = Validation.byDefaultProvider().configure()) instanceof HibernateValidatorConfiguration) {
                            HibernateValidatorConfiguration hvConfig = (HibernateValidatorConfiguration)config;
                            hvConfig.externalClassLoader(bvalClassLoader);
                        }
                        if (this.bvalManagedObjectBuilderSR.getReference() == null) break block12;
                        BvalManagedObjectBuilder bvalManagedObjectBuilder = (BvalManagedObjectBuilder)this.bvalManagedObjectBuilderSR.getServiceWithException();
                        validatorFactory2 = bvalManagedObjectBuilder.injectValidatorFactoryResources(config, appClassLoader);
                        if (setClassLoader == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (setClassLoader != null) {
                            setClassLoader.execute(oldClassLoader);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                            }
                        }
                        if (setClassLoader != null && setClassLoader.wasChanged) {
                            this.releaseLoader(tcclClassLoader);
                        }
                        throw throwable;
                    }
                    setClassLoader.execute(oldClassLoader);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                    }
                }
                if (setClassLoader != null && setClassLoader.wasChanged) {
                    this.releaseLoader(tcclClassLoader);
                }
                return validatorFactory2;
            }
            validatorFactory = config.buildValidatorFactory();
            if (setClassLoader == null) break block14;
            setClassLoader.execute(oldClassLoader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
            }
        }
        if (setClassLoader != null && setClassLoader.wasChanged) {
            this.releaseLoader(tcclClassLoader);
        }
        return validatorFactory;
    }

    private ClassLoader configureBvalClassloader(ClassLoader cl) {
        if (cl == null) {
            cl = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
        }
        if (cl != null) {
            if (this.classLoadingService.isThreadContextClassLoader(cl)) {
                return cl;
            }
            if (this.classLoadingService.isAppClassLoader(cl)) {
                return this.createTCCL(cl);
            }
        }
        return this.createTCCL(ValidatorFactoryBuilderImpl.class.getClassLoader());
    }

    private ClassLoader createTCCL(ClassLoader parentCL) {
        return AccessController.doPrivileged(() -> this.classLoadingService.createThreadContextClassLoader(parentCL));
    }

    private void releaseLoader(ClassLoader tccl) {
        AccessController.doPrivileged(() -> {
            this.classLoadingService.destroyThreadContextClassLoader(tccl);
            return null;
        });
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.bvalManagedObjectBuilderSR.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.bvalManagedObjectBuilderSR.deactivate(cc);
    }

    @Reference(name="BvalManagedObjectBuilder", service=BvalManagedObjectBuilder.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setBvalManagedObjectBuilder(ServiceReference<BvalManagedObjectBuilder> builderRef) {
        this.bvalManagedObjectBuilderSR.setReference(builderRef);
    }

    protected void unsetBvalManagedObjectBuilder(ServiceReference<BvalManagedObjectBuilder> builderRef) {
        this.bvalManagedObjectBuilderSR.unsetReference(builderRef);
    }
}

