/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejb.portable;

import com.ibm.ws.ejb.portable.HandleHelper;
import com.ibm.ws.ejb.portable.LoggerHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.spi.HandleDelegate;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.stub.java.rmi._Remote_Stub;

public class HandleDelegateImpl
implements HandleDelegate {
    private static final String CLASS_NAME = HandleDelegateImpl.class.getName();
    private static final Logger logger = LoggerHelper.getLogger(CLASS_NAME, "EJBContainer");
    private static final HandleDelegate instance = new HandleDelegateImpl();

    public static HandleDelegate getInstance() {
        return instance;
    }

    protected ORB getORB() throws IOException {
        try {
            return HandleHelper.getORB();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void writeObject(java.lang.Object object, ObjectOutputStream out) throws IOException {
        Boolean orbOut;
        boolean isTraceOn = logger.isLoggable(Level.FINER);
        if (isTraceOn) {
            logger.entering(CLASS_NAME, "writeObject", object);
        }
        if ((orbOut = HandleHelper.isORBOutputStream(out)) == null) {
            _Remote_Stub remoteStub = new _Remote_Stub();
            remoteStub._set_delegate(((Stub)object)._get_delegate());
            if (isTraceOn && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "writeObject", "writing _Remote_Stub: " + remoteStub);
            }
            out.writeObject(remoteStub);
        } else if (orbOut.booleanValue()) {
            if (isTraceOn && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "writeObject", "writing object: " + object);
            }
            out.writeObject(object);
        } else {
            String string = this.getORB().object_to_string((Object)object);
            if (isTraceOn && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "writeObject", "writing string: " + string);
            }
            out.writeObject(string);
        }
        if (isTraceOn) {
            logger.exiting(CLASS_NAME, "writeObject");
        }
    }

    private java.lang.Object readObject(Class klass, ObjectInputStream in) throws IOException, ClassNotFoundException {
        java.lang.Object object;
        boolean isTraceOn = logger.isLoggable(Level.FINER);
        if (isTraceOn) {
            logger.entering(CLASS_NAME, "readObject", klass);
        }
        if ((object = in.readObject()) != null) {
            if (object instanceof String) {
                if (isTraceOn && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "readObject", "read string: " + object);
                }
                object = this.getORB().string_to_object((String)object);
            } else {
                Stub stub = (Stub)object;
                try {
                    ORB orb = stub._orb();
                    if (isTraceOn && logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "readObject", "read connected stub: " + orb);
                    }
                }
                catch (Throwable t) {
                    if (isTraceOn && logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "readObject", "read disconnected stub: " + t);
                    }
                    stub.connect(this.getORB());
                }
            }
            object = PortableRemoteObject.narrow((java.lang.Object)object, (Class)klass);
        }
        if (isTraceOn) {
            logger.exiting(CLASS_NAME, "readObject", object);
        }
        return object;
    }

    public void writeEJBObject(EJBObject object, ObjectOutputStream out) throws IOException {
        this.writeObject(object, out);
    }

    public EJBObject readEJBObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        return (EJBObject)this.readObject(EJBObject.class, in);
    }

    public void writeEJBHome(EJBHome home, ObjectOutputStream out) throws IOException {
        this.writeObject(home, out);
    }

    public EJBHome readEJBHome(ObjectInputStream in) throws ClassNotFoundException, IOException {
        return (EJBHome)this.readObject(EJBHome.class, in);
    }
}

