/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.logging;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.environment.logging.Category;
import org.jboss.weld.environment.logging.WeldEnvironmentLogger;
import org.jboss.weld.exceptions.IllegalArgumentException;

@MessageLogger(projectCode="WELD-ENV-")
public interface WeldSELogger
extends WeldEnvironmentLogger {
    public static final WeldSELogger LOG = (WeldSELogger)Logger.getMessageLogger(WeldSELogger.class, (String)Category.BOOTSTRAP.getName());

    @Message(id=2000, value="Weld SE container {0} is already running!", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException weldContainerAlreadyRunning(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2001, value="Weld SE container {0} shut down", format=Message.Format.MESSAGE_FORMAT)
    public void weldContainerShutdown(Object var1);

    @Message(id=2002, value="Weld SE container {0} was already shut down", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException weldContainerAlreadyShutDown(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2003, value="Weld SE container {0} initialized", format=Message.Format.MESSAGE_FORMAT)
    public void weldContainerInitialized(Object var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=2004, value="Scanning package {0}, class resource: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void scanningPackage(Object var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2005, value="Package intended for scanning was not found: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void packageNotFound(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2006, value="Multiple containers running - CDI.current() may not work properly: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void multipleContainersRunning(Object var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=2007, value="Resource URL procotol not supported: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void resourceUrlProtocolNotSupported(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2008, value="Bean class {0} found in multiple bean archives - this may result in incorrect behavior: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void beanClassDeployedInMultipleBeanArchives(Object var1, Object var2);

    @Message(id=2009, value="Weld SE container cannot be initialized - no bean archives found")
    public IllegalStateException weldContainerCannotBeInitializedNoBeanArchivesFound();

    @Message(id=2010, value="The observed type {0} is not a container lifecycle event type", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException observedTypeNotContonainerLifecycleEventType(Object var1);

    @Message(id=2011, value="The observed type {0} does not match the container lifecycle event type {1}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException observedTypeDoesNotMatchContonainerLifecycleEventType(Object var1, Object var2);

    @Message(id=2012, value="The container lifecycle observer is not properly initialized: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException containerLifecycleObserverNotInitialized(Object var1);

    @Message(id=2014, value="Weld SE container with id {0} has not yet validated the deployment - methods for programmatic lookup cannot be used", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException weldContainerDeploymentNotValidated(Object var1);

    @Message(id=2015, value="Bean discovery mode NONE is not a valid option for Weld SE deployment archive - Weld SE container with id {0}.", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException beanArchiveWithModeNone(Object var1);

    @Message(id=2016, value="Zero or more than one container is running - WeldContainer.current() cannot determine the current container.", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException zeroOrMoreThanOneContainerRunning();
}

