/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.upgrade;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.webcontainer31.async.ThreadContextManager;
import com.ibm.ws.webcontainer31.srt.SRTUpgradeInputStream31;
import com.ibm.ws.webcontainer31.util.UpgradeInputByteBufferUtil;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import com.ibm.wsspi.webcontainer31.WCCustomProperties31;
import java.io.IOException;
import java.net.SocketTimeoutException;
import javax.servlet.ReadListener;

public class UpgradeReadCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(UpgradeReadCallback.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer31.resources.Messages");
    ReadListener _rl;
    UpgradeInputByteBufferUtil _upgradeStream;
    private SRTUpgradeInputStream31 _srtUpgradeStream;
    private ThreadContextManager _contextManager;

    public UpgradeReadCallback(ReadListener rl, UpgradeInputByteBufferUtil uIBBU, ThreadContextManager tcm, SRTUpgradeInputStream31 srtUpgradeStream) {
        this._rl = rl;
        this._upgradeStream = uIBBU;
        this._contextManager = tcm;
        this._srtUpgradeStream = srtUpgradeStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IOException.class})
    public void complete(VirtualConnection vc, TCPReadRequestContext rsc) {
        if (vc == null) {
            return;
        }
        SRTUpgradeInputStream31 sRTUpgradeInputStream31 = this._srtUpgradeStream;
        synchronized (sRTUpgradeInputStream31) {
            if (this._upgradeStream.isClosing()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The upgradedStream is closing, won't notify user of data", (Object[])new Object[0]);
                }
                ((Object)((Object)this._srtUpgradeStream)).notify();
                return;
            }
            this._upgradeStream.configurePostInitialReadBuffer();
        }
        try {
            this._contextManager.pushContextData();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Calling user's ReadListener.onDataAvailable : " + this._rl), (Object[])new Object[0]);
            }
            this._rl.onDataAvailable();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("User's ReadListener.onDataAvailable complete, reading for more data : " + this._rl), (Object[])new Object[0]);
            }
        }
        catch (Throwable onDataAvailableException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ReadListener.onDataAvailable threw an exception : " + onDataAvailableException + ", " + this._rl), (Object[])new Object[0]);
            }
            this._rl.onError(onDataAvailableException);
        }
        finally {
            this._contextManager.popContextData();
            sRTUpgradeInputStream31 = this._srtUpgradeStream;
            synchronized (sRTUpgradeInputStream31) {
                if (!this._upgradeStream.isClosing()) {
                    this._upgradeStream.initialRead();
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The upgradedStream is closing, won't issue the initial read", (Object[])new Object[0]);
                    }
                    ((Object)((Object)this._srtUpgradeStream)).notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FFDCIgnore(value={IOException.class})
    public void error(VirtualConnection vc, TCPReadRequestContext rsc, IOException ioe) {
        boolean closing = false;
        boolean isFirstRead = false;
        SRTUpgradeInputStream31 sRTUpgradeInputStream31 = this._srtUpgradeStream;
        synchronized (sRTUpgradeInputStream31) {
            closing = this._upgradeStream.isClosing();
            isFirstRead = this._upgradeStream.isFirstRead();
            this._upgradeStream.setIsInitialRead(false);
        }
        if (!closing) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Encountered an error during the initial read for data : " + ioe + ", " + this._rl), (Object[])new Object[0]);
            }
            try {
                this._contextManager.pushContextData();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error encountered while we are not closing : " + this._rl), (Object[])new Object[0]);
                }
                if (!isFirstRead) {
                    if (WCCustomProperties31.UPGRADE_READ_TIMEOUT != -1 && ioe instanceof SocketTimeoutException) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Other side did not send data within the timeout time, calling onError : " + this._rl), (Object[])new Object[0]);
                        }
                        if (this._upgradeStream.isIsonErrorCalled()) return;
                        this._upgradeStream.setIsonErrorCalled(true);
                        this._rl.onError((Throwable)ioe);
                        return;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Other side must be closed, check if not called before call onAllDataRead : " + this._rl), (Object[])new Object[0]);
                    }
                    if (this._upgradeStream.isAlldataReadCalled()) return;
                    try {
                        this._upgradeStream.setAlldataReadCalled(true);
                        this._rl.onAllDataRead();
                        return;
                    }
                    catch (Throwable onAllDataReadException) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Encountered an error during ReadListener.onAllDataRead : " + onAllDataReadException + ", " + this._rl), (Object[])new Object[0]);
                        }
                        if (this._upgradeStream.isIsonErrorCalled()) return;
                        this._upgradeStream.setIsonErrorCalled(true);
                        this._rl.onError(onAllDataReadException);
                    }
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Encountered an error during the first initialRead for data, calling the ReadListener.onError : " + this._rl), (Object[])new Object[0]);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"setReadListener.initialread.failed", (Object[])new Object[0]);
                }
                if (this._upgradeStream.isIsonErrorCalled()) return;
                this._upgradeStream.setIsonErrorCalled(true);
                this._rl.onError((Throwable)ioe);
                return;
            }
            finally {
                block28: {
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("finally call close from ReadListener.onError : " + this._rl), (Object[])new Object[0]);
                        }
                        this._upgradeStream.getWebConn().close();
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block28;
                        Tr.debug((TraceComponent)tc, (String)("Caught exception during WebConnection.close : " + e + "," + this._rl), (Object[])new Object[0]);
                    }
                }
                this._contextManager.popContextData();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"We are closing, skipping the call to onError", (Object[])new Object[0]);
        }
        sRTUpgradeInputStream31 = this._srtUpgradeStream;
        synchronized (sRTUpgradeInputStream31) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Issuing the notify", (Object[])new Object[0]);
            }
            ((Object)((Object)this._srtUpgradeStream)).notify();
            return;
        }
    }
}

