/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.ClaimValue;
import org.eclipse.microprofile.jwt.JsonWebToken;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ClaimProducer {
    private static final TraceComponent tc = Tr.register(ClaimProducer.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.cdi.resources.JwtCDI");
    @Inject
    private JsonWebToken jsonWebToken;
    static final long serialVersionUID = 6691209285196014393L;

    @Produces
    @Dependent
    @Claim
    @ManualTrace
    public <T> ClaimValue<T> getClaimValue(InjectionPoint injectionPoint) {
        ParameterizedType parameterizedBeanType;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getClaimValue", (Object[])new Object[]{injectionPoint});
        }
        final String claimName = this.getClaimName(injectionPoint);
        boolean isOptional = false;
        Class<?> returnClass = null;
        Class<?> wrappedClass = null;
        Type beanType = injectionPoint.getType();
        if (beanType instanceof ParameterizedType && (isOptional = Optional.class.isAssignableFrom(returnClass = this.getTypeClass((parameterizedBeanType = (ParameterizedType)beanType).getActualTypeArguments()[0])))) {
            wrappedClass = this.getTypeClass(((ParameterizedType)parameterizedBeanType.getActualTypeArguments()[0]).getActualTypeArguments()[0]);
        }
        final boolean isOptionalFinal = isOptional;
        final Class<?> returnClassFinal = returnClass;
        final Class<?> wrappedClassFinal = wrappedClass;
        ClaimValue instance = new ClaimValue<T>(){
            static final long serialVersionUID = -2190047812712150984L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public String getName() {
                return claimName;
            }

            public T getValue() {
                Object value = null;
                value = isOptionalFinal ? Optional.ofNullable(ClaimProducer.this.getPlainValue(wrappedClassFinal, claimName)) : (returnClassFinal != null && JsonValue.class.isAssignableFrom(returnClassFinal) ? ClaimProducer.this.getAsJsonValue(claimName) : ClaimProducer.this.jsonWebToken.getClaim(claimName));
                return value;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.mp.jwt.cdi.ClaimProducer$1", 1.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.cdi.resources.JwtCDI");
            }
        };
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getClaimValue", (Object)instance);
        }
        return instance;
    }

    @ManualTrace
    private String getClaimName(InjectionPoint injectionPoint) {
        Claim claim;
        String claimName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getClaimName", (Object[])new Object[]{injectionPoint});
        }
        if ((claimName = (claim = this.getClaimAnnotation(injectionPoint)).value()) == null || claimName.trim().isEmpty()) {
            claimName = claim.standard().name();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getClaimName", (Object)claimName);
        }
        return claimName;
    }

    @ManualTrace
    private Claim getClaimAnnotation(InjectionPoint injectionPoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getClaimAnnotation", (Object[])new Object[]{injectionPoint});
        }
        Claim claim = null;
        Set qualifiers = injectionPoint.getQualifiers();
        if (qualifiers != null) {
            for (Annotation qualifier : qualifiers) {
                if (!qualifier.annotationType().equals(Claim.class)) continue;
                claim = (Claim)qualifier;
                break;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getClaimAnnotation", claim);
        }
        return claim;
    }

    private Class<?> getTypeClass(Type type) {
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    private <U> U getPlainValue(Class<U> returnClass, String claimName) {
        Object value = null;
        value = JsonValue.class.isAssignableFrom(returnClass) ? this.getAsJsonValue(claimName) : this.jsonWebToken.getClaim(claimName);
        return (U)value;
    }

    private JsonValue getAsJsonValue(String claimName) {
        JsonReader reader = Json.createReader((Reader)new StringReader(this.jsonWebToken.toString()));
        JsonObject jsonObject = reader.readObject();
        return (JsonValue)jsonObject.get((Object)claimName);
    }

    @Produces
    @Dependent
    @Claim
    @ManualTrace
    public String getString(InjectionPoint injectionPoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getString", (Object[])new Object[]{injectionPoint});
        }
        String instance = (String)this.jsonWebToken.getClaim(this.getClaimName(injectionPoint));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getString", (Object)instance);
        }
        return instance;
    }

    @Produces
    @Dependent
    @Claim
    @ManualTrace
    public Set<String> getSetString(InjectionPoint injectionPoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSetString", (Object[])new Object[]{injectionPoint});
        }
        Set instance = (Set)this.jsonWebToken.getClaim(this.getClaimName(injectionPoint));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSetString", (Object)instance);
        }
        return instance;
    }

    @Produces
    @Dependent
    @Claim
    @ManualTrace
    public Long getLong(InjectionPoint injectionPoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLong", (Object[])new Object[]{injectionPoint});
        }
        Long instance = (Long)this.jsonWebToken.getClaim(this.getClaimName(injectionPoint));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLong", (Object)instance);
        }
        return instance;
    }

    @Produces
    @Dependent
    @Claim
    @ManualTrace
    public Boolean getBoolean(InjectionPoint injectionPoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBoolean", (Object[])new Object[]{injectionPoint});
        }
        Boolean instance = (Boolean)this.jsonWebToken.getClaim(this.getClaimName(injectionPoint));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getBoolean", (Object)instance);
        }
        return instance;
    }

    @Produces
    @Dependent
    @Claim
    @ManualTrace
    public <T> Optional<T> getOptional(InjectionPoint injectionPoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOptional", (Object[])new Object[]{injectionPoint});
        }
        ParameterizedType parameterizedBeanType = (ParameterizedType)injectionPoint.getType();
        Class<?> wrappedClassFinal = this.getTypeClass(parameterizedBeanType.getActualTypeArguments()[0]);
        Optional<?> instance = Optional.ofNullable(this.getPlainValue(wrappedClassFinal, this.getClaimName(injectionPoint)));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOptional", instance);
        }
        return instance;
    }

    @Produces
    @Dependent
    @Claim
    @ManualTrace
    public JsonNumber getJsonNumber(InjectionPoint injectionPoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getJsonNumber", (Object[])new Object[]{injectionPoint});
        }
        JsonNumber instance = (JsonNumber)this.getAsJsonValue(this.getClaimName(injectionPoint));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getJsonNumber", (Object)instance);
        }
        return instance;
    }

    @Produces
    @Dependent
    @Claim
    @ManualTrace
    public JsonString getJsonString(InjectionPoint injectionPoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getJsonString", (Object[])new Object[]{injectionPoint});
        }
        JsonString instance = (JsonString)this.getAsJsonValue(this.getClaimName(injectionPoint));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getJsonNumber", (Object)instance);
        }
        return instance;
    }

    @Produces
    @Dependent
    @Claim
    @ManualTrace
    public JsonStructure getJsonStructure(InjectionPoint injectionPoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getJsonStructure", (Object[])new Object[]{injectionPoint});
        }
        JsonStructure instance = (JsonStructure)this.getAsJsonValue(this.getClaimName(injectionPoint));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getJsonStructure", (Object)instance);
        }
        return instance;
    }

    @Produces
    @Dependent
    @Claim
    @ManualTrace
    public JsonArray getJsonArray(InjectionPoint injectionPoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getJsonArray", (Object[])new Object[]{injectionPoint});
        }
        JsonArray instance = (JsonArray)this.getAsJsonValue(this.getClaimName(injectionPoint));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getJsonArray", (Object)instance);
        }
        return instance;
    }

    @Produces
    @Dependent
    @Claim
    @ManualTrace
    public JsonObject getJsonObject(InjectionPoint injectionPoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getJsonObject", (Object[])new Object[]{injectionPoint});
        }
        JsonObject instance = (JsonObject)this.getAsJsonValue(this.getClaimName(injectionPoint));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getJsonObject", (Object)instance);
        }
        return instance;
    }
}

