/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.sso.common.SsoService;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorHelper;
import com.ibm.ws.wssecurity.saml.impl.ServiceUtils;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WssSamlServiceImpl
implements SsoService {
    protected static final TraceComponent tc = Tr.register(WssSamlServiceImpl.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.saml.resources.WssSamlMessages");
    protected static final String KEY_SERVICE_PID = "service.pid";
    public static final String KEY_SSO_SERVICE = "ssoService";
    static final String KEY_SECURITY_SERVICE = "securityService";
    protected final ConcurrentServiceReferenceMap<String, SsoService> ssoServiceRefs = new ConcurrentServiceReferenceMap("ssoService");
    protected final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    static final long serialVersionUID = -1845385704261201422L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSsoService(ServiceReference<SsoService> reference) {
        String type = (String)reference.getProperty("type");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WSS Saml setSsoService type=" + type), (Object[])new Object[0]);
        }
        ConcurrentServiceReferenceMap<String, SsoService> concurrentServiceReferenceMap = this.ssoServiceRefs;
        synchronized (concurrentServiceReferenceMap) {
            this.ssoServiceRefs.putReference((Object)type, reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetSsoService(ServiceReference<SsoService> reference) {
        String type = (String)reference.getProperty("type");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WSS Saml unsetSsoService type=" + type), (Object[])new Object[0]);
        }
        ConcurrentServiceReferenceMap<String, SsoService> concurrentServiceReferenceMap = this.ssoServiceRefs;
        synchronized (concurrentServiceReferenceMap) {
            this.ssoServiceRefs.removeReference((Object)type, reference);
        }
    }

    protected void setSecurityService(ServiceReference<SecurityService> ref) {
        this.securityServiceRef.setReference(ref);
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> ref) {
        this.securityServiceRef.unsetReference(ref);
    }

    public void activate(ComponentContext cc) {
        this.ssoServiceRefs.activate(cc);
        this.securityServiceRef.activate(cc);
        ServiceUtils.setAuthHelper(new WebProviderAuthenticatorHelper(this.securityServiceRef));
        ServiceUtils.setCommonSsoService(this.ssoServiceRefs);
        ServiceUtils.setSecurityServiceRef(this.securityServiceRef);
    }

    public void deactivate(ComponentContext cc) {
        this.ssoServiceRefs.deactivate(cc);
        this.securityServiceRef.deactivate(cc);
    }

    public Map<String, Object> handleRequest(String requestName, Map<String, Object> requestContext) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WSS Saml handleRequest requestName:" + requestName + "requestContext:" + requestContext), (Object[])new Object[0]);
        }
        result.putAll(requestContext);
        return result;
    }
}

