/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal.bci;

import com.ibm.websphere.monitor.annotation.ProbeAtCatch;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.monitor.internal.ListenerConfiguration;
import com.ibm.ws.monitor.internal.ProbeFilter;
import com.ibm.ws.monitor.internal.ProbeImpl;
import com.ibm.ws.monitor.internal.ProbeListener;
import com.ibm.ws.monitor.internal.bci.MethodInfo;
import com.ibm.ws.monitor.internal.bci.ProbeMethodAdapter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ProbeAtCatchMethodAdapter
extends ProbeMethodAdapter {
    private static final String EXCEPTION_FILTER_KEY = "ProbeAtCatch:Filter";
    private Map<Label, Type> handlers = new HashMap<Label, Type>();
    private Set<ProbeListener> enabledListeners = new HashSet<ProbeListener>();
    private Label handlerPendingInstruction;
    private final boolean enabled;
    static final long serialVersionUID = -5623167466035822490L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected ProbeAtCatchMethodAdapter(ProbeMethodAdapter probeMethodAdapter, MethodInfo methodInfo, Set<ProbeListener> interested) {
        super(probeMethodAdapter, methodInfo);
        for (ProbeListener listener : interested) {
            ListenerConfiguration config = listener.getListenerConfiguration();
            ProbeAtCatch probeAtCatch = config.getProbeAtCatch();
            if (probeAtCatch == null) continue;
            ProbeFilter filter = (ProbeFilter)config.getTransformerData(EXCEPTION_FILTER_KEY);
            if (filter == null) {
                filter = new ProbeFilter(probeAtCatch.value(), null, null, null, null);
                config.setTransformerData(EXCEPTION_FILTER_KEY, filter);
            }
            this.enabledListeners.add(listener);
        }
        this.enabled = !this.enabledListeners.isEmpty();
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String exceptionType) {
        if (this.enabled && exceptionType != null) {
            this.handlers.put(handler, Type.getObjectType((String)exceptionType));
        }
        super.visitTryCatchBlock(start, end, handler, exceptionType);
    }

    @Override
    public void visitLabel(Label label) {
        if (this.enabled && this.handlers.containsKey(label)) {
            this.handlerPendingInstruction = label;
        }
        super.visitLabel(label);
    }

    private void onHandlerEntry() {
        if (this.enabled) {
            Type exceptionType = this.handlers.get(this.handlerPendingInstruction);
            this.handlerPendingInstruction = null;
            HashSet<ProbeListener> filtered = new HashSet<ProbeListener>();
            for (ProbeListener listener : this.enabledListeners) {
                Class<?> clazz;
                ListenerConfiguration config = listener.getListenerConfiguration();
                ProbeFilter filter = (ProbeFilter)config.getTransformerData(EXCEPTION_FILTER_KEY);
                if (filter.isBasicFilter() && filter.basicClassNameMatches(exceptionType.getClassName())) {
                    filtered.add(listener);
                    continue;
                }
                if (!filter.isAdvancedFilter() || (clazz = this.getOwningClass(exceptionType.getInternalName())) == null || !filter.matches(clazz)) continue;
                filtered.add(listener);
            }
            if (filtered.isEmpty()) {
                return;
            }
            String key = this.createKey(exceptionType);
            ProbeImpl probe = this.getProbe(key);
            long probeId = probe.getIdentifier();
            this.setProbeInProgress(true);
            this.visitInsn(89);
            this.visitLdcInsn(probeId);
            this.visitInsn(93);
            this.visitInsn(88);
            if (this.isStatic()) {
                this.visitInsn(1);
            } else {
                this.visitVarInsn(25, 0);
            }
            this.visitInsn(95);
            this.visitInsn(1);
            this.visitInsn(95);
            this.visitFireProbeInvocation();
            this.setProbeInProgress(false);
            this.setProbeListeners(probe, filtered);
        }
    }

    private String createKey(Type exceptionType) {
        StringBuilder sb = new StringBuilder("EXCEPTION_CAUGHT: ");
        sb.append(this.getMethodName());
        sb.append(this.getDescriptor());
        sb.append(": ").append(exceptionType.getInternalName());
        return sb.toString();
    }

    @Override
    public void visitInsn(int opcode) {
        if (this.handlerPendingInstruction != null) {
            this.onHandlerEntry();
        }
        super.visitInsn(opcode);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (this.handlerPendingInstruction != null) {
            this.onHandlerEntry();
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        if (this.handlerPendingInstruction != null) {
            this.onHandlerEntry();
        }
        super.visitIincInsn(var, increment);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        if (this.handlerPendingInstruction != null) {
            this.onHandlerEntry();
        }
        super.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        if (this.handlerPendingInstruction != null) {
            this.onHandlerEntry();
        }
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLdcInsn(Object constant) {
        if (this.handlerPendingInstruction != null) {
            this.onHandlerEntry();
        }
        super.visitLdcInsn(constant);
    }

    @Override
    public void visitLookupSwitchInsn(Label defaultTarget, int[] keys, Label[] labels) {
        if (this.handlerPendingInstruction != null) {
            this.onHandlerEntry();
        }
        super.visitLookupSwitchInsn(defaultTarget, keys, labels);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (this.handlerPendingInstruction != null) {
            this.onHandlerEntry();
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        if (this.handlerPendingInstruction != null) {
            this.onHandlerEntry();
        }
        super.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label defaultLabel, Label[] labels) {
        if (this.handlerPendingInstruction != null) {
            this.onHandlerEntry();
        }
        super.visitTableSwitchInsn(min, max, defaultLabel, labels);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        if (this.handlerPendingInstruction != null) {
            this.onHandlerEntry();
        }
        super.visitTypeInsn(opcode, type);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        if (this.handlerPendingInstruction != null) {
            this.onHandlerEntry();
        }
        super.visitVarInsn(opcode, var);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.monitor.internal.bci.ProbeAtCatchMethodAdapter", ProbeAtCatchMethodAdapter.class, (String)"PMI", (String)"com.ibm.ws.pmi.properties.PMIMessages");
    }
}

