/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.server.plugins;

import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.OAuthUtil;
import com.ibm.oauth.core.internal.oauth20.OAuth20Constants;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenHelper;
import com.ibm.oauth.core.internal.oauth20.tokentype.OAuth20TokenTypeHandler;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.common.claims.UserClaims;
import com.ibm.ws.security.common.claims.UserClaimsRetrieverService;
import com.ibm.ws.security.common.jwk.interfaces.JWK;
import com.ibm.ws.security.common.token.propagation.TokenPropagationHelper;
import com.ibm.ws.security.oauth20.ProvidersService;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.plugins.OAuth20TokenImpl;
import com.ibm.ws.security.oauth20.plugins.jose4j.JWTData;
import com.ibm.ws.security.oauth20.plugins.jose4j.JwtCreator;
import com.ibm.ws.security.oauth20.plugins.jose4j.OidcUserClaims;
import com.ibm.ws.security.oauth20.util.ConfigUtils;
import com.ibm.ws.security.openidconnect.server.ServerConstants;
import com.ibm.ws.security.openidconnect.server.internal.HashUtils;
import com.ibm.ws.security.openidconnect.server.plugins.IDTokenImpl;
import com.ibm.ws.security.openidconnect.server.plugins.OIDCProvidersConfig;
import com.ibm.ws.security.openidconnect.token.IDToken;
import com.ibm.ws.security.openidconnect.token.JWSHeader;
import com.ibm.ws.security.openidconnect.token.JsonTokenUtil;
import com.ibm.ws.security.openidconnect.token.Payload;
import com.ibm.ws.webcontainer.security.jwk.JSONWebKey;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import com.ibm.wsspi.security.openidconnect.IDTokenMediator;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.jose4j.keys.HmacKey;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class IDTokenHandler
implements OAuth20TokenTypeHandler {
    private static final TraceComponent tc = Tr.register(IDTokenHandler.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    private static final String CFG_KEY_ISSUER_IDENTIFIER = "issuerIdentifier";
    private static final String JTI_CLAIM = "jti";
    private static final String SIGNATURE_ALG_NONE = "none";
    private static final String SIGNATURE_ALG_HS256 = "HS256";
    private static final String SIGNATURE_ALG_RS256 = "RS256";
    private static final String SHARED_KEY = "sharedKey";
    public static final String AT_HASH = "at_hash";
    private static final int IDTOKEN_LIFETIME_DEFAULT = 7200;
    private volatile SecurityService securityService;
    static final long serialVersionUID = -4275100464320245940L;

    public void init(OAuthComponentConfiguration config) {
    }

    protected void activate(ComponentContext cc, Map<String, Object> properties) {
    }

    protected void deactivate(ComponentContext cc, Map<String, Object> properties) {
    }

    protected void modified(ComponentContext cc, Map<String, Object> properties) {
    }

    public String getTypeTokenType() {
        return "id_token";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth20Token createToken(@Sensitive Map<String, String[]> tokenMap) {
        IDTokenImpl token = null;
        String sharedKey = OAuth20Util.getValueFromMap((String)SHARED_KEY, tokenMap);
        String componentId = OAuth20Util.getValueFromMap((String)"COMPONENTID", tokenMap);
        String accessToken = OAuth20Util.getValueFromMap((String)"access_token", tokenMap);
        String clientId = OAuth20Util.getValueFromMap((String)"client_id", tokenMap);
        String username = OAuth20Util.getValueFromMap((String)"username", tokenMap);
        String redirectUri = OAuth20Util.getValueFromMap((String)"redirect_uri", tokenMap);
        String stateId = this.getStateId(tokenMap);
        String[] scopes = tokenMap.get("scope");
        String grantType = OAuth20Util.getValueFromMap((String)"grant_type", tokenMap);
        OidcServerConfig oidcServerConfig = OIDCProvidersConfig.getOidcServerConfigForOAuth20Provider(componentId);
        int lifetime = this.getLifetime(oidcServerConfig);
        String idTokenString = null;
        String signatureAlgorithm = oidcServerConfig.getSignatureAlgorithm();
        if (ServerConstants.JAVA_VERSION_6 || SIGNATURE_ALG_NONE.equals(signatureAlgorithm)) {
            Payload payload = this.createPayload(tokenMap, oidcServerConfig);
            Object signingKey = this.getSigningKey(signatureAlgorithm, sharedKey, oidcServerConfig);
            idTokenString = this.createIdTokenAsString(payload, signatureAlgorithm, signingKey, accessToken);
        } else {
            String accessTokenHash = null;
            if (accessToken != null) {
                accessTokenHash = JsonTokenUtil.accessTokenHash((String)accessToken);
            }
            JWTData jwtData = new JWTData(sharedKey, oidcServerConfig, "ID Token");
            boolean idSpi = this.isIDTokenMediatorSpi();
            String jsonFromSpi = null;
            if (idSpi) {
                IDTokenHandler iDTokenHandler = this;
                synchronized (iDTokenHandler) {
                    boolean subjectPushed = false;
                    Subject priorSubject = null;
                    try {
                        priorSubject = TokenPropagationHelper.getRunAsSubject();
                        subjectPushed = TokenPropagationHelper.pushSubject((String)username);
                        jsonFromSpi = this.getIDTokenClaimsFromMediatorSpi(tokenMap);
                    }
                    finally {
                        if (subjectPushed) {
                            TokenPropagationHelper.setRunAsSubject((Subject)priorSubject);
                        }
                    }
                }
                if (jsonFromSpi != null) {
                    idTokenString = JwtCreator.createJwtAsStringForSpi((String)jsonFromSpi, (OidcServerConfig)oidcServerConfig, (String)clientId, (String)username, (String[])scopes, (int)lifetime, tokenMap, (String)grantType, (String)accessTokenHash, (JWTData)jwtData);
                }
            }
            if (jsonFromSpi == null) {
                Map<String, Object> userClaims = this.getCustomClaims(tokenMap, oidcServerConfig);
                if (accessTokenHash != null) {
                    userClaims.put(AT_HASH, accessTokenHash);
                }
                OAuth20Provider oauth20Provider = ProvidersService.getOAuth20Provider((String)componentId);
                boolean useMicroProfileTokenFormat = false;
                idTokenString = JwtCreator.createJwtAsString((OidcServerConfig)oidcServerConfig, (String)clientId, (String)username, (String[])scopes, (int)lifetime, tokenMap, userClaims, (JWTData)jwtData, (boolean)useMicroProfileTokenFormat);
            }
        }
        String tokenId = HashUtils.digest(idTokenString);
        Map externalClaims = OAuth20TokenHelper.getExternalClaims(tokenMap);
        token = new IDTokenImpl(tokenId, idTokenString, componentId, clientId, username, redirectUri, stateId, scopes, lifetime, externalClaims, grantType);
        if (token != null) {
            ((OAuth20TokenImpl)token).setAccessTokenKey(accessToken);
        }
        return token;
    }

    private boolean isIDTokenMediatorSpi() {
        if (ConfigUtils.getIdTokenMediatorService().size() > 0) {
            if (ServerConstants.JAVA_VERSION_6) {
                Tr.warning((TraceComponent)tc, (String)"IDT_MEDIATOR_SPI_REQUIRES_JDK", (Object[])new Object[]{ServerConstants.JAVA_VERSION});
                return false;
            }
            return true;
        }
        return false;
    }

    protected String getIDTokenClaimsFromMediatorSpi(Map<String, String[]> tokenMap) {
        String idStr = null;
        Iterator idMediators = ConfigUtils.getIdTokenMediatorService().getServices();
        if (idMediators.hasNext()) {
            IDTokenMediator idMediator = (IDTokenMediator)idMediators.next();
            idStr = idMediator.mediateToken(tokenMap);
        }
        return idStr;
    }

    private int getLifetime(OidcServerConfig oidcServerConfig) {
        int lifetime = 7200;
        if (oidcServerConfig != null) {
            Long lifeValue = oidcServerConfig.getIdTokenLifetime();
            if (lifeValue < Integer.MAX_VALUE && lifeValue > 0L) {
                lifetime = lifeValue.intValue();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The value of idTokenLifetime exceeds maximum number of integer: " + lifeValue), (Object[])new Object[0]);
                }
                throw new RuntimeException("The value of idTokenLifetime exceeds maximum number of integer: " + lifeValue);
            }
        }
        return lifetime;
    }

    private String getStateId(Map<String, String[]> tokenMap) {
        String stateId = OAuth20Util.getValueFromMap((String)"state_id", tokenMap);
        if (stateId == null) {
            stateId = OAuth20Util.generateUUID();
        }
        return stateId;
    }

    private Payload createPayload(@Sensitive Map<String, String[]> tokenMap, OidcServerConfig oidcServerConfig) {
        Payload payload = new Payload();
        this.addRequiredClaims(payload, tokenMap, oidcServerConfig);
        this.validateRequiredClaims(payload);
        this.addOptionalClaims(payload, tokenMap, oidcServerConfig);
        this.addCustomClaims(payload, tokenMap, oidcServerConfig);
        this.addExternalClaims(payload, tokenMap);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("debug:" + payload), (Object[])new Object[0]);
        }
        return payload;
    }

    private void addExternalClaims(Payload payload, Map<String, String[]> tokenMap) {
        Set<Map.Entry<String, String[]>> entries = tokenMap.entrySet();
        for (Map.Entry<String, String[]> entry : entries) {
            List<String> list;
            String key = entry.getKey();
            if (!key.startsWith("com.ibm.wsspi.security.oidc.external.claims:")) continue;
            String shortKey = key.substring(OAuth20Constants.EXTERNAL_CLAIMS_PREFIX_LENGTH);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" longKey:" + key + " shortKey:" + shortKey), (Object[])new Object[0]);
            }
            if ((list = this.getListFromMap(key, tokenMap)).isEmpty()) continue;
            if (list.size() > 1) {
                payload.put((Object)shortKey, list);
                continue;
            }
            payload.put((Object)shortKey, (Object)OAuth20Util.getValueFromMap((String)key, tokenMap));
        }
    }

    List<String> getListFromMap(String key, Map<String, String[]> m) {
        ArrayList<String> list = new ArrayList<String>();
        String[] values = m.get(key);
        if (values != null && values.length > 0) {
            int max = values.length;
            for (int i = 0; i < max; ++i) {
                list.add(values[i]);
            }
        }
        return list;
    }

    private void addRequiredClaims(Payload payload, @Sensitive Map<String, String[]> tokenMap, OidcServerConfig oidcServerConfig) {
        payload.setIssuer(this.getIssuerIdentifier(tokenMap, oidcServerConfig));
        payload.setSubject(OAuth20Util.getValueFromMap((String)"username", tokenMap));
        payload.setAudience((Object)OAuth20Util.getValueFromMap((String)"client_id", tokenMap));
        long issuedAtTimeInSeconds = this.getIssuedAtTimeInSeconds();
        payload.setIssuedAtTimeSeconds(Long.valueOf(issuedAtTimeInSeconds));
        payload.setExpirationTimeSeconds(Long.valueOf(issuedAtTimeInSeconds + (long)this.getLifetime(oidcServerConfig)));
        String nonce = OAuth20Util.getValueFromMap((String)"nonce", tokenMap);
        if (nonce != null) {
            payload.setNonce(nonce);
        }
    }

    private String getIssuerIdentifier(@Sensitive Map<String, String[]> tokenMap, OidcServerConfig oidcServerConfig) {
        String issuerIdentifier = oidcServerConfig.getIssuerIdentifier();
        if (issuerIdentifier == null || issuerIdentifier.isEmpty()) {
            issuerIdentifier = OAuth20Util.getValueFromMap((String)CFG_KEY_ISSUER_IDENTIFIER, tokenMap);
        }
        return issuerIdentifier;
    }

    private long getIssuedAtTimeInSeconds() {
        return new Date().getTime() / 1000L;
    }

    protected void validateRequiredClaims(Payload payload) {
        String[] requiredClaims = new String[]{"iss", "sub", "aud", "exp", "iat"};
        StringBuffer sb = new StringBuffer("ID Token is missing required claims:");
        boolean valid = true;
        for (String requiredClaim : requiredClaims) {
            if (payload.get((Object)requiredClaim) != null) continue;
            sb.append(" ");
            sb.append(requiredClaim);
            valid = false;
        }
        if (!valid) {
            throw new RuntimeException(sb.toString());
        }
    }

    private void addOptionalClaims(Payload payload, @Sensitive Map<String, String[]> tokenMap, OidcServerConfig oidcServerConfig) {
        if (oidcServerConfig.isJTIClaimEnabled()) {
            payload.put((Object)JTI_CLAIM, (Object)OAuthUtil.getRandom((int)16));
        }
    }

    private void addCustomClaims(Payload payload, @Sensitive Map<String, String[]> tokenMap, OidcServerConfig oidcServerConfig) {
        Map<String, Object> userClaims = this.getCustomClaims(tokenMap, oidcServerConfig);
        if (userClaims != null) {
            payload.putAll(userClaims);
        }
    }

    private Map<String, Object> getCustomClaims(@Sensitive Map<String, String[]> tokenMap, OidcServerConfig oidcServerConfig) {
        String groupIdentifier;
        String username;
        UserClaims oauthUserClaims;
        UserClaimsRetrieverService userClaimsRetrieverService;
        if (oidcServerConfig.isCustomClaimsEnabled() && (userClaimsRetrieverService = ConfigUtils.getUserClaimsRetrieverService()) != null && (oauthUserClaims = userClaimsRetrieverService.getUserClaims(username = OAuth20Util.getValueFromMap((String)"username", tokenMap), groupIdentifier = oidcServerConfig.getGroupIdentifier())) != null) {
            if (oauthUserClaims.isEnabled()) {
                OidcUserClaims oidcUserClaims = new OidcUserClaims(oauthUserClaims);
                oidcUserClaims.addExtraClaims(oidcServerConfig);
                return oidcUserClaims.asMap();
            }
            return oauthUserClaims.asMap();
        }
        return new HashMap<String, Object>();
    }

    @Sensitive
    private Object getSigningKey(String signatureAlgorithm, @Sensitive String sharedKey, OidcServerConfig oidcServerConfig) {
        Object keyValue = null;
        if (oidcServerConfig.isJwkEnabled() && SIGNATURE_ALG_RS256.equals(signatureAlgorithm)) {
            keyValue = oidcServerConfig.getJSONWebKey();
        } else if (SIGNATURE_ALG_HS256.equals(signatureAlgorithm)) {
            keyValue = Base64Coder.getBytes((String)sharedKey);
        } else if (SIGNATURE_ALG_RS256.equals(signatureAlgorithm)) {
            keyValue = this.getRSAPrivateKey(oidcServerConfig);
        }
        return keyValue;
    }

    @Sensitive
    @FFDCIgnore(value={Exception.class})
    public static JWTData getSigningKey(@Sensitive String sharedKey, OidcServerConfig oidcServerConfig) {
        PrivateKey keyValue = null;
        String keyId = null;
        String signatureAlgorithm = oidcServerConfig.getSignatureAlgorithm();
        if (oidcServerConfig.isJwkEnabled() && SIGNATURE_ALG_RS256.equals(signatureAlgorithm)) {
            JSONWebKey jwk = oidcServerConfig.getJSONWebKey();
            keyValue = jwk.getPrivateKey();
            keyId = jwk.getKeyID();
        } else if (SIGNATURE_ALG_HS256.equals(signatureAlgorithm)) {
            try {
                keyValue = new HmacKey(sharedKey.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException jwk) {
                Object[] objectArray = new Object[2];
                objectArray[0] = "<sensitive java.lang.String>";
                objectArray[1] = oidcServerConfig;
                FFDCFilter.processException((Throwable)jwk, (String)"com.ibm.ws.security.openidconnect.server.plugins.IDTokenHandler", (String)"439", null, (Object[])objectArray);
            }
        } else if (SIGNATURE_ALG_RS256.equals(signatureAlgorithm)) {
            try {
                keyValue = oidcServerConfig.getPrivateKey();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("RSAPrivateKey: " + (keyValue instanceof RSAPrivateKey)), (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception obtaining the private key: " + e), (Object[])new Object[0]);
                }
                throw new RuntimeException("Unable to create signed ID token due to exception: " + e);
            }
        }
        return new JWTData((Key)keyValue, keyId);
    }

    /*
     * WARNING - void declaration
     */
    private String createIdTokenAsString(Payload payload, String signatureAlgorithm, @Sensitive Object signingKey, @Sensitive String accessToken) {
        String jwtString = null;
        try {
            jwtString = this.requiresSigning(signatureAlgorithm) ? this.createSignedIdToken(payload, signatureAlgorithm, signingKey, accessToken) : this.createPlainTextIdToken(payload);
        }
        catch (Exception exception) {
            void e;
            Object[] objectArray = new Object[4];
            objectArray[0] = payload;
            objectArray[1] = signatureAlgorithm;
            objectArray[2] = "<sensitive java.lang.Object>";
            objectArray[3] = "<sensitive java.lang.String>";
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.server.plugins.IDTokenHandler", (String)"468", (Object)this, (Object[])objectArray);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception creating the id_token string: " + e), (Object[])new Object[0]);
            }
            throw new RuntimeException("Exception creating the id_token string: " + e);
        }
        return jwtString;
    }

    private boolean requiresSigning(String signatureAlgorithm) {
        return !SIGNATURE_ALG_NONE.equals(signatureAlgorithm);
    }

    private String createSignedIdToken(Payload payload, String signatureAlgorithm, @Sensitive Object signingKey, @Sensitive String accessToken) throws InvalidKeyException, SignatureException {
        JWSHeader jwsHeader = new JWSHeader();
        jwsHeader.setAlgorithm(signatureAlgorithm);
        if (signingKey instanceof JWK) {
            JWK jwk = (JWK)signingKey;
            signingKey = jwk.getPrivateKey();
            jwsHeader.setKeyId(jwk.getKeyID());
        }
        IDToken idToken = new IDToken(jwsHeader, payload, signingKey, accessToken);
        return idToken.getSignedJWTString();
    }

    @Sensitive
    @FFDCIgnore(value={Exception.class})
    private Object getRSAPrivateKey(OidcServerConfig oidcServerConfig) {
        PrivateKey rsaPrivateKey = null;
        try {
            rsaPrivateKey = oidcServerConfig.getPrivateKey();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("RSAPrivateKey: " + (rsaPrivateKey instanceof RSAPrivateKey)), (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception obtaining the private key: " + e), (Object[])new Object[0]);
            }
            throw new RuntimeException("Unable to create signed ID token due to exception: " + e);
        }
        return rsaPrivateKey;
    }

    private String createPlainTextIdToken(Payload payload) {
        JWSHeader jwsHeader = new JWSHeader();
        IDToken idToken = new IDToken(jwsHeader, payload);
        return idToken.getJWTString();
    }

    public List<String> getKeysTokenType(AttributeList attributeList) throws OAuthException {
        return Collections.emptyList();
    }

    public void validateRequestTokenType(AttributeList attributeList, List<OAuth20Token> tokens) throws OAuthException {
    }

    public void buildResponseTokenType(AttributeList attributeList, List<OAuth20Token> tokens) {
    }
}

