/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.ldap.context;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.security.wim.adapter.ldap.LdapHelper;
import java.util.Hashtable;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class TimedDirContext {
    public static final String JNDI_CALL = "JNDI_CALL ";
    private static final TraceComponent tc = Tr.register(TimedDirContext.class, (String)"ldapUtil", (String)"com.ibm.ws.security.wim.adapter.ldap.resources.LdapUtilMessages");
    private final InitialLdapContext context;
    private long iCreateTimestampSeconds;
    private long iPoolTimestampSeconds;
    private final String iProviderURL;
    static final long serialVersionUID = 8850942696157376481L;

    @Sensitive
    public TimedDirContext(@Sensitive Hashtable<?, ?> environment, Control[] connCtls, long createTimestamp) throws NamingException {
        this.context = new InitialLdapContext(environment, connCtls);
        this.iCreateTimestampSeconds = createTimestamp;
        this.iPoolTimestampSeconds = createTimestamp;
        this.iProviderURL = (String)environment.get("java.naming.provider.url");
    }

    @FFDCIgnore(value={NamingException.class})
    public void close() throws NamingException {
        String METHODNAME = "close()";
        long begin = 0L;
        NamingException ne = null;
        try {
            this.traceJndiBegin("close()", new Object[0]);
            begin = System.currentTimeMillis();
            this.context.close();
        }
        catch (NamingException e) {
            ne = e;
            throw e;
        }
        finally {
            if (ne == null) {
                this.traceJndiReturn("close()", System.currentTimeMillis() - begin, new Object[0]);
            } else {
                this.traceJndiThrow("close()", System.currentTimeMillis() - begin, ne);
            }
        }
    }

    @FFDCIgnore(value={NamingException.class})
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        DirContext results;
        block7: {
            NamingException ne;
            long begin;
            block6: {
                String METHODNAME = "createSubcontext(Name,Attributes)";
                begin = 0L;
                ne = null;
                results = null;
                try {
                    this.traceJndiBegin("createSubcontext(Name,Attributes)", name, attrs);
                    begin = System.currentTimeMillis();
                    results = this.context.createSubcontext(name, attrs);
                    if (ne != null) break block6;
                }
                catch (NamingException e) {
                    try {
                        ne = e;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (ne == null) {
                            this.traceJndiReturn("createSubcontext(Name,Attributes)", System.currentTimeMillis() - begin, results);
                        } else {
                            this.traceJndiThrow("createSubcontext(Name,Attributes)", System.currentTimeMillis() - begin, ne);
                        }
                        throw throwable;
                    }
                }
                this.traceJndiReturn("createSubcontext(Name,Attributes)", System.currentTimeMillis() - begin, results);
                break block7;
            }
            this.traceJndiThrow("createSubcontext(Name,Attributes)", System.currentTimeMillis() - begin, ne);
        }
        return results;
    }

    @FFDCIgnore(value={NamingException.class})
    public void destroySubcontext(Name name) throws NamingException {
        String METHODNAME = "destroySubcontext(Name)";
        long begin = 0L;
        NamingException ne = null;
        try {
            this.traceJndiBegin("destroySubcontext(Name)", name);
            begin = System.currentTimeMillis();
            this.context.destroySubcontext(name);
        }
        catch (NamingException e) {
            ne = e;
            throw e;
        }
        finally {
            if (ne == null) {
                this.traceJndiReturn("destroySubcontext(Name)", System.currentTimeMillis() - begin, new Object[0]);
            } else {
                this.traceJndiThrow("destroySubcontext(Name)", System.currentTimeMillis() - begin, ne);
            }
        }
    }

    @FFDCIgnore(value={NamingException.class})
    public Attributes getAttributes(Name name, String[] attrs) throws NamingException {
        Attributes results;
        block7: {
            NamingException ne;
            long begin;
            block6: {
                String METHODNAME = "getAttributes(Name,String[])";
                begin = 0L;
                ne = null;
                results = null;
                try {
                    this.traceJndiBegin("getAttributes(Name,String[])", attrs);
                    begin = System.currentTimeMillis();
                    results = this.context.getAttributes(name, attrs);
                    if (ne != null) break block6;
                }
                catch (NamingException e) {
                    try {
                        ne = e;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (ne == null) {
                            this.traceJndiReturn("getAttributes(Name,String[])", System.currentTimeMillis() - begin, results);
                        } else {
                            this.traceJndiThrow("getAttributes(Name,String[])", System.currentTimeMillis() - begin, ne);
                        }
                        throw throwable;
                    }
                }
                this.traceJndiReturn("getAttributes(Name,String[])", System.currentTimeMillis() - begin, results);
                break block7;
            }
            this.traceJndiThrow("getAttributes(Name,String[])", System.currentTimeMillis() - begin, ne);
        }
        return results;
    }

    public long getCreateTimestamp() {
        return this.iCreateTimestampSeconds;
    }

    @Sensitive
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.context.getEnvironment();
    }

    @FFDCIgnore(value={NamingException.class})
    public NameParser getNameParser(String name) throws NamingException {
        NameParser results;
        block7: {
            NamingException ne;
            long begin;
            block6: {
                String METHODNAME = "getNameParser(String)";
                begin = 0L;
                ne = null;
                results = null;
                try {
                    this.traceJndiBegin("getNameParser(String)", name);
                    begin = System.currentTimeMillis();
                    results = this.context.getNameParser(name);
                    if (ne != null) break block6;
                }
                catch (NamingException e) {
                    try {
                        ne = e;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (ne == null) {
                            this.traceJndiReturn("getNameParser(String)", System.currentTimeMillis() - begin, results);
                        } else {
                            this.traceJndiThrow("getNameParser(String)", System.currentTimeMillis() - begin, ne);
                        }
                        throw throwable;
                    }
                }
                this.traceJndiReturn("getNameParser(String)", System.currentTimeMillis() - begin, results);
                break block7;
            }
            this.traceJndiThrow("getNameParser(String)", System.currentTimeMillis() - begin, ne);
        }
        return results;
    }

    public long getPoolTimestamp() {
        return this.iPoolTimestampSeconds;
    }

    @FFDCIgnore(value={NamingException.class})
    public Control[] getResponseControls() throws NamingException {
        String METHODNAME = "getResponseControls()";
        long begin = 0L;
        NamingException ne = null;
        Control[] results = null;
        try {
            this.traceJndiBegin("getResponseControls()", new Object[0]);
            begin = System.currentTimeMillis();
            results = this.context.getResponseControls();
        }
        catch (NamingException e) {
            ne = e;
            throw e;
        }
        finally {
            if (ne == null) {
                this.traceJndiReturn("getResponseControls()", System.currentTimeMillis() - begin, results);
            } else {
                this.traceJndiThrow("getResponseControls()", System.currentTimeMillis() - begin, ne);
            }
        }
        return results;
    }

    @FFDCIgnore(value={NamingException.class})
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        String METHODNAME = "modifyAttributes(Name,int,Attributes)";
        long begin = 0L;
        NamingException ne = null;
        try {
            this.traceJndiBegin("modifyAttributes(Name,int,Attributes)", name, mod_op, attrs);
            begin = System.currentTimeMillis();
            this.context.modifyAttributes(name, mod_op, attrs);
        }
        catch (NamingException e) {
            ne = e;
            throw e;
        }
        finally {
            if (ne == null) {
                this.traceJndiReturn("modifyAttributes(Name,int,Attributes)", System.currentTimeMillis() - begin, new Object[0]);
            } else {
                this.traceJndiThrow("modifyAttributes(Name,int,Attributes)", System.currentTimeMillis() - begin, ne);
            }
        }
    }

    @FFDCIgnore(value={NamingException.class})
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        String METHODNAME = "modifyAttributes(Name,ModificationItem[])";
        long begin = 0L;
        NamingException ne = null;
        try {
            this.traceJndiBegin("modifyAttributes(Name,ModificationItem[])", name, mods);
            begin = System.currentTimeMillis();
            this.context.modifyAttributes(name, mods);
        }
        catch (NamingException e) {
            ne = e;
            throw e;
        }
        finally {
            if (ne == null) {
                this.traceJndiReturn("modifyAttributes(Name,ModificationItem[])", System.currentTimeMillis() - begin, new Object[0]);
            } else {
                this.traceJndiThrow("modifyAttributes(Name,ModificationItem[])", System.currentTimeMillis() - begin, ne);
            }
        }
    }

    @FFDCIgnore(value={NamingException.class})
    public void rename(String oldName, String newName) throws NamingException {
        String METHODNAME = "rename(String,String)";
        long begin = 0L;
        NamingException ne = null;
        try {
            this.traceJndiBegin("rename(String,String)", oldName, newName);
            begin = System.currentTimeMillis();
            this.context.rename(oldName, newName);
        }
        catch (NamingException e) {
            ne = e;
            throw e;
        }
        finally {
            if (ne == null) {
                this.traceJndiReturn("rename(String,String)", System.currentTimeMillis() - begin, new Object[0]);
            } else {
                this.traceJndiThrow("rename(String,String)", System.currentTimeMillis() - begin, ne);
            }
        }
    }

    @FFDCIgnore(value={NamingException.class})
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        NamingEnumeration<SearchResult> results;
        block7: {
            NamingException ne;
            long begin;
            block6: {
                String METHODNAME = "search(Name,String,Object[],SearchControls)";
                begin = 0L;
                ne = null;
                results = null;
                try {
                    this.traceJndiBegin("search(Name,String,Object[],SearchControls)", name, filterExpr, filterArgs, LdapHelper.printSearchControls(cons));
                    begin = System.currentTimeMillis();
                    results = this.context.search(name, filterExpr, filterArgs, cons);
                    if (ne != null) break block6;
                }
                catch (NamingException e) {
                    try {
                        ne = e;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (ne == null) {
                            this.traceJndiReturn("search(Name,String,Object[],SearchControls)", System.currentTimeMillis() - begin, results);
                        } else {
                            this.traceJndiThrow("search(Name,String,Object[],SearchControls)", System.currentTimeMillis() - begin, ne);
                        }
                        throw throwable;
                    }
                }
                this.traceJndiReturn("search(Name,String,Object[],SearchControls)", System.currentTimeMillis() - begin, results);
                break block7;
            }
            this.traceJndiThrow("search(Name,String,Object[],SearchControls)", System.currentTimeMillis() - begin, ne);
        }
        return results;
    }

    @FFDCIgnore(value={NamingException.class})
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, SearchControls cons) throws NamingException {
        NamingEnumeration<SearchResult> results;
        block7: {
            NamingException ne;
            long begin;
            block6: {
                String METHODNAME = "search(Name,String,SearchControls)";
                begin = 0L;
                ne = null;
                results = null;
                try {
                    this.traceJndiBegin("search(Name,String,SearchControls)", name, filterExpr, LdapHelper.printSearchControls(cons));
                    begin = System.currentTimeMillis();
                    results = this.context.search(name, filterExpr, cons);
                    if (ne != null) break block6;
                }
                catch (NamingException e) {
                    try {
                        ne = e;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (ne == null) {
                            this.traceJndiReturn("search(Name,String,SearchControls)", System.currentTimeMillis() - begin, results);
                        } else {
                            this.traceJndiThrow("search(Name,String,SearchControls)", System.currentTimeMillis() - begin, ne);
                        }
                        throw throwable;
                    }
                }
                this.traceJndiReturn("search(Name,String,SearchControls)", System.currentTimeMillis() - begin, results);
                break block7;
            }
            this.traceJndiThrow("search(Name,String,SearchControls)", System.currentTimeMillis() - begin, ne);
        }
        return results;
    }

    @FFDCIgnore(value={NamingException.class})
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, SearchControls cons) throws NamingException {
        NamingEnumeration<SearchResult> results;
        block7: {
            NamingException ne;
            long begin;
            block6: {
                String METHODNAME = "search(String,String,SearchControls)";
                begin = 0L;
                ne = null;
                results = null;
                try {
                    this.traceJndiBegin("search(String,String,SearchControls)", name, filterExpr, cons);
                    begin = System.currentTimeMillis();
                    results = this.context.search(name, filterExpr, cons);
                    if (ne != null) break block6;
                }
                catch (NamingException e) {
                    try {
                        ne = e;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (ne == null) {
                            this.traceJndiReturn("search(String,String,SearchControls)", System.currentTimeMillis() - begin, results);
                        } else {
                            this.traceJndiThrow("search(String,String,SearchControls)", System.currentTimeMillis() - begin, ne);
                        }
                        throw throwable;
                    }
                }
                this.traceJndiReturn("search(String,String,SearchControls)", System.currentTimeMillis() - begin, results);
                break block7;
            }
            this.traceJndiThrow("search(String,String,SearchControls)", System.currentTimeMillis() - begin, ne);
        }
        return results;
    }

    public void setCreateTimestamp(long createTimestamp) {
        this.iCreateTimestampSeconds = createTimestamp;
    }

    public void setPoolTimeStamp(long poolTimestamp) {
        this.iPoolTimestampSeconds = poolTimestamp;
    }

    @FFDCIgnore(value={NamingException.class})
    public void setRequestControls(Control[] requestControls) throws NamingException {
        String METHODNAME = "setRequestControls(Control[])";
        long begin = 0L;
        NamingException ne = null;
        try {
            this.traceJndiBegin("setRequestControls(Control[])", requestControls);
            begin = System.currentTimeMillis();
            this.context.setRequestControls(requestControls);
        }
        catch (NamingException e) {
            ne = e;
            throw e;
        }
        finally {
            if (ne == null) {
                this.traceJndiReturn("setRequestControls(Control[])", System.currentTimeMillis() - begin, new Object[0]);
            } else {
                this.traceJndiThrow("setRequestControls(Control[])", System.currentTimeMillis() - begin, ne);
            }
        }
    }

    private void traceJndiBegin(String methodname, Object ... objs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String providerURL = "UNKNOWN";
            try {
                providerURL = (String)this.getEnvironment().get("java.naming.provider.url");
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            Tr.debug((TraceComponent)tc, (String)(JNDI_CALL + methodname + " [" + providerURL + "]"), (Object[])objs);
        }
    }

    private void traceJndiReturn(String methodname, long duration, Object ... objs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(JNDI_CALL + methodname + " [" + duration + " ms]"), (Object[])objs);
        }
    }

    private void traceJndiThrow(String methodname, long duration, NamingException ne) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(JNDI_CALL + methodname + " [" + duration + " ms] " + ne.getMessage()), (Object[])new Object[]{ne});
        }
    }

    public String toString() {
        return super.toString() + "{iProviderURL=" + this.iProviderURL + ", iCreateTimestampSeconds=" + this.iCreateTimestampSeconds + ", iPoolTimeStampSeconds=" + this.iPoolTimestampSeconds + "}";
    }
}

