/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics23.writer;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.metrics.writer.PrometheusMetricWriter;
import com.ibm.ws.microprofile.metrics23.helper.PrometheusBuilder23;
import com.ibm.ws.microprofile.metrics23.writer.OutputWriter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Timer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PrometheusMetricWriter23
extends PrometheusMetricWriter
implements OutputWriter {
    private static final TraceComponent tc = Tr.register(PrometheusMetricWriter23.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    static final long serialVersionUID = -2055724109383628261L;

    public PrometheusMetricWriter23(Writer writer, Locale locale) {
        super(writer, locale);
    }

    @Override
    protected void writeMetricMapAsPrometheus(StringBuilder builder, String registryName, Map<MetricID, Metric> metricMap, Map<String, Metadata> metricMetadataMap) {
        for (Map.Entry<MetricID, Metric> entry : metricMap.entrySet()) {
            Metric metric = entry.getValue();
            MetricID metricID = entry.getKey();
            String metricName = metricID.getName();
            String metricNamePrometheus = registryName + "_" + metricName;
            Metadata metricMetaData = metricMetadataMap.get(metricName);
            String description = "";
            description = !metricMetaData.getDescription().isPresent() || ((String)metricMetaData.getDescription().get()).trim().isEmpty() ? "" : Tr.formatMessage((TraceComponent)tc, (Locale)this.locale, (String)((String)metricMetaData.getDescription().get()), (Object[])new Object[0]);
            String tags = metricID.getTagsAsString();
            String unit = (String)metricMetaData.getUnit().get();
            double conversionFactor = 0.0;
            String appendUnit = null;
            if (unit == null || unit.trim().isEmpty() || unit.equals("none")) {
                conversionFactor = Double.NaN;
                appendUnit = null;
            } else if (unit.equals("nanoseconds")) {
                conversionFactor = 1.0E-9;
                appendUnit = "_seconds";
            } else if (unit.equals("microseconds")) {
                conversionFactor = 1.0E-6;
                appendUnit = "_seconds";
            } else if (unit.equals("seconds")) {
                conversionFactor = 1.0;
                appendUnit = "_seconds";
            } else if (unit.equals("minutes")) {
                conversionFactor = 60.0;
                appendUnit = "_seconds";
            } else if (unit.equals("hours")) {
                conversionFactor = 3600.0;
                appendUnit = "_seconds";
            } else if (unit.equals("days")) {
                conversionFactor = 86400.0;
                appendUnit = "_seconds";
            } else if (unit.equals("percent")) {
                conversionFactor = Double.NaN;
                appendUnit = "_percent";
            } else if (unit.equals("bytes")) {
                conversionFactor = 1.0;
                appendUnit = "_bytes";
            } else if (unit.equals("kilobytes")) {
                conversionFactor = 1024.0;
                appendUnit = "_bytes";
            } else if (unit.equals("megabytes")) {
                conversionFactor = 1048576.0;
                appendUnit = "_bytes";
            } else if (unit.equals("gigabytes")) {
                conversionFactor = 1.073741824E9;
                appendUnit = "_bytes";
            } else if (unit.equals("kilobits")) {
                conversionFactor = 125.0;
                appendUnit = "_bytes";
            } else if (unit.equals("megabits")) {
                conversionFactor = 125000.0;
                appendUnit = "_bytes";
            } else if (unit.equals("gigabits")) {
                conversionFactor = 1.25E8;
                appendUnit = "_bytes";
            } else if (unit.equals("kibibits")) {
                conversionFactor = 128.0;
                appendUnit = "_bytes";
            } else if (unit.equals("mebibits")) {
                conversionFactor = 131072.0;
                appendUnit = "_bytes";
            } else if (unit.equals("gibibits")) {
                conversionFactor = 1.342E8;
                appendUnit = "_bytes";
            } else if (unit.equals("milliseconds")) {
                conversionFactor = 0.001;
                appendUnit = "_seconds";
            } else {
                conversionFactor = Double.NaN;
                appendUnit = "_" + unit;
            }
            if (Counter.class.isInstance(metric)) {
                PrometheusBuilder23.buildCounter(builder, metricNamePrometheus, (Counter)metric, description, tags);
                continue;
            }
            if (ConcurrentGauge.class.isInstance(metric)) {
                PrometheusBuilder23.buildConcurrentGauge(builder, metricNamePrometheus, (ConcurrentGauge)metric, description, tags);
                continue;
            }
            if (Gauge.class.isInstance(metric)) {
                PrometheusBuilder23.buildGauge(builder, metricNamePrometheus, (Gauge)metric, description, conversionFactor, tags, appendUnit);
                continue;
            }
            if (Timer.class.isInstance(metric)) {
                PrometheusBuilder23.buildTimer(builder, metricNamePrometheus, (Timer)metric, description, tags);
                continue;
            }
            if (Histogram.class.isInstance(metric)) {
                PrometheusBuilder23.buildHistogram(builder, metricNamePrometheus, (Histogram)metric, description, conversionFactor, tags, appendUnit);
                continue;
            }
            if (Meter.class.isInstance(metric)) {
                PrometheusBuilder23.buildMeter(builder, metricNamePrometheus, (Meter)metric, description, tags);
                continue;
            }
            if (SimpleTimer.class.isInstance(metric)) {
                PrometheusBuilder23.buildSimpleTimer(builder, metricNamePrometheus, (SimpleTimer)metric, description, tags);
                continue;
            }
            Tr.event((TraceComponent)tc, (String)("Metric type '" + metric.getClass() + " for " + metricName + " is invalid."), (Object[])new Object[0]);
        }
    }
}

