/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility.tasks;

import com.ibm.ws.jbatch.utility.rest.BatchRestClient;
import com.ibm.ws.jbatch.utility.rest.PollingBatchClient;
import com.ibm.ws.jbatch.utility.tasks.BaseBatchRestTask;
import com.ibm.ws.jbatch.utility.utils.ArgumentRequiredException;
import com.ibm.ws.jbatch.utility.utils.ConsoleWrapper;
import com.ibm.ws.jbatch.utility.utils.TaskIO;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;

public class StatusTask
extends BaseBatchRestTask<StatusTask> {
    public StatusTask(String scriptName) {
        super("status", scriptName);
    }

    @Override
    public int handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws Exception {
        this.setTaskIO(new TaskIO(stdin, stdout, stderr));
        this.setTaskArgs(args);
        BatchRestClient batchRestClient = this.getBatchRestClient();
        JobInstance jobInstance = batchRestClient.getJobInstance(this.resolveJobInstanceId());
        List<JobExecution> jobExecutions = batchRestClient.getJobExecutions(jobInstance);
        return this.handleResult(jobInstance, jobExecutions);
    }

    protected int handleResult(JobInstance jobInstance, List<JobExecution> jobExecutions) {
        this.issueJobInstanceMessage(jobInstance);
        for (JobExecution jobExecution : jobExecutions) {
            this.issueJobExecutionMessage(jobExecution);
        }
        JobExecution latestJobExecution = PollingBatchClient.getLatestJobExecution(jobExecutions);
        return latestJobExecution != null ? this.getBatchStatusReturnCode(latestJobExecution.getBatchStatus()) : 0;
    }

    protected Long getJobExecutionId() {
        return this.getTaskArgs().getLongValue("--jobExecutionId", null);
    }

    protected Long getJobInstanceId() {
        return this.getTaskArgs().getLongValue("--jobInstanceId", null);
    }

    protected long resolveJobInstanceId() throws IOException {
        Long jobInstanceId = this.getJobInstanceId();
        Long jobExecutionId = this.getJobExecutionId();
        if (jobInstanceId != null) {
            return jobInstanceId;
        }
        if (jobExecutionId != null) {
            return this.getBatchRestClient().getJobInstanceForJobExecution(jobExecutionId).getInstanceId();
        }
        throw new ArgumentRequiredException("--jobInstanceId or --jobExecutionId");
    }
}

