/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility.utils;

import com.ibm.ws.jbatch.utility.utils.ArgumentRequiredException;
import com.ibm.ws.jbatch.utility.utils.ConsoleWrapper;
import com.ibm.ws.jbatch.utility.utils.InvalidArgumentValueException;
import com.ibm.ws.jbatch.utility.utils.ResourceBundleUtils;
import com.ibm.ws.jbatch.utility.utils.StringUtils;
import com.ibm.ws.jbatch.utility.utils.TaskIO;
import com.ibm.ws.jbatch.utility.utils.UnrecognizedArgumentException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ControlPropsTaskArgs
extends Properties {
    private Properties jobParameters = new Properties();
    private boolean jobParametersFileInCmd = false;
    private boolean jobPropertiesFileInCmd = false;
    private static final List<String> boolContProps = Arrays.asList("--trustSslCertificates", "--stopOnShutdown", "--returnExitStatus", "--wait", "--getJobLog", "--verbose");

    public ControlPropsTaskArgs(String[] args) throws IOException {
        String contPropsFile = "";
        for (String arg : args) {
            String argname = this.parseArgName(arg);
            if (argname.equalsIgnoreCase("--controlPropertiesFile")) {
                contPropsFile = this.parseArgValue(arg);
                continue;
            }
            if (argname.equalsIgnoreCase("--jobParametersFile")) {
                this.jobParametersFileInCmd = true;
                continue;
            }
            if (!argname.equalsIgnoreCase("--jobPropertiesFile")) continue;
            this.jobPropertiesFileInCmd = true;
        }
        if (contPropsFile.length() > 0) {
            this.parseControlPropsFile(contPropsFile);
        }
        this.parseArgs(args);
        this.jobParameters = this.resolveJobParameters();
    }

    protected Properties parseArgs(String[] args) {
        for (String arg : args) {
            this.processArg(this.parseArgName(arg), this.parseArgValue(arg));
        }
        return this;
    }

    protected void processArg(String argName, String argValue) {
        if ("--jobParameter".equalsIgnoreCase(argName)) {
            this.processJobParameter(argValue);
        } else if ("--jobParametersFile".equalsIgnoreCase(argName)) {
            this.setProperty(argName, argValue);
        } else if ("--jobPropertiesFile".equalsIgnoreCase(argName) && !this.jobParametersFileInCmd) {
            this.remove("--jobParametersFile");
            this.setProperty(argName, argValue);
        } else if (argValue == null) {
            this.setProperty(argName, argName);
        } else {
            this.setProperty(argName, argValue);
        }
    }

    protected void processJobParameter(String jobParameter) {
        if (StringUtils.isEmpty(jobParameter) || this.parseArgValue(jobParameter) == null) {
            throw new InvalidArgumentValueException("--jobParameter", jobParameter, Arrays.asList("--jobParameter=[key]=[value]"));
        }
        this.jobParameters.setProperty(this.parseArgName(jobParameter), this.parseArgValue(jobParameter));
    }

    public synchronized Properties getJobParameters() {
        return this.jobParameters;
    }

    public boolean isSpecified(String argName) {
        return this.containsKey(argName);
    }

    public void parseControlPropsFile(String path) throws IOException {
        String[] files;
        Properties temp = new Properties();
        for (String value : files = path.split(",")) {
            File propsFile;
            if (value.length() <= 0 || (propsFile = this.getFileFromValue(value)) == null) continue;
            FileInputStream is = new FileInputStream(propsFile);
            try {
                temp.load(is);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                ((InputStream)is).close();
            }
            if (temp.containsKey("--jobParametersFile") && temp.containsKey("--jobPropertiesFile")) {
                temp.remove("--jobPropertiesFile");
                this.remove("--jobParametersFile");
                this.remove("--jobPropertiesFile");
            } else if (temp.containsKey("--jobParametersFile")) {
                this.remove("--jobParametersFile");
                this.remove("--jobPropertiesFile");
            } else if (temp.containsKey("--jobPropertiesFile")) {
                this.remove("--jobParametersFile");
                this.remove("--jobPropertiesFile");
            }
            this.putAll((Map<?, ?>)temp);
        }
        Enumeration<?> keys = this.propertyNames();
        while (keys.hasMoreElements()) {
            String tmpKey = (String)keys.nextElement();
            String tmpValue = this.getProperty(tmpKey);
            this.remove(tmpKey);
            tmpValue = tmpValue.trim();
            tmpKey = tmpKey.trim();
            if (this.isBooleanControlProp(tmpKey)) {
                this.put(tmpKey, tmpKey);
                continue;
            }
            this.put(tmpKey, tmpValue);
        }
    }

    public boolean isBooleanControlProp(String tmpKey) {
        return boolContProps.contains(tmpKey);
    }

    public Properties getControlPropsInlineJobParameters(String path) throws IOException {
        String[] files;
        Properties retMe = new Properties();
        for (String value : files = path.split(",")) {
            String line;
            File propsFile;
            if (value.length() <= 0 || (propsFile = this.getFileFromValue(value)) == null) continue;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(propsFile), Charset.defaultCharset()));
            while ((line = br.readLine()) != null) {
                if (this.parseArgName(line).compareTo("--jobParameter") != 0) continue;
                retMe.setProperty(this.parseArgName(this.parseArgValue(line)), this.parseArgValue(this.parseArgValue(line)));
            }
            br.close();
        }
        Enumeration<?> keys = retMe.propertyNames();
        while (keys.hasMoreElements()) {
            String tmpKey = (String)keys.nextElement();
            String tmpValue = retMe.getProperty(tmpKey);
            retMe.remove(tmpKey);
            tmpValue = tmpValue.trim();
            tmpKey = tmpKey.trim();
            retMe.put(tmpKey, tmpValue);
        }
        return retMe;
    }

    public Properties getJobPropsFileProps(String key) throws IOException {
        Properties retMe = new Properties();
        String unsplit = this.getProperty(key);
        if (unsplit != null) {
            String[] files;
            for (String value : files = unsplit.split(",")) {
                File propsFile;
                if (value.length() <= 0 || (propsFile = this.getFileFromValue(value)) == null) continue;
                FileInputStream is = new FileInputStream(propsFile);
                try {
                    retMe.load(is);
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            Enumeration<?> keys = retMe.propertyNames();
            while (keys.hasMoreElements()) {
                String tmpKey = (String)keys.nextElement();
                String tmpValue = retMe.getProperty(tmpKey);
                retMe.remove(tmpKey);
                tmpValue = tmpValue.trim();
                tmpKey = tmpKey.trim();
                retMe.put(tmpKey, tmpValue);
            }
        }
        return retMe;
    }

    public Properties resolveJobParameters() throws IOException {
        Properties fileProps = new Properties();
        if (this.jobParametersFileInCmd || this.jobPropertiesFileInCmd) {
            if (this.isSpecified("--controlPropertiesFile")) {
                fileProps.putAll((Map<?, ?>)this.getControlPropsInlineJobParameters(this.getProperty("--controlPropertiesFile")));
            }
            if (this.isSpecified("--jobParametersFile")) {
                fileProps.putAll((Map<?, ?>)this.getJobPropsFileProps("--jobParametersFile"));
            } else if (this.isSpecified("--jobPropertiesFile")) {
                fileProps.putAll((Map<?, ?>)this.getJobPropsFileProps("--jobPropertiesFile"));
            }
        } else {
            if (this.isSpecified("--jobParametersFile")) {
                fileProps.putAll((Map<?, ?>)this.getJobPropsFileProps("--jobParametersFile"));
            } else if (this.isSpecified("--jobPropertiesFile")) {
                fileProps.putAll((Map<?, ?>)this.getJobPropsFileProps("--jobPropertiesFile"));
            }
            if (this.isSpecified("--controlPropertiesFile")) {
                fileProps.putAll((Map<?, ?>)this.getControlPropsInlineJobParameters(this.getProperty("--controlPropertiesFile")));
            }
        }
        fileProps.putAll((Map<?, ?>)this.getJobParameters());
        if (this.isSpecified("--verbose")) {
            this.printControlProps(fileProps);
        }
        return fileProps;
    }

    public void printControlProps(Properties fileProps) {
        String printme = "";
        StringBuffer printmebuf = new StringBuffer();
        printmebuf.append("\n{");
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            if (entry.getKey().toString().equals("--password")) {
                printmebuf.append(entry.getKey().toString() + "=XXXX\n");
                continue;
            }
            if (entry.getKey().toString().equals("--jobParameter")) continue;
            printmebuf.append(entry.getKey().toString());
            if (entry.getValue() != null) {
                printmebuf.append("=" + entry.getValue().toString());
            }
            printmebuf.append("\n");
        }
        printme = printmebuf.toString();
        printme = printme.substring(0, printme.length() - 1);
        printme = printme + "}";
        TaskIO taskIO = new TaskIO(null, System.out, null);
        taskIO.info(ResourceBundleUtils.getMessage("control.props.vals", printme));
        StringBuffer printmebuf2 = new StringBuffer();
        printmebuf2.append("\n{");
        for (Map.Entry<Object, Object> entry : fileProps.entrySet()) {
            printmebuf2.append(entry.getKey());
            if (entry.getValue() != null) {
                printmebuf2.append("=" + entry.getValue().toString());
            }
            printmebuf2.append("\n");
        }
        printme = printmebuf2.toString();
        printme = printme.substring(0, printme.length() - 1);
        printme = printme + "}";
        taskIO.info(ResourceBundleUtils.getMessage("job.parms.vals", printme));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRestartTokenFileValue(String name, String value) throws IOException {
        File restartFile = this.getFileValue(name);
        if (restartFile != null) {
            try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(restartFile, false));){
                StringBuffer sb = new StringBuffer("restartJob=").append(value);
                dos.writeBytes(sb.toString());
                dos.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRestartTokenFromFile(String name) throws IOException {
        File restartFile = this.getFileValue(name);
        if (restartFile != null) {
            try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(restartFile, false));){
                dos.writeBytes("");
            }
        }
    }

    public void validateExpectedArgs(Collection<String> expectedArgs) {
        for (Object key : this.keySet()) {
            if (expectedArgs.contains((String)key)) continue;
            this.handleUnexpectedArg(expectedArgs, (String)key);
        }
    }

    protected void handleUnexpectedArg(Collection<String> expectedArgs, String unexpectedArg) {
        if (expectedArgs.contains("-" + unexpectedArg)) {
            throw new UnrecognizedArgumentException(unexpectedArg, "-" + unexpectedArg);
        }
        if (!unexpectedArg.startsWith("internal-")) {
            throw new UnrecognizedArgumentException(unexpectedArg);
        }
    }

    public String verifyStringValue(String argName, List<String> permittedValues, String defaultValue) {
        String argValue = this.getStringValue(argName);
        if (StringUtils.isEmpty(argValue)) {
            return defaultValue;
        }
        if (permittedValues.contains(argValue)) {
            return argValue;
        }
        throw new InvalidArgumentValueException(argName, argValue, permittedValues);
    }

    protected String parseArgName(String arg) {
        int idx = arg.indexOf("=");
        return idx >= 0 ? arg.substring(0, idx) : arg;
    }

    protected String parseArgValue(String arg) {
        int idx = arg.indexOf("=");
        return idx >= 0 ? arg.substring(idx + 1) : null;
    }

    public Long getLongValue(String argName, Long defaultValue) {
        String val = this.getStringValue(argName);
        return val != null ? new Long(val) : defaultValue;
    }

    public Long getRequiredLongValue(String argName) {
        Long retMe = this.getLongValue(argName, null);
        if (retMe == null) {
            throw new ArgumentRequiredException(argName);
        }
        return retMe;
    }

    public String getRequiredString(String argName) {
        String retMe = this.getStringValue(argName);
        if (StringUtils.isEmpty(retMe)) {
            throw new ArgumentRequiredException(argName);
        }
        return retMe;
    }

    public Integer getIntValue(String argName, Integer defaultValue) {
        String val = this.getStringValue(argName);
        return val != null ? new Integer(val) : defaultValue;
    }

    public String getOrPromptForMaskedValue(String argName, ConsoleWrapper console, String prompt) {
        String retMe = this.getStringValue(argName);
        if (retMe == null) {
            retMe = console.readMaskedText(prompt);
            this.put(argName, retMe);
        }
        return retMe;
    }

    public String getStringValue(String argName) {
        return (String)this.get(argName);
    }

    public File getFileFromValue(String value) {
        String fileName = value;
        return StringUtils.isEmpty(fileName) ? null : new File(fileName);
    }

    public File getFileValue(String key) {
        String fileName = this.getProperty(key);
        return StringUtils.isEmpty(fileName) ? null : new File(fileName);
    }
}

