/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi31;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.openapi.impl.parser.OpenAPIParser;
import com.ibm.ws.microprofile.openapi.impl.parser.core.models.SwaggerParseResult;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.openapi31.OpenAPIWebProvider;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.openapi31.OASProvider;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.OpenAPI;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OASProviderWrapper {
    private static final TraceComponent tc = Tr.register(OASProviderWrapper.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi31.resources.OpenAPIMessages");
    private final OASProvider provider;
    private final boolean isWebProvider;
    private Boolean isValid = null;
    private OpenAPI document = null;
    private final Set<String> jsonPathKeys = new HashSet<String>();
    static final long serialVersionUID = 963463828179679367L;

    public OASProviderWrapper(OASProvider provider) {
        this.provider = provider;
        this.isWebProvider = provider instanceof OpenAPIWebProvider;
    }

    public OASProvider getOpenAPIProvider() {
        return this.provider;
    }

    public synchronized OpenAPI getOpenAPI() {
        String openAPIString;
        if (this.document != null) {
            return this.document;
        }
        OpenAPI doc = this.provider.getOpenAPIModel();
        if (doc == null && (openAPIString = this.provider.getOpenAPIDocument()) != null && !openAPIString.isEmpty()) {
            try {
                SwaggerParseResult result = new OpenAPIParser().readContents(openAPIString, null, null, null);
                if (result != null && result.getOpenAPI() != null) {
                    doc = result.getOpenAPI();
                }
            }
            catch (Exception result) {
                FFDCFilter.processException((Throwable)result, (String)"com.ibm.ws.openapi31.OASProviderWrapper", (String)"64", (Object)this, (Object[])new Object[0]);
                Tr.error((TraceComponent)tc, (String)"OPENAPI_FILE_PARSE_ERROR", (Object[])new Object[]{this.provider.getContextRoot()});
            }
        }
        if (doc == null && !(this.provider instanceof OpenAPIWebProvider)) {
            Tr.warning((TraceComponent)tc, (String)"OPENAPI_IS_NULL", (Object[])new Object[]{this.provider});
        }
        this.document = doc;
        return this.document;
    }

    public Set<String> getJsonPathKeys() {
        return this.jsonPathKeys;
    }

    public boolean getIsWebProvider() {
        return this.isWebProvider;
    }

    public boolean isPublic() {
        return this.provider.isPublic();
    }

    public String getContextRoot() {
        return this.provider.getContextRoot();
    }

    public synchronized boolean validate() {
        if (this.isValid == null) {
            this.validateDocument(this.document);
        }
        return this.isValid;
    }

    @Trivial
    private void validateDocument(OpenAPI document) {
        this.isValid = true;
        OASValidator validator = new OASValidator();
        OASValidationResult result = validator.validate(document);
        StringBuilder sbError = new StringBuilder();
        StringBuilder sbWarnings = new StringBuilder();
        if (result.hasEvents()) {
            String warnings;
            result.getEvents().stream().forEach(v -> {
                String message = ValidatorUtils.formatMessage((String)"validationMessage", (String[])new String[]{v.message, v.location});
                if (v.severity == OASValidationResult.ValidationEvent.Severity.ERROR) {
                    sbError.append("\n - " + message);
                } else if (v.severity == OASValidationResult.ValidationEvent.Severity.WARNING) {
                    sbWarnings.append("\n - " + message);
                }
            });
            String errors = sbError.toString();
            if (!errors.isEmpty()) {
                this.isValid = false;
                Tr.error((TraceComponent)tc, (String)"OPENAPI_DOCUMENT_VALIDATION_ERROR", (Object[])new Object[]{errors + "\n"});
            }
            if (!(warnings = sbWarnings.toString()).isEmpty()) {
                Tr.warning((TraceComponent)tc, (String)"OPENAPI_DOCUMENT_VALIDATION_WARNING", (Object[])new Object[]{warnings + "\n"});
            }
        }
    }
}

