/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.cxf.validator;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.cache.ReplayCacheFactory;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.UsernameToken;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.cache.ReplayCache;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Utils {
    private static final TraceComponent tc = Tr.register(Utils.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    static final long serialVersionUID = 754683423761430230L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReplayCache getReplayCache(@Sensitive SoapMessage message, String booleanKey, String instanceKey) {
        boolean specified = false;
        Object o = message.getContextualProperty(booleanKey);
        if (o != null) {
            if (!MessageUtils.isTrue((Object)o)) {
                return null;
            }
            specified = true;
        }
        if (!specified && MessageUtils.isRequestor((Message)message)) {
            return null;
        }
        Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
        if (ep != null && ep.getEndpointInfo() != null) {
            EndpointInfo info;
            EndpointInfo endpointInfo = info = ep.getEndpointInfo();
            synchronized (endpointInfo) {
                ReplayCache replayCache = (ReplayCache)message.getContextualProperty(instanceKey);
                if (replayCache == null) {
                    replayCache = (ReplayCache)info.getProperty(instanceKey);
                }
                if (replayCache == null) {
                    ReplayCacheFactory replayCacheFactory = ReplayCacheFactory.newInstance();
                    String cacheKey = instanceKey;
                    if (info.getName() != null) {
                        cacheKey = cacheKey + "-" + info.getName().toString().hashCode();
                    }
                    replayCache = replayCacheFactory.newReplayCache(cacheKey, (Message)message);
                    info.setProperty(instanceKey, (Object)replayCache);
                }
                return replayCache;
            }
        }
        return null;
    }

    public static boolean checkPolicyNoPassword(@Sensitive SoapMessage message) throws WSSecurityException {
        boolean bRet = false;
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        Collection ais = aim.getAssertionInfo(SP12Constants.USERNAME_TOKEN);
        UsernameToken tok = null;
        for (AssertionInfo ai : ais) {
            tok = (UsernameToken)ai.getAssertion();
            if (!tok.isNoPassword()) continue;
            bRet = true;
        }
        return bRet;
    }

    /*
     * WARNING - void declaration
     */
    @Sensitive
    public static Crypto getCrypto(Properties cryptoProps) {
        Crypto crypto;
        block3: {
            crypto = null;
            try {
                if (cryptoProps != null) {
                    crypto = CryptoFactory.getInstance((Properties)cryptoProps);
                }
            }
            catch (WSSecurityException wSSecurityException) {
                void e;
                FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.wssecurity.cxf.validator.Utils", (String)"117", null, (Object[])new Object[]{cryptoProps});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("cannot create a Crypto, please double check the key properties (" + e + ")"), (Object[])new Object[0]);
            }
        }
        return crypto;
    }

    @Sensitive
    public static String changePasswordType(SerializableProtectedString protectedString) {
        char[] password_array;
        String clearString = null;
        if (protectedString != null && (password_array = protectedString.getChars()).length > 0) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < password_array.length; ++i) {
                buf.append(password_array[i]);
            }
            clearString = PasswordUtil.passwordDecode((String)buf.toString());
        }
        return clearString;
    }

    @Sensitive
    public static void modifyConfigMap(Map<String, Object> configMap) {
        String pwd;
        if (configMap.containsKey("ws-security.password")) {
            pwd = Utils.changePasswordType((SerializableProtectedString)configMap.get("ws-security.password"));
            configMap.put("ws-security.password", pwd);
        }
        if (configMap.containsKey("org.apache.ws.security.crypto.merlin.keystore.private.password")) {
            pwd = Utils.changePasswordType((SerializableProtectedString)configMap.get("org.apache.ws.security.crypto.merlin.keystore.private.password"));
            configMap.put("org.apache.ws.security.crypto.merlin.keystore.private.password", pwd);
        }
        if (configMap.containsKey("org.apache.ws.security.crypto.merlin.keystore.password")) {
            pwd = Utils.changePasswordType((SerializableProtectedString)configMap.get("org.apache.ws.security.crypto.merlin.keystore.password"));
            configMap.put("org.apache.ws.security.crypto.merlin.keystore.password", pwd);
        }
        if (configMap.containsKey("org.apache.ws.security.crypto.merlin.truststore.password")) {
            pwd = Utils.changePasswordType((SerializableProtectedString)configMap.get("org.apache.ws.security.crypto.merlin.truststore.password"));
            configMap.put("org.apache.ws.security.crypto.merlin.truststore.password", pwd);
        }
    }
}

