/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.injectionengine;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.injectionengine.InternalInjectionEngine;
import com.ibm.ws.injectionengine.ffdc.Formattable;
import com.ibm.ws.javaee.dd.common.Property;
import com.ibm.wsspi.injectionengine.ClientInjectionTarget;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionEngineAccessor;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionProcessorContext;
import com.ibm.wsspi.injectionengine.InjectionScope;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.injectionengine.InjectionTargetContext;
import com.ibm.wsspi.injectionengine.InjectionTargetField;
import com.ibm.wsspi.injectionengine.InjectionTargetMethod;
import com.ibm.wsspi.injectionengine.InjectionTargetMultiParamMethod;
import com.ibm.wsspi.injectionengine.JNDIEnvironmentRefType;
import com.ibm.wsspi.injectionengine.RecursiveInjectionException;
import com.ibm.wsspi.injectionengine.factory.InjectionObjectFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public abstract class InjectionBinding<A extends Annotation>
implements Formattable {
    private static final String CLASS_NAME = InjectionBinding.class.getName();
    private static final TraceComponent tc = Tr.register(InjectionBinding.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");
    private InjectionProcessorContext ivContext;
    Class<?> ivProcessorClass;
    private String ivJndiName;
    private InjectionScope ivInjectionScope;
    private String ivJavaNameSpaceName;
    private A ivAnnotation;
    private Class<?> ivInjectionClassType;
    private String ivInjectionClassTypeName;
    private Object ivInjectedObject;
    private Object ivBindingObject;
    private String ivObjectFactoryClassName;
    private Class<? extends ObjectFactory> ivObjectFactoryClass;
    protected volatile ObjectFactory ivObjectFactory;
    private InjectionObjectFactory ivInjectionObjectFactory;
    List<InjectionTarget> ivInjectionTargets;
    protected J2EEName ivJ2eeName;
    protected ComponentNameSpaceConfiguration ivNameSpaceConfig;
    boolean ivResolveAttempted;
    protected Map<String, InjectionBinding<?>> ivJavaColonCompEnvMap;
    protected boolean ivCheckAppConfig;

    private List<Method> getDeclaredSetMethods(Class<?> clazz, boolean isClient) {
        Map<Class<?>, List<Method>> localCache = this.ivContext.getDeclaredSetMethodCache();
        List<Method> methods = localCache.get(clazz);
        if (methods == null) {
            Method[] declaredMethods;
            methods = new ArrayList<Method>();
            for (Method declared : declaredMethods = clazz.getDeclaredMethods()) {
                int modifier = declared.getModifiers();
                if (Modifier.isStatic(modifier) != isClient || !declared.getName().startsWith("set")) continue;
                methods.add(declared);
            }
            localCache.put(clazz, methods);
        }
        return methods;
    }

    public void metadataProcessingComplete() {
        this.ivInjectionTargets = null;
        this.ivContext = null;
        this.ivNameSpaceConfig = null;
    }

    void metadataProcessingInitialize(ComponentNameSpaceConfiguration nameSpaceConfig) {
        this.ivContext = (InjectionProcessorContext)nameSpaceConfig.getInjectionProcessorContext();
        this.ivNameSpaceConfig = nameSpaceConfig;
        this.ivCheckAppConfig = nameSpaceConfig.isCheckApplicationConfiguration();
    }

    public boolean isComplete() {
        return this.ivNameSpaceConfig == null;
    }

    public InjectionBinding(A annotation, ComponentNameSpaceConfiguration nameSpaceConfig) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<init>: " + Util.identity((Object)this)), (Object[])new Object[0]);
        }
        this.metadataProcessingInitialize(nameSpaceConfig);
        this.ivAnnotation = annotation;
        this.ivJ2eeName = nameSpaceConfig.getJ2EEName();
        this.ivJavaColonCompEnvMap = nameSpaceConfig.getJavaColonCompEnvMap();
        this.ivJndiName = null;
        this.ivInjectionClassType = null;
        this.ivInjectedObject = null;
        this.ivBindingObject = null;
    }

    private void addInjectionTarget(InjectionTarget target) {
        if (this.ivInjectionTargets == null) {
            this.ivInjectionTargets = new ArrayList<InjectionTarget>();
        }
        this.ivInjectionTargets.add(target);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addInjectionTarget(Class<?> injectionType, String targetName, String targetClassName) throws InjectionException {
        InjectionTarget injectionTarget;
        boolean isTraceOn;
        block40: {
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("addInjectionTarget : " + injectionType + ", " + targetName + ", " + targetClassName), (Object[])new Object[0]);
            }
            if (this.ivNameSpaceConfig.getOwningFlow() == ComponentNameSpaceConfiguration.ReferenceFlowKind.CLIENT && this.ivNameSpaceConfig.getClassLoader() == null) {
                this.addInjectionTarget(new ClientInjectionTarget(targetClassName, targetName, this));
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"addInjectionTarget: added client injection target");
                }
                return;
            }
            Field targetField = null;
            Method targetMethod = null;
            Class<?> injectionClass = this.loadClass(targetClassName);
            injectionTarget = null;
            if (targetName == null || targetClassName == null || injectionClass == null) {
                if (targetName != null || injectionType != null || injectionClass != null) {
                    InjectionException iex = new InjectionException("One or more of these argument(s) is null.  " + targetName + " targetName, " + injectionType + " injectionType, " + injectionClass + " injectionClass");
                    Tr.error((TraceComponent)tc, (String)"INCORRECT_OR_NULL_INJECTION_TARGETS_SPECIFIED_CWNEN0023E", (Object[])new Object[]{targetName, injectionType, injectionClass});
                    throw iex;
                }
            } else {
                List<Method> declaredMethods;
                Method primitiveMethod = null;
                ArrayList<Method> compatibleMethods = null;
                boolean isClient = this.ivNameSpaceConfig.isClientMain(injectionClass);
                String setMethodName = InjectionBinding.getMethodFromProperty(targetName);
                Class<?> primitiveClass = InjectionBinding.getPrimitiveClass(injectionType);
                try {
                    declaredMethods = this.getDeclaredSetMethods(injectionClass, isClient);
                }
                catch (LinkageError err) {
                    String message = Tr.formatMessage((TraceComponent)tc, (String)"DECLARED_MEMBER_LINKAGE_ERROR_CWNEN0075E", (Object[])new Object[]{targetClassName, setMethodName, this.getJndiName(), this.ivNameSpaceConfig.getDisplayName(), this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName(), err.toString()});
                    InjectionException ex = new InjectionException(message, err);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"addInjectionTarget", (Object[])new Object[]{ex});
                    }
                    throw ex;
                }
                for (Method method : declaredMethods) {
                    Class<?>[] params;
                    if (!method.getName().equals(setMethodName) || (params = method.getParameterTypes()).length != 1) continue;
                    if (injectionType == null) {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("target method found (compatible) : " + method), (Object[])new Object[0]);
                        }
                        if (compatibleMethods == null) {
                            compatibleMethods = new ArrayList<Method>();
                        }
                        compatibleMethods.add(method);
                        continue;
                    }
                    Class<?> param = params[0];
                    if (param == injectionType) {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("target method found (specific) : " + method), (Object[])new Object[0]);
                        }
                        targetMethod = method;
                        break;
                    }
                    if (param == primitiveClass) {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("target method found (primitive) : " + method), (Object[])new Object[0]);
                        }
                        primitiveMethod = method;
                        continue;
                    }
                    if (!param.isAssignableFrom(injectionType)) continue;
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("target method found (compatible) : " + method), (Object[])new Object[0]);
                    }
                    if (compatibleMethods == null) {
                        compatibleMethods = new ArrayList();
                    }
                    compatibleMethods.add(method);
                }
                if (targetMethod == null) {
                    if (primitiveMethod != null) {
                        targetMethod = primitiveMethod;
                    } else if (compatibleMethods != null) {
                        if (compatibleMethods.size() != 1) {
                            InjectionException iex = new InjectionException("The " + targetName + " injection target property name for the " + this.getJndiName() + " reference is ambiguous in the " + targetClassName + " class.  The " + compatibleMethods.get(0) + " method and the " + compatibleMethods.get(1) + " method are both type compatible with the " + injectionType + " type.");
                            Tr.error((TraceComponent)tc, (String)"AMBIGUOUS_INJECTION_METHODS_CWNEN0061E", (Object[])new Object[]{targetName, this.getJndiName(), targetClassName, compatibleMethods.get(0), compatibleMethods.get(1), injectionType});
                            throw iex;
                        }
                        targetMethod = (Method)compatibleMethods.get(0);
                    }
                }
                if (targetMethod != null) {
                    if (!this.containsTarget(targetMethod)) {
                        injectionTarget = this.createInjectionTarget(targetMethod, this);
                    }
                } else {
                    try {
                        targetField = injectionClass.getDeclaredField(targetName);
                        Class<?> fieldClass = targetField.getType();
                        if (injectionType == null || InjectionBinding.isClassesCompatible(fieldClass, injectionType)) {
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("target field found (compatible) : " + targetField), (Object[])new Object[0]);
                            }
                            if (!this.containsTarget(targetField)) {
                                injectionTarget = new InjectionTargetField(targetField, this);
                            }
                            break block40;
                        }
                        String qualifiedTargetName = injectionClass.getName() + "." + targetName;
                        Tr.warning((TraceComponent)tc, (String)"FIELD_IS_DECLARED_DIFFERENT_THAN_THE_INECTION_TYPE_CWNEN0021W", (Object[])new Object[]{qualifiedTargetName, fieldClass.getName(), injectionType.getName()});
                        if (this.isValidationFailable()) {
                            throw new InjectionConfigurationException("The " + qualifiedTargetName + " field is declared as " + fieldClass.getName() + " but the requested injection type for the field is " + injectionType.getName() + ".");
                        }
                    }
                    catch (NoSuchFieldException e) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".addInjectionTarget"), (String)"254", (Object)this, (Object[])new Object[]{targetClassName, targetName});
                        InjectionException iex = new InjectionException("An injection target for the " + this.getJndiName() + " reference cannot be processed because neither the " + setMethodName + " method nor the " + targetName + " field exist on the " + targetClassName + " class.");
                        Tr.error((TraceComponent)tc, (String)"UNABLE_TO_FIND_THE_MEMBER_SPECIFIED_CWNEN0022E", (Object[])new Object[]{this.getJndiName(), setMethodName, targetName, targetClassName});
                        throw iex;
                    }
                    catch (LinkageError err) {
                        String message = Tr.formatMessage((TraceComponent)tc, (String)"DECLARED_MEMBER_LINKAGE_ERROR_CWNEN0075E", (Object[])new Object[]{targetClassName, targetName, this.getJndiName(), this.ivNameSpaceConfig.getDisplayName(), this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName(), err.toString()});
                        InjectionException ex = new InjectionException(message, err);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"addInjectionTarget", (Object[])new Object[]{ex});
                        }
                        throw ex;
                    }
                }
            }
        }
        if (injectionTarget != null) {
            injectionTarget.setInjectionBinding(this);
            injectionTarget.ivFromXML = true;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("adding injection target : " + injectionTarget), (Object[])new Object[0]);
            }
            this.addInjectionTarget(injectionTarget);
        } else if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"no injection target to add : duplicate or not compatible", (Object[])new Object[0]);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addInjectionTarget : " + this.ivInjectionTargets));
        }
    }

    public void addInjectionClass(Class<?> klass) {
    }

    public void addInjectionTarget(Member member) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addInjectionTarget: " + member), (Object[])new Object[0]);
        }
        boolean containsTarget = false;
        String existingMemberName = null;
        String toAddMemberName = null;
        InjectionTarget injectionTarget = null;
        if (this.ivInjectionTargets != null) {
            for (InjectionTarget target : this.ivInjectionTargets) {
                Member targetMember = target.getMember();
                if (targetMember.equals(member)) {
                    target.ivFromXML = false;
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("found: " + target), (Object[])new Object[0]);
                    }
                    injectionTarget = target;
                    containsTarget = true;
                    break;
                }
                if (targetMember.getDeclaringClass() != member.getDeclaringClass() || !(existingMemberName = targetMember instanceof Method ? targetMember.getName() : InjectionBinding.getMethodFromProperty(targetMember.getName())).equals(toAddMemberName = member instanceof Method ? member.getName() : InjectionBinding.getMethodFromProperty(member.getName()))) continue;
                if (target.ivFromXML) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("removing: " + targetMember.getName()), (Object[])new Object[0]);
                    }
                    this.ivInjectionTargets.remove(target);
                    break;
                }
                Tr.error((TraceComponent)tc, (String)"INJECTION_DECLARED_IN_BOTH_THE_FIELD_AND_METHOD_OF_A_BEAN_CWNEN0056E", (Object[])new Object[]{this.ivJndiName, member.getDeclaringClass().getName(), this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName()});
                throw new InjectionConfigurationException("Injection of the " + this.ivJndiName + " resource was specified for both a property instance variable and its corresponding set method on the " + member.getDeclaringClass().getName() + " class in the " + this.ivNameSpaceConfig.getModuleName() + " module of the " + this.ivNameSpaceConfig.getApplicationName() + " application.");
            }
        }
        if (!containsTarget) {
            injectionTarget = member instanceof Field ? new InjectionTargetField((Field)member, this) : this.createInjectionTarget((Method)member, this);
            injectionTarget.setInjectionBinding(this);
            this.addInjectionTarget(injectionTarget);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addInjectionTarget : " + (containsTarget ? "(duplicate) " : "") + injectionTarget));
        }
    }

    public abstract void merge(A var1, Class<?> var2, Member var3) throws InjectionException;

    protected JNDIEnvironmentRefType getJNDIEnvironmentRefType() {
        throw new UnsupportedOperationException();
    }

    protected void mergeError(Object oldValue, Object newValue, boolean xml, String elementName, boolean property, String key) throws InjectionConfigurationException {
        JNDIEnvironmentRefType refType = this.getJNDIEnvironmentRefType();
        String component = this.ivNameSpaceConfig.getDisplayName();
        String module = this.ivNameSpaceConfig.getModuleName();
        String application = this.ivNameSpaceConfig.getApplicationName();
        String jndiName = this.getJndiName();
        if (xml) {
            Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{component, module, application, elementName, refType.getXMLElementName(), refType.getNameXMLElementName(), jndiName, oldValue, newValue});
        } else {
            Tr.error((TraceComponent)tc, (String)"CONFLICTING_ANNOTATION_VALUES_CWNEN0054E", (Object[])new Object[]{component, module, application, elementName, '@' + refType.getAnnotationShortName(), refType.getNameAnnotationElementName(), jndiName, oldValue, newValue});
        }
        String exMsg = xml ? "The " + component + " component in the " + module + " module of the " + application + " application has conflicting configuration data in the XML deployment descriptor. Conflicting " + elementName + " element values exist for multiple " + refType.getXMLElementName() + " elements with the same " + refType.getNameXMLElementName() + " element value : " + jndiName + ". The conflicting " + elementName + " element values are " + oldValue + " and " + newValue + "." : "The " + component + " component in the " + module + " module of the " + application + " application has conflicting configuration data in source code annotations. Conflicting " + elementName + " attribute values exist for multiple @" + refType.getAnnotationShortName() + " annotations with the same " + refType.getNameAnnotationElementName() + " attribute value : " + jndiName + ". The conflicting " + elementName + " attribute values are " + oldValue + " and " + newValue + ".";
        throw new InjectionConfigurationException(exMsg);
    }

    protected Boolean mergeAnnotationBoolean(Boolean oldValue, boolean oldValueXML, boolean newValue, String elementName, boolean defaultValue) throws InjectionConfigurationException {
        if (newValue == defaultValue || oldValueXML) {
            return oldValue;
        }
        if (this.isComplete()) {
            this.mergeError(oldValue, newValue, false, elementName, false, elementName);
            return oldValue;
        }
        return newValue;
    }

    protected Integer mergeAnnotationInteger(Integer oldValue, boolean oldValueXML, int newValue, String elementName, int defaultValue, Map<Integer, String> valueNames) throws InjectionConfigurationException {
        if (newValue == defaultValue) {
            return oldValue;
        }
        if (oldValueXML) {
            return oldValue;
        }
        if (oldValue == null ? this.isComplete() : !oldValue.equals(newValue)) {
            Integer oldValueName = valueNames == null ? oldValue : valueNames.get(oldValue);
            Integer newValueName = valueNames == null ? Integer.valueOf(newValue) : valueNames.get(newValue);
            this.mergeError(oldValueName, newValueName, false, elementName, false, elementName);
            return oldValue;
        }
        return newValue;
    }

    protected <T> T mergeAnnotationValue(T oldValue, boolean oldValueXML, T newValue, String elementName, T defaultValue) throws InjectionConfigurationException {
        if (newValue.equals(defaultValue) || oldValueXML) {
            return oldValue;
        }
        if (oldValue == null ? this.isComplete() : !newValue.equals(oldValue)) {
            this.mergeError(oldValue, newValue, false, elementName, false, elementName);
            return oldValue;
        }
        return newValue;
    }

    protected void mergeAnnotationPropertyError(String property) throws InjectionConfigurationException {
        JNDIEnvironmentRefType refType = this.getJNDIEnvironmentRefType();
        String component = this.ivNameSpaceConfig.getDisplayName();
        String module = this.ivNameSpaceConfig.getModuleName();
        String application = this.ivNameSpaceConfig.getApplicationName();
        String jndiName = this.getJndiName();
        Tr.error((TraceComponent)tc, (String)"INVALID_ANNOTATION_PROPERTY_CWNEN0066E", (Object[])new Object[]{'@' + refType.getAnnotationShortName(), jndiName, refType.getNameAnnotationElementName(), component, module, application, property});
        String exMsg = "The @" + refType.getAnnotationShortName() + " source code annotation with the " + jndiName + " " + refType.getNameAnnotationElementName() + " attribute for the " + component + " component in the " + module + " module in the " + application + " application has configuration data for the properties attribute that is not valid: " + property;
        throw new InjectionConfigurationException(exMsg);
    }

    protected Map<String, String> mergeAnnotationProperties(Map<String, String> oldProperties, Set<String> oldXMLPropertyNames, String[] newProperties) throws InjectionConfigurationException {
        if (newProperties.length != 0) {
            if (oldProperties == null) {
                oldProperties = new HashMap<String, String>();
            }
            for (String property : newProperties) {
                int index = property.indexOf(61);
                if (index == -1) {
                    this.mergeAnnotationPropertyError(property);
                    continue;
                }
                String name = property.substring(0, index);
                if (oldXMLPropertyNames != null && oldXMLPropertyNames.contains(name)) continue;
                String newValue = property.substring(index + 1);
                String oldValue = oldProperties.get(name);
                if (oldValue == null ? this.isComplete() : !newValue.equals(oldValue)) {
                    this.mergeError(oldValue, newValue, true, name + " property", true, name);
                    continue;
                }
                oldProperties.put(name, newValue);
            }
        }
        return oldProperties;
    }

    protected <T> T mergeXMLValue(T oldValue, T newValue, String elementName, String key, Map<T, String> valueNames) throws InjectionConfigurationException {
        if (newValue == null) {
            return oldValue;
        }
        if (oldValue != null && !newValue.equals(oldValue)) {
            T oldValueName = valueNames == null ? oldValue : valueNames.get(oldValue);
            T newValueName = valueNames == null ? newValue : valueNames.get(newValue);
            this.mergeError(oldValueName, newValueName, true, elementName, false, key);
            return oldValue;
        }
        return newValue;
    }

    protected Map<String, String> mergeXMLProperties(Map<String, String> oldProperties, Set<String> oldXMLProperties, List<Property> properties) throws InjectionConfigurationException {
        if (!properties.isEmpty()) {
            if (oldProperties == null) {
                oldProperties = new HashMap<String, String>();
            }
            for (Property property : properties) {
                String newValue;
                String name = property.getName();
                String oldValue = oldProperties.put(name, newValue = property.getValue());
                if (oldValue != null && !newValue.equals(oldValue)) {
                    this.mergeError(oldValue, newValue, true, name + " property", true, name);
                    continue;
                }
                oldXMLProperties.add(name);
            }
        }
        return oldProperties;
    }

    public void mergeSaved(InjectionBinding<A> injectionBinding) throws InjectionException {
        throw new UnsupportedOperationException();
    }

    protected final <T> void mergeSavedValue(T oldValue, T newValue, String name) throws InjectionConfigurationException {
        if (oldValue == null ? newValue != null : !oldValue.equals(newValue)) {
            Tr.error((TraceComponent)tc, (String)"INCOMPATIBLE_MERGE_ATTRIBUTES_CWNEN0072E", (Object[])new Object[]{this.getJndiName(), name, oldValue, newValue});
            throw new InjectionConfigurationException("The " + this.getJndiName() + " reference has conflicting values for the " + name + " attribute: " + oldValue + " and " + newValue);
        }
    }

    public Class<?> getAnnotationType() {
        return this.ivAnnotation.annotationType();
    }

    protected static <K, V> void addOrRemoveProperty(Map<K, V> props, K key, V value) {
        if (value == null) {
            props.remove(key);
        } else {
            props.put(key, value);
        }
    }

    public Reference createDefinitionReference(String bindingName, String type, Map<String, Object> properties) throws InjectionException {
        Reference ref;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Map<String, Object> traceProps = properties;
            if (traceProps.containsKey("password")) {
                traceProps = new HashMap<String, Object>(properties);
                traceProps.put("password", "********");
            }
            Tr.entry((TraceComponent)tc, (String)("createDefinitionReference: bindingName=" + bindingName + ", type=" + type), (Object[])new Object[]{traceProps});
        }
        try {
            InternalInjectionEngine injectionEngine = (InternalInjectionEngine)InjectionEngineAccessor.getInstance();
            ref = injectionEngine.createDefinitionReference(this.ivNameSpaceConfig, this.ivInjectionScope, this.getJndiName(), bindingName, type, properties);
        }
        catch (Exception ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createDefinitionReference", (Object)ex);
            }
            throw new InjectionException(ex);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createDefinitionReference", (Object)ref);
        }
        return ref;
    }

    public final void setObjects(Object injectionObject, Object bindingObject) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setObjects", (Object[])new Object[]{injectionObject, bindingObject});
        }
        this.ivInjectedObject = injectionObject;
        Object object = this.ivBindingObject = bindingObject != null ? bindingObject : injectionObject;
        if (this.ivBindingObject == null) {
            throw new IllegalArgumentException("expected non-null argument");
        }
    }

    public void setObjects(Object injectionObject, Reference bindingObject) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setObjects", (Object[])new Object[]{injectionObject, this.bindingObjectToString(bindingObject)});
        }
        this.ivInjectedObject = injectionObject;
        if (bindingObject != null) {
            this.ivBindingObject = bindingObject;
            this.ivObjectFactoryClassName = bindingObject.getFactoryClassName();
            if (this.ivObjectFactoryClassName == null) {
                throw new IllegalArgumentException("expected non-null getFactoryClassName");
            }
        } else {
            this.ivBindingObject = injectionObject;
        }
    }

    public void setReferenceObject(Reference bindingObject, Class<? extends ObjectFactory> objectFactory) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setReferenceObject", (Object[])new Object[]{this.bindingObjectToString(bindingObject), objectFactory});
        }
        this.ivInjectedObject = null;
        this.ivBindingObject = bindingObject;
        this.ivObjectFactoryClass = objectFactory;
        this.ivObjectFactoryClassName = objectFactory.getName();
    }

    Object getInjectableObject(Object targetObject, InjectionTargetContext targetContext) throws InjectionException {
        if (this.getInjectionScope() != InjectionScope.COMP) {
            return InjectionEngineAccessor.getInternalInstance().getInjectableObject(this, targetObject, targetContext);
        }
        return this.getInjectionObject(targetObject, targetContext);
    }

    public final Object getInjectionObject() throws InjectionException {
        return this.getInjectionObject(null, null);
    }

    public Object getInjectionObject(Object targetObject, InjectionTargetContext targetContext) throws InjectionException {
        Object retObj;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInjectionObject: " + this.toSimpleString()), (Object[])new Object[0]);
        }
        if ((retObj = this.ivInjectedObject) == null) {
            try {
                retObj = this.getInjectionObjectInstance(targetObject, targetContext);
            }
            catch (RecursiveInjectionException ex) {
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("getInjectionObject: " + ex));
                }
                throw ex;
            }
            catch (Throwable ex) {
                if (targetObject != null) {
                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".getInjectionObject"), (String)"408", (Object)this, (Object[])null);
                }
                String displayName = this.getDisplayName();
                String exMessage = ex.getLocalizedMessage();
                if (exMessage == null) {
                    exMessage = ex.toString();
                }
                String message = Tr.formatMessage((TraceComponent)tc, (String)"FAILED_TO_CREATE_OBJECT_INSTANCE_CWNEN0030E", (Object[])new Object[]{displayName, exMessage});
                InjectionException ex2 = new InjectionException(message, ex);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getInjectionObject", (Object)ex2);
                }
                throw ex2;
            }
            if (retObj == null) {
                String app;
                String module;
                String component;
                if (this.ivJ2eeName != null) {
                    component = this.ivJ2eeName.getComponent();
                    module = this.ivJ2eeName.getModule();
                    app = this.ivJ2eeName.getApplication();
                } else {
                    app = "UNKNOWN";
                    module = "UNKNOWN";
                    component = "UNKNOWN";
                }
                String classTypeName = this.ivInjectionClassType == null ? "UNKNOWN" : this.ivInjectionClassType.getName();
                Tr.error((TraceComponent)tc, (String)"UNABLE_TO_RESOLVE_INJECTION_OBJECT_CWNEN0035E", (Object[])new Object[]{this.getDisplayName(), classTypeName, component, module, app});
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getInjectionObject : failed");
                }
                throw new InjectionException("The " + this.getDisplayName() + " reference of type " + classTypeName + " for the " + component + " component in the " + module + " module of the " + app + " application cannot be resolved.");
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInjectionObject : " + Util.identity((Object)retObj)));
        }
        return retObj;
    }

    protected Object getInjectionObjectInstance(Object targetObject, InjectionTargetContext targetContext) throws Exception {
        ObjectFactory objectFactory = this.ivObjectFactory;
        InjectionObjectFactory injObjFactory = this.ivInjectionObjectFactory;
        if (objectFactory == null) {
            try {
                InternalInjectionEngine ie = InjectionEngineAccessor.getInternalInstance();
                objectFactory = ie.getObjectFactory(this.ivObjectFactoryClassName, this.ivObjectFactoryClass);
                if (objectFactory instanceof InjectionObjectFactory) {
                    this.ivInjectionObjectFactory = injObjFactory = (InjectionObjectFactory)objectFactory;
                }
                this.ivObjectFactory = objectFactory;
            }
            catch (Throwable ex) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getInjectionObjectInstance", (Object[])new Object[]{ex});
                }
                Tr.error((TraceComponent)tc, (String)"OBJECT_FACTORY_CLASS_FAILED_TO_LOAD_CWNEN0024E", (Object[])new Object[]{this.ivObjectFactoryClassName});
                throw new InjectionException(ex.toString(), ex);
            }
        }
        if (injObjFactory != null) {
            return injObjFactory.getInjectionObjectInstance((Reference)this.getBindingObject(), targetObject, targetContext);
        }
        return objectFactory.getObjectInstance(this.getBindingObject(), null, null, null);
    }

    public final Object getBindingObject() {
        return this.ivBindingObject;
    }

    public Object getRemoteObject() throws NamingException {
        return this.ivBindingObject;
    }

    public boolean isResolved() {
        return this.getBindingObject() != null;
    }

    public final A getAnnotation() {
        return this.ivAnnotation;
    }

    public final void setAnnotation(A newAnnotation) {
        this.ivAnnotation = newAnnotation;
    }

    public final void setJndiName(String jndiName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && jndiName.length() != 0) {
            Tr.debug((TraceComponent)tc, (String)("setJndiName: " + jndiName), (Object[])new Object[0]);
        }
        this.ivJndiName = InjectionScope.normalize(jndiName);
    }

    public final String getJndiName() {
        return this.ivJndiName;
    }

    public String getDisplayName() {
        return InjectionScope.denormalize(this.ivJndiName);
    }

    public InjectionScope getInjectionScope() {
        return this.ivInjectionScope == null ? InjectionScope.COMP : this.ivInjectionScope;
    }

    public void setInjectionClassType(Class<?> injectionClassType) throws InjectionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setInjectionClassType: " + injectionClassType), (Object[])new Object[0]);
        }
        if (this.ivInjectionClassType == null || this.ivInjectionClassType == Object.class) {
            this.ivInjectionClassType = injectionClassType;
        } else if (this.ivInjectionClassType.isAssignableFrom(injectionClassType)) {
            this.ivInjectionClassType = injectionClassType;
        } else if (!injectionClassType.isAssignableFrom(this.ivInjectionClassType) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WARNING: Class " + injectionClassType + " is not assignable from " + this.ivInjectionClassType), (Object[])new Object[0]);
        }
    }

    public void setInjectionClassTypeName(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setInjectionClassType: " + name), (Object[])new Object[0]);
        }
        if (this.ivInjectionClassTypeName != null) {
            throw new IllegalStateException("duplicate reference data for " + this.getJndiName());
        }
        this.ivInjectionClassTypeName = name;
    }

    public void setInjectionClassType(Method method) throws InjectionException {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            Tr.error((TraceComponent)tc, (String)"INJECTION_METHOD_MUST_HAVE_ONE_PARAM_CWNEN0069E", (Object[])new Object[]{method.getDeclaringClass().getName(), method.getName(), method.getParameterTypes().length});
            InjectionConfigurationException icex = new InjectionConfigurationException("The injection method " + method.getDeclaringClass().getName() + "." + method.getName() + " must have exactly one parameter, not " + method.getParameterTypes().length + " parameters.");
            throw icex;
        }
        this.setInjectionClassType(parameterTypes[0]);
    }

    public String getInjectionClassTypeName() {
        return this.ivInjectionClassType != null && this.ivInjectionClassType != Object.class ? this.ivInjectionClassType.getName() : this.ivInjectionClassTypeName;
    }

    public Class<?> getInjectionClassType() {
        return this.ivInjectionClassType;
    }

    final void resolveJndiName() throws InjectionConfigurationException {
        if (this.ivJndiName.startsWith("java:")) {
            this.ivInjectionScope = InjectionScope.match(this.ivJndiName);
            if (this.ivInjectionScope == null) {
                String component = this.ivNameSpaceConfig.getDisplayName();
                String module = this.ivNameSpaceConfig.getModuleName();
                String application = this.ivNameSpaceConfig.getApplicationName();
                Tr.error((TraceComponent)tc, (String)"INVALID_REFERENCE_NAME_CWNEN0065E", (Object[])new Object[]{this.ivJndiName, component, module, application});
                throw new InjectionConfigurationException("The " + this.ivJndiName + " reference for the " + component + " component in the " + module + " module in the " + application + " application has a name that is not valid.");
            }
            this.ivJavaNameSpaceName = this.ivJndiName.substring(this.ivInjectionScope.prefix().length());
        } else {
            this.ivJavaNameSpaceName = this.ivJndiName;
        }
    }

    private String bindingObjectToString(Object object) {
        if (object instanceof Reference) {
            Reference ref = (Reference)object;
            StringBuilder sb = new StringBuilder(Util.identity((Object)ref));
            sb.append("[").append(ref.getFactoryClassName()).append(", [");
            for (int i = 0; i < ref.size(); ++i) {
                RefAddr refAddr = ref.get(i);
                sb.append(refAddr.getType()).append('[').append(refAddr.getContent()).append("], ");
            }
            sb.setLength(sb.length() - 2);
            return sb.append("]]").toString();
        }
        return String.valueOf(object);
    }

    void bindInjectedObject() throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("bindInjectedObject: " + this.toSimpleString()), (Object[])new Object[]{this.bindingObjectToString(this.ivBindingObject)});
        }
        InternalInjectionEngine ie = InjectionEngineAccessor.getInternalInstance();
        ie.bindJavaNameSpaceObject(this.ivNameSpaceConfig, this.ivInjectionScope, this.ivJavaNameSpaceName, this, this.ivBindingObject);
        if (this.ivJavaColonCompEnvMap != null && this.ivInjectionScope == null) {
            this.ivJavaColonCompEnvMap.put(this.ivJndiName, this);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"bindInjectedObject");
        }
    }

    public static boolean isClassesCompatible(Class<?> memberClass, Class<?> injectClass) {
        if (memberClass.isAssignableFrom(injectClass)) {
            return true;
        }
        if (injectClass.isAssignableFrom(memberClass)) {
            return true;
        }
        return InjectionBinding.getPrimitiveClass(memberClass) == InjectionBinding.getPrimitiveClass(injectClass);
    }

    public static Class<?> mostSpecificClass(Class<?> classOne, Class<?> classTwo) {
        if (classOne.isAssignableFrom(classTwo)) {
            return classTwo;
        }
        if (classTwo.isAssignableFrom(classOne)) {
            return classOne;
        }
        return null;
    }

    public static final Class<?> getPrimitiveClass(Class<?> clazz) {
        Class<Object> retValue = clazz;
        if (clazz == Long.class) {
            retValue = Long.TYPE;
        } else if (clazz == Integer.class) {
            retValue = Integer.TYPE;
        } else if (clazz == Boolean.class) {
            retValue = Boolean.TYPE;
        } else if (clazz == Short.class) {
            retValue = Short.TYPE;
        } else if (clazz == Byte.class) {
            retValue = Byte.TYPE;
        } else if (clazz == Character.class) {
            retValue = Character.TYPE;
        } else if (clazz == Double.class) {
            retValue = Double.TYPE;
        } else if (clazz == Float.class) {
            retValue = Float.TYPE;
        }
        return retValue;
    }

    public static String getMethodFromProperty(String propertyName) {
        String methodName = propertyName;
        StringBuilder methodBuilder = new StringBuilder("set");
        methodBuilder.append(propertyName.substring(0, 1).toUpperCase());
        methodBuilder.append(propertyName.substring(1));
        methodName = methodBuilder.toString();
        return methodName;
    }

    private boolean containsTarget(Member member) {
        if (this.ivInjectionTargets != null) {
            for (InjectionTarget target : this.ivInjectionTargets) {
                Member targetMember = target.getMember();
                if (!targetMember.equals(member)) continue;
                return true;
            }
        }
        return false;
    }

    protected final Class<?> loadClass(String className) throws InjectionConfigurationException {
        ClassLoader classLoader = this.ivNameSpaceConfig.getClassLoader();
        if (className == null || className.equals("") || classLoader == null) {
            return null;
        }
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("loadClass : " + className), (Object[])new Object[0]);
        }
        Class<?> loadedClass = null;
        try {
            loadedClass = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".loadClass"), (String)"675", (Object)this, (Object[])new Object[]{className});
            InjectionConfigurationException icex = new InjectionConfigurationException("Referenced class could not be loaded : " + className, ex);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("loadClass : " + icex));
            }
            throw icex;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("loadClass : " + loadedClass));
        }
        return loadedClass;
    }

    public boolean hasAnyInjectionTargets() {
        return this.ivInjectionTargets != null;
    }

    protected final boolean isValidationLoggable() {
        return InjectionEngineAccessor.getInternalInstance().isValidationLoggable(this.ivCheckAppConfig);
    }

    protected final boolean isValidationFailable() {
        return InjectionEngineAccessor.getInternalInstance().isValidationFailable(this.ivCheckAppConfig);
    }

    private InjectionTargetMethod createInjectionTarget(Method method, InjectionBinding<?> binding) throws InjectionException {
        if (method.getParameterTypes().length != 1) {
            return new InjectionTargetMultiParamMethod(method, binding);
        }
        return new InjectionTargetMethod(method, binding);
    }

    String toSimpleString() {
        return super.toString() + "[name=" + this.ivJndiName + ']';
    }

    public String toString() {
        return super.toString() + "[name=" + this.ivJndiName + ", " + this.ivAnnotation + ']';
    }

    @Override
    public void formatTo(IncidentStream is) {
        is.writeLine("", ">--- Start InjectionBinding Dump ---> " + Util.identity((Object)this));
        is.writeLine("", "JndiName     = " + this.ivJndiName);
        is.writeLine("", "Annotation   = " + this.ivAnnotation);
        is.writeLine("", "Scope        = " + (Object)((Object)this.ivInjectionScope));
        is.writeLine("", "NameSpace    = " + this.ivJavaNameSpaceName);
        is.writeLine("", "Type         = " + (this.ivInjectionClassType != null ? this.ivInjectionClassType.getName() : this.ivInjectionClassTypeName));
        is.writeLine("", "Resolved     = " + (this.ivNameSpaceConfig == null));
        is.writeLine("", "");
        is.writeLine("", "InjectedObject = " + Util.identity((Object)this.ivInjectedObject));
        is.writeLine("", "BindingObject  = " + Util.identity((Object)this.ivBindingObject));
        is.writeLine("", "ObjectFactory  = " + Util.identity((Object)this.ivObjectFactory) + ", " + this.ivObjectFactoryClass + ", " + this.ivObjectFactoryClassName);
        if (this.ivInjectionTargets != null) {
            is.writeLine("", "");
            is.writeLine("", "Injection Targets : " + this.ivInjectionTargets.size());
            for (InjectionTarget target : this.ivInjectionTargets) {
                is.writeLine("", "   " + target);
            }
        }
        is.writeLine("", "");
        is.writeLine("", this.ivNameSpaceConfig != null ? this.ivNameSpaceConfig.toString() : "ivNameSpaceConfig = null");
        is.writeLine("", "<--- InjectionBinding Dump Complete---< ");
    }

    public static String toStringSecure(Annotation ann) {
        Class<? extends Annotation> annType = ann.annotationType();
        StringBuilder sb = new StringBuilder();
        sb.append('@').append(annType.getName()).append('(');
        boolean any = false;
        for (Method m : annType.getMethods()) {
            Object value;
            Object defaultValue = m.getDefaultValue();
            if (defaultValue == null) continue;
            String name = m.getName();
            try {
                value = m.invoke((Object)ann, new Object[0]);
                value = name.equals("password") && !defaultValue.equals(value) ? "********" : (value instanceof Object[] ? Arrays.toString((Object[])value) : String.valueOf(value));
            }
            catch (Throwable t) {
                value = "<" + t + ">";
            }
            if (any) {
                sb.append(", ");
            } else {
                any = true;
            }
            sb.append(name).append('=').append(value);
        }
        return sb.append(')').toString();
    }

    public void cleanAfterMethodInvocation() {
    }
}

