/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.impl;

import io.smallrye.reactive.messaging.ChannelRegistar;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.impl.ConnectorConfig;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;
import org.eclipse.microprofile.reactive.messaging.spi.ConnectorLiteral;
import org.eclipse.microprofile.reactive.messaging.spi.IncomingConnectorFactory;
import org.eclipse.microprofile.reactive.messaging.spi.OutgoingConnectorFactory;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ConfiguredChannelFactory
implements ChannelRegistar {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfiguredChannelFactory.class);
    private final Instance<IncomingConnectorFactory> incomingConnectorFactories;
    private final Instance<OutgoingConnectorFactory> outgoingConnectorFactories;
    protected final Config config;
    protected final ChannelRegistry registry;

    ConfiguredChannelFactory() {
        this.incomingConnectorFactories = null;
        this.outgoingConnectorFactories = null;
        this.config = null;
        this.registry = null;
    }

    @Inject
    public ConfiguredChannelFactory(@Any Instance<IncomingConnectorFactory> incomingConnectorFactories, @Any Instance<OutgoingConnectorFactory> outgoingConnectorFactories, Instance<Config> config, @Any Instance<ChannelRegistry> registry, BeanManager beanManager) {
        this(incomingConnectorFactories, outgoingConnectorFactories, config, registry, beanManager, true);
    }

    ConfiguredChannelFactory(@Any Instance<IncomingConnectorFactory> incomingConnectorFactories, @Any Instance<OutgoingConnectorFactory> outgoingConnectorFactories, Instance<Config> config, @Any Instance<ChannelRegistry> registry, BeanManager beanManager, boolean logConnectors) {
        this.registry = (ChannelRegistry)registry.get();
        if (config.isUnsatisfied()) {
            this.incomingConnectorFactories = null;
            this.outgoingConnectorFactories = null;
            this.config = null;
        } else {
            this.incomingConnectorFactories = incomingConnectorFactories;
            this.outgoingConnectorFactories = outgoingConnectorFactories;
            if (logConnectors) {
                LOGGER.info("Found incoming connectors: {}", this.getConnectors(beanManager, IncomingConnectorFactory.class));
                LOGGER.info("Found outgoing connectors: {}", this.getConnectors(beanManager, OutgoingConnectorFactory.class));
            }
            this.config = ConfigProvider.getConfig();
        }
    }

    private List<String> getConnectors(BeanManager beanManager, Class<?> clazz) {
        return beanManager.getBeans(clazz, new Annotation[0]).stream().map(BeanAttributes::getQualifiers).flatMap(set -> set.stream().filter(a -> a.annotationType().equals(Connector.class))).map(annotation -> ((Connector)annotation).value()).collect(Collectors.toList());
    }

    static Map<String, ConnectorConfig> extractConfigurationFor(String prefix, Config root) {
        Iterable names = root.getPropertyNames();
        HashMap<String, ConnectorConfig> configs = new HashMap<String, ConnectorConfig>();
        names.forEach(key -> {
            if (key.startsWith(prefix)) {
                String name = key.substring(prefix.length());
                if (name.contains(".")) {
                    String tmp = name;
                    name = tmp.substring(0, tmp.indexOf(46));
                    configs.put(name, new ConnectorConfig(prefix, root, name));
                } else {
                    configs.put(name, new ConnectorConfig(prefix, root, name));
                }
            }
        });
        return configs;
    }

    @Override
    public void initialize() {
        if (this.config == null) {
            LOGGER.info("No MicroProfile Config found, skipping");
            return;
        }
        LOGGER.info("Stream manager initializing...");
        Map<String, ConnectorConfig> sourceConfiguration = ConfiguredChannelFactory.extractConfigurationFor("mp.messaging.incoming.", this.config);
        Map<String, ConnectorConfig> sinkConfiguration = ConfiguredChannelFactory.extractConfigurationFor("mp.messaging.outgoing.", this.config);
        this.register(sourceConfiguration, sinkConfiguration);
    }

    void register(Map<String, ConnectorConfig> sourceConfiguration, Map<String, ConnectorConfig> sinkConfiguration) {
        try {
            sourceConfiguration.forEach((name, conf) -> this.registry.register((String)name, this.createPublisherBuilder((String)name, (Config)conf)));
            sinkConfiguration.forEach((name, conf) -> this.registry.register((String)name, this.createSubscriberBuilder((String)name, (Config)conf)));
        }
        catch (RuntimeException e) {
            LOGGER.error("Unable to create the publisher or subscriber during initialization", (Throwable)e);
            throw e;
        }
    }

    private static String getConnectorAttribute(Config config) {
        return (String)config.getValue("connector", String.class);
    }

    private PublisherBuilder<? extends Message> createPublisherBuilder(String name, Config config) {
        String connector = ConfiguredChannelFactory.getConnectorAttribute(config);
        IncomingConnectorFactory mySourceFactory = (IncomingConnectorFactory)this.incomingConnectorFactories.select(new Annotation[]{ConnectorLiteral.of((String)connector)}).stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown connector for " + name + "."));
        return mySourceFactory.getPublisherBuilder(config);
    }

    private SubscriberBuilder<? extends Message, Void> createSubscriberBuilder(String name, Config config) {
        String connector = ConfiguredChannelFactory.getConnectorAttribute(config);
        OutgoingConnectorFactory mySinkFactory = (OutgoingConnectorFactory)this.outgoingConnectorFactories.select(new Annotation[]{ConnectorLiteral.of((String)connector)}).stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown connector for " + name + "."));
        return mySinkFactory.getSubscriberBuilder(config);
    }
}

