/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class ExtendedBoolean
implements Comparable {
    private static final TraceComponent tc = SibTr.register(ExtendedBoolean.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private static final String STRING_FALSE = "false";
    public static final ExtendedBoolean FALSE = new ExtendedBoolean("false", 0, 0);
    private static final String STRING_TRUE = "true";
    public static final ExtendedBoolean TRUE = new ExtendedBoolean("true", 1, 1);
    private static final String STRING_NONE = "none";
    public static final ExtendedBoolean NONE = new ExtendedBoolean("none", 2, 2);
    private static final ExtendedBoolean[] set = new ExtendedBoolean[]{FALSE, TRUE, NONE};
    private static final ExtendedBoolean[] indexSet = new ExtendedBoolean[]{FALSE, TRUE, NONE};
    private static final String[] nameSet = new String[]{"false", "true", "none"};
    public static final int MAX_INDEX = NONE.getIndex();
    private final String name;
    private final int value;
    private final int index;

    private ExtendedBoolean(String aName, int aValue, int aIndex) {
        this.name = aName;
        this.value = aValue;
        this.index = aIndex;
    }

    public static final ExtendedBoolean getExtendedBoolean(int aValue) {
        if (tc.isDebugEnabled()) {
            SibTr.info((TraceComponent)tc, (String)("Value = " + aValue));
        }
        return set[aValue];
    }

    public final int toInt() {
        return this.value;
    }

    public final String toString() {
        return this.name;
    }

    public final int compareTo(Object other) {
        if (tc.isDebugEnabled()) {
            SibTr.info((TraceComponent)tc, (String)("this: " + this + ", other: " + other.toString() + ", result: " + (this.value - ((ExtendedBoolean)other).value)));
        }
        return this.value - ((ExtendedBoolean)other).value;
    }

    public static final ExtendedBoolean getExtendedBooleanByName(String name) throws NullPointerException, IllegalArgumentException {
        if (tc.isDebugEnabled()) {
            SibTr.info((TraceComponent)tc, (String)("Name = " + name));
        }
        if (name == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i <= MAX_INDEX + 1; ++i) {
            if (!name.equals(nameSet[i])) continue;
            return indexSet[i];
        }
        throw new IllegalArgumentException();
    }

    public static final ExtendedBoolean getExtendedBooleanByIndex(int index) {
        if (tc.isDebugEnabled()) {
            SibTr.info((TraceComponent)tc, (String)("Index = " + index));
        }
        return indexSet[index + 1];
    }

    public final int getIndex() {
        return this.index;
    }
}

